<?php
if ( ! function_exists( 'newsmax_ruby_theme_options_typography_post' ) ) {
	function newsmax_ruby_theme_options_typography_post() {
		return array(
			'id'         => 'newsmax_ruby_config_section_typo_post',
			'title'      => esc_html__( 'Post Title Typography', 'newsmax' ),
			'icon'       => 'el el-font',
			'subsection' => true,
			'desc'       => esc_html__( 'Select font values for post titles for your website. The theme defines font values by size: extra big, big, medium, default, small and mini. You can setup your font to fit with all devices by responsive options. Leave blank if you want to set as defaults and make sure you input line-height when setup font-size. Refer default values at the end of options', 'newsmax' ),
			'fields'     => array(
				array(
					'id'     => 'section_start_block_font_post_title_0',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Extra Big - Title Typography Options', 'newsmax' ),
					'indent' => true
				),
				array(
					'id'             => 'font_post_title_0',
					'type'           => 'typography',
					'title'          => esc_html__( 'Extra Big Title Font', 'newsmax' ),
					'subtitle'       => esc_html__( 'select font values for extra big titles. These options will apply to full-screen title ie: single title, full-screen sliders and full-screen carousels layouts... [ CSS classname: .is-size-0 ]', 'newsmax' ),
					'desc'           => esc_html__( 'Default [ font-size: 40px | line-height: 42px | letter-spacing: -1.6px | color: #282828 ]', 'newsmax' ),
					'google'         => true,
					'font-backup'    => true,
					'text-align'     => false,
					'color'          => true,
					'text-transform' => true,
					'letter-spacing' => true,
					'font-weight'    => true,
					'units'          => 'px',
					'default'        => array(
						'font-family'    => 'Poppins',
						'font-weight'    => 700,
						'font-size'      => '',
						'color'          => '',
						'text-transform' => '',
						'letter-spacing' => '',
					),
					'output'         => array( '.post-title.is-size-0' )
				),
				array(
					'id'             => 'font_post_title_0_notebook',
					'type'           => 'typography',
					'title'          => esc_html__( 'Extra Big - Notebook Responsive (1024px)', 'newsmax' ),
					'subtitle'       => esc_html__( 'select font values for extra titles on notebook devices (screen max-width < 1200px ).', 'newsmax' ),
					'desc'           => esc_html__( 'Default [ font-size: 32px | line-height: 36px | letter-spacing: -1.28px ]', 'newsmax' ),
					'google'         => false,
					'font-family'    => false,
					'font-backup'    => false,
					'text-align'     => false,
					'color'          => false,
					'text-transform' => false,
					'letter-spacing' => true,
					'line-height'    => true,
					'font-style'     => false,
					'font-weight'    => false,
					'preview'        => false,
					'units'          => 'px',
					'default'        => array(
						'font-size'      => '',
						'line-height'    => '',
						'letter-spacing' => '',
					),
				),
				array(
					'id'             => 'font_post_title_0_tablet',
					'type'           => 'typography',
					'title'          => esc_html__( 'Extra Big - Tablet Responsive (768px)', 'newsmax' ),
					'subtitle'       => esc_html__( 'select font values for extra big titles on tablet devices (screen max-width < 992px ).', 'newsmax' ),
					'desc'           => esc_html__( 'Default [ font-size: 28px | line-height: 32px | letter-spacing: -0.84px ]', 'newsmax' ),
					'google'         => false,
					'font-family'    => false,
					'font-backup'    => false,
					'text-align'     => false,
					'color'          => false,
					'text-transform' => false,
					'letter-spacing' => true,
					'line-height'    => true,
					'font-style'     => false,
					'font-weight'    => false,
					'preview'        => false,
					'units'          => 'px',
					'default'        => array(
						'font-size'      => '',
						'line-height'    => '',
						'letter-spacing' => '',
					),
				),
				array(
					'id'             => 'font_post_title_0_mobile',
					'type'           => 'typography',
					'title'          => esc_html__( 'Extra Big - Mobile Responsive (480px)', 'newsmax' ),
					'subtitle'       => esc_html__( 'select font values for extra big titles on mobile devices (screen max-width < 768px ).', 'newsmax' ),
					'desc'           => esc_html__( 'Default [ font-size: 20px | line-height: 23px | letter-spacing: -0.3px ]', 'newsmax' ),
					'google'         => false,
					'font-family'    => false,
					'font-backup'    => false,
					'text-align'     => false,
					'color'          => false,
					'text-transform' => false,
					'letter-spacing' => true,
					'line-height'    => true,
					'font-style'     => false,
					'font-weight'    => false,
					'preview'        => false,
					'units'          => 'px',
					'default'        => array(
						'font-size'      => '',
						'line-height'    => '',
						'letter-spacing' => '',
					),
				),
				array(
					'id'     => 'section_end_block_font_post_title_0',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false
				),
				array(
					'id'     => 'section_start_block_font_post_title_1',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Big - Title Typography Options', 'newsmax' ),
					'indent' => true
				),
				array(
					'id'             => 'font_post_title_1',
					'type'           => 'typography',
					'title'          => esc_html__( 'Big Title Font', 'newsmax' ),
					'subtitle'       => esc_html__( 'select font values for big titles. These options will apply to full-width title ie: single title, fullwidth sliders and carousels layouts... [ CSS classname: .is-size-1 ]', 'newsmax' ),
					'desc'           => esc_html__( 'Default [ font-size: 36px | line-height: 40px | letter-spacing: -1.4px | color: #282828 ]', 'newsmax' ),
					'google'         => true,
					'font-backup'    => true,
					'text-align'     => false,
					'color'          => true,
					'text-transform' => true,
					'letter-spacing' => true,
					'font-weight'    => true,
					'units'          => 'px',
					'default'        => array(
						'font-family'    => 'Poppins',
						'font-weight'    => 700,
						'font-size'      => '',
						'color'          => '',
						'text-transform' => '',
						'letter-spacing' => '',
					),
					'output'         => array( '.post-title.is-size-1' )
				),
				array(
					'id'             => 'font_post_title_1_notebook',
					'type'           => 'typography',
					'title'          => esc_html__( 'Big - Notebook Responsive (1024px)', 'newsmax' ),
					'subtitle'       => esc_html__( 'select font values for big titles on notebook devices (screen max-width < 1200px ).', 'newsmax' ),
					'desc'           => esc_html__( 'Default [ font-size: 32px | line-height: 36px | letter-spacing: -1.28px ]', 'newsmax' ),
					'google'         => false,
					'font-family'    => false,
					'font-backup'    => false,
					'text-align'     => false,
					'color'          => false,
					'text-transform' => false,
					'letter-spacing' => true,
					'line-height'    => true,
					'font-style'     => false,
					'font-weight'    => false,
					'preview'        => false,
					'units'          => 'px',
					'default'        => array(
						'font-size'      => '',
						'line-height'    => '',
						'letter-spacing' => '',
					),
				),
				array(
					'id'             => 'font_post_title_1_tablet',
					'type'           => 'typography',
					'title'          => esc_html__( 'Big - Tablet Responsive (768px)', 'newsmax' ),
					'subtitle'       => esc_html__( 'select font values for big titles on tablet devices (screen max-width < 992px ).', 'newsmax' ),
					'desc'           => esc_html__( 'Default [ font-size: 28px | line-height: 32px | letter-spacing: -0.84px ]', 'newsmax' ),
					'google'         => false,
					'font-family'    => false,
					'font-backup'    => false,
					'text-align'     => false,
					'color'          => false,
					'text-transform' => false,
					'letter-spacing' => true,
					'line-height'    => true,
					'font-style'     => false,
					'font-weight'    => false,
					'preview'        => false,
					'units'          => 'px',
					'default'        => array(
						'font-size'      => '',
						'line-height'    => '',
						'letter-spacing' => '',
					),
				),
				array(
					'id'             => 'font_post_title_1_mobile',
					'type'           => 'typography',
					'title'          => esc_html__( 'Big - Mobile Responsive (480px)', 'newsmax' ),
					'subtitle'       => esc_html__( 'select font values for big titles on mobile devices (screen max-width < 768px ).', 'newsmax' ),
					'desc'           => esc_html__( 'Default [ font-size: 20px | line-height: 23px | letter-spacing: -0.3px ]', 'newsmax' ),
					'google'         => false,
					'font-family'    => false,
					'font-backup'    => false,
					'text-align'     => false,
					'color'          => false,
					'text-transform' => false,
					'letter-spacing' => true,
					'line-height'    => true,
					'font-style'     => false,
					'font-weight'    => false,
					'preview'        => false,
					'units'          => 'px',
					'default'        => array(
						'font-size'      => '',
						'line-height'    => '',
						'letter-spacing' => '',
					),
				),
				array(
					'id'     => 'section_end_block_font_post_title_1',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false
				),
				array(
					'id'     => 'section_start_block_font_post_title_2',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Medium - Title Typography Options', 'newsmax' ),
					'indent' => true
				),
				array(
					'id'             => 'font_post_title_2',
					'type'           => 'typography',
					'title'          => esc_html__( 'Medium Title Font', 'newsmax' ),
					'subtitle'       => esc_html__( 'select font values for medium titles. These options will apply to: the classic, small sliders, big grid and list layouts... [ CSS classname: .is-size-2 ]', 'newsmax' ),
					'desc'           => esc_html__( 'Default [ font-size: 22px | line-height: 26px | letter-spacing: -0.88px | color: #282828 ]', 'newsmax' ),
					'google'         => true,
					'font-backup'    => true,
					'text-align'     => false,
					'color'          => true,
					'text-transform' => true,
					'letter-spacing' => true,
					'font-weight'    => true,
					'units'          => 'px',
					'default'        => array(
						'font-family'    => 'Poppins',
						'font-weight'    => 500,
						'font-size'      => '',
						'color'          => '',
						'text-transform' => '',
						'letter-spacing' => '',
					),
					'output'         => array( '.post-title.is-size-2' )
				),
				array(
					'id'             => 'font_post_title_2_notebook',
					'type'           => 'typography',
					'title'          => esc_html__( 'Medium - Notebook Responsive (1024px)', 'newsmax' ),
					'subtitle'       => esc_html__( 'select font values for medium titles on notebook devices (screen max-width < 1200px ).', 'newsmax' ),
					'desc'           => esc_html__( 'Default [ font-size: 18px | line-height: 23px | letter-spacing: -0.72px ]', 'newsmax' ),
					'google'         => false,
					'font-family'    => false,
					'font-backup'    => false,
					'text-align'     => false,
					'color'          => false,
					'text-transform' => false,
					'letter-spacing' => true,
					'line-height'    => true,
					'font-style'     => false,
					'font-weight'    => false,
					'preview'        => false,
					'units'          => 'px',
					'default'        => array(
						'font-size'      => '',
						'line-height'    => '',
						'letter-spacing' => '',
					),
				),
				array(
					'id'             => 'font_post_title_2_tablet',
					'type'           => 'typography',
					'title'          => esc_html__( 'Medium - Tablet Responsive (768px)', 'newsmax' ),
					'subtitle'       => esc_html__( 'select font values for medium titles on tablet devices (screen max-width < 992px ).', 'newsmax' ),
					'desc'           => esc_html__( 'Default [ font-size: 16px | line-height: 21px | letter-spacing: -0.4px ]', 'newsmax' ),
					'google'         => false,
					'font-family'    => false,
					'font-backup'    => false,
					'text-align'     => false,
					'color'          => false,
					'text-transform' => false,
					'letter-spacing' => true,
					'line-height'    => true,
					'font-style'     => false,
					'font-weight'    => false,
					'preview'        => false,
					'units'          => 'px',
					'default'        => array(
						'font-size'      => '',
						'line-height'    => '',
						'letter-spacing' => '',
					),
				),
				array(
					'id'             => 'font_post_title_2_mobile',
					'type'           => 'typography',
					'title'          => esc_html__( 'Medium - Mobile Responsive (480px)', 'newsmax' ),
					'subtitle'       => esc_html__( 'select font values for medium titles on mobile devices (screen max-width < 768px ).', 'newsmax' ),
					'desc'           => esc_html__( 'Default [ font-size: 15px | line-height: 20px | letter-spacing: -0.3px ]', 'newsmax' ),
					'google'         => false,
					'font-family'    => false,
					'font-backup'    => false,
					'text-align'     => false,
					'color'          => false,
					'text-transform' => false,
					'letter-spacing' => true,
					'line-height'    => true,
					'font-style'     => false,
					'font-weight'    => false,
					'preview'        => false,
					'units'          => 'px',
					'default'        => array(
						'font-size'      => '',
						'line-height'    => '',
						'letter-spacing' => '',
					),
				),
				array(
					'id'     => 'section_end_block_font_post_title_2',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false
				),
				array(
					'id'     => 'section_start_block_font_post_title_3',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Small - Title Typography Options', 'newsmax' ),
					'indent' => true
				),
				array(
					'id'             => 'font_post_title_3',
					'type'           => 'typography',
					'title'          => esc_html__( 'Small Title Font', 'newsmax' ),
					'subtitle'       => esc_html__( 'select font values for small titles. These options will apply to: default list, grid layouts... [ CSS classname: .is-size-3 ]', 'newsmax' ),
					'desc'           => esc_html__( 'Default [ font-size: 18px | line-height: 23px | letter-spacing: -0.72px | color: #282828 ]', 'newsmax' ),
					'google'         => true,
					'font-backup'    => true,
					'text-align'     => false,
					'color'          => true,
					'text-transform' => true,
					'letter-spacing' => true,
					'font-weight'    => true,
					'units'          => 'px',
					'default'        => array(
						'font-family'    => 'Poppins',
						'font-weight'    => 500,
						'font-size'      => '',
						'color'          => '',
						'text-transform' => '',
						'letter-spacing' => '',
					),
					'output'         => array( '.post-title.is-size-3' )
				),
				array(
					'id'             => 'font_post_title_3_notebook',
					'type'           => 'typography',
					'title'          => esc_html__( 'Small - Notebook Responsive (1024px)', 'newsmax' ),
					'subtitle'       => esc_html__( 'select font values for small titles on notebook devices (screen max-width < 1200px ).', 'newsmax' ),
					'desc'           => esc_html__( 'Default [ font-size: 18px | line-height: 23px | letter-spacing: -0.72px ]', 'newsmax' ),
					'google'         => false,
					'font-family'    => false,
					'font-backup'    => false,
					'text-align'     => false,
					'color'          => false,
					'text-transform' => false,
					'letter-spacing' => true,
					'line-height'    => true,
					'font-style'     => false,
					'font-weight'    => false,
					'preview'        => false,
					'units'          => 'px',
					'default'        => array(
						'font-size'      => '',
						'line-height'    => '',
						'letter-spacing' => '',
					),
				),
				array(
					'id'             => 'font_post_title_3_tablet',
					'type'           => 'typography',
					'title'          => esc_html__( 'Small - Tablet Responsive (768px)', 'newsmax' ),
					'subtitle'       => esc_html__( 'select font values for small titles on tablet devices (screen max-width < 992px ).', 'newsmax' ),
					'desc'           => esc_html__( 'Default [ font-size: 14px | line-height: 19px | letter-spacing: -0.19px ]', 'newsmax' ),
					'google'         => false,
					'font-family'    => false,
					'font-backup'    => false,
					'text-align'     => false,
					'color'          => false,
					'text-transform' => false,
					'letter-spacing' => true,
					'line-height'    => true,
					'font-style'     => false,
					'font-weight'    => false,
					'preview'        => false,
					'units'          => 'px',
					'default'        => array(
						'font-size'      => '',
						'line-height'    => '',
						'letter-spacing' => '',
					),
				),
				array(
					'id'             => 'font_post_title_3_mobile',
					'type'           => 'typography',
					'title'          => esc_html__( 'Small - Mobile Responsive (480px)', 'newsmax' ),
					'subtitle'       => esc_html__( 'select font values for small titles on mobile devices (screen max-width < 768px ).', 'newsmax' ),
					'desc'           => esc_html__( 'Default [ font-size: 14px | line-height: 19px | letter-spacing: -0.19px ]', 'newsmax' ),
					'google'         => false,
					'font-family'    => false,
					'font-backup'    => false,
					'text-align'     => false,
					'color'          => false,
					'text-transform' => false,
					'letter-spacing' => true,
					'line-height'    => true,
					'font-style'     => false,
					'font-weight'    => false,
					'preview'        => false,
					'units'          => 'px',
					'default'        => array(
						'font-size'      => '',
						'line-height'    => '',
						'letter-spacing' => '',
					),
				),
				array(
					'id'     => 'section_end_block_font_post_title_3',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false
				),
				array(
					'id'     => 'section_start_block_font_post_title_4',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Mini - Title Typography Options', 'newsmax' ),
					'indent' => true
				),
				array(
					'id'             => 'font_post_title_4',
					'type'           => 'typography',
					'title'          => esc_html__( 'Mini Title Font', 'newsmax' ),
					'subtitle'       => esc_html__( 'select font values for mini titles. These options will apply to: mini list, grid layouts... [ CSS classname: .is-size-4 ]', 'newsmax' ),
					'desc'           => esc_html__( 'Default [ font-size: 12px | line-height: 16px | letter-spacing: -0.36px | color: #282828 ]', 'newsmax' ),
					'google'         => true,
					'font-backup'    => true,
					'text-align'     => false,
					'color'          => true,
					'text-transform' => true,
					'letter-spacing' => true,
					'font-weight'    => true,
					'units'          => 'px',
					'default'        => array(
						'font-family'    => 'Poppins',
						'font-weight'    => 500,
						'font-size'      => '',
						'color'          => '',
						'text-transform' => '',
						'letter-spacing' => '',
					),
					'output'         => array( '.post-title.is-size-4' )
				),
				array(
					'id'             => 'font_post_title_4_notebook',
					'type'           => 'typography',
					'title'          => esc_html__( 'Mini - Notebook Responsive (1024px)', 'newsmax' ),
					'subtitle'       => esc_html__( 'select font values for mini titles on notebook devices (screen max-width < 1200px ).', 'newsmax' ),
					'desc'           => esc_html__( 'Default [ font-size: 12px | line-height: 16px | letter-spacing: -0.36px ]', 'newsmax' ),
					'google'         => false,
					'font-family'    => false,
					'font-backup'    => false,
					'text-align'     => false,
					'color'          => false,
					'text-transform' => false,
					'letter-spacing' => true,
					'line-height'    => true,
					'font-style'     => false,
					'font-weight'    => false,
					'preview'        => false,
					'units'          => 'px',
					'default'        => array(
						'font-size'      => '',
						'line-height'    => '',
						'letter-spacing' => '',
					),
				),
				array(
					'id'             => 'font_post_title_4_tablet',
					'type'           => 'typography',
					'title'          => esc_html__( 'Mini - Tablet Responsive (768px)', 'newsmax' ),
					'subtitle'       => esc_html__( 'select font values for mini titles on tablet devices (screen max-width < 992px ).', 'newsmax' ),
					'desc'           => esc_html__( 'Default [ font-size: 12px | line-height: 16px | letter-spacing: -0.36px ]', 'newsmax' ),
					'google'         => false,
					'font-family'    => false,
					'font-backup'    => false,
					'text-align'     => false,
					'color'          => false,
					'text-transform' => false,
					'letter-spacing' => true,
					'line-height'    => true,
					'font-style'     => false,
					'font-weight'    => false,
					'preview'        => false,
					'units'          => 'px',
					'default'        => array(
						'font-size'      => '',
						'line-height'    => '',
						'letter-spacing' => '',
					),
				),
				array(
					'id'             => 'font_post_title_4_mobile',
					'type'           => 'typography',
					'title'          => esc_html__( 'Mini - Mobile Responsive (480px)', 'newsmax' ),
					'subtitle'       => esc_html__( 'select font values for mini titles on mobile devices (screen max-width < 768px ).', 'newsmax' ),
					'desc'           => esc_html__( 'Default [ font-size: 12px | line-height: 16px | letter-spacing: -0.36px ]', 'newsmax' ),
					'google'         => false,
					'font-family'    => false,
					'font-backup'    => false,
					'text-align'     => false,
					'color'          => false,
					'text-transform' => false,
					'letter-spacing' => true,
					'line-height'    => true,
					'font-style'     => false,
					'font-weight'    => false,
					'preview'        => false,
					'units'          => 'px',
					'default'        => array(
						'font-size'      => '',
						'line-height'    => '',
						'letter-spacing' => '',
					),
				),
				array(
					'id'     => 'section_end_block_font_post_title_4',
					'type'   => 'section',
					'class'  => 'ruby-section-end no-border',
					'indent' => false
				),
			)
		);
	}
}