<?php
/** amp panel */
if ( ! function_exists( 'newsmax_ruby_theme_options_amp' ) ) {
	function newsmax_ruby_theme_options_amp() {
		if ( function_exists( 'amp_init' ) ) {
			return array(
				'id'     => 'newsmax_config_section_amp',
				'title'  => esc_html__( 'AMP Options', 'newsmax' ),
				'desc'   => esc_html__( 'Select special options for AMP site, You can control other settings as background, text style, copyright text in Theme Options > Footer Settings.', 'newsmax' ),
				'icon'   => 'el el-road',
				'fields' => array(
					array(
						'id'     => 'section_start_amp_footer',
						'type'   => 'section',
						'class'  => 'ruby-section-start',
						'title'  => esc_html__( 'Footer Settings', 'newsmax' ),
						'indent' => true
					),
					array(
						'id'       => 'amp_back_top',
						'type'     => 'switch',
						'title'    => esc_html__( 'Back to Top', 'newsmax' ),
						'subtitle' => esc_html__( 'Enable or disable the back to top button.', 'newsmax' ),
						'default'  => 0
					),
					array(
						'id'     => 'section_end_amp_footer',
						'type'   => 'section',
						'class'  => 'ruby-section-end',
						'indent' => false
					),
					array(
						'id'     => 'section_start_amp_single',
						'type'   => 'section',
						'class'  => 'ruby-section-start',
						'title'  => esc_html__( 'Single Settings', 'newsmax' ),
						'indent' => true
					),
					array(
						'id'       => 'amp_disable_author',
						'type'     => 'switch',
						'title'    => esc_html__( 'Author Card', 'newsmax' ),
						'off'      => esc_html__( 'Default from Single Settings', 'newsmax' ),
						'on'       => esc_html__( 'Disable on AMP', 'newsmax' ),
						'subtitle' => esc_html__( 'Disable the Author Card on the AMP site.', 'newsmax' ),
						'default'  => 0
					),
					array(
						'id'       => 'amp_disable_single_pagination',
						'type'     => 'switch',
						'title'    => esc_html__( 'Next/Prev Articles', 'newsmax' ),
						'off'      => esc_html__( 'Default from Single Settings', 'newsmax' ),
						'on'       => esc_html__( 'Disable on AMP', 'newsmax' ),
						'subtitle' => esc_html__( 'Disable the Next/Prev Articles section on the AMP site.', 'newsmax' ),
						'default'  => 0
					),
					array(
						'id'       => 'amp_disable_comment',
						'type'     => 'switch',
						'title'    => esc_html__( 'Comment Box', 'newsmax' ),
						'off'      => esc_html__( 'Default', 'newsmax' ),
						'on'       => esc_html__( 'Disable on AMP', 'newsmax' ),
						'subtitle' => esc_html__( 'Disable comment form on AMP site.', 'newsmax' ),
						'default'  => 0
					),
					array(
						'id'       => 'amp_disable_related',
						'type'     => 'switch',
						'title'    => esc_html__( 'Related Section', 'newsmax' ),
						'off'      => esc_html__( 'Default from Single Settings', 'newsmax' ),
						'on'       => esc_html__( 'Disable on AMP', 'newsmax' ),
						'subtitle' => esc_html__( 'Disable the related section on the AMP site.', 'newsmax' ),
						'default'  => 0
					),
					array(
						'id'     => 'section_end_amp_single',
						'type'   => 'section',
						'class'  => 'ruby-section-end',
						'indent' => false
					),
					/** header advert */
					array(
						'id'     => 'section_start_amp_header_advert',
						'type'   => 'section',
						'class'  => 'ruby-section-start',
						'title'  => esc_html__( 'Header Ad Settings', 'newsmax' ),
						'indent' => true
					),
					array(
						'id'       => 'amp_header_ad_type',
						'type'     => 'select',
						'title'    => esc_html__( 'Header - Ad Type', 'newsmax' ),
						'subtitle' => esc_html__( 'Select your ad type to display at the header.', 'newsmax' ),
						'options'  => array(
							'1' => esc_html__( '-- Adsense --', 'newsmax' ),
							'2' => esc_html__( 'AMP Custom Script Ad', 'newsmax' ),
						),
						'default'  => 1
					),
					array(
						'id'       => 'amp_header_adsense_client',
						'type'     => 'text',
						'required' => array( 'amp_header_ad_type', '=', '1' ),
						'title'    => esc_html__( 'Header - Data Ad Client', 'newsmax' ),
						'subtitle' => esc_html__( 'Input the data-ad-client number ID (without ca-pub-).', 'newsmax' ),
						'default'  => ''
					),
					array(
						'id'       => 'amp_header_adsense_slot',
						'type'     => 'text',
						'required' => array( 'amp_header_ad_type', '=', '1' ),
						'title'    => esc_html__( 'Header - Data Ad Slot', 'newsmax' ),
						'subtitle' => esc_html__( 'Input the data-ad-slot number ID.', 'newsmax' ),
						'default'  => ''
					),
					array(
						'id'       => 'amp_header_adsense_size',
						'type'     => 'select',
						'required' => array( 'amp_header_ad_type', '=', '1' ),
						'title'    => esc_html__( 'Header - Adsense Size', 'newsmax' ),
						'subtitle' => esc_html__( 'Select a size for this ad.', 'newsmax' ),
						'options'  => array(
							'1' => esc_html__( '-- Responsive --', 'newsmax' ),
							'2' => esc_html__( 'Fixed Height (90px)', 'newsmax' ),
						),
						'default'  => 1
					),
					array(
						'id'       => 'amp_header_ad_code',
						'type'     => 'textarea',
						'required' => array( 'amp_header_ad_type', '=', '2' ),
						'title'    => esc_html__( 'Header - AMP Custom Ad Script', 'newsmax' ),
						'subtitle' => esc_html__( 'Input your AMP custom ad script.', 'newsmax' ),
						'default'  => ''
					),
					array(
						'id'     => 'section_end_amp_header_advert',
						'type'   => 'section',
						'class'  => 'ruby-section-end',
						'indent' => false
					),
					/** footer advert */
					array(
						'id'     => 'section_start_amp_footer_advert',
						'type'   => 'section',
						'class'  => 'ruby-section-start',
						'title'  => esc_html__( 'Footer Ad Settings', 'newsmax' ),
						'indent' => true
					),
					array(
						'id'       => 'amp_footer_ad_type',
						'type'     => 'select',
						'title'    => esc_html__( 'Footer - Ad Type', 'newsmax' ),
						'subtitle' => esc_html__( 'Select your ad type to display at the footer.', 'newsmax' ),
						'options'  => array(
							'1' => esc_html__( '-- Adsense --', 'newsmax' ),
							'2' => esc_html__( 'AMP Custom Script Ad', 'newsmax' ),
						),
						'default'  => 1
					),
					array(
						'id'       => 'amp_footer_adsense_client',
						'type'     => 'text',
						'required' => array( 'amp_footer_ad_type', '=', '1' ),
						'title'    => esc_html__( 'Footer - Data Ad Client', 'newsmax' ),
						'subtitle' => esc_html__( 'Input the data-ad-client number ID (without ca-pub-).', 'newsmax' ),
						'default'  => ''
					),
					array(
						'id'       => 'amp_footer_adsense_slot',
						'type'     => 'text',
						'required' => array( 'amp_footer_ad_type', '=', '1' ),
						'title'    => esc_html__( 'Footer - Data Ad Slot', 'newsmax' ),
						'subtitle' => esc_html__( 'Input the data-ad-slot number ID.', 'newsmax' ),
						'default'  => ''
					),
					array(
						'id'       => 'amp_footer_adsense_size',
						'type'     => 'select',
						'required' => array( 'amp_footer_ad_type', '=', '1' ),
						'title'    => esc_html__( 'Footer - Adsense Size', 'newsmax' ),
						'subtitle' => esc_html__( 'Select a size for this ad.', 'newsmax' ),
						'options'  => array(
							'1' => esc_html__( '-- Responsive --', 'newsmax' ),
							'2' => esc_html__( 'Fixed Height (90px)', 'newsmax' ),
						),
						'default'  => 1
					),
					array(
						'id'       => 'amp_footer_ad_code',
						'type'     => 'textarea',
						'required' => array( 'amp_footer_ad_type', '=', '2' ),
						'title'    => esc_html__( 'Footer - AMP Custom Ad Script', 'newsmax' ),
						'subtitle' => esc_html__( 'Input your AMP custom ad script.', 'newsmax' ),
						'default'  => ''
					),
					array(
						'id'     => 'section_end_amp_footer_advert',
						'type'   => 'section',
						'class'  => 'ruby-section-end',
						'indent' => false
					),
					/** top article */
					array(
						'id'     => 'section_start_amp_top_single_advert',
						'type'   => 'section',
						'class'  => 'ruby-section-start',
						'title'  => esc_html__( 'Top Single Content Ad Settings', 'newsmax' ),
						'indent' => true
					),
					array(
						'id'       => 'amp_top_single_ad_type',
						'type'     => 'select',
						'title'    => esc_html__( 'Top - Ad Type', 'newsmax' ),
						'subtitle' => esc_html__( 'Select your ad type to display at the top single content.', 'newsmax' ),
						'options'  => array(
							'1' => esc_html__( '-- Adsense --', 'newsmax' ),
							'2' => esc_html__( 'AMP Custom Script Ad', 'newsmax' ),
						),
						'default'  => 1
					),
					array(
						'id'       => 'amp_top_single_adsense_client',
						'type'     => 'text',
						'required' => array( 'amp_top_single_ad_type', '=', '1' ),
						'title'    => esc_html__( 'Top - Data Ad Client', 'newsmax' ),
						'subtitle' => esc_html__( 'Input the data-ad-client number ID (without ca-pub-).', 'newsmax' ),
						'default'  => ''
					),
					array(
						'id'       => 'amp_top_single_adsense_slot',
						'type'     => 'text',
						'required' => array( 'amp_top_single_ad_type', '=', '1' ),
						'title'    => esc_html__( 'Top - Data Ad Slot', 'newsmax' ),
						'subtitle' => esc_html__( 'Input the data-ad-slot number ID.', 'newsmax' ),
						'default'  => ''
					),
					array(
						'id'       => 'amp_top_single_adsense_size',
						'type'     => 'select',
						'required' => array( 'amp_top_single_ad_type', '=', '1' ),
						'title'    => esc_html__( 'Top - Adsense Size', 'newsmax' ),
						'subtitle' => esc_html__( 'Select a size for this ad.', 'newsmax' ),
						'options'  => array(
							'1' => esc_html__( '-- Responsive --', 'newsmax' ),
							'2' => esc_html__( 'Fixed Height (90px)', 'newsmax' ),
						),
						'default'  => 1
					),
					array(
						'id'       => 'amp_top_single_ad_code',
						'type'     => 'textarea',
						'required' => array( 'amp_top_single_ad_type', '=', '2' ),
						'title'    => esc_html__( 'Top - AMP Custom Ad Script', 'newsmax' ),
						'subtitle' => esc_html__( 'Input your AMP custom ad script.', 'newsmax' ),
						'default'  => ''
					),
					array(
						'id'     => 'section_end_amp_top_single_advert',
						'type'   => 'section',
						'class'  => 'ruby-section-end',
						'indent' => false
					),
					/** bottom single */
					array(
						'id'     => 'section_start_amp_bottom_single_advert',
						'type'   => 'section',
						'class'  => 'ruby-section-start',
						'title'  => esc_html__( 'Bottom Single Content Ad Settings', 'newsmax' ),
						'indent' => true
					),
					array(
						'id'       => 'amp_bottom_single_ad_type',
						'type'     => 'select',
						'title'    => esc_html__( 'Bottom - Ad Type', 'newsmax' ),
						'subtitle' => esc_html__( 'Select your ad type to display at the bottom single content.', 'newsmax' ),
						'options'  => array(
							'1' => esc_html__( '-- Adsense --', 'newsmax' ),
							'2' => esc_html__( 'AMP Custom Script Ad', 'newsmax' ),
						),
						'default'  => 1
					),
					array(
						'id'       => 'amp_bottom_single_adsense_client',
						'type'     => 'text',
						'required' => array( 'amp_bottom_single_ad_type', '=', '1' ),
						'title'    => esc_html__( 'Bottom - Data Ad Client', 'newsmax' ),
						'subtitle' => esc_html__( 'Input the data-ad-client number ID (without ca-pub-).', 'newsmax' ),
						'default'  => ''
					),
					array(
						'id'       => 'amp_bottom_single_adsense_slot',
						'type'     => 'text',
						'required' => array( 'amp_bottom_single_ad_type', '=', '1' ),
						'title'    => esc_html__( 'Bottom - Data Ad Slot', 'newsmax' ),
						'subtitle' => esc_html__( 'Input the data-ad-slot number ID.', 'newsmax' ),
						'default'  => ''
					),
					array(
						'id'       => 'amp_bottom_single_adsense_size',
						'type'     => 'select',
						'required' => array( 'amp_bottom_single_ad_type', '=', '1' ),
						'title'    => esc_html__( 'Bottom - Adsense Size', 'newsmax' ),
						'subtitle' => esc_html__( 'Select a size for this ad.', 'newsmax' ),
						'options'  => array(
							'1' => esc_html__( '-- Responsive --', 'newsmax' ),
							'2' => esc_html__( 'Fixed Height (90px)', 'newsmax' ),
						),
						'default'  => 1
					),
					array(
						'id'       => 'amp_bottom_single_ad_code',
						'type'     => 'textarea',
						'required' => array( 'amp_bottom_single_ad_type', '=', '2' ),
						'title'    => esc_html__( 'Bottom - AMP Custom Ad Script', 'newsmax' ),
						'subtitle' => esc_html__( 'Input your AMP custom ad script.', 'newsmax' ),
						'default'  => ''
					),
					array(
						'id'     => 'section_end_amp_bottom_single_advert',
						'type'   => 'section',
						'class'  => 'ruby-section-end',
						'indent' => false
					),
					/** inline content */
					array(
						'id'     => 'section_start_amp_inline_single_advert',
						'type'   => 'section',
						'class'  => 'ruby-section-start',
						'title'  => esc_html__( 'Inline Single Content Ad Settings', 'newsmax' ),
						'indent' => true
					),
					array(
						'id'       => 'amp_inline_single_ad_type',
						'type'     => 'select',
						'title'    => esc_html__( 'Inline - Ad Type', 'newsmax' ),
						'subtitle' => esc_html__( 'Select your ad type to display at the bottom single content.', 'newsmax' ),
						'options'  => array(
							'1' => esc_html__( '-- Adsense --', 'newsmax' ),
							'2' => esc_html__( 'AMP Custom Script Ad', 'newsmax' ),
						),
						'default'  => 1
					),
					array(
						'id'       => 'amp_inline_single_adsense_client',
						'type'     => 'text',
						'required' => array( 'amp_inline_single_ad_type', '=', '1' ),
						'title'    => esc_html__( 'Inline - Data Ad Client', 'newsmax' ),
						'subtitle' => esc_html__( 'Input the data-ad-client number ID (without ca-pub-).', 'newsmax' ),
						'default'  => ''
					),
					array(
						'id'       => 'amp_inline_single_adsense_slot',
						'type'     => 'text',
						'required' => array( 'amp_inline_single_ad_type', '=', '1' ),
						'title'    => esc_html__( 'Inline - Data Ad Slot', 'newsmax' ),
						'subtitle' => esc_html__( 'Input the data-ad-slot number ID.', 'newsmax' ),
						'default'  => ''
					),
					array(
						'id'       => 'amp_inline_single_adsense_size',
						'type'     => 'select',
						'required' => array( 'amp_inline_single_ad_type', '=', '1' ),
						'title'    => esc_html__( 'Inline - Adsense Size', 'newsmax' ),
						'subtitle' => esc_html__( 'Select a size for this ad.', 'newsmax' ),
						'options'  => array(
							'1' => esc_html__( '-- Responsive --', 'newsmax' ),
							'2' => esc_html__( 'Fixed Height (90px)', 'newsmax' ),
						),
						'default'  => 1
					),
					array(
						'id'       => 'amp_inline_single_ad_code',
						'type'     => 'textarea',
						'required' => array( 'amp_inline_single_ad_type', '=', '2' ),
						'title'    => esc_html__( 'Inline - AMP Custom Ad Script', 'newsmax' ),
						'subtitle' => esc_html__( 'Input your AMP custom ad script.', 'newsmax' ),
						'default'  => ''
					),
					array(
						'id'       => 'amp_inline_single_ad_pos',
						'type'     => 'text',
						'title'    => esc_html__( 'Inline - After Paragraph', 'newsmax' ),
						'subtitle' => esc_html__( 'display this ad after x paragraph. Default is 2', 'newsmax' ),
						'default'  => '2'
					),
					array(
						'id'     => 'section_end_amp_inline_single_advert',
						'type'   => 'section',
						'class'  => 'ruby-section-end no-border',
						'indent' => false
					),
				)
			);
		} else {
			return array(
				'id'     => 'newsmax_config_section_amp',
				'title'  => esc_html__( 'AMP Settings', 'newsmax' ),
				'desc'   => esc_html__( 'Select options for AMP settings.', 'newsmax' ),
				'icon'   => 'el el-road',
				'fields' => array(
					array(
						'id'    => 'amp_info_warning',
						'type'  => 'info',
						'title' => esc_html__( 'AMP Plugin is missing!', 'newsmax' ),
						'style' => 'warning',
						'desc'  => html_entity_decode( esc_html__( 'Accelerated Mobile Pages support, Please install <a target="_blank" href=\"https://wordpress.org/plugins/amp\">Automattic AMP</a> plugin to activate the features.', 'newsmax' ) ),
					),
				)
			);
		}
	}
}