<?php

/**
 * @return string
 * render breadcrumbs bar
 */
if ( ! function_exists( 'newsmax_ruby_dimox_breadcrumb' ) ) {
	function newsmax_ruby_dimox_breadcrumb( $is_single = '' ) {
		$check = newsmax_ruby_get_option( 'site_breadcrumb' );
		$protocol = 'http';
		if ( is_ssl() ) {
			$protocol = 'https';
		}
		ob_start(); ?>
		<div id="site-breadcrumb" class="breadcrumb-outer">
			<?php if ( !empty( $check ) ) : ?>
			<div class="breadcrumb-wrap">
				<div class="breadcrumb-inner ruby-container">
					<?php if ( function_exists( 'bcn_display' ) ) : ?>
						<span class="breadcrumb-navxt" vocab="<?php echo esc_html( $protocol ); ?>://schema.org/" typeof="BreadcrumbList"><?php bcn_display(); ?></span>
					<?php
					else :
						if ( function_exists( 'yoast_breadcrumb' ) ) :
							yoast_breadcrumb( '<span class="breadcrumb breadcrumb-yoast"><span class="breadcrumb-yoast">', '</span></span>' );
						endif;
					endif; ?>
				</div>
			</div>
			<?php endif; ?>
		</div>
		<?php return ob_get_clean();
	}
}