<?php
$newsmax_ruby_ad_script = '';
$newsmax_ruby_ad_image  = '';
$newsmax_ruby_ad_url    = '';

$newsmax_ruby_ad_type = newsmax_ruby_get_option( 'header_ad_type' );
if ( 'script' == $newsmax_ruby_ad_type ) {
	$newsmax_ruby_ad_script = newsmax_ruby_get_option( 'header_ad_script' );
} else {
	$newsmax_ruby_ad_image = newsmax_ruby_get_option( 'header_ad_image' );
	$newsmax_ruby_ad_url   = newsmax_ruby_get_option( 'header_ad_url' );
}?>
<?php if ( ! empty( $newsmax_ruby_ad_image['url'] ) && 'custom' == $newsmax_ruby_ad_type ) : ?>
	<aside class="header-ad-wrap is-custom-ad">
		<div class="header-ad-inner">
			<?php if ( ! empty( $newsmax_ruby_ad_url ) ) : ?>
                <a rel="nofollow" class="header-ad-image" href="<?php echo esc_url( $newsmax_ruby_ad_url ) ?>" target="_blank">
                    <img height="<?php echo esc_attr( $newsmax_ruby_ad_image['height'] ); ?>" width="<?php echo esc_attr( $newsmax_ruby_ad_image['width'] ); ?>" src="<?php echo esc_url( $newsmax_ruby_ad_image['url'] ); ?>" alt="<?php bloginfo( 'name' ); ?>" loading="lazy">
                </a>
			<?php else : ?>
                <div class="header-ad-image">
                    <img height="<?php echo esc_attr( $newsmax_ruby_ad_image['height'] ); ?>" width="<?php echo esc_attr( $newsmax_ruby_ad_image['width'] ); ?>" src="<?php echo esc_url( $newsmax_ruby_ad_image['url'] ) ?>" alt="<?php bloginfo( 'name' ); ?>" loading="lazy">
                </div>
			<?php endif; ?>
			</div>
		</aside>
	<?php elseif( ! empty( $newsmax_ruby_ad_script ) && 'script' == $newsmax_ruby_ad_type ) : ?>
	<aside class="header-ad-wrap is-script-ad">
		<div class="header-ad-inner">
			<?php if ( function_exists( 'newsmax_ruby_ad_render_script' ) ) : ?>
				<?php echo html_entity_decode( stripslashes( newsmax_ruby_ad_render_script( $newsmax_ruby_ad_script, 'banner_ad' ) ) ); ?>
			<?php else: ?>
				<?php echo '<div>' . html_entity_decode( stripslashes( $newsmax_ruby_ad_script ) ) . '</div>'; ?>
			<?php endif; ?>
		</div>
	</aside>
<?php endif;



