<?php
if ( ! function_exists( 'newsmax_ruby_metabox_s_page_toc' ) ) {
	function newsmax_ruby_metabox_s_page_toc() {

		return array(
			'id'         => 'newsmax_ruby_metabox_s_page_toc',
			'title'      => esc_html__( 'TABLE OF CONTENTS', 'newsmax' ),
			'post_types' => array( 'page' ),
			'priority'   => 'high',
			'context'    => 'normal',
			'fields'     => array(
				array(
					'id'      => 'table_contents_page',
					'name'    => esc_html__( 'Table of Contents', 'newsmax' ),
					'desc'    => esc_html__( 'Enable or disable the table content for this post.', 'newsmax' ),
					'type'    => 'select',
					'options' => array(
						'default' => esc_html__( '-- Default from Theme Options --', 'newsmax' ),
						'1'       => esc_html__( 'Enable', 'newsmax' ),
						'-1'      => esc_html__( 'Disable', 'newsmax' ),
					),
				),
				array(
					'id'   => 'table_contents_enable',
					'type' => 'text',
					'name' => esc_html__( 'Enable When', 'newsmax' ),
					'desc' => esc_html__( 'Input a minimum value for total heading tags to show the table of contents box. Leave this field empty to set as the default.', 'newsmax' ),
					'std'  => ''
				),
				array(
					'id'   => 'table_contents_position',
					'type' => 'text',
					'name' => esc_html__( 'Display Position', 'newsmax' ),
					'desc' => esc_html__( 'Input a position (After x paragraph) to display the table of contents box. Leave this field empty to set as the default.', 'newsmax' ),
					'std'  => ''
				),
			),
		);
	}
}