<?php
/**
 * @param $option_name
 *
 * @return string
 * get theme options
 */
if ( ! function_exists( 'newsmax_ruby_get_option' ) ) {
	function newsmax_ruby_get_option( $option_name ) {

		$options = get_option( 'newsmax_ruby_theme_options' );
		if ( empty( $options ) ) {
			$options = newsmax_ruby_redux_default_config();
		}
		if ( empty( $options[ $option_name ] ) ) {
			return false;
		} else {
			return $options[ $option_name ];
		}
	}
}

/**
 * @return mixed
 * get category page id
 */
if ( ! function_exists( 'newsmax_ruby_get_cat_id' ) ) {
	function newsmax_ruby_get_cat_id() {
		global $wp_query;

		return $wp_query->get_queried_object_id();
	}
}


if ( ! function_exists( 'newsmax_is_amp' ) ) {
	/**
	 * @return bool
	 */
	function newsmax_is_amp() {
		return function_exists( 'amp_is_request' ) && amp_is_request();
	}
}

if ( ! function_exists( 'newsmax_get_image_size' ) ) {
	/**
	 * @param $file
	 *
	 * @return array|false
	 */
	function newsmax_get_image_size( $file ) {
		return @getimagesize( $file );
	}
}