<?php
/** register composer blocks */
if ( ! function_exists( 'newsmax_composer_blocks' ) ) {
	function newsmax_composer_blocks() {
		$uri    = get_template_directory_uri();
		$blocks = array(
			'newsmax_ruby_fw_block_1'           => array(
				'title'         => esc_html__( 'Featured 1', 'newsmax' ),
				'description'   => esc_html__( 'show grid slider (full screen)', 'newsmax' ),
				'img'           => $uri . '/assets/images/fw-block-1.png',
				'section'       => 'section_full_width',
				'block_options' => newsmax_ruby_fw_block_1::block_config()
			),
			'newsmax_ruby_fw_block_2'           => array(
				'title'         => esc_html__( 'Featured 2', 'newsmax' ),
				'description'   => esc_html__( 'show grid slider (fullwidth)', 'newsmax' ),
				'img'           => $uri . '/assets/images/fw-block-2.png',
				'section'       => 'section_full_width',
				'block_options' => newsmax_ruby_fw_block_2::block_config()
			),
			'newsmax_ruby_fw_block_3'           => array(
				'title'         => esc_html__( 'Featured 3', 'newsmax' ),
				'description'   => esc_html__( 'show grid slider (fullwidth)', 'newsmax' ),
				'img'           => $uri . '/assets/images/fw-block-3.png',
				'section'       => 'section_full_width',
				'block_options' => newsmax_ruby_fw_block_3::block_config()
			),
			'newsmax_ruby_fw_block_4'           => array(
				'title'         => esc_html__( 'Featured 4', 'newsmax' ),
				'description'   => esc_html__( 'show big grid carousel (2 columns)', 'newsmax' ),
				'img'           => $uri . '/assets/images/fw-block-4.png',
				'section'       => 'section_full_width',
				'block_options' => newsmax_ruby_fw_block_4::block_config()
			),
			'newsmax_ruby_fw_block_5'           => array(
				'title'         => esc_html__( 'Featured 5', 'newsmax' ),
				'description'   => esc_html__( 'show grid carousel (3 columns)', 'newsmax' ),
				'img'           => $uri . '/assets/images/fw-block-5.png',
				'section'       => 'section_full_width',
				'block_options' => newsmax_ruby_fw_block_5::block_config()
			),
			'newsmax_ruby_fw_block_6'           => array(
				'title'         => esc_html__( 'Featured 6', 'newsmax' ),
				'description'   => esc_html__( 'show big carousel (full screen)', 'newsmax' ),
				'img'           => $uri . '/assets/images/fw-block-6.png',
				'section'       => 'section_full_width',
				'block_options' => newsmax_ruby_fw_block_6::block_config()
			),
			'newsmax_ruby_fw_block_7'           => array(
				'title'         => esc_html__( 'Featured 7', 'newsmax' ),
				'description'   => esc_html__( 'show featured grid slider layout', 'newsmax' ),
				'img'           => $uri . '/assets/images/fw-block-7.png',
				'section'       => 'section_full_width',
				'block_options' => newsmax_ruby_fw_block_7::block_config()
			),
			'newsmax_ruby_fw_block_8'           => array(
				'title'         => esc_html__( 'Featured 8', 'newsmax' ),
				'description'   => esc_html__( 'show featured grid slider layout', 'newsmax' ),
				'img'           => $uri . '/assets/images/fw-block-8.png',
				'section'       => 'section_full_width',
				'block_options' => newsmax_ruby_fw_block_8::block_config()
			),
			'newsmax_ruby_fw_block_9'           => array(
				'title'         => esc_html__( 'Featured 9', 'newsmax' ),
				'description'   => esc_html__( 'show featured grid slider layout', 'newsmax' ),
				'img'           => $uri . '/assets/images/fw-block-9.png',
				'section'       => 'section_full_width',
				'block_options' => newsmax_ruby_fw_block_9::block_config()
			),
			'newsmax_ruby_fw_block_10'          => array(
				'title'         => esc_html__( 'Featured 10', 'newsmax' ),
				'description'   => esc_html__( 'show featured carousel slider', 'newsmax' ),
				'img'           => $uri . '/assets/images/fw-block-10.png',
				'section'       => 'section_full_width',
				'block_options' => newsmax_ruby_fw_block_10::block_config()
			),
			'newsmax_ruby_fw_block_11'          => array(
				'title'         => esc_html__( 'Featured 11', 'newsmax' ),
				'description'   => esc_html__( 'show featured slider (fullwidth)', 'newsmax' ),
				'img'           => $uri . '/assets/images/fw-block-11.png',
				'section'       => 'section_full_width',
				'block_options' => newsmax_ruby_fw_block_11::block_config()
			),
			'newsmax_ruby_fw_block_12'          => array(
				'title'         => esc_html__( 'Featured 12', 'newsmax' ),
				'description'   => esc_html__( 'show featured slider with nav slider (fullwidth)', 'newsmax' ),
				'img'           => $uri . '/assets/images/fw-block-12.png',
				'section'       => 'section_full_width',
				'block_options' => newsmax_ruby_fw_block_12::block_config()
			),
			'newsmax_ruby_fw_block_grid_1'      => array(
				'title'         => esc_html__( 'Grid 1', 'newsmax' ),
				'description'   => esc_html__( 'show default grid layout (3 columns)', 'newsmax' ),
				'img'           => $uri . '/assets/images/fw-block-grid-1.png',
				'section'       => 'section_full_width',
				'block_options' => newsmax_ruby_fw_block_grid_1::block_config()
			),
			'newsmax_ruby_fw_block_grid_2'      => array(
				'title'         => esc_html__( 'Grid 2', 'newsmax' ),
				'description'   => esc_html__( 'show big grid layout (2 columns)', 'newsmax' ),
				'img'           => $uri . '/assets/images/fw-block-grid-2.png',
				'section'       => 'section_full_width',
				'block_options' => newsmax_ruby_fw_block_grid_2::block_config()
			),
			'newsmax_ruby_fw_block_grid_3'      => array(
				'title'         => esc_html__( 'Grid 3', 'newsmax' ),
				'description'   => esc_html__( 'show small grid layout (5 columns)', 'newsmax' ),
				'img'           => $uri . '/assets/images/fw-block-grid-3.png',
				'section'       => 'section_full_width',
				'block_options' => newsmax_ruby_fw_block_grid_3::block_config()
			),
			'newsmax_ruby_fw_block_grid_4'      => array(
				'title'         => esc_html__( 'Grid 4', 'newsmax' ),
				'description'   => esc_html__( 'show small grid layout (3 columns)', 'newsmax' ),
				'img'           => $uri . '/assets/images/fw-block-grid-4.png',
				'section'       => 'section_full_width',
				'block_options' => newsmax_ruby_fw_block_grid_4::block_config()
			),
			'newsmax_ruby_fw_block_grid_5'      => array(
				'title'         => esc_html__( 'Grid 5', 'newsmax' ),
				'description'   => esc_html__( 'show small grid without thumbnail (3 columns)', 'newsmax' ),
				'img'           => $uri . '/assets/images/fw-block-grid-5.png',
				'section'       => 'section_full_width',
				'block_options' => newsmax_ruby_fw_block_grid_5::block_config()
			),
			'newsmax_ruby_fw_block_grid_6'      => array(
				'title'         => esc_html__( 'Grid 6', 'newsmax' ),
				'description'   => esc_html__( 'show small grid without thumbnail (4 columns)', 'newsmax' ),
				'img'           => $uri . '/assets/images/fw-block-grid-6.png',
				'section'       => 'section_full_width',
				'block_options' => newsmax_ruby_fw_block_grid_6::block_config()
			),
			'newsmax_ruby_fw_block_grid_7'      => array(
				'title'         => esc_html__( 'Grid 7', 'newsmax' ),
				'description'   => esc_html__( 'show overlay grid (2 columns)', 'newsmax' ),
				'img'           => $uri . '/assets/images/fw-block-grid-7.png',
				'section'       => 'section_full_width',
				'block_options' => newsmax_ruby_fw_block_grid_7::block_config()
			),
			'newsmax_ruby_fw_block_grid_8'      => array(
				'title'         => esc_html__( 'Grid 8', 'newsmax' ),
				'description'   => esc_html__( 'show overlay grid (3 columns)', 'newsmax' ),
				'img'           => $uri . '/assets/images/fw-block-grid-8.png',
				'section'       => 'section_full_width',
				'block_options' => newsmax_ruby_fw_block_grid_8::block_config()
			),
			'newsmax_ruby_fw_block_grid_9'      => array(
				'title'         => esc_html__( 'Grid 9', 'newsmax' ),
				'description'   => esc_html__( 'show overlay grid (3 columns)', 'newsmax' ),
				'img'           => $uri . '/assets/images/fw-block-grid-9.png',
				'section'       => 'section_full_width',
				'block_options' => newsmax_ruby_fw_block_grid_9::block_config()
			),
			'newsmax_ruby_fw_block_gallery_1'   => array(
				'title'         => esc_html__( 'Gallery Grid 1', 'newsmax' ),
				'description'   => esc_html__( 'show gallery grid with popup slider in fullwidth section', 'newsmax' ),
				'img'           => $uri . '/assets/images/block-gallery-1.png',
				'section'       => 'section_full_width',
				'block_options' => newsmax_ruby_fw_block_gallery_1::block_config()
			),
			'newsmax_ruby_fw_block_gallery_2'   => array(
				'title'         => esc_html__( 'Gallery Grid 2', 'newsmax' ),
				'description'   => esc_html__( 'show gallery grid with popup slider in fullwidth section', 'newsmax' ),
				'img'           => $uri . '/assets/images/block-gallery-2.png',
				'section'       => 'section_full_width',
				'block_options' => newsmax_ruby_fw_block_gallery_2::block_config()
			),
			// fullwidth video block
			'newsmax_ruby_fw_block_video_1'     => array(
				'title'         => esc_html__( 'Playlist 1', 'newsmax' ),
				'description'   => esc_html__( 'show video playlist in fullwidth section', 'newsmax' ),
				'img'           => $uri . '/assets/images/fw-block-video-1.png',
				'section'       => 'section_full_width',
				'block_options' => newsmax_ruby_fw_block_video_1::block_config()
			),
			'newsmax_ruby_fw_block_video_2'     => array(
				'title'         => esc_html__( 'Playlist 2', 'newsmax' ),
				'description'   => esc_html__( 'show video playlist in fullwidth section', 'newsmax' ),
				'img'           => $uri . '/assets/images/fw-block-video-2.png',
				'section'       => 'section_full_width',
				'block_options' => newsmax_ruby_fw_block_video_2::block_config()
			),
			'newsmax_ruby_fw_block_onet_1'      => array(
				'title'         => esc_html__( 'One-third 1 (33%)', 'newsmax' ),
				'description'   => esc_html__( 'show one-third list layout in full-width section (33% width)', 'newsmax' ),
				'img'           => $uri . '/assets/images/fw-block-onet-1.png',
				'section'       => 'section_full_width',
				'block_options' => newsmax_ruby_fw_block_onet_1::block_config()
			),
			'newsmax_ruby_fw_block_onet_2'      => array(
				'title'         => esc_html__( 'One-third 2 (33%)', 'newsmax' ),
				'description'   => esc_html__( 'show one-third list layout in full-width section (33% width)', 'newsmax' ),
				'img'           => $uri . '/assets/images/fw-block-onet-2.png',
				'section'       => 'section_full_width',
				'block_options' => newsmax_ruby_fw_block_onet_2::block_config()
			),
			'newsmax_ruby_fw_block_onet_3'      => array(
				'title'         => esc_html__( 'One-third 3 (33%)', 'newsmax' ),
				'description'   => esc_html__( 'show one-third list layout in full-width section (33% width)', 'newsmax' ),
				'img'           => $uri . '/assets/images/fw-block-onet-3.png',
				'section'       => 'section_full_width',
				'block_options' => newsmax_ruby_fw_block_onet_3::block_config()
			),
			'newsmax_ruby_fw_block_onet_4'      => array(
				'title'         => esc_html__( 'One-third 4 (33%)', 'newsmax' ),
				'description'   => esc_html__( 'show one-third list layout in full-width section (33% width)', 'newsmax' ),
				'img'           => $uri . '/assets/images/fw-block-onet-4.png',
				'section'       => 'section_full_width',
				'block_options' => newsmax_ruby_fw_block_onet_4::block_config()
			),
			'newsmax_ruby_fw_block_html'        => array(
				'title'         => esc_html__( 'Custom HTML', 'newsmax' ),
				'description'   => esc_html__( 'show HTMl content, this block allows you can input text, HTML, shortcodes, iframe...', 'newsmax' ),
				'img'           => $uri . '/assets/images/block-html.png',
				'section'       => 'section_full_width',
				'block_options' => newsmax_ruby_fw_block_html::block_config()
			),
			'newsmax_ruby_fw_block_advertising' => array(
				'title'         => esc_html__( 'Advertising', 'newsmax' ),
				'description'   => esc_html__( 'show Advertisement box in fullwidth section', 'newsmax' ),
				'section'       => 'section_full_width',
				'img'           => get_template_directory_uri() . '/assets/images/block-ad.png',
				'block_options' => newsmax_ruby_fw_block_advertising::block_config()
			),
			'newsmax_ruby_fw_block_shortcode'   => array(
				'title'         => esc_html__( 'Shortcodes', 'newsmax' ),
				'description'   => esc_html__( 'show shortcodes in fullwidth section', 'newsmax' ),
				'section'       => 'section_full_width',
				'img'           => get_template_directory_uri() . '/assets/images/block-shortcode.png',
				'block_options' => newsmax_ruby_fw_block_shortcode::block_config()
			),
			'newsmax_ruby_fw_block_subscribe'   => array(
				'title'         => esc_html__( 'Subscribe', 'newsmax' ),
				'description'   => esc_html__( 'show subscribe form in fullwidth section', 'newsmax' ),
				'section'       => 'section_full_width',
				'img'           => get_template_directory_uri() . '/assets/images/block-subscribe.png',
				'block_options' => newsmax_ruby_fw_block_subscribe::block_config()
			),
			'newsmax_ruby_fw_block_col'         => array(
				'title'         => esc_html__( 'Column - Images', 'newsmax' ),
				'description'   => esc_html__( 'show column images and destination links in full-width section.', 'newsmax' ),
				'section'       => 'section_full_width',
				'img'           => get_template_directory_uri() . '/assets/images/block-col-img.png',
				'block_options' => newsmax_ruby_fw_block_col::block_config()
			),
			'newsmax_ruby_fw_block_raw_html'    => array(
				'title'         => esc_html__( 'Column - Raw HTML', 'newsmax' ),
				'description'   => esc_html__( 'show column raw HTML in full-width section.', 'newsmax' ),
				'section'       => 'section_full_width',
				'img'           => get_template_directory_uri() . '/assets/images/block-raw-html.png',
				'block_options' => newsmax_ruby_fw_block_raw_html::block_config()
			),
			// has sidebar
			'newsmax_ruby_hs_block_1'           => array(
				'title'         => esc_html__( 'Block 1', 'newsmax' ),
				'description'   => esc_html__( 'show grid layout in has sidebar section', 'newsmax' ),
				'img'           => $uri . '/assets/images/hs-block-1.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_1::block_config()
			),
			'newsmax_ruby_hs_block_2'           => array(
				'title'         => esc_html__( 'Block 2', 'newsmax' ),
				'description'   => esc_html__( 'show grid layout in has sidebar section', 'newsmax' ),
				'img'           => $uri . '/assets/images/hs-block-2.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_2::block_config()
			),
			'newsmax_ruby_hs_block_3'           => array(
				'title'         => esc_html__( 'Block 3', 'newsmax' ),
				'description'   => esc_html__( 'show grid layout in has sidebar section', 'newsmax' ),
				'img'           => $uri . '/assets/images/hs-block-3.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_3::block_config()
			),
			'newsmax_ruby_hs_block_4'           => array(
				'title'         => esc_html__( 'Block 4', 'newsmax' ),
				'description'   => esc_html__( 'show grid layout in has sidebar section', 'newsmax' ),
				'img'           => $uri . '/assets/images/hs-block-4.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_4::block_config()
			),
			'newsmax_ruby_hs_block_5'           => array(
				'title'         => esc_html__( 'Block 5', 'newsmax' ),
				'description'   => esc_html__( 'show grid layout in has sidebar section', 'newsmax' ),
				'img'           => $uri . '/assets/images/hs-block-5.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_5::block_config()
			),
			'newsmax_ruby_hs_block_6'           => array(
				'title'         => esc_html__( 'Block 6', 'newsmax' ),
				'description'   => esc_html__( 'show grid layout in has sidebar section', 'newsmax' ),
				'img'           => $uri . '/assets/images/hs-block-6.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_6::block_config()
			),
			'newsmax_ruby_hs_block_7'           => array(
				'title'         => esc_html__( 'Block 7', 'newsmax' ),
				'description'   => esc_html__( 'show grid layout in has sidebar section', 'newsmax' ),
				'img'           => $uri . '/assets/images/hs-block-7.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_7::block_config()
			),
			'newsmax_ruby_hs_block_8'           => array(
				'title'         => esc_html__( 'Block 8', 'newsmax' ),
				'description'   => esc_html__( 'show grid layout in has sidebar section', 'newsmax' ),
				'img'           => $uri . '/assets/images/hs-block-8.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_8::block_config()
			),
			'newsmax_ruby_hs_block_9'           => array(
				'title'         => esc_html__( 'Block 9', 'newsmax' ),
				'description'   => esc_html__( 'show grid layout in has sidebar section', 'newsmax' ),
				'img'           => $uri . '/assets/images/hs-block-9.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_9::block_config()
			),
			'newsmax_ruby_hs_block_10'          => array(
				'title'         => esc_html__( 'Block 10', 'newsmax' ),
				'description'   => esc_html__( 'show grid layout in has sidebar section', 'newsmax' ),
				'img'           => $uri . '/assets/images/hs-block-10.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_10::block_config()
			),
			'newsmax_ruby_hs_block_11'          => array(
				'title'         => esc_html__( 'Block 11', 'newsmax' ),
				'description'   => esc_html__( 'show grid layout in has sidebar section', 'newsmax' ),
				'img'           => $uri . '/assets/images/hs-block-11.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_11::block_config()
			),
			'newsmax_ruby_hs_block_12'          => array(
				'title'         => esc_html__( 'Block 12', 'newsmax' ),
				'description'   => esc_html__( 'show grid layout in has sidebar section', 'newsmax' ),
				'img'           => $uri . '/assets/images/hs-block-12.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_12::block_config()
			),
			'newsmax_ruby_hs_block_13'          => array(
				'title'         => esc_html__( 'Block 13', 'newsmax' ),
				'description'   => esc_html__( 'show grid layout in has sidebar section', 'newsmax' ),
				'img'           => $uri . '/assets/images/hs-block-13.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_13::block_config()
			),
			'newsmax_ruby_hs_block_14'          => array(
				'title'         => esc_html__( 'Block 14', 'newsmax' ),
				'description'   => esc_html__( 'show grid layout in has sidebar section', 'newsmax' ),
				'img'           => $uri . '/assets/images/hs-block-14.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_14::block_config()
			),
			'newsmax_ruby_hs_block_15'          => array(
				'title'         => esc_html__( 'Featured 1', 'newsmax' ),
				'description'   => esc_html__( 'show featured slider in has sidebar section', 'newsmax' ),
				'img'           => $uri . '/assets/images/hs-block-15.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_15::block_config()
			),
			'newsmax_ruby_hs_block_16'          => array(
				'title'         => esc_html__( 'Featured 2', 'newsmax' ),
				'description'   => esc_html__( 'show featured slider in has sidebar section', 'newsmax' ),
				'img'           => $uri . '/assets/images/hs-block-16.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_16::block_config()
			),
			'newsmax_ruby_hs_block_oneh_1'      => array(
				'title'         => esc_html__( 'One-half 1 (50%)', 'newsmax' ),
				'description'   => esc_html__( 'show one-half list layout in has sidebar section (50% width)', 'newsmax' ),
				'img'           => $uri . '/assets/images/hs-block-oneh-1.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_oneh_1::block_config()
			),
			'newsmax_ruby_hs_block_oneh_2'      => array(
				'title'         => esc_html__( 'One-half 2 (50%)', 'newsmax' ),
				'description'   => esc_html__( 'show one-half list layout in has sidebar section (50% width)', 'newsmax' ),
				'img'           => $uri . '/assets/images/hs-block-oneh-2.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_oneh_2::block_config()
			),
			'newsmax_ruby_hs_block_oneh_3'      => array(
				'title'         => esc_html__( 'One-half 3 (50%)', 'newsmax' ),
				'description'   => esc_html__( 'show one-half list layout in has sidebar section (50% width)', 'newsmax' ),
				'img'           => $uri . '/assets/images/hs-block-oneh-3.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_oneh_3::block_config()
			),
			'newsmax_ruby_hs_block_oneh_4'      => array(
				'title'         => esc_html__( 'One-half 4 (50%)', 'newsmax' ),
				'description'   => esc_html__( 'show one-half list layout in has sidebar section (50% width)', 'newsmax' ),
				'img'           => $uri . '/assets/images/hs-block-oneh-4.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_oneh_4::block_config()
			),
			'newsmax_ruby_hs_block_grid_1'      => array(
				'title'         => esc_html__( 'Grid 1', 'newsmax' ),
				'description'   => esc_html__( 'show the grid layout (2 columns) of list of posts in the has-sidebar section', 'newsmax' ),
				'img'           => $uri . '/assets/images/hs-block-grid-1.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_grid_1::block_config()
			),
			'newsmax_ruby_hs_block_grid_2'      => array(
				'title'         => esc_html__( 'Grid 2', 'newsmax' ),
				'description'   => esc_html__( 'show the grid layout (2 columns) of list of posts in the has-sidebar section', 'newsmax' ),
				'img'           => $uri . '/assets/images/hs-block-grid-2.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_grid_2::block_config()
			),
			'newsmax_ruby_hs_block_grid_3'      => array(
				'title'         => esc_html__( 'Grid 3', 'newsmax' ),
				'description'   => esc_html__( 'show the grid layout (2 columns) of list of posts in the has-sidebar section', 'newsmax' ),
				'img'           => $uri . '/assets/images/hs-block-grid-3.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_grid_3::block_config()
			),
			'newsmax_ruby_hs_block_grid_4'      => array(
				'title'         => esc_html__( 'Grid 4', 'newsmax' ),
				'description'   => esc_html__( 'show the grid layout (2 columns) of list of posts in the has-sidebar section', 'newsmax' ),
				'img'           => $uri . '/assets/images/hs-block-grid-4.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_grid_4::block_config()
			),
			'newsmax_ruby_hs_block_grid_5'      => array(
				'title'         => esc_html__( 'Grid 5', 'newsmax' ),
				'description'   => esc_html__( 'show the grid layout (3 columns) of list of posts in the has-sidebar section', 'newsmax' ),
				'img'           => $uri . '/assets/images/hs-block-grid-5.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_grid_5::block_config()
			),
			'newsmax_ruby_hs_block_grid_6'      => array(
				'title'         => esc_html__( 'Grid 6', 'newsmax' ),
				'description'   => esc_html__( 'show overlay grid layout (3 columns) of list of posts in the has-sidebar section', 'newsmax' ),
				'img'           => $uri . '/assets/images/hs-block-grid-6.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_grid_6::block_config()
			),
			'newsmax_ruby_hs_block_list_1'      => array(
				'title'         => esc_html__( 'List 1', 'newsmax' ),
				'description'   => esc_html__( 'show the list layout of list of posts in the has-sidebar section', 'newsmax' ),
				'img'           => $uri . '/assets/images/hs-block-list-1.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_list_1::block_config()
			),
			'newsmax_ruby_hs_block_list_2'      => array(
				'title'         => esc_html__( 'List 2', 'newsmax' ),
				'description'   => esc_html__( 'show the list layout of list of posts in the has-sidebar section', 'newsmax' ),
				'img'           => $uri . '/assets/images/hs-block-list-2.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_list_2::block_config()
			),
			'newsmax_ruby_hs_block_list_3'      => array(
				'title'         => esc_html__( 'List 3', 'newsmax' ),
				'description'   => esc_html__( 'show the list layout of list of posts in the has-sidebar section', 'newsmax' ),
				'img'           => $uri . '/assets/images/hs-block-list-3.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_list_3::block_config()
			),
			'newsmax_ruby_hs_block_classic_1'   => array(
				'title'         => esc_html__( 'Classic 1', 'newsmax' ),
				'description'   => esc_html__( 'show the classic layout of list of posts in the has-sidebar section', 'newsmax' ),
				'img'           => $uri . '/assets/images/hs-block-classic-1.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_classic_1::block_config()
			),
			'newsmax_ruby_hs_block_classic_2'   => array(
				'title'         => esc_html__( 'Classic 2', 'newsmax' ),
				'description'   => esc_html__( 'show the classic layout of list of posts in the has-sidebar section', 'newsmax' ),
				'img'           => $uri . '/assets/images/hs-block-classic-2.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_classic_2::block_config()
			),
			'newsmax_ruby_hs_block_mix_1'       => array(
				'title'         => esc_html__( 'Mix 1', 'newsmax' ),
				'description'   => esc_html__( 'show mix layout, 1st classic layout and then list Layout', 'newsmax' ),
				'img'           => $uri . '/assets/images/hs-block-mix-1.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_mix_1::block_config()
			),
			'newsmax_ruby_hs_block_mix_2'       => array(
				'title'         => esc_html__( 'Mix 2', 'newsmax' ),
				'description'   => esc_html__( 'show mix layout, 1st classic layout and then list Layout', 'newsmax' ),
				'img'           => $uri . '/assets/images/hs-block-mix-2.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_mix_2::block_config()
			),
			'newsmax_ruby_hs_block_mix_3'       => array(
				'title'         => esc_html__( 'Mix 3', 'newsmax' ),
				'description'   => esc_html__( 'show mix layout, 1st classic layout and then grid Layout (2 columns)', 'newsmax' ),
				'img'           => $uri . '/assets/images/hs-block-mix-3.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_mix_3::block_config()
			),
			'newsmax_ruby_hs_block_mix_4'       => array(
				'title'         => esc_html__( 'Mix 4', 'newsmax' ),
				'description'   => esc_html__( 'show mix layout, 1st classic layout and then grid Layout (3 columns)', 'newsmax' ),
				'img'           => $uri . '/assets/images/hs-block-mix-4.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_mix_4::block_config()
			),
			'newsmax_ruby_hs_block_mix_5'       => array(
				'title'         => esc_html__( 'Mix 5', 'newsmax' ),
				'description'   => esc_html__( 'show mix layout, 1st classic layout (style 2) and then list Layout', 'newsmax' ),
				'img'           => $uri . '/assets/images/hs-block-mix-5.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_mix_5::block_config()
			),
			'newsmax_ruby_hs_block_mix_6'       => array(
				'title'         => esc_html__( 'Mix 6', 'newsmax' ),
				'description'   => esc_html__( 'show mix layout, 1st classic layout (style 2) and then list Layout', 'newsmax' ),
				'img'           => $uri . '/assets/images/hs-block-mix-6.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_mix_6::block_config()
			),
			'newsmax_ruby_hs_block_mix_7'       => array(
				'title'         => esc_html__( 'Mix 7', 'newsmax' ),
				'description'   => esc_html__( 'show mix layout, 1st classic layout and then grid Layout (2 columns)', 'newsmax' ),
				'img'           => $uri . '/assets/images/hs-block-mix-7.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_mix_7::block_config()
			),
			'newsmax_ruby_hs_block_mix_8'       => array(
				'title'         => esc_html__( 'Mix 8', 'newsmax' ),
				'description'   => esc_html__( 'show mix layout, 1st classic layout and then grid Layout (3 columns)', 'newsmax' ),
				'img'           => $uri . '/assets/images/hs-block-mix-8.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_mix_8::block_config()
			),
			'newsmax_ruby_hs_block_gallery_1'   => array(
				'title'         => esc_html__( 'Galley 1', 'newsmax' ),
				'description'   => esc_html__( 'show gallery grid in has sidebar section', 'newsmax' ),
				'img'           => $uri . '/assets/images/block-gallery-1.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_gallery_1::block_config()
			),
			'newsmax_ruby_hs_block_gallery_2'   => array(
				'title'         => esc_html__( 'Gallery 2', 'newsmax' ),
				'description'   => esc_html__( 'show gallery grid in has sidebar section', 'newsmax' ),
				'img'           => $uri . '/assets/images/block-gallery-2.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_gallery_2::block_config()
			),
			'newsmax_ruby_hs_block_video_1'     => array(
				'title'         => esc_html__( 'Playlist 1', 'newsmax' ),
				'description'   => esc_html__( 'show video playlist in has sidebar section', 'newsmax' ),
				'img'           => $uri . '/assets/images/hs-block-video-1.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_video_1::block_config()
			),
			'newsmax_ruby_hs_block_video_2'     => array(
				'title'         => esc_html__( 'Playlist 2', 'newsmax' ),
				'description'   => esc_html__( 'show video playlist in has sidebar section', 'newsmax' ),
				'img'           => $uri . '/assets/images/hs-block-video-2.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_video_2::block_config()
			),
			'newsmax_ruby_hs_block_html'        => array(
				'title'         => esc_html__( 'Custom HTML', 'newsmax' ),
				'description'   => esc_html__( 'show HTMl content, this block allows you can input text, HTML, shortcodes, iframe...', 'newsmax' ),
				'img'           => $uri . '/assets/images/block-html.png',
				'section'       => 'section_has_sidebar',
				'block_options' => newsmax_ruby_hs_block_html::block_config()
			),
			'newsmax_ruby_hs_block_advertising' => array(
				'title'         => esc_html__( 'Advertising', 'newsmax' ),
				'description'   => esc_html__( 'show Advertisement box in has sidebar section', 'newsmax' ),
				'section'       => 'section_has_sidebar',
				'img'           => get_template_directory_uri() . '/assets/images/block-ad.png',
				'block_options' => newsmax_ruby_hs_block_advertising::block_config()
			),
			'newsmax_ruby_hs_block_shortcode'   => array(
				'title'         => esc_html__( 'Shortcodes', 'newsmax' ),
				'description'   => esc_html__( 'show shortcodes in has sidebar section', 'newsmax' ),
				'section'       => 'section_has_sidebar',
				'img'           => get_template_directory_uri() . '/assets/images/block-shortcode.png',
				'block_options' => newsmax_ruby_hs_block_shortcode::block_config()
			),
			'newsmax_ruby_hs_block_subscribe'   => array(
				'title'         => esc_html__( 'Subscribe', 'newsmax' ),
				'description'   => esc_html__( 'show subscribe form in has sidebar section', 'newsmax' ),
				'section'       => 'section_has_sidebar',
				'img'           => get_template_directory_uri() . '/assets/images/block-subscribe.png',
				'block_options' => newsmax_ruby_hs_block_subscribe::block_config()
			),
			'newsmax_ruby_hs_block_raw_html'    => array(
				'title'         => esc_html__( 'Column - Raw HTML', 'newsmax' ),
				'description'   => esc_html__( 'show column raw HTML in has sidebar section.', 'newsmax' ),
				'section'       => 'section_has_sidebar',
				'img'           => get_template_directory_uri() . '/assets/images/block-raw-html.png',
				'block_options' => newsmax_ruby_hs_block_raw_html::block_config()
			),
		);

		return $blocks;
	}
}


/**
 * this file render ruby composer layouts
 */
if ( ! class_exists( 'newsmax_ruby_composer_render' ) ) {
	class newsmax_ruby_composer_render {

		/**
		 * @return bool|string
		 * render page composer
		 */
		static function render_page() {

			global $paged;
			$paged = intval( get_query_var( 'paged' ) );
			if ( empty( $paged ) ) {
				$paged = intval( get_query_var( 'page' ) );
			}

			$page_composer_data = get_post_meta( get_the_ID(), 'newsmax_ruby_page_composer_data', true );

			if ( empty( $page_composer_data ) || ! is_array( $page_composer_data ) || $paged > 1 ) {
				return false;
			}

			$str = '';
			foreach ( $page_composer_data as $section_data ) {
				$str .= self::render_section( $section_data );
			}

			return $str;
		}


		/**
		 * @param $section_data
		 *
		 * @return string
		 * render page section
		 */
		static function render_section( $section_data ) {
			// check
			if ( empty( $section_data['section_type'] ) ) {
				return false;
			}


			$str = '';
			switch ( $section_data['section_type'] ) {
				case 'section_full_width' :
					$str .= self::render_section_fw( $section_data );
					break;
				case 'section_has_sidebar' :
					$str .= self::render_section_hs( $section_data );
					break;
			}

			return $str;
		}


		/**
		 * @param $section_data
		 *
		 * @return string
		 * render fw section
		 */
		static function render_section_fw( $section_data ) {

			if ( empty( $section_data['blocks'] ) || ! is_array( $section_data['blocks'] ) ) {
				return false;
			}

			if ( ! empty( $section_data['section_id'] ) ) {
				$section_id = $section_data['section_id'];
			} else {
				$section_id = '';
			}


			$counter    = 1;
			$last_check = false;
			$str        = '';

			$str .= self::open_section_fw( $section_id );
			foreach ( $section_data['blocks'] as $block ) {

				if ( true === self::check_fw_block_onet( $block ) ) {
					if ( 1 == $counter ) {
						$str .= '<div class="block-third-outer clearfix ruby-container">';
						$last_check = true;
					}
					$counter ++;
				} else {

					if ( $counter <= 3 && true === $last_check ) {
						$str .= '</div>';

						$counter    = 1;
						$last_check = false;
					}
				}

				$str .= ruby_composer_block::render( 'section_full_width', $block );

				if ( $counter > 3 ) {
					$str .= '</div>';

					$counter    = 1;
					$last_check = false;
				}
			}

			if ( 1 !== $counter ) {
				$str .= '</div>';
			}

			$str .= self::close_section_fw();

			return $str;

		}


		/**
		 * @param $section_data
		 *
		 * @return string
		 * render has sidebar section
		 */
		static function render_section_hs( $section_data ) {

			if ( empty( $section_data['blocks'] ) || ! is_array( $section_data['blocks'] ) ) {
				return false;
			}

			if ( ! empty( $section_data['section_id'] ) ) {
				$section_id = $section_data['section_id'];
			} else {
				$section_id = '';
			}

			if ( ! empty( $section_data['section_sidebar_position'] ) ) {
				$sidebar_position = $section_data['section_sidebar_position'];
			} else {
				$sidebar_position = 'right';
			}

			if ( ! empty( $section_data['section_sidebar_sticky'] ) ) {
				$sidebar_sticky = $section_data['section_sidebar_sticky'];
			} else {
				$sidebar_sticky = 'default';
			}

			if ( ! empty( $section_data['section_sidebar'] ) ) {
				$sidebar_name = $section_data['section_sidebar'];
			} else {
				$sidebar_name = 'newsmax_ruby_sidebar_default';
			}


			$counter    = 1;
			$last_check = false;
			$str        = '';

			$str .= self::open_section_hs( $section_id, $sidebar_position );
			$str .= self::open_section_hs_content( $sidebar_position );

			foreach ( $section_data['blocks'] as $block ) {

				// clear float
				if ( true === self::check_sb_block_oneh( $block ) ) {
					$last_check = true;
					$counter ++;

				} else {
					if ( true === $last_check && $counter == 2 ) {
						$str .= '<div class="clearfix"></div>';
					}

					$counter    = 1;
					$last_check = false;
				}

				$str .= ruby_composer_block::render( 'section_has_sidebar', $block );

				if ( $counter > 2 ) {
					$str .= '<div class="clearfix"></div>';
					$counter = 1;
				}
			}
			$str .= self::close_section_hs_content();

			$str .= self::open_sidebar( $sidebar_sticky );
			$str .= self::render_sidebar( $sidebar_name );
			$str .= self::close_sidebar( $sidebar_sticky );

			$str .= self::close_section_hs();

			return $str;
		}


		/**
		 * @param $sidebar_name
		 *
		 * @return bool|string
		 * render sidebar
		 */
		static function render_sidebar( $sidebar_name ) {

			// check sidebar
			if ( empty( $sidebar_name ) || ! is_active_sidebar( $sidebar_name ) ) {
				return false;
			}

			ob_start();
			dynamic_sidebar( $sidebar_name );

			return ob_get_clean();

		}


		/**
		 * @param $section_id
		 *
		 * @return string
		 * open section full width
		 */
		static function open_section_fw( $section_id ) {
			if ( ! empty( $section_id ) ) {
				return '<div id="' . esc_attr( $section_id ) . '" class="ruby-section-fw ruby-section">';
			} else {
				return '<div class="ruby-section-fw ruby-section">';
			}
		}


		/**
		 * @return string
		 * close fw section
		 */
		static function close_section_fw() {
			return '</div>';
		}


		/**
		 * @param        $section_id
		 * @param string $sidebar_position
		 *
		 * @return string
		 */
		static function open_section_hs( $section_id, $sidebar_position = 'right' ) {
			$str = '';
			if ( ! empty( $section_id ) ) {
				$str .= '<div id="' . esc_attr( $section_id ) . '" class="ruby-section ruby-section-hs row is-sidebar-' . esc_attr( $sidebar_position ) . '">';
				$str .= '<div class="ruby-container">';
			} else {
				$str .= '<div class="ruby-section ruby-section-hs row is-sidebar-' . esc_attr( $sidebar_position ) . '">';
				$str .= '<div class="ruby-container">';
			}

			return $str;
		}

		/**
		 * @return string
		 * close sidebar section
		 */
		static function close_section_hs() {
			return '</div></div>';
		}


		/**
		 * @param string $sidebar_position
		 *
		 * @return string
		 * open has content of section has sidebar
		 */
		static function open_section_hs_content( $sidebar_position = 'right' ) {
			if ( 'none' == $sidebar_position ) {
				return '<div class="ruby-content-wrap content-without-sidebar col-xs-12">';
			} else {
				return '<div class="ruby-content-wrap content-with-sidebar col-sm-8 col-xs-12">';
			}
		}


		/**
		 * @return string
		 * close sidebar section content
		 */
		static function close_section_hs_content() {
			return '</div>';
		}


		/**
		 * @return string
		 * render sidebar wrap
		 */
		static function open_sidebar( $sticky = null ) {

			// sticky config
			if ( empty( $sticky ) || 'default' == $sticky ) {
				$sticky = newsmax_ruby_get_option( 'sidebar_sticky' );
			} elseif ( 'none' == $sticky ) {
				$sticky = false;
			} else {
				$sticky = true;
			}

			if ( ! empty( $sticky ) ) {
				return '<aside class="sidebar-wrap col-sm-4 col-xs-12"><div class="ruby-sidebar-sticky"><div class="sidebar-inner">';
			} else {
				return '<aside class="sidebar-wrap col-sm-4 col-xs-12"><div class="sidebar-inner">';
			}

		}


		/**
		 * @return string
		 * close sidebar wrap
		 */
		static function close_sidebar( $sticky = null ) {

			// sticky config
			if ( empty( $sticky ) || 'default' == $sticky ) {
				$sticky = newsmax_ruby_get_option( 'sidebar_sticky' );
			} elseif ( 'none' == $sticky ) {
				$sticky = false;
			} else {
				$sticky = true;
			}

			if ( ! empty( $sticky ) ) {
				return '</div></div></aside>';
			} else {
				return '</div></aside>';
			}
		}


		/**
		 * @param $block
		 * check block 33% width
		 */
		static function check_fw_block_onet( $block ) {
			$data_name = array(
				'newsmax_ruby_fw_block_onet_1',
				'newsmax_ruby_fw_block_onet_2',
				'newsmax_ruby_fw_block_onet_3',
				'newsmax_ruby_fw_block_onet_4',
			);

			// check
			$check = false;
			if ( ! empty( $block['block_name'] ) && in_array( $block['block_name'], $data_name ) ) {
				$check = true;
			}

			return $check;
		}


		/**
		 * @param $block
		 * check block 50% width
		 */
		static function check_sb_block_oneh( $block ) {
			$data_name = array(
				'newsmax_ruby_hs_block_oneh_1',
				'newsmax_ruby_hs_block_oneh_2',
				'newsmax_ruby_hs_block_oneh_3',
				'newsmax_ruby_hs_block_oneh_4'
			);

			$check = false;
			if ( ! empty( $block['block_name'] ) && in_array( $block['block_name'], $data_name ) ) {
				$check = true;
			}

			return $check;
		}


		/**
		 * create dynamic css for composer page
		 */
		static function dynamic_style() {

			$page_id = get_the_ID();

			if ( 'page-composer.php' != get_page_template_slug( $page_id ) ) {
				return false;
			}

			$str        = '';
			$cache_name = 'newsmax_ruby_composer_dynamic_style_cache';
			$cache      = get_post_meta( $page_id, $cache_name, true );

			if ( empty( $cache ) ) {
				$page_composer_data = get_post_meta( $page_id, 'newsmax_ruby_page_composer_data', true );

				if ( empty( $page_composer_data ) || ! is_array( $page_composer_data ) ) {
					return false;
				}

				foreach ( $page_composer_data as $section_data ) {

					if ( empty( $section_data['blocks'] ) || ! is_array( $section_data['blocks'] ) ) {
						continue;
					}

					foreach ( $section_data['blocks'] as $block ) {

						if ( ! empty( $block['block_options']['background'] ) ) {
							$str .= '#' . $block['block_id'];
							$str .= '{ background-color: ' . $block['block_options']['background'] . ';}';
						};
						if ( ! empty( $block['block_options']['background_image'] ) ) {
							$str .= '#' . $block['block_id'];
							$str .= '{ background-image: url(' . esc_url( $block['block_options']['background_image'] ) . ');}';
						}

						if ( ! empty( $block['block_options']['header_color'] ) ) {

							$str .= '#' . $block['block_id'] . ' .block-header-inner';
							$str .= '{ color: ' . $block['block_options']['header_color'] . ';}';
							$str .= '#' . $block['block_id'] . ' .block-title h3:before,';
							$str .= '.is-block-header-style-3 #' . $block['block_id'] . ' .block-title h3,';
							$str .= '.is-block-header-style-4 #' . $block['block_id'] . ' .block-title h3';
							$str .= '{ background-color: ' . $block['block_options']['header_color'] . ';}';

							$str .= '.is-block-header-style-2 #' . $block['block_id'] . ' .block-title';
							$str .= '{ background-color: ' . $block['block_options']['header_color'] . ';}';
							$str .= '.is-block-header-style-2 #' . $block['block_id'] . ' .block-header-inner';
							$str .= '{ border-color: ' . $block['block_options']['header_color'] . ';}';

						}
					}
				}

				$cache = addslashes( $str );
				delete_post_meta( $page_id, $cache_name );
				update_post_meta( $page_id, $cache_name, $cache );

			} else {
				$str = stripslashes( $cache );
			}

			wp_add_inline_style( 'newsmax-ruby-style', $str );

			return false;
		}
	}
}

// render composer
if ( ! class_exists( 'ruby_composer_block' ) ) {
	class ruby_composer_block {
		static function render( $section, $block ) {

			if ( 'section_full_width' == $section ) {
				switch ( $block['block_name'] ) {
					case 'newsmax_ruby_fw_block_1' : {
						return newsmax_ruby_fw_block_1::render( $block );
					}
					case 'newsmax_ruby_fw_block_2' : {
						return newsmax_ruby_fw_block_2::render( $block );
					}
					case 'newsmax_ruby_fw_block_3' : {
						return newsmax_ruby_fw_block_3::render( $block );
					}
					case 'newsmax_ruby_fw_block_4' : {
						return newsmax_ruby_fw_block_4::render( $block );
					}
					case 'newsmax_ruby_fw_block_5' : {
						return newsmax_ruby_fw_block_5::render( $block );
					}
					case 'newsmax_ruby_fw_block_6' : {
						return newsmax_ruby_fw_block_6::render( $block );
					}
					case 'newsmax_ruby_fw_block_7' : {
						return newsmax_ruby_fw_block_7::render( $block );
					}
					case 'newsmax_ruby_fw_block_8' : {
						return newsmax_ruby_fw_block_8::render( $block );
					}
					case 'newsmax_ruby_fw_block_9' : {
						return newsmax_ruby_fw_block_9::render( $block );
					}
					case 'newsmax_ruby_fw_block_10' : {
						return newsmax_ruby_fw_block_10::render( $block );
					}
					case 'newsmax_ruby_fw_block_11' : {
						return newsmax_ruby_fw_block_11::render( $block );
					}
					case 'newsmax_ruby_fw_block_12' : {
						return newsmax_ruby_fw_block_12::render( $block );
					}
					case 'newsmax_ruby_fw_block_grid_1' : {
						return newsmax_ruby_fw_block_grid_1::render( $block );
					}
					case 'newsmax_ruby_fw_block_grid_2' : {
						return newsmax_ruby_fw_block_grid_2::render( $block );
					}
					case 'newsmax_ruby_fw_block_grid_3' : {
						return newsmax_ruby_fw_block_grid_3::render( $block );
					}
					case 'newsmax_ruby_fw_block_grid_4' : {
						return newsmax_ruby_fw_block_grid_4::render( $block );
					}
					case 'newsmax_ruby_fw_block_grid_5' : {
						return newsmax_ruby_fw_block_grid_5::render( $block );
					}
					case 'newsmax_ruby_fw_block_grid_6' : {
						return newsmax_ruby_fw_block_grid_6::render( $block );
					}
					case 'newsmax_ruby_fw_block_grid_7' : {
						return newsmax_ruby_fw_block_grid_7::render( $block );
					}
					case 'newsmax_ruby_fw_block_grid_8' : {
						return newsmax_ruby_fw_block_grid_8::render( $block );
					}
					case 'newsmax_ruby_fw_block_grid_9' : {
						return newsmax_ruby_fw_block_grid_9::render( $block );
					}
					case 'newsmax_ruby_fw_block_gallery_1' : {
						return newsmax_ruby_fw_block_gallery_1::render( $block );
					}
					case 'newsmax_ruby_fw_block_gallery_2' : {
						return newsmax_ruby_fw_block_gallery_2::render( $block );
					}
					case 'newsmax_ruby_fw_block_video_1' : {
						return newsmax_ruby_fw_block_video_1::render( $block );
					}
					case 'newsmax_ruby_fw_block_video_2' : {
						return newsmax_ruby_fw_block_video_2::render( $block );
					}
					case 'newsmax_ruby_fw_block_onet_1' : {
						return newsmax_ruby_fw_block_onet_1::render( $block );
					}
					case 'newsmax_ruby_fw_block_onet_2' : {
						return newsmax_ruby_fw_block_onet_2::render( $block );
					}
					case 'newsmax_ruby_fw_block_onet_3' : {
						return newsmax_ruby_fw_block_onet_3::render( $block );
					}
					case 'newsmax_ruby_fw_block_onet_4' : {
						return newsmax_ruby_fw_block_onet_4::render( $block );
					}
					case 'newsmax_ruby_fw_block_html' : {
						return newsmax_ruby_fw_block_html::render( $block );
					}
					case 'newsmax_ruby_fw_block_advertising' : {
						return newsmax_ruby_fw_block_advertising::render( $block );
					}
					case 'newsmax_ruby_fw_block_shortcode' : {
						return newsmax_ruby_fw_block_shortcode::render( $block );
					}
					case 'newsmax_ruby_fw_block_subscribe' : {
						return newsmax_ruby_fw_block_subscribe::render( $block );
					}
					case 'newsmax_ruby_fw_block_col' : {
						return newsmax_ruby_fw_block_col::render( $block );
					}
					case 'newsmax_ruby_fw_block_raw_html' : {
						return newsmax_ruby_fw_block_raw_html::render( $block );
					}
					default :
						return false;
				}
			} else {

				switch ( $block['block_name'] ) {
					case 'newsmax_ruby_hs_block_1' : {
						return newsmax_ruby_hs_block_1::render( $block );
					}
					case 'newsmax_ruby_hs_block_2' : {
						return newsmax_ruby_hs_block_2::render( $block );
					}
					case 'newsmax_ruby_hs_block_3' : {
						return newsmax_ruby_hs_block_3::render( $block );
					}
					case 'newsmax_ruby_hs_block_4' : {
						return newsmax_ruby_hs_block_4::render( $block );
					}
					case 'newsmax_ruby_hs_block_5' : {
						return newsmax_ruby_hs_block_5::render( $block );
					}
					case 'newsmax_ruby_hs_block_6' : {
						return newsmax_ruby_hs_block_6::render( $block );
					}
					case 'newsmax_ruby_hs_block_7' : {
						return newsmax_ruby_hs_block_7::render( $block );
					}
					case 'newsmax_ruby_hs_block_8' : {
						return newsmax_ruby_hs_block_8::render( $block );
					}
					case 'newsmax_ruby_hs_block_9' : {
						return newsmax_ruby_hs_block_9::render( $block );
					}
					case 'newsmax_ruby_hs_block_10' : {
						return newsmax_ruby_hs_block_10::render( $block );
					}
					case 'newsmax_ruby_hs_block_11' : {
						return newsmax_ruby_hs_block_11::render( $block );
					}
					case 'newsmax_ruby_hs_block_12' : {
						return newsmax_ruby_hs_block_12::render( $block );
					}
					case 'newsmax_ruby_hs_block_13' : {
						return newsmax_ruby_hs_block_13::render( $block );
					}
					case 'newsmax_ruby_hs_block_14' : {
						return newsmax_ruby_hs_block_14::render( $block );
					}
					case 'newsmax_ruby_hs_block_15' : {
						return newsmax_ruby_hs_block_15::render( $block );
					}
					case 'newsmax_ruby_hs_block_16' : {
						return newsmax_ruby_hs_block_16::render( $block );
					}
					case 'newsmax_ruby_hs_block_oneh_1' : {
						return newsmax_ruby_hs_block_oneh_1::render( $block );
					}
					case 'newsmax_ruby_hs_block_oneh_2' : {
						return newsmax_ruby_hs_block_oneh_2::render( $block );
					}
					case 'newsmax_ruby_hs_block_oneh_3' : {
						return newsmax_ruby_hs_block_oneh_3::render( $block );
					}
					case 'newsmax_ruby_hs_block_oneh_4' : {
						return newsmax_ruby_hs_block_oneh_4::render( $block );
					}
					case 'newsmax_ruby_hs_block_grid_1' : {
						return newsmax_ruby_hs_block_grid_1::render( $block );
					}
					case 'newsmax_ruby_hs_block_grid_2' : {
						return newsmax_ruby_hs_block_grid_2::render( $block );
					}
					case 'newsmax_ruby_hs_block_grid_3' : {
						return newsmax_ruby_hs_block_grid_3::render( $block );
					}
					case 'newsmax_ruby_hs_block_grid_4' : {
						return newsmax_ruby_hs_block_grid_4::render( $block );
					}
					case 'newsmax_ruby_hs_block_grid_5' : {
						return newsmax_ruby_hs_block_grid_5::render( $block );
					}
					case 'newsmax_ruby_hs_block_grid_6' : {
						return newsmax_ruby_hs_block_grid_6::render( $block );
					}
					case 'newsmax_ruby_hs_block_list_1' : {
						return newsmax_ruby_hs_block_list_1::render( $block );
					}
					case 'newsmax_ruby_hs_block_list_2' : {
						return newsmax_ruby_hs_block_list_2::render( $block );
					}
					case 'newsmax_ruby_hs_block_list_3' : {
						return newsmax_ruby_hs_block_list_3::render( $block );
					}
					case 'newsmax_ruby_hs_block_classic_1' : {
						return newsmax_ruby_hs_block_classic_1::render( $block );
					}
					case 'newsmax_ruby_hs_block_classic_2' : {
						return newsmax_ruby_hs_block_classic_2::render( $block );
					}
					case 'newsmax_ruby_hs_block_mix_1' : {
						return newsmax_ruby_hs_block_mix_1::render( $block );
					}
					case 'newsmax_ruby_hs_block_mix_2' : {
						return newsmax_ruby_hs_block_mix_2::render( $block );
					}
					case 'newsmax_ruby_hs_block_mix_3' : {
						return newsmax_ruby_hs_block_mix_3::render( $block );
					}
					case 'newsmax_ruby_hs_block_mix_4' : {
						return newsmax_ruby_hs_block_mix_4::render( $block );
					}
					case 'newsmax_ruby_hs_block_mix_5' : {
						return newsmax_ruby_hs_block_mix_5::render( $block );
					}
					case 'newsmax_ruby_hs_block_mix_6' : {
						return newsmax_ruby_hs_block_mix_6::render( $block );
					}
					case 'newsmax_ruby_hs_block_mix_7' : {
						return newsmax_ruby_hs_block_mix_7::render( $block );
					}
					case 'newsmax_ruby_hs_block_mix_8' : {
						return newsmax_ruby_hs_block_mix_8::render( $block );
					}
					case 'newsmax_ruby_hs_block_gallery_1' : {
						return newsmax_ruby_hs_block_gallery_1::render( $block );
					}
					case 'newsmax_ruby_hs_block_gallery_2' : {
						return newsmax_ruby_hs_block_gallery_2::render( $block );
					}
					case 'newsmax_ruby_hs_block_video_1' : {
						return newsmax_ruby_hs_block_video_1::render( $block );
					}
					case 'newsmax_ruby_hs_block_video_2' : {
						return newsmax_ruby_hs_block_video_2::render( $block );
					}
					case 'newsmax_ruby_hs_block_html' : {
						return newsmax_ruby_hs_block_html::render( $block );
					}
					case 'newsmax_ruby_hs_block_advertising' : {
						return newsmax_ruby_hs_block_advertising::render( $block );
					}
					case 'newsmax_ruby_hs_block_shortcode' : {
						return newsmax_ruby_hs_block_shortcode::render( $block );
					}
					case 'newsmax_ruby_hs_block_subscribe' : {
						return newsmax_ruby_hs_block_subscribe::render( $block );
					}
					case 'newsmax_ruby_hs_block_raw_html' : {
						return newsmax_ruby_hs_block_raw_html::render( $block );
					}
					default :
						return false;
				}
			}
		}
	}
}

// add custom style
if ( class_exists( 'newsmax_ruby_composer_render' ) ) {
	add_action( 'wp_enqueue_scripts', array( 'newsmax_ruby_composer_render', 'dynamic_style' ) );
}