<?php

$orig_post = $post;
global $post;

$categories = get_the_category($post->ID);

if ($categories) {

	$category_ids = array();

	foreach($categories as $individual_category) $category_ids[] = $individual_category->term_id;

	$args = array(
		'category__in'     => $category_ids,
		'post__not_in'     => array($post->ID),
		'posts_per_page'   => 3, // Number of related posts that will be shown.
		'ignore_sticky_posts' => 1,
		'orderby' => 'rand'
	);

	$my_query = new wp_query( $args );
	if( $my_query->have_posts() ) { ?>
		<div class="related-post">
			<h2 class="main-block-title title-arrow"><span><?php esc_html_e( 'Related Posts', 'news247' ); ?></span></h2>
			<div class="editor-grid-post">
			<?php
			$i = 1;
			while( $my_query->have_posts() ) { $my_query->the_post();
				if( $i == 1 ){ ?>
				    <div class="row gap-40">
				<?php } ?>
					<div class="ediotr-grid-item col-lg-4 col-sm-12">
						<div class="most-view-item-content editor-item-content">
						<div class="related-post-imgwrap">
							<a href="<?php echo esc_url( get_permalink() ); ?>">
								<?php the_post_thumbnail('news247-xmedium-size'); ?>
							</a>
						</div>
							<div class="editor-item-content-info">
								<h4 class="entry-title"><a href="<?php echo esc_url( get_permalink() ); ?>"><?php the_title(); ?></a></h4>
				              <div class="entry-post-footer-wrap">
		                           <?php if ( get_the_author_meta('first_name') != "" || get_the_author_meta('last_name') != "" ) { ?>
		                              <span class="post-meta-author"><?php esc_html_e('By','news247');?> <a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php echo get_the_author_meta('first_name');?> <?php echo get_the_author_meta('last_name');?></a></span>
		                           <?php } else { ?>
		                              <span class="post-meta-author"> <?php esc_html_e('By','news247');?> <?php the_author_posts_link() ?></span>
		                          <?php }?>
	                             <span class="publish-date">
	                                <time class="entry-date" datetime="<?php esc_attr( the_time( 'c' ) ); ?>"><?php echo get_the_date(); ?></time>
	                             </span>

				              </div> <!-- .entry-post-meta-wrap -->
							</div>
						</div><!--/.most-view-item-content -->
					</div>

				<?php if( $i == 3 ){ ?>
					</div>
				<?php $i = 1;
				}else{
					$i++;
				} ?>
			<?php }
			wp_reset_postdata();
			if($i !=  1 ){ ?>
				</div>
			<?php } ?>
			</div>
		</div>
	<?php }
}
$post = $orig_post;
?>