<?php

if ( ! function_exists( 'news247_theme_setup' ) ) :

function news247_theme_setup() {

   // Load text domain
   load_theme_textdomain( 'news247', get_template_directory() . '/languages' );

   // Editor-style.css to match the theme style.
   add_editor_style();

   if ( function_exists( 'add_theme_support' ) ) {

      add_theme_support( 'automatic-feed-links' );

      //Post Thumbnails
      add_theme_support( 'post-thumbnails' );
      add_image_size( 'news247-main-size', 1140, 620, true );
      add_image_size( 'news247-medium-size', 880, 570, true );
        add_image_size( 'news247-xmedium-size', 580, 460, true );
      add_image_size( 'news247-small-size', 350, 220, true );
      //Post Formats
      add_theme_support( 'post-formats', array('standard', 'aside', 'image', 'video', 'audio', 'quote', 'link', 'gallery' ) );
      add_theme_support( 'title-tag' );
        add_theme_support( 'woocommerce' );
   }

   //Menu Register
   register_nav_menus(
      array(
      'primary'  => esc_html__( 'Main Menu', 'news247' ),
      'footermenu'  => esc_html__( 'Footer Menu', 'news247' ),
      'topmenu'  => esc_html__( 'Top Menu', 'news247' ),
   ) );

   add_editor_style( array( 'css/editor-style.css' ) );

    /*
     * Enable support for wide alignment class for Gutenberg blocks.
     */
    add_theme_support( 'align-wide' );
    add_theme_support( 'editor-styles' );
    add_theme_support( 'wp-block-styles' );

}
endif;
// news247_theme_setup
add_action( 'after_setup_theme', 'news247_theme_setup' );


function news247_body_classes( $classes ) {

    if ( is_active_sidebar( 'sidebar' ) ) {
        $classes[] = 'sidebar-active';
    }else{
        $classes[] = 'sidebar-inactive';
    }
    return $classes;
}
add_filter( 'body_class','news247_body_classes' );


/*-------------------------------------------------------
 *             Menu Fallback
 *-------------------------------------------------------*/

function news247_primary_menu_fallback() {
  ?>
  <div class="navbar-responsive-collapse">
      <ul id="main-menu" class="nav navbar-nav main-menu">
        <li><a href="<?php echo admin_url( 'nav-menus.php' )?>"><?php esc_html_e( 'Add primary menu', 'news247' ); ?></a></li>
      </ul>
    </div>
  <?php
}

/*-------------------------------------------------------
 *          Theme Options
 *-------------------------------------------------------*/

if(!function_exists('news247_theme_options')):
   function news247_theme_options($arg) {
      global $news247_options;
      if (isset($news247_options[$arg])) {
         return $news247_options[$arg];
      } else {
         return false;
      }
   }
endif;

if(!function_exists('news247_theme_options_url')):
   function news247_theme_options_url($arg,$arg2) {
      global $news247_options;
      if (isset($news247_options[$arg][$arg2])) {
         return $news247_options[$arg][$arg2];
      } else {
         return false;
      }
   }
endif;

// home classic
if ( ! function_exists( 'news247_home_layout_class' ) ) {
    function news247_home_layout_class(){
      $homelayoutclass = '';
      if ( news247_theme_options('home_layout') ){
          $homelayoutclass = esc_attr( news247_theme_options('home_layout'));
      } else {
         $homelayoutclass = 'home_page1';
      }
       return $homelayoutclass;
    }
}
// single style class
if ( ! function_exists( 'news247_single_style_class' ) ) {
    function news247_single_style_class(){
      $singlestyleclass = '';
      if ( news247_theme_options('single_style_blog') ) {
         $singlestyleclass = esc_attr( news247_theme_options('single_style_blog'));
      } else {
         $singlestyleclass = 'single_style1';
      }

       return $singlestyleclass;
    }
}


//Post View Count
if(!function_exists('news247_wpb_get_post_views')):
function news247_wpb_get_post_views($postID){
    $count_key = '_post_views_count';
    $count = get_post_meta($postID, $count_key, true);
    if($count==''){
        delete_post_meta($postID, $count_key);
        add_post_meta($postID, $count_key, '0');
        return "0";
    }
    return $count;
}
endif;