<?php

require_once NEWS247_DIR . '/includes/class-tgm-plugin-activation.php';

add_action( 'tgmpa_register', 'news247_register_required_plugins');

if(!function_exists('news247_register_required_plugins')):

	function news247_register_required_plugins()
	{
		$plugins = array(

				array(
					'name'                  => esc_html__('News247 Main', 'news247'),
					'slug'                  => 'news247-main',
					'source'                => esc_url('https://demo.themewinter.com/wp/plugins/news247/news247-main.zip'),
					'required'              => true,
					'version'               => '',
					'force_activation'      => false,
					'force_deactivation'    => false,
					'external_url'          => '',
				),
				array(
					'name'                  => esc_html__('Elementor', 'news247'),
					'slug'                  => 'elementor',
					'required'              => true,
					'version'               => '',
					'force_activation'      => false,
					'force_deactivation'    => false,
					'external_url'          => esc_url('https://downloads.wordpress.org/plugin/elementor.1.7.3.zip'),
				),
				array(
					'name'                  => esc_html__('Regenerate Thumbnails', 'news247'),
					'slug'                  => 'regenerate-thumbnails',
					'required'              => false,
					'version'               => '',
					'force_activation'      => false,
					'force_deactivation'    => false,
					'external_url'          => esc_url('https://downloads.wordpress.org/plugin/regenerate-thumbnails.zip'),
				),
				array(
					'name'                  => esc_html__('One Click Demo Import', 'news247'),
					'slug'                  => 'one-click-demo-import',
					'required'              => false,
					'version'               => '',
					'force_activation'      => false,
					'force_deactivation'    => false,
					'external_url'          => esc_url('https://downloads.wordpress.org/plugin/one-click-demo-import.2.4.0.zip'),
				),
				array(
					'name'                  => esc_html__('WP Mega Menu', 'news247'),
					'slug'                  => 'wp-megamenu',
					'required'              => false,
					'version'               => '',
					'force_activation'      => false,
					'force_deactivation'    => false,
					'external_url'          => esc_url('https://downloads.wordpress.org/plugin/wp-megamenu.zip'),
				),
				array(
					'name'                  => esc_html__('AccessPress Social Counter', 'news247'),
					'slug'                  => 'accesspress-social-counter',
					'required'              => false,
					'version'               => '',
					'force_activation'      => false,
					'force_deactivation'    => false,
					'external_url'          => esc_url('https://downloads.wordpress.org/plugin/accesspress-social-counter.1.7.2.zip'),
				),
				array(
					'name'                  => esc_html__('Contact Form 7', 'news247'),
					'slug'                  => 'contact-form-7',
					'required'              => false,
					'version'               => '',
					'force_activation'      => false,
					'force_deactivation'    => false,
					'external_url'          => esc_url('https://downloads.wordpress.org/plugin/contact-form-7.4.5.1.zip'),
				),
                array(
                    'name'                  => esc_html__('MailChimp for WordPress', 'news247'),
                    'slug'                  => 'mailchimp-for-wp',
                    'required'              => false,
                    'version'               => '',
                    'force_activation'      => false,
                    'force_deactivation'    => false,
                    'external_url'          => esc_url('https://downloads.wordpress.org/plugin/mailchimp-for-wp.4.0.5.zip'),
                ),

				array(
				'name'                  => esc_html__('Widget Importer Exporter', 'news247'),
				'slug'                  => 'widget-importer-exporter',
				'required'              => false,
				'version'               => '',
				'force_activation'      => false,
				'force_deactivation'    => false,
				'external_url'          => esc_url('https://downloads.wordpress.org/plugin/widget-importer-exporter.1.4.4.zip'),
				)
			);

	$config = array(
			'domain'            => 'news247',
			'id'           		=> 'tgmpa',
			'default_path'      => '',
			'parent_slug'  		=> 'themes.php',
			'capability'   		=> 'edit_theme_options',
			'menu'              => 'install-required-plugins',
			'has_notices'       => true,
			'dismissable'  		=> true,
			'is_automatic'      => false,
			'message'           => '',
			'strings'           => array(
						'page_title'                                => esc_html__( 'Install Required Plugins', 'news247' ),
						'menu_title'                                => esc_html__( 'Install Plugins', 'news247' ),
						'installing'                                => esc_html__( 'Installing Plugin: %s', 'news247' ),
						'oops'                                      => esc_html__( 'Something went wrong with the plugin API.', 'news247'),
						'return'                                    => esc_html__( 'Return to Required Plugins Installer', 'news247'),
						'plugin_activated'                          => esc_html__( 'Plugin activated successfully.','news247'),
						'complete'                                  => esc_html__( 'All plugins installed and activated successfully. %s', 'news247' ),
						'nag_type'									=> 'updated'
				)
	);

	tgmpa( $plugins, $config );

	}

endif;
