<?php

if ( ! function_exists( 'news247_content_nav' ) ) :
/**
 * Display navigation to next/previous pages when applicable
 */
function news247_content_nav( $nav_id ) {
	global $wp_query, $post;

	// Don't print empty markup on single pages if there's nowhere to navigate.
	if ( is_single() ) {
		$previous = ( is_attachment() ) ? get_post( $post->post_parent ) : get_adjacent_post( false, '', true );
		$next = get_adjacent_post( false, '', false );

		if ( ! $next && ! $previous )
			return;
	}

	// Don't print empty markup in archives if there's only one page.
	if ( $wp_query->max_num_pages < 2 && ( is_home() || is_archive() || is_search() ) )
		return;

	$nav_class = ( is_single() ) ? 'clearfix' : 'paging-navigation clearfix';

	?>
	<div class="clearfix"></div>
	<nav id="<?php echo esc_attr( $nav_id ); ?>" class="<?php echo esc_attr($nav_class); ?>">


		<?php if ( is_single() ) : // navigation links for single posts ?>

				<?php the_post_navigation( array(
					'next_text' => '<span class="meta-nav" aria-hidden="true">' . esc_html__( 'Next', 'news247' ) . '<i class="fa fa-angle-right"></i></span> ' .
						'<span class="screen-reader-text">' . esc_html__( 'Next post:', 'news247' ) . '</span> ' .
						'<h3 class="post-title">%title</h3>',
					'prev_text' => '<span class="meta-nav" aria-hidden="true"><i class="fa fa-angle-left"></i>' . esc_html__( 'Previous', 'news247' ) . '</span> ' .
						'<span class="screen-reader-text">' . esc_html__( 'Previous post:', 'news247' ) . '</span> ' .
						'<h3 class="post-title">%title</h3>',
				) );?>
		<?php elseif ( $wp_query->max_num_pages > 1 && ( is_home() || is_archive() || is_search() ) ) : // navigation links for home, archive, and search pages ?>
			<ul class="post-nav">
				<?php if ( get_next_posts_link() ) : ?>
				<li class="nav-previous previous"><?php next_posts_link( '<i class="fa fa-angle-double-left"></i>'. esc_html__( 'Older posts', 'news247' ) ); ?></li>
				<?php endif; ?>

				<?php if ( get_previous_posts_link() ) : ?>
				<li class="nav-next next"><?php previous_posts_link( esc_html__( 'Newer posts', 'news247' ). '<i class="fa fa-angle-double-right"></i>' ); ?></li>
				<?php endif; ?>
			</ul>
		<?php endif; ?>


	</nav><!-- #<?php //echo esc_html( $nav_id ); ?> -->
	<?php
}
endif; // news247_content_nav