<div class="entry-blog-grid">
<div class="entry-blog">
    <div class="entry-blog-list-left">
        <?php get_template_part( 'includes/post-format' ); ?>
        <?php if ( class_exists( 'ReduxFramework' ) ) { ?>
            <?php if ( news247_theme_options('blog_category') ) { ?>
                <?php if ( get_the_category_list(', ') ) { ?>
                    <span class="category-meta-bg"><?php echo get_the_category_list(' '); ?></span>
                <?php }?>
            <?php } ?>
        <?php } else { ?>
            <span class="category-meta-bg"><?php echo get_the_category_list(' '); ?></span>
        <?php }?>
    </div>
    <div class="entry-blog-header">
        <h2 class="entry-post-title">
            <a href="<?php esc_url( the_permalink() ); ?>" rel="bookmark"><?php the_title(); ?></a>
            <?php if ( is_sticky() && is_home() && ! is_paged() ) { ?>
                <sup class="featured-post"><?php esc_html_e( 'Sticky', 'news247' ) ?></sup>
            <?php } ?>
        </h2>
    </div><!-- .blog-header -->
    <div class="grid-entry-post-footer">
      <div class="list-entry-post-footer">
        <div class="entry-post-footer-wrap d-flex justify-content-end">
            <?php if ( class_exists( 'ReduxFramework' ) ) { ?>
                 <?php if ( news247_theme_options('blog_author') ) { ?>
                     <?php if ( get_the_author_meta('first_name') != "" || get_the_author_meta('last_name') != "" ) { ?>
                        <span class="post-meta-author"> <a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php echo get_the_author_meta('first_name');?> <?php echo get_the_author_meta('last_name');?></a></span>
                     <?php } else { ?>
                        <span class="post-meta-author"><?php the_author_posts_link() ?></span>
                    <?php }?>
                <?php }?>
            <?php } else {?>
                 <?php if ( get_the_author_meta('first_name') != "" || get_the_author_meta('last_name') != "" ) { ?>
                    <span class="post-meta-author"><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php echo get_the_author_meta('first_name');?> <?php echo get_the_author_meta('last_name');?></a></span>
                 <?php } else { ?>
                    <span class="post-meta-author"><?php the_author_posts_link() ?></span>
                <?php }?>
            <?php }?>

              <?php if ( class_exists( 'ReduxFramework' ) ) { ?>
                   <?php if ( news247_theme_options('blog_date') ) { ?>
                       <span class="publish-date mr-auto">
                          <a href="<?php esc_url( the_permalink() ); ?>" rel="bookmark">
                          <time class="entry-date" datetime="<?php esc_attr( the_time( 'c' ) ); ?>"><?php echo get_the_date(); ?></time>
                          </a>
                       </span>
                   <?php } ?>
              <?php } else {?>
                   <span class="publish-date mr-auto">
                      <a href="<?php esc_url( the_permalink() ); ?>" rel="bookmark">
                      <time class="entry-date" datetime="<?php esc_attr( the_time( 'c' ) ); ?>"><?php echo get_the_date(); ?></time>
                      </a>
                   </span>
              <?php }?>
              <?php if ( class_exists( 'ReduxFramework' ) ) { ?>
                  <?php if ( news247_theme_options('post_view') ) { ?>
                      <span class="entry-meta-view">
                          <i class="fa fa-heart"></i>
                          <?php echo news247_wpb_get_post_views($post->ID); ?>
                      </span>
                  <?php } ?>
              <?php } else { ?>
                  <span class="entry-meta-view">
                      <i class="fa fa-heart"></i>
                      <?php echo news247_wpb_get_post_views($post->ID); ?>
                  </span>
              <?php } ?>
              <?php if ( class_exists( 'ReduxFramework' ) ) { ?>
                  <?php if ( news247_theme_options('blog_comment') ) {
                      if ( ! post_password_required() && ( comments_open() || get_comments_number() ) ) : ?>
                          <span class="entry-comment">
                              <i class="fa fa-comments-o" aria-hidden="true"></i> <?php comments_popup_link( '' . esc_html__( '0', 'news247' ) . '', esc_html__( 'Post a comment', 'news247' ), esc_html__( '%', 'news247' ) ); ?>
                          </span>
                      <?php endif;
                  }?>
              <?php } else {
                  if ( ! post_password_required() && ( comments_open() || get_comments_number() ) ) : ?>
                      <span class="entry-comment">
                          <i class="fa fa-comments-o" aria-hidden="true"></i> <?php comments_popup_link( '' . esc_html__( '0', 'news247' ) . '', esc_html__( 'Post a comment', 'news247' ), esc_html__( '%', 'news247' ) ); ?>
                      </span>
                  <?php endif;?>
              <?php }?>
        </div> <!-- .entry-post-meta-wrap -->
      </div><!--list-entry-post-footer -->
    </div> <!-- .entry-post-meta-wrap -->


      <?php if ( is_single() ) : ?>
          <div class="entry-summary blog-entry-summary">
              <?php the_content(); ?>
          </div><!-- .entry-summary -->
      <?php else : ?>
          <div class="entry-content blog-entry-summary">
              <?php
              $continue_reading_en ='';
              $continue_reading = '';

              if( news247_theme_options('blog_continue_en') ){
                  if ( news247_theme_options('blog_continue') ){
                      $continue_reading = news247_theme_options('blog_continue');
                   }else {
                      $continue_reading = esc_html__('Continue Reading','news247');
                   }
                  $continue_reading_en = '<span class="readmore-blog">'.esc_attr($continue_reading).'</span>';
              }

              if ( news247_theme_options('post_charlenght') ) {
                if ( news247_theme_options('post_charlenght_limit') ) {
                            global $index;
                            if ( $index == 0 ) {
                              $post_charlenght_limit = 300;
                            }else {
                                $post_charlenght_limit = news247_theme_options('post_charlenght_limit');
                            }
                      echo news247_excerpt_max_charlength( esc_attr($post_charlenght_limit) );
                  } else {
                     echo news247_excerpt_max_charlength(300);
                  }
                  if( news247_theme_options('blog_continue_en') ){
                   echo '<span class="fixed-char"><a class="readmore-blog" href="'.get_permalink().'">'.$continue_reading.'</a></span>';
                  }
              } else {
                the_content($continue_reading_en);
              }?>
              <?php wp_link_pages( array(
                  'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'news247' ),
                  'after'  => '</div>',
                  'link_before' => '<span>',
                  'link_after'  => '</span>',
              ) ); ?>
          </div><!-- .entry-content -->
      <?php endif; ?>
  </div> <!--/.entry-blog -->
</div> <!--/.entry-blog -->



