<?php
/**
 * The template for displaying Comments.
 *
 * The area of the page that contains both current comments
 * and the comment form. The actual display of comments is
 * handled by a callback to news247_theme_comment() which is
 * located in the includes/template-tags.php file.
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */

if ( post_password_required() ) {
	return;
}

?>

	<div id="comments" class="comments-area">

	<?php // You can start editing here -- including this comment! ?>

	<?php if ( have_comments() ) : ?>
		<header class="page-header">
			<h3 class="main-block-title title-arrow"><span>
				<?php
					printf( _nx( 'One Comment', '%1$s Comments', esc_html( get_comments_number() ), 'comments title', 'news247' ),
						number_format_i18n( esc_html( get_comments_number() ) ), '<span>' . esc_html( get_the_title() ) . '</span>' );
				?>
			</span></h3>
		</header>


		<ol class="comment-list media-list">
			<?php
				/* Loop through and list the comments. Tell wp_list_comments()
				 * to use news247_theme_comment() to format the comments.
				 * If you want to overload this in a child theme then you can
				 * define news247_theme_comment() and that will be used instead.
				 * See news247_theme_comment() in includes/template-tags.php for more.
				 */
				wp_list_comments( array( 'callback' => 'news247_theme_comment', 'avatar_size' => 60 ) );
			?>
		</ol><!-- .comment-list -->

		<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // are there comments to navigate through ?>
		<nav id="comment-nav-below" class="comment-navigation">
			<h1 class="screen-reader-text"><?php esc_html_e( 'Comment navigation', 'news247' ); ?></h1>
			<div class="nav-previous"><?php previous_comments_link( esc_html__( '&larr; Older Comments', 'news247' ) ); ?></div>
			<div class="nav-next"><?php next_comments_link( esc_html__( 'Newer Comments &rarr;', 'news247' ) ); ?></div>
		</nav><!-- #comment-nav-below -->
		<?php endif; // check for comment navigation ?>

	<?php endif; // have_comments() ?>

	<?php
		// If comments are closed and there are comments, let's leave a little note, shall we?
		if ( ! comments_open() && '0' != get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) :
	?>
		<p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'news247' ); ?></p>
	<?php endif; ?>

	<?php
		comment_form( array(
			'title_reply_before' => '<h3 id="reply-title" class="comment-reply-title"><span>',
			'title_reply_after'  => '</span></h3>',
		) );
	?>



</div><!-- #comments -->
