<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
    <?php neocut_viewport(); ?>
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<?php wp_head(); ?>
</head>
<?php
$type = neocut_opts_get('comingsoon-style', 'type1');
$bg = neocut_option('pageoptions','comingsoon-bg');
$opacity = neocut_opts_get('comingsoon-bg-opacity', '1');
$position = neocut_opts_get('comingsoon-bg-position', 'center center');
$repeat = neocut_opts_get('comingsoon-bg-repeat', 'no-repeat');
$color = neocut_option('pageoptions','comingsoon-bg-color');
$showcolor = neocut_option('pageoptions','show-comingsoon-bg-color');

$estyle = neocut_option('pageoptions','comingsoon-bg-style');

$color = !empty($color) ? neocut_hex2rgb($color) : array('f', 'f', 'f');
$style = !empty($bg) ? "background:url($bg) $position $repeat;" : '';
$style .= (!empty($color) && isset($showcolor) ) ? "background-color:rgba(  $color[0],  $color[1],  $color[2], {$opacity});" : '';
$style .= !empty($estyle) ? $estyle : ''; ?>

<body <?php body_class(); ?> style="<?php echo esc_attr($style); ?>">

<div class="wrapper under-construction <?php echo esc_attr($type);  ?>" style="<?php echo esc_attr($style); ?>"><?php
	$pageid = neocut_option('pageoptions','comingsoon-pageid');
	if( !empty($pageid) ):
		$page = get_post( $pageid, ARRAY_A );
		echo DTCoreShortcodesDefination::dtShortcodeHelper ( stripslashes($page['post_content']) );
	else:
		echo '<div class="uc-wrapper-inner">';
			echo '<h2>'.esc_html__('Website is almost ready', 'neocut').'</h2>';
			echo '<p>'.esc_html__('Our website is under construction.', 'neocut').'</p>';
			echo '<p>'.esc_html__("We'll be here soon with our new awesome.", 'neocut').'</p>';
			echo '<div class="dt-sc-hr-invisible-xsmall"></div>';

			if( neocut_option('pageoptions','show-launchdate') == 'true'):
				$date = neocut_option('pageoptions','comingsoon-launchdate');
				$datetime = new DateTime('tomorrow');
				$date = !empty( $date ) ? $date : $datetime->format('m/d/Y');
				$offset = neocut_option('pageoptions','comingsoon-timezone');
				$offset = !empty( $offset ) ? $offset : '+5';

				echo '<div class="downcount" data-date="'.$date.'" data-offset="'.$offset.'">';
					echo '<div class="dt-sc-counter-wrapper">';
						echo '<div class="counter-icon-wrapper">';
							echo '<div class="dt-sc-counter-number days">00</div>';
						echo '</div>';
						echo '<h3 class="title">'.esc_html__('Days', 'neocut').'</h3>';
					echo '</div>';
					echo '<div class="dt-sc-counter-wrapper">';
						echo '<div class="counter-icon-wrapper">';
							echo '<div class="dt-sc-counter-number hours">00</div>';
						echo '</div>';
						echo '<h3 class="title">'.esc_html__('Hours', 'neocut').'</h3>';
					echo '</div>';
					echo '<div class="dt-sc-counter-wrapper">';
						echo '<div class="counter-icon-wrapper">';
							echo '<div class="dt-sc-counter-number minutes">00</div>';
						echo '</div>';
						echo '<h3 class="title">'.esc_html__('Minutes', 'neocut').'</h3>';
					echo '</div>';
					echo '<div class="dt-sc-counter-wrapper">';
						echo '<div class="counter-icon-wrapper">';
							echo '<div class="dt-sc-counter-number seconds">00</div>';
						echo '</div>';
						echo '<h3 class="title">'.esc_html__('Seconds', 'neocut').'</h3>';
					echo '</div>';
				echo '</div>';
			endif;	
		echo '</div>';
	endif; ?>
</div>
<?php wp_footer(); ?>
</body>
</html>