<?php
/*Template Name: Appointment Template*/

get_header();

?>

<div class="container">

    <section id="primary" class="content-full-width">
    
        <?php
        if(class_exists('DTAppointmentAddon')) {
            
            $step4_status = $step4_other_steps_status = $step1_status = $step4_content_status = $step4_other_steps_content_status = $step1_content_status = $step1_other_steps_content_status = '';
                    
            if(isset($_REQUEST['status']) && $_REQUEST['status'] != '') {
                if(array_key_exists('status', $_REQUEST) && $_REQUEST['status'] == 'success') {
                    dttheme_new_reservation($_REQUEST['custom']);
                }
                $step4_status = 'dt-sc-completed-step';
                $step4_other_steps_status = 'dt-sc-completed-step';
                $step4_content_status = 'style="display:block;"';
                $step4_other_steps_content_status = 'style="display:none;"';
                $step_value = 4; 
            } else {
                $step1_status = 'dt-sc-current-step';
                $step1_content_status = 'style="display:block;"';
                $step1_other_steps_content_status = 'style="display:none;"';
                $step_value = 1; 
            }
            ?>
            
            <div class="dt-sc-schedule-progress-wrapper">
                <div class="dt-sc-schedule-progress step1 <?php echo esc_attr($step4_other_steps_status.' '.$step1_status); ?>">
                    <div class="dt-sc-progress-step">
                        <span>1</span>
                    </div>
                    <h4><?php echo esc_html__('Select Service / Date', 'neocut'); ?></h4>
                    <p><?php echo esc_html__('Please choose the service along with your convenient time.', 'neocut'); ?></p>
                </div>
                <div class="dt-sc-schedule-progress step2 <?php echo esc_attr($step4_other_steps_status); ?>">
                    <div class="dt-sc-progress-step">
                        <span>2</span>
                    </div>
                    <h4><?php echo esc_html__('Fill Contact Details', 'neocut'); ?></h4>
                    <p><?php echo esc_html__('Please fill in your contact details here.', 'neocut'); ?></p>
                </div>
                <div class="dt-sc-schedule-progress step3 <?php echo esc_attr($step4_other_steps_status); ?>">
                    <div class="dt-sc-progress-step">
                        <span>3</span>
                    </div>
                    <h4><?php echo esc_html__('Make Payment', 'neocut'); ?></h4>
                    <p><?php echo esc_html__('Choose payment option for our service.', 'neocut'); ?></p>
                </div>
                <div class="dt-sc-schedule-progress step4 <?php echo esc_attr($step4_status); ?>">
                    <div class="dt-sc-progress-step">
                        <span>4</span>
                    </div>
                    <h4><?php echo esc_html__('Confirmation', 'neocut'); ?></h4>
                    <p><?php echo esc_html__('Your appointment is confirmed with us.', 'neocut'); ?></p>
                </div>
            </div>
            <div class="dt-sc-margin60"></div>
            <div class="clear"></div>
            
            
                <div class="dt-sc-goback-box" style="display:none;">
                    <span class="fa fa-caret-left"></span>
                    <input class="appointment-goback" value="<?php echo esc_html__('Go Back & Edit', 'neocut'); ?>" type="button" />
                    <input type="hidden" value="true" name="appointment-step-checker"  id="appointment-step-checker"  />
                    <input type="hidden" value="1" name="appointment-step"  id="appointment-step"  />
                </div> 
                
                <div class="dt-sc-instant-notification-box" style="display:none;">
    
                    <h3 class="dt-sc-border-title type3"><?php echo esc_html__('Review your details', 'neocut'); ?></h3>
                    <div class="clear"></div>
                    <div class="dt-sc-margin15"></div>
                     
                    <div class="column dt-sc-one-half dt-sc-instant-notification-details dt-sc-instant-notification-schedulebox first" style="display:none;">
                        <h4><?php echo esc_html__('Schedule Details', 'neocut'); ?></h4>
                        <div class="dt-sc-instant-schedule-details" id="dt-sc-instant-schedule-details"></div>
                    </div>
                    
                    <div class="column dt-sc-one-half dt-sc-instant-notification-details dt-sc-instant-notification-contactbox" style="display:none;">
                        <h4><?php echo esc_html__('Contact Information', 'neocut'); ?></h4>
                        <div class="dt-sc-instant-contact-info" id="dt-sc-instant-contact-info"></div>
                    </div>
                    
                    <div class="dt-sc-margin30"></div>
                
                </div>
                
                            
                <div class="dt-sc-schedule-box steps step1" <?php echo neocut_wp_kses($step4_other_steps_content_status.' '.$step1_content_status); ?>>
                
                    <h2 class="dt-sc-border-title type3"><?php echo esc_html__('Please choose your convenient time', 'neocut'); ?></h2>
                    <div class="dt-sc-margin30"></div>
        
                    <div class="dt-sc-service-box">
                    
                        <form class="dt-sc-appointment-scheduler-form" name="dt-sc-appointment-scheduler-form" method="post">
                        
                            <?php
                            if(class_exists('WP_Store_locator')) {
                                ?>
                                <div class="column dt-sc-one-column first">
                                    <label class="dt-sc-margin10"><?php echo esc_html__('Store', 'neocut'); ?></label>
                                    <select name="storeid" id="storeid" class="dt-select-store">
                                        <option value=""><?php echo esc_html__('All Stores', 'neocut'); ?></option>
                                            <?php
                                            $cp_stores = get_posts( array( 'post_type'=>'wpsl_stores', 'posts_per_page'=>'-1' , 'suppress_filters' => false ) );
                                            if($cp_stores) {
                                                foreach ( $cp_stores as $cp_store ) {
                                                    $id = $cp_store->ID;
                                                    $title = $cp_store->post_title;
                                                    ?>
                                                    <option value="<?php echo esc_attr($id); ?>" <?php if(isset($_REQUEST['storeid'])) { echo selected($_REQUEST['storeid'], $id, false); } ?>><?php echo esc_html($title); ?></option>
                                                    <?php
                                                }
                                            }
                                            ?>
                                    </select>
                                </div>
                                <div class="dt-sc-margin35"></div>
                                <?php
                            }
                            ?>
                        
                            <div class="column dt-sc-one-third first">
                                <label class="dt-sc-margin10"><?php echo esc_html__('Services', 'neocut'); ?></label>
                                <select name="serviceid" id="serviceid" class="dt-select-service">
                                    <option value=""><?php echo esc_html__('All Services', 'neocut'); ?></option>
                                        <?php
                                        $services_args = array('post_type'=>'dt_services', 'posts_per_page'=>'-1' , 'suppress_filters' => false );
                                        $cp_services = get_posts( $services_args );
                                        if( $cp_services ){
                                            foreach( $cp_services as $cp_service ){
                                                $id = $cp_service->ID; 
                                                $title = $cp_service->post_title;
                                                ?>
                                                <option value="<?php echo esc_attr($id); ?>"><?php echo esc_html($title); ?></option>
                                                <?php
                                            }
                                        }
                                        ?>
                                </select>
                            </div>
            
                            <div class="column dt-sc-one-third">
                                <label class="dt-sc-margin10"><?php echo esc_html__('Staffs', 'neocut'); ?></label>
                                <select name="staffid" id="staffid" class="dt-select-staff">
                                    <option value=""><?php echo esc_html__('All Staffs','neocut'); ?></option>
                                    <?php
                                    $staffs_args = array(
                                        'post_type' => 'dt_staffs',
                                        'posts_per_page' => '-1',
                                        'meta_query'=>array()
                                        );
                                    $cp_staffs = get_posts( $staffs_args );
                                    if( $cp_staffs ){
                                        foreach( $cp_staffs as $cp_staff ){
                                            $id = $cp_staff->ID;
                                            $title = $cp_staff->post_title;
                                            ?>
                                            <option value="<?php echo esc_attr($id); ?>"><?php echo esc_html($title); ?></option>
                                            <?php
                                        }
                                    }
                                    ?>
                                </select>
                            </div>
            
                            <div class="column dt-sc-one-third">
                                <label class="dt-sc-margin10"><?php echo esc_html__('Date', 'neocut'); ?></label>
                                <input type="text" id="aptdatepicker" name="date" value="<?php if(isset($_REQUEST['date'])) echo esc_attr($_REQUEST['date']); else echo date('Y-m-d'); ?>" />
                            </div>
                            
                            <div class="dt-sc-margin60"></div>
                            <input class="generate-timeslot" value="<?php echo esc_html__('Check available time', 'neocut'); ?>" type="button" />
        
                        </form>
                        <div class="dt-sc-margin50"> </div> 
                        
                    </div>
                    
                    <div class="dt-sc-timeslot-box">
                        <div class="appointment-ajax-holder"></div>
                    </div>
                
                </div>
                
                            
                <div class="dt-sc-contactdetails-box steps step2" <?php echo neocut_wp_kses($step4_other_steps_content_status.' '.$step1_other_steps_content_status); ?>>
                
                    <h2 class="dt-sc-border-title type3"><?php echo esc_html__('Please provide us your contact details', 'neocut'); ?></h2>
                    <div class="dt-sc-margin30"></div>
                    
                    <form class="dt-sc-appointment-contactdetails-form" name="dt-sc-appointment-contactdetails-form" method="post" >
                    
                        <div class="column dt-sc-one-half first">
                            <label class="dt-sc-margin10"><?php echo esc_html__('First Name', 'neocut'); ?></label>
                            <input type="text" id="firstname" name="firstname" value="" placeholder="<?php echo esc_html__('Enter your first name', 'neocut'); ?>" required />
                        </div>
                        <div class="column dt-sc-one-half">
                            <label class="dt-sc-margin10"><?php echo esc_html__('Last Name', 'neocut'); ?></label>
                            <input type="text" id="lastname" name="lastname" value="" placeholder="<?php echo esc_html__('Enter your last name', 'neocut'); ?>" required />
                        </div>
                        
                        <div class="column dt-sc-one-half first">
                            <label class="dt-sc-margin10"><?php echo esc_html__('Phone', 'neocut'); ?></label>
                            <input type="text" id="phone" name="phone" value="" placeholder="<?php echo esc_html__('Enter your phone number', 'neocut'); ?>" required />
                        </div>
                        <div class="column dt-sc-one-half">
                            <label class="dt-sc-margin10"><?php echo esc_html__('Email', 'neocut'); ?></label>
                            <input type="text" id="emailid" name="emailid" value="" placeholder="<?php echo esc_html__('Enter your email', 'neocut'); ?>" required />
                        </div>
                        
                        <div class="column dt-sc-one-half first">
                            <label class="dt-sc-margin10"><?php echo esc_html__('Address 1', 'neocut'); ?></label>
                            <input type="text" id="address1" name="address1" value="" placeholder="<?php echo esc_html__('Enter your address line 1', 'neocut'); ?>" />
                        </div>
                        <div class="column dt-sc-one-half">
                            <label class="dt-sc-margin10"><?php echo esc_html__('Address 2', 'neocut'); ?></label>
                            <input type="text" id="address2" name="address2" value="" placeholder="<?php echo esc_html__('Enter your address line 2', 'neocut'); ?>"  />
                        </div>
                        
                        <div class="column dt-sc-one-half first">
                            <label class="dt-sc-margin10"><?php echo esc_html__('City', 'neocut'); ?></label>
                            <input type="text" id="city" name="city" value="" placeholder="<?php echo esc_html__('Enter your city', 'neocut'); ?>" />
                        </div>
                        <div class="column dt-sc-one-half">
                            <label class="dt-sc-margin10"><?php echo esc_html__('State', 'neocut'); ?></label>
                            <input type="text" id="state" name="state" value="" placeholder="<?php echo esc_html__('Enter your state', 'neocut'); ?>" />
                        </div>
                        
                        <div class="column dt-sc-one-half first">
                            <label class="dt-sc-margin10"><?php echo esc_html__('Zip', 'neocut'); ?></label>
                            <input type="text" id="zip" name="zip" value="" placeholder="<?php echo esc_html__('Enter your zip code', 'neocut'); ?>" />
                        </div>
                        <div class="column dt-sc-one-half"></div>
                        
                        <div class="column dt-sc-one-column first">
                            <label class="dt-sc-margin10"><?php echo esc_html__('Notes if any', 'neocut'); ?></label>
                            <textarea id="notes" name="notes" placeholder="<?php echo esc_html__('Anything you like to share with us', 'neocut'); ?>"></textarea>
                        </div>
                        
                        <div class="dt-sc-margin10"></div>
                        
                        <input class="fullwidth generate-paymentbox" value="<?php echo esc_html__('Next', 'neocut'); ?>" type="submit" />	
        
                    </form>
                    
                </div>
                
                
                <div class="dt-sc-payment-box steps step3" <?php echo neocut_wp_kses($step4_other_steps_content_status.' '.$step1_other_steps_content_status); ?>>
                    
                    <div id="dt-sc-ajax-load-image" style="display:none;"><img src="<?php echo esc_url( NEOCUT_THEME_URI . '/framework/theme-options/images/loading.png' );?>" alt="<?php esc_html_e('Loading','neocut');?>" /></div>
                    
                    <h2 class="dt-sc-border-title type3"><?php echo esc_html__('Please make payment for our service', 'neocut'); ?></h2>
                    <div class="dt-sc-margin30"></div>
                    
                    <?php
                    $currency = neocut_option('appointments','currency');
                    $language = neocut_option('appointments','language');
                    $payment_modes = neocut_option('appointments','payment-modes');
                    $sandbox_account = neocut_option('appointments','sandbox-account');
                    $live_account = neocut_option('appointments','live-account');
                    if($payment_modes == 'live_mode') {
                        $account = $live_account;
                        $path = 'paypal';
                    } else {
                        $account = $sandbox_account;	
                        $path = 'sandbox.paypal';
                    }
                    
                    $appointment_pageurl = neocut_get_page_permalink_by_its_template('tpl-appointment.php');
                    
                    $appointment_id = $wpdb->get_var("SELECT max(option_id) FROM $wpdb->options");
                    
                    ?>
                    
                    <form action='https://www.<?php echo esc_attr($path); ?>.com/cgi-bin/webscr' method='post' class="dt-sc-appointment-payment-form" name="dt-sc-appointment-payment-form">
                        
                        <label>
                            <input type="radio" name="payment_type" value="payatarrival" checked="checked" /><?php echo esc_html__('Pay At Arrival', 'neocut'); ?>
                        </label>
                            
                        <?php
                        $enablepaypal = neocut_option('appointments','enable-paypal');
                        if($enablepaypal != '') {
                            ?>
                            <label>
                                <input type="radio" name="payment_type" value="paypal" /><?php echo esc_html__('Pay Using Paypal', 'neocut'); ?>
                            </label>
                            
                            <input type="hidden" name="cmd" value="_xclick" />
                            <input type="hidden" name="business" value="<?php echo esc_attr($account); ?>" />
                            <input type="hidden" name="item_name" id="paypal_item_name" value="" />
                            <input type="hidden" name="currency_code" value="<?php echo esc_attr($currency); ?>" />
                            <input type="hidden" name="amount" id="paypal_amount" value="" />
                            <input type="hidden" name="lc" value="<?php echo esc_attr($language); ?>">
                            <input type="hidden" name="item_number" value="<?php echo esc_attr($appointment_id); ?>" />
                            <input type="hidden" name="return" value="<?php echo esc_url($appointment_pageurl).'?status=success'; ?>" />
                            <input type="hidden" name="bn" value="<?php echo esc_html__('DesignThemes Appointment Addon', 'neocut'); ?>">
                            <input type="hidden" name="cancel_return" value="<?php echo esc_url($appointment_pageurl).'?status=cancelled'; ?>" />
                            <input type="hidden" name="notify_url" value="<?php echo esc_url($appointment_pageurl); ?>" />
                            <input type="hidden" name="first_name" id="customer_first_name" value="" />
                            <input type="hidden" name="last_name" id="customer_last_name" value="" />
                            <input type="hidden" name="address1" id="customer_address1" value="" />
                            <input type="hidden" name="address2" id="customer_address2" value="" />
                            <input type="hidden" name="city" id="customer_city" value="" />
                            <input type="hidden" name="state" id="customer_state" value="" />
                            <input type="hidden" name="zip" id="customer_zip" value="" />
                            <?php
                        }
                        ?>
                        
                        <input type="hidden" name="custom" id="custom" value="" />	
                            
                        <input class="make-payment" value="<?php echo esc_html__('Next', 'neocut'); ?>" type="submit" />
                    
                    </form>
                </div>
                
                <div class="dt-sc-appointment-notification-box steps step4" <?php echo neocut_wp_kses($step4_content_status.' '.$step1_other_steps_content_status); ?>>
                
                    <?php
                    $contact_info = $schedule_info = '';
                    $notification_display = 'style="display:none"';
                    if(array_key_exists('custom', $_REQUEST) && $_REQUEST['custom'] != '') {
                        
                        $custom_data = explode('|', $_REQUEST['custom']);
                        $schedule_info_arr = explode('#', $custom_data[0]);
                        if(isset($schedule_info_arr)) {
                            $schedule_info = '<ul>';
							if($schedule_info_arr[0] != '') { $schedule_info .= '<li><label>'.esc_html__('Day : ', 'neocut').' : </label>'.$schedule_info_arr[0].'</li>'; }
							if($schedule_info_arr[1] != '') { $schedule_info .= '<li><label>'.esc_html__('Time : ', 'neocut').' : </label>'.$schedule_info_arr[1].'</li>'; }
							if($schedule_info_arr[2] != '') { $schedule_info .= '<li><label>'.esc_html__('Store : ', 'neocut').' : </label>'.$schedule_info_arr[2].'</li>'; }
							if($schedule_info_arr[3] != '') { $schedule_info .= '<li><label>'.esc_html__('Staff : ', 'neocut').' : </label>'.$schedule_info_arr[3].'</li>'; }
							if($schedule_info_arr[4] != '') { $schedule_info .= '<li><label>'.esc_html__('Service : ', 'neocut').' : </label>'.$schedule_info_arr[4].'</li>'; }
                            $schedule_info .= '</ul>';
                        }
                        
                        $contact_info_arr = explode('#', $custom_data[2]);
                        if(isset($contact_info_arr)) {
                            $contact_info = '<ul>';
							if($contact_info_arr[0] != '') { $contact_info .= '<li><label>'.esc_html__('Name : ', 'neocut').' : </label>'.$contact_info_arr[0].' '.$contact_info_arr[1].'</li>'; }
							if($contact_info_arr[2] != '') { $contact_info .= '<li><label>'.esc_html__('Address 1 : ', 'neocut').' : </label>'.$contact_info_arr[2].'</li>'; }
							if($contact_info_arr[3] != '') { $contact_info .= '<li><label>'.esc_html__('Address 2 : ', 'neocut').' : </label>'.$contact_info_arr[3].'</li>'; }
							if($contact_info_arr[4] != '') { $contact_info .= '<li><label>'.esc_html__('City : ', 'neocut').' : </label>'.$contact_info_arr[4].'</li>'; }
							if($contact_info_arr[5] != '') { $contact_info .= '<li><label>'.esc_html__('State : ', 'neocut').' : </label>'.$contact_info_arr[5].'</li>'; }
							if($contact_info_arr[6] != '') { $contact_info .= '<li><label>'.esc_html__('Zip : ', 'neocut').' : </label>'.$contact_info_arr[6].'</li>'; }
							if($contact_info_arr[7] != '') { $contact_info .= '<li><label>'.esc_html__('Phone : ', 'neocut').' : </label>'.$contact_info_arr[7].'</li>'; }
							if($contact_info_arr[8] != '') { $contact_info .= '<li><label>'.esc_html__('Email : ', 'neocut').' : </label>'.$contact_info_arr[8].'</li>'; }
                            $contact_info .= '</ul>';
                        }
                        
                        $notification_display = 'style="display:block"';
                        
                    }
                    ?>
                    <div class="column dt-sc-one-half dt-sc-notification-details dt-sc-notification-schedulebox first" <?php echo neocut_wp_kses($notification_display); ?>>
                        <h3><?php echo esc_html__('Schedule Details', 'neocut'); ?></h3>
                        <div class="dt-sc-schedule-details" id="dt-sc-schedule-details"><?php echo neocut_wp_kses($schedule_info); ?></div>
                    </div>
                    
                    <div class="column dt-sc-one-half dt-sc-notification-details dt-sc-notification-contactbox" <?php echo neocut_wp_kses($notification_display); ?>>
                        <h3><?php echo esc_html__('Contact Information', 'neocut'); ?></h3>
                        <div class="dt-sc-contact-info" id="dt-sc-contact-info"><?php echo neocut_wp_kses($contact_info); ?></div>
                    </div>
        
                    <div class="dt-sc-margin25"></div>
                    <div class="clear"></div>
                     
                    <?php
                    $success_display = $cancelled_display = 'style="display:none"';
                    if(array_key_exists('status', $_REQUEST) && $_REQUEST['status'] == 'success') {
                        $success_display = 'style="display:block"';
                    }
                    if(array_key_exists('status', $_REQUEST) && $_REQUEST['status'] == 'cancelled') {
                        $cancelled_display = 'style="display:block"';
                    }
                    ?> 
                    <div class="dt-sc-apt-success-box" <?php echo neocut_wp_kses($success_display); ?>>
                        <?php
                        $success = neocut_option('appointments', 'success_message');
                        $success = stripslashes($success);
                        echo do_shortcode($success);
                        ?>
                    </div>
                    <div class="dt-sc-apt-error-box" <?php echo neocut_wp_kses($cancelled_display); ?>>
                        <?php
                        $error= neocut_option('appointments', 'error_message');
                        $error = stripslashes($error);
                        echo do_shortcode($error);
                        ?>
                    </div>
                    
                </div>
                
            <?php
    
        } else {
            ?>
            <div class="dt-sc-notification-box dt-sc-info-box"><?php echo esc_html__('Please install and activate the DesignThemes Appointment Addon!', 'neocut'); ?></div>
            <?php
        }
        ?>
        
    </section>
    
</div>    

<?php get_footer(); ?>