<?php
add_filter( 'wpsl_templates', 'neocut_store_locator_template' );
function neocut_store_locator_template( $templates ) {

    $templates[] = array (
        'id'   => 'custom',
        'name' => 'Custom template',
        'path' => get_template_directory() . '/' . 'wpsl-templates/custom.php',
    );

    return $templates;
	
}

add_filter( 'wpsl_listing_template', 'neocut_custom_listing_template' );
function neocut_custom_listing_template() {

    global $wpsl_settings;
	
    $listing_template = '<li data-store-id="<%= id %>">' . "\r\n";
    $listing_template .= "\t\t" . '<div>' . "\r\n";
    $listing_template .= "\t\t\t" . '<p><%= thumb %>' . "\r\n";
    $listing_template .= "\t\t\t\t" . wpsl_store_header_template( 'listing' ) . "\r\n";
    $listing_template .= "\t\t\t\t" . '<span class="wpsl-street"><%= address %></span>' . "\r\n";
    $listing_template .= "\t\t\t\t" . '<% if ( address2 ) { %>' . "\r\n";
    $listing_template .= "\t\t\t\t" . '<span class="wpsl-street"><%= address2 %></span>' . "\r\n";
    $listing_template .= "\t\t\t\t" . '<% } %>' . "\r\n";
    $listing_template .= "\t\t\t\t" . '<span>' . wpsl_address_format_placeholders() . '</span>' . "\r\n";
    $listing_template .= "\t\t\t\t" . '<span class="wpsl-country"><%= country %></span>' . "\r\n";
    $listing_template .= "\t\t\t" . '</p>' . "\r\n";
    $listing_template .= "\t\t" . '</div>' . "\r\n";

    if ( !$wpsl_settings['hide_distance'] ) {
        $listing_template .= "\t\t" . '<p><span><%= distance %> ' . esc_html( $wpsl_settings['distance_unit'] ) . '</span></p>' . "\r\n";
    }
 
	$appointment_pageurl = neocut_get_page_permalink_by_its_template('tpl-appointment.php');
	if($appointment_pageurl != '' && $appointment_pageurl != '#' && class_exists('DTAppointmentAddon')) {
		$listing_template .= "\t\t\t" . '<a href="'.esc_url($appointment_pageurl).'?storeid=<%= id %>" target="_blank" class="dt-appointment-fix">' . esc_html__( 'Fix an Appointment', 'neocut' ) . '</a>' . "\r\n";
	}
 
    $listing_template .= "\t\t" . '<%= createDirectionUrl() %>' . "\r\n"; 
	
    $listing_template .= "\t" . '</li>' . "\r\n"; 

    return $listing_template;
	
}

add_filter( 'wpsl_thumb_size', 'neocut_custom_thumb_size' );
function neocut_custom_thumb_size() {
    
    $size = array( 90, 90 );
    return $size;
	
}


add_action( 'wp_enqueue_scripts', 'neocut_enqueue_custom_js' );
function neocut_enqueue_custom_js() {
	
	$custom_js = "\n";
	$custom_js .= 'jQuery.noConflict();
	jQuery(document).ready(function($){
        
        $("a.dt-sc-toggle-advanced-options").on( "click", function( event ){
			event.preventDefault();
			var $this = $(this);
			$this.parents(".wpsl-search").find( "div.dt-sc-advanced-options" ).slideToggle( "slow", function() {
				$this.toggleClass("expanded");
				if($this.hasClass("expanded")) {
					$this.html(dttheme_urls.advOptions + \' <span class="fa fa-angle-up"></span>\');
				} else {
					$this.html(dttheme_urls.advOptions + \' <span class="fa fa-angle-down"></span>\');
				}
			});
		});
		
	});';
	$custom_js .= "\n";
	
		
	if($custom_js != '') {
		wp_add_inline_script( 'jq.custom', $custom_js );
	}

}

?>