<?php
/**
 * Gutenberg Editor CSS
 */

if ( ! class_exists( 'Gutenberg_Editor_CSS' ) ) :
	/**
	 * Admin Helper
	 */
	class Gutenberg_Editor_CSS {

		function __construct() {

			add_action( 'current_screen', array( $this,  'neocut_current_screen_hook' ), 10, 1 );
			add_action( 'enqueue_block_editor_assets', array( $this, 'neocut_backend_editor_styles' ), 10 );
			add_filter( 'tiny_mce_before_init', array( $this, 'neocut_theme_editor_dynamic_styles' ) );
			add_action( 'wp_enqueue_scripts', array( $this, 'neocut_editor_enqueue_styles'), 110 );

		}
		
		function neocut_theme_editor_dynamic_styles( $mceInit ) {

			$styles = '';
			$styles = neocut_styles_custom_font();


			$body_bg_color = neocut_option('colors','body-bgcolor');
			if( $body_bg_color != '' ) {
				$styles .= "body { background-color: ".$body_bg_color." !important; } ";
			}

			$content_text_color = neocut_option('colors','content-text-color');
			if( $content_text_color != '' ) {
				$styles .= "body { color: ".$content_text_color." !important; } ";
			}

			$content_link_color = neocut_option('colors','content-link-color');
			if( $content_link_color != '' ) {
				$styles .= "a { color: ".$content_link_color." !important; } ";
			}

			$content_link_hcolor = neocut_option('colors','content-link-hcolor');
			if( $content_link_hcolor != '' ) {
				$styles .= "a:hover { color: ".$content_link_hcolor." !important; } ";
			}

			$heading_h1_color = neocut_option('colors','heading-h1-color');
			if( $heading_h1_color != '' ) {
				$styles .= "h1 { color: ".$heading_h1_color." !important; } ";
			}

			$heading_h2_color = neocut_option('colors','heading-h2-color');
			if( $heading_h2_color != '' ) {
				$styles .= "h2 { color: ".$heading_h2_color." !important; } ";
			}

			$heading_h3_color = neocut_option('colors','heading-h3-color');
			if( $heading_h3_color != '' ) {
				$styles .= "h3 { color: ".$heading_h3_color." !important; } ";
			}

			$heading_h4_color = neocut_option('colors','heading-h4-color');
			if( $heading_h4_color != '' ) {
				$styles .= "h4 { color: ".$heading_h4_color." !important; } ";
			}

			$heading_h5_color = neocut_option('colors','heading-h5-color');
			if( $heading_h5_color != '' ) {
				$styles .= "h5 { color: ".$heading_h5_color." !important; } ";
			}

			$heading_h6_color = neocut_option('colors','heading-h6-color');
			if( $heading_h6_color != '' ) {
				$styles .= "h6 { color: ".$heading_h6_color." !important; } ";
			}

			$content_font = neocut_option('fonts','content-font');
			if( $content_font != '' ) {
				$styles .= "body { font-family: '".$content_font."' !important; } ";
			}

			$h1font = neocut_option('fonts','h1-font');
			if( $h1font != '' ) {
				$styles .= "h1 { font-family: '".$h1font."' !important; } ";
			}

			$h2font = neocut_option('fonts','h2-font');
			if( $h2font != '' ) {
				$styles .= "h2 { font-family: '".$h2font."' !important; } ";
			}

			$h3font = neocut_option('fonts','h3-font');
			if( $h3font != '' ) {
				$styles .= "h3 { font-family: '".$h3font."' !important; } ";
			}

			$h4font = neocut_option('fonts','h4-font');
			if( $h4font != '' ) {
				$styles .= "h4 { font-family: '".$h4font."' !important; } ";
			}

			$h5font = neocut_option('fonts','h5-font');
			if( $h5font != '' ) {
				$styles .= "h5 { font-family: '".$h5font."' !important; } ";
			}

			$h6font = neocut_option('fonts','h6-font');
			if( $h6font != '' ) {
				$styles .= "h6 { font-family: '".$h6font."' !important; } ";
			}

			$content_font_size = neocut_option('fonts','content-font-size');
			if( $content_font_size != '' ) {
				$styles .= "body { font-size: ".$content_font_size."px !important; } ";
			}

			$h1_font_size = neocut_option('fonts','h1-font-size');
			if( $h1_font_size != '' ) {
				$styles .= "h1 { font-size: ".$h1_font_size."px !important; } ";
			}

			$h2_font_size = neocut_option('fonts','h2-font-size');
			if( $h2_font_size != '' ) {
				$styles .= "h2 { font-size: ".$h2_font_size."px !important; } ";
			}

			$h3_font_size = neocut_option('fonts','h3-font-size');
			if( $h3_font_size != '' ) {
				$styles .= "h3 { font-size: ".$h3_font_size."px !important; } ";
			}

			$h4_font_size = neocut_option('fonts','h4-font-size');
			if( $h4_font_size != '' ) {
				$styles .= "h4 { font-size: ".$h4_font_size."px !important; } ";
			}

			$h5_font_size = neocut_option('fonts','h5-font-size');
			if( $h5_font_size != '' ) {
				$styles .= "h5 { font-size: ".$h5_font_size."px !important; } ";
			}

			$h6_font_size = neocut_option('fonts','h6-font-size');
			if( $h6_font_size != '' ) {
				$styles .= "h6 { font-size: ".$h6_font_size."px !important; } ";
			}


			$h1font_weight = neocut_option('fonts','h1-weight');
			if( $h1font_weight != '' ) {
				$styles .= "h1 { font-weight: ".$h1font_weight." !important;  } ";
			}
			
			$h2font_weight = neocut_option('fonts','h2-weight');
			if( $h2font_weight != '' ) {
				$styles .= "h2 { font-weight: ".$h2font_weight." !important; } ";
			}

			$h3font_weight = neocut_option('fonts','h3-weight');
			if( $h3font_weight != '' ) {
				$styles .= "h3 { font-weight: ".$h3font_weight." !important; } ";
			}

			$h4font_weight = neocut_option('fonts','h4-weight');
			if( $h4font_weight != '' ) {
				$styles .= "h4 { font-weight: ".$h4font_weight." !important; } ";
			}

			$h5font_weight = neocut_option('fonts','h5-weight');
			if( $h5font_weight != '' ) {
				$styles .= "h5 { font-weight: ".$h5font_weight." !important; } ";
			}

			$h6font_weight = neocut_option('fonts','h6-weight');
			if( $h6font_weight != '' ) {
				$styles .= "h6 { font-weight: ".$h6font_weight." !important; } ";
			}

			$h1_letter_spacing = neocut_option('fonts','h1-letter-spacing');
			if( $h1_letter_spacing != '' ) {
				$styles .= "h1 { letter-spacing: ".$h1_letter_spacing." !important; } ";
			}

			$h2_letter_spacing = neocut_option('fonts','h2-letter-spacing');
			if( $h2_letter_spacing != '' ) {
				$styles .= "h2 { letter-spacing: ".$h2_letter_spacing." !important; } ";
			}

			$h3_letter_spacing = neocut_option('fonts','h3-letter-spacing');
			if( $h3_letter_spacing != '' ) {
				$styles .= "h3 { letter-spacing: ".$h3_letter_spacing." !important; } ";
			}

			$h4_letter_spacing = neocut_option('fonts','h4-letter-spacing');
			if( $h4_letter_spacing != '' ) {
				$styles .= "h4 { letter-spacing: ".$h4_letter_spacing." !important; } ";
			}

			$h5_letter_spacing = neocut_option('fonts','h5-letter-spacing');
			if( $h5_letter_spacing != '' ) {
				$styles .= "h5 { letter-spacing: ".$h5_letter_spacing." !important; } ";
			}

			$h6_letter_spacing = neocut_option('fonts','h6-letter-spacing');
			if( $h6_letter_spacing != '' ) {
				$styles .= "h6 { letter-spacing: ".$h6_letter_spacing." !important; } ";
			}

			$body_line_height = neocut_option('fonts','body-line-height');
			if( $body_line_height != '' ) {
				$styles .= "body { line-height: ".$body_line_height."px !important; } ";
			}
				
			if ( isset( $mceInit['content_style'] ) ) {
				$mceInit['content_style'] .= ' ' . $styles . ' ';
			} else {
				$mceInit['content_style'] = $styles . ' ';
			}

			return $mceInit;
		}

		function neocut_current_screen_hook( $current_screen ) {
			
			if ( 'post' == $current_screen->base ) {

				// google fonts -----------------------------------------------------------------
			$google_fonts = neocut_fonts();
			$google_fonts = $google_fonts['all'];

			$subset 	  = neocut_option('fonts','font-subset');
			if( $subset ) $subset = str_replace(' ', '', $subset);

			// style & weight  --------------------------------------------------------------
			if( $weight = neocut_option('fonts', 'font-style') )
				$weight = ':'. implode( ',', $weight );

			$fonts = neocut_fonts_selected();
			$fonts = array_unique($fonts);
			$fonts_url = ''; $font_families = array();
			foreach( $fonts as $font ){
				if( in_array( $font, $google_fonts ) ){
					// if google fonts
					$font_families[] .= $font . $weight;
				}
			}
			$query_args = array( 'family' => urlencode( implode( '|', $font_families ) ), 'subset' => urlencode( $subset ) );
			$fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );

				add_editor_style( $fonts_url );
				add_editor_style( 'css/editor-style.css' );
			}
		}

		function neocut_backend_editor_styles() {
			
			wp_enqueue_style( 'neocut-gutenberg', get_theme_file_uri('/css/admin-gutenberg.css'), false, false, 'all' );
			wp_add_inline_style( 'neocut-gutenberg', neocut_styles_custom_font() );
			
			$styles = '';

			$body_bg_color = neocut_option('colors','body-bgcolor');
			if( $body_bg_color != '' ) {
				$styles .= ".editor-styles-wrapper body, .editor-styles-wrapper { background-color: ".$body_bg_color." !important; } ";
			}

			$content_text_color = neocut_option('colors','content-text-color');
			if( $content_text_color != '' ) {
				$styles .= ".editor-styles-wrapper body, .editor-styles-wrapper, .editor-styles-wrapper blockquote p, .editor-styles-wrapper p { color: ".$content_text_color."; } ";
			}

			$content_link_color = neocut_option('colors','content-link-color');
			if( $content_link_color != '' ) {
				$styles .= ".editor-styles-wrapper a { color: ".$content_link_color." !important; } ";
			}

			$content_link_hcolor = neocut_option('colors','content-link-hcolor');
			if( $content_link_hcolor != '' ) {
				$styles .= ".editor-styles-wrapper a:hover { color: ".$content_link_hcolor." !important; } ";
			}

			$heading_h1_color = neocut_option('colors','heading-h1-color');
			if( $heading_h1_color != '' ) {
				$styles .= ".editor-styles-wrapper h1 { color: ".$heading_h1_color." !important; } ";
			}

			$heading_h2_color = neocut_option('colors','heading-h2-color');
			if( $heading_h2_color != '' ) {
				$styles .= ".editor-styles-wrapper h2 { color: ".$heading_h2_color." !important; } ";
			}

			$heading_h3_color = neocut_option('colors','heading-h3-color');
			if( $heading_h3_color != '' ) {
				$styles .= ".editor-styles-wrapper h3 { color: ".$heading_h3_color." !important; } ";
			}

			$heading_h4_color = neocut_option('colors','heading-h4-color');
			if( $heading_h4_color != '' ) {
				$styles .= ".editor-styles-wrapper h4 { color: ".$heading_h4_color." !important; } ";
			}

			$heading_h5_color = neocut_option('colors','heading-h5-color');
			if( $heading_h5_color != '' ) {
				$styles .= ".editor-styles-wrapper h5 { color: ".$heading_h5_color." !important; } ";
			}

			$heading_h6_color = neocut_option('colors','heading-h6-color');
			if( $heading_h6_color != '' ) {
				$styles .= ".editor-styles-wrapper h6 { color: ".$heading_h6_color." !important; } ";
			}

			$content_font = neocut_option('fonts','content-font');
			if( $content_font != '' ) {
				$styles .= ".editor-styles-wrapper body, .editor-styles-wrapper { font-family: '".$content_font."' !important; } ";
			}

			$h1font = neocut_option('fonts','h1-font');
			if( $h1font != '' ) {
				$styles .= ".editor-styles-wrapper h1 { font-family: '".$h1font."' !important; } ";
			}

			$h2font = neocut_option('fonts','h2-font');
			if( $h2font != '' ) {
				$styles .= ".editor-styles-wrapper h2 { font-family: '".$h2font."' !important; } ";
			}

			$h3font = neocut_option('fonts','h3-font');
			if( $h3font != '' ) {
				$styles .= ".editor-styles-wrapper h3 { font-family: '".$h3font."' !important; } ";
			}

			$h4font = neocut_option('fonts','h4-font');
			if( $h4font != '' ) {
				$styles .= ".editor-styles-wrapper h4 { font-family: '".$h4font."' !important; } ";
			}

			$h5font = neocut_option('fonts','h5-font');
			if( $h5font != '' ) {
				$styles .= ".editor-styles-wrapper h5 { font-family: '".$h5font."' !important; } ";
			}

			$h6font = neocut_option('fonts','h6-font');
			if( $h6font != '' ) {
				$styles .= ".editor-styles-wrapper h6 { font-family: '".$h6font."' !important; } ";
			}

			$content_font_size = neocut_option('fonts','content-font-size');
			if( $content_font_size != '' ) {
				$styles .= ".editor-styles-wrapper body, .editor-block-list__block-edit p, .editor-styles-wrapper blockquote p { font-size: ".$content_font_size."px; } ";
			}

			$h1_font_size = neocut_option('fonts','h1-font-size');
			if( $h1_font_size != '' ) {
				$styles .= ".editor-styles-wrapper h1 { font-size: ".$h1_font_size."px !important; } ";
			}


			$h2_font_size = neocut_option('fonts','h2-font-size');
			if( $h2_font_size != '' ) {
				$styles .= ".editor-styles-wrapper h2 { font-size: ".$h2_font_size."px !important; } ";
			}

			$h3_font_size = neocut_option('fonts','h3-font-size');
			if( $h3_font_size != '' ) {
				$styles .= ".editor-styles-wrapper h3 { font-size: ".$h3_font_size."px !important; } ";
			}

			$h4_font_size = neocut_option('fonts','h4-font-size');
			if( $h4_font_size != '' ) {
				$styles .= ".editor-styles-wrapper h4 { font-size: ".$h4_font_size."px !important; } ";
			}

			$h5_font_size = neocut_option('fonts','h5-font-size');
			if( $h5_font_size != '' ) {
				$styles .= ".editor-styles-wrapper h5 { font-size: ".$h5_font_size."px !important; } ";
			}

			$h6_font_size = neocut_option('fonts','h6-font-size');
			if( $h6_font_size != '' ) {
				$styles .= ".editor-styles-wrapper h6 { font-size: ".$h6_font_size."px !important; } ";
			}


			$h1font_weight = neocut_option('fonts','h1-weight');
			
			if( $h1font_weight != '' ) {
				$styles .= ".editor-styles-wrapper h1 { font-weight: ".$h1font_weight." !important; } ";
			}
			
			$h2font_weight = neocut_option('fonts','h2-weight');
			if( $h2font_weight != '' ) {
				$styles .= ".editor-styles-wrapper h2 { font-weight: ".$h2font_weight." !important; } ";
			}

			$h3font_weight = neocut_option('fonts','h3-weight');
			if( $h3font_weight != '' ) {
				$styles .= ".editor-styles-wrapper h3 { font-weight: ".$h3font_weight." !important; } ";
			}

			$h4font_weight = neocut_option('fonts','h4-weight');
			if( $h4font_weight != '' ) {
				$styles .= ".editor-styles-wrapper h4 { font-weight: ".$h4font_weight." !important; } ";
			}

			$h5font_weight = neocut_option('fonts','h5-weight');
			if( $h5font_weight != '' ) {
				$styles .= ".editor-styles-wrapper h5 { font-weight: ".$h5font_weight." !important; } ";
			}

			$h6font_weight = neocut_option('fonts','h6-weight');
			if( $h6font_weight != '' ) {
				$styles .= ".editor-styles-wrapper h6 { font-weight: ".$h6font_weight." !important; } ";
			}

			$h1_letter_spacing = neocut_option('fonts','h1-letter-spacing');
			if( $h1_letter_spacing != '' ) {
				$styles .= ".editor-styles-wrapper h1 { letter-spacing: ".$h1_letter_spacing." !important; } ";
			}

			$h2_letter_spacing = neocut_option('fonts','h2-letter-spacing');
			if( $h2_letter_spacing != '' ) {
				$styles .= ".editor-styles-wrapper h2 { letter-spacing: ".$h2_letter_spacing." !important; } ";
			}

			$h3_letter_spacing = neocut_option('fonts','h3-letter-spacing');
			if( $h3_letter_spacing != '' ) {
				$styles .= ".editor-styles-wrapper h3 { letter-spacing: ".$h3_letter_spacing." !important; } ";
			}

			$h4_letter_spacing = neocut_option('fonts','h4-letter-spacing');
			if( $h4_letter_spacing != '' ) {
				$styles .= ".editor-styles-wrapper h4 { letter-spacing: ".$h4_letter_spacing." !important; } ";
			}

			$h5_letter_spacing = neocut_option('fonts','h5-letter-spacing');
			if( $h5_letter_spacing != '' ) {
				$styles .= ".editor-styles-wrapper h5 { letter-spacing: ".$h5_letter_spacing." !important; } ";
			}

			$h6_letter_spacing = neocut_option('fonts','h6-letter-spacing');
			if( $h6_letter_spacing != '' ) {
				$styles .= ".editor-styles-wrapper h6 { letter-spacing: ".$h6_letter_spacing." !important; } ";
			}

			$body_line_height = neocut_option('fonts','body-line-height');
			if( $body_line_height != '' ) {
				$styles .= ".editor-styles-wrapper body, .editor-styles-wrapper p { line-height: ".$body_line_height."px !important; } ";
			}
			wp_add_inline_style( 'neocut-gutenberg', $styles );
		}

		function neocut_editor_enqueue_styles( ) {

			$styles = '';

			$primary_color = $secondary_color = $tertiary_color = '';
			$skin = neocut_option('colors','theme-skin');
	
			if( $skin == 'custom' ) {
				$default_options = neocut_default_option();
				$custom_default = $default_options['colors']['custom-default'];
				$custom_light = $default_options['colors']['custom-light'];
				$custom_dark = $default_options['colors']['custom-default'];
	
				$primary_color   = neocut_opts_get('custom-default', $custom_default);
				$secondary_color = neocut_opts_get('custom-light', $custom_light);
				$tertiary_color  = neocut_opts_get('custom-dark', $custom_dark);
			} else {
				$colors          = neocut_skins( $skin );
				$primary_color   = $colors['primary-color'];
				$secondary_color = $colors['secondary-color'];
				$tertiary_color  = $colors['tertiary-color'];
			}

			# Primary Color
			$styles .= '.has-primary-background-color { background-color:'.$primary_color.'; }';
			$styles .= '.has-primary-color { color:'.$primary_color.'; }';
	
			# Secondary Color
			$styles .= '.has-secondary-background-color { background-color:'.$secondary_color.'; }';
			$styles .= '.has-secondary-color { color:'.$secondary_color.'; }';
	
			# Tertiary Color
			$styles .= '.has-tertiary-background-color { background-color:'.$tertiary_color.'; }';
			$styles .= '.has-tertiary-color { color:'.$tertiary_color.'; }';

			wp_add_inline_style('neocut-gutenberg', $styles );

		}

	}

	new Gutenberg_Editor_CSS();

endif;