<?php
/**
 * Theme Functions
 *
 * @package DTtheme
 * @author DesignThemes
 * @link http://wedesignthemes.com
 */

define( 'NEOCUT_THEME_DIR', get_template_directory() );
define( 'NEOCUT_THEME_URI', get_template_directory_uri() );
define( 'NEOCUT_CORE_PLUGIN', WP_PLUGIN_DIR.'/designthemes-core-features' );
define( 'NEOCUT_SETTINGS', 'neocut-opts' );

if (function_exists ('wp_get_theme')) :
	$themeData = wp_get_theme();
	define( 'THEME_NAME', $themeData->get('Name'));
	define( 'THEME_VERSION', $themeData->get('Version'));
endif;

define( 'NEOCUT_LANG_DIR', NEOCUT_THEME_DIR. '/languages' );

/* ---------------------------------------------------------------------------
 * Loads Theme Textdomain
 * --------------------------------------------------------------------------- */
load_theme_textdomain( 'neocut', NEOCUT_LANG_DIR );

/* ---------------------------------------------------------------------------
 * Loads the Admin Panel Scripts
 * --------------------------------------------------------------------------- */
function neocut_admin_scripts() {

	wp_enqueue_style('neocut-admin', NEOCUT_THEME_URI .'/framework/theme-options/style.css');
	wp_enqueue_style('neocut-chosen', NEOCUT_THEME_URI .'/framework/theme-options/css/chosen.css');
	wp_enqueue_style('wp-color-picker');

	wp_enqueue_script('jquery-ui-tabs');
	wp_enqueue_script('jquery-ui-sortable');
	wp_enqueue_script('jquery-ui-slider');
	wp_enqueue_script('wp-color-picker');
	
	wp_enqueue_script('neocut-browser', NEOCUT_THEME_URI . '/framework/theme-options/js/jquery.browser.min.js');
	wp_enqueue_script('neocut-tooltip', NEOCUT_THEME_URI . '/framework/theme-options/js/jquery.tools.min.js');
	wp_enqueue_script('neocut-chosen', NEOCUT_THEME_URI . '/framework/theme-options/js/chosen.jquery.min.js');
	wp_enqueue_script('neocut-custom', NEOCUT_THEME_URI . '/framework/theme-options/js/dttheme.admin.js', array( 'wp-blocks' ));
	wp_enqueue_media();

	wp_localize_script('neocut-custom', 'objectL10n', array(
		'saveall' => esc_html__('Save All', 'neocut'),
		'saving' => esc_html__('Saving ...', 'neocut'),
		'noResult' => esc_html__('No Results Found!', 'neocut'),
		'resetConfirm' => esc_html__('This will restore all of your options to default. Are you sure?', 'neocut'),
		'importConfirm' => esc_html__('You are going to import the dummy data provided with the theme, kindly confirm?', 'neocut'),
		'backupMsg' => esc_html__('Click OK to backup your current saved options.', 'neocut'),
		'backupSuccess' => esc_html__('Your options are backuped successfully', 'neocut'),
		'backupFailure' => esc_html__('Backup Process not working', 'neocut'),
		'disableImportMsg' => esc_html__('Importing is disabled.. :), Please select atleast import type','neocut'),
		'restoreMsg' => esc_html__('Warning: All of your current options will be replaced with the data from your last backup! Proceed?', 'neocut'),
		'restoreSuccess' => esc_html__('Your options are restored from previous backup successfully', 'neocut'),
		'restoreFailure' => esc_html__('Restore Process not working', 'neocut'),
		'importMsg' => esc_html__('Click ok import options from the above textarea', 'neocut'),
		'importSuccess' => esc_html__('Your options are imported successfully', 'neocut'),
		'importFailure' => esc_html__('Import Process not working', 'neocut')));
}
add_action( 'admin_enqueue_scripts', 'neocut_admin_scripts' );

/* ---------------------------------------------------------------------------
 * Loads the Options Panel
 * --------------------------------------------------------------------------- */
require_once( NEOCUT_THEME_DIR .'/framework/utils.php' );
require_once( NEOCUT_THEME_DIR .'/framework/fonts.php' );
require_once( NEOCUT_THEME_DIR .'/framework/theme-options/init.php' );

/* ---------------------------------------------------------------------------
 * Loads Theme Functions
 * --------------------------------------------------------------------------- */

// Functions --------------------------------------------------------------------
require_once( NEOCUT_THEME_DIR .'/functions/register-functions.php' );

// Header -----------------------------------------------------------------------
require_once( NEOCUT_THEME_DIR .'/functions/register-head.php' );

// Menu -------------------------------------------------------------------------
require_once( NEOCUT_THEME_DIR .'/functions/register-menu.php' );
require_once( NEOCUT_THEME_DIR .'/functions/register-mega-menu.php' );

// Hooks ------------------------------------------------------------------------
require_once( NEOCUT_THEME_DIR .'/functions/register-hooks.php' );

// Likes ------------------------------------------------------------------------
require_once( NEOCUT_THEME_DIR .'/functions/register-likes.php' );


// Widgets ----------------------------------------------------------------------
add_action( 'widgets_init', 'neocut_widgets_init' );
function neocut_widgets_init() {
	require_once( NEOCUT_THEME_DIR .'/functions/register-widgets.php' );
}

// Plugins ---------------------------------------------------------------------- 
require_once( NEOCUT_THEME_DIR .'/functions/register-plugins.php' );

// Store Locator -----------------------------------------------------------------------
if(class_exists('WP_Store_locator')) {
	require_once( NEOCUT_THEME_DIR .'/functions/register-storelocator.php' );
}

// WooCommerce ------------------------------------------------------------------
if( function_exists( 'is_woocommerce' ) ){
	require_once( NEOCUT_THEME_DIR .'/functions/register-woocommerce.php' );
}

// Register Gutenberg -----------------------------------------------------------
require_once( NEOCUT_THEME_DIR . '/functions/register-gutenberg-editor.php' ); ?>