<?php
/* ---------------------------------------------------------------------------
 * Load default theme options
 * - To return default options to store in database.
 * --------------------------------------------------------------------------- */
function neocut_default_option() {
	 
	$general = array(
		'show-pagecomments' => 'true',
		'enable-responsive' => 'true',
		'show-mobileslider' => 'true'
	);

	$layout = array(
		'logo' => 'true',
		'show-breadcrumb' => 'true',
		'breadcrumb-delimiter' => 'fa fa-angle-right',
		'show-boxed-layout-pattern-color' => 'true',
		'show-boxed-layout-bg-color' => 'true',
		'site-layout' => 'wide',
		'header-type' => 'fullwidth-header',
		'layout-stickynav' => 'true',
		'header-position' => 'above slider',
		'header-transparant' => 'semi-transparent-header',
		'menu-active-type' => 'menu-active-highlight-grey',
		'show-sociables' => 'on',
		'enable-footer' => 'true',
		'footer-columns' => '4',
		'footer-darkbg' => 'true',
		'enable-copyright' => 'true',
		'copyright-content' => '<div class="container">
		<div class="vc-no-left-padding wpb_column vc_column_container vc_col-sm-12">
			<div class="vc_column-inner ">
				<div class="wpb_wrapper">
					
					<ul class="footer-list aligncenter">
						<li>Top Category: </li>
						<li><a href="">Service </a></li>
						<li><a href="">Products </a></li>
						<li><a href="">Specialists </a></li>
						<li><a href="">Offers </a></li>
					</ul>        
									
				 </div>
			</div>
		</div>
									
		<div class="aligncenter vc-no-right-padding wpb_column vc_column_container vc_col-sm-12">
			<div class="vc_column-inner ">
				<div class="wpb_wrapper">
					
					<p>Copyright © 2015 NEOCUT. Design by <a href="#" title="Designthemes"> Designthemes </a> . All rights reserved</p>
					
				</div>
			</div>
		</div> 
	</div>',
		'copyright-darkbg' => 'true'
	);	
	
	$social = array(
		'social-1' => array(
			'icon' => 'fa-facebook',
			'link' => '#'
		),
		'social-2' => array(
			'icon' => 'fa-twitter',
			'link' => '#'
		),
		'social-3' => array(
			'icon' => 'fa-google-plus',
			'link' => '#'
		)
	);

	$pageoptions = array(
		'show-standard-left-sidebar-for-post-archives' => 'true',
		'show-standard-right-sidebar-for-post-archives' => 'true',
		'post-format-meta' => 'true',
		'post-author-meta' => 'true',
		'post-date-meta' => 'true',
		'post-comment-meta' => 'true',
		'post-category-meta' => 'true',
		'post-tag-meta' => 'true',
		'show-standard-left-sidebar-for-portfolio-archives' => 'true',
		'show-standard-right-sidebar-for-portfolio-archives' => 'true',
		'show-notfound-bg-color' => 'true',
		'enable-404message' => 'true',
		'show-launchdate' => 'true',
		'show-comingsoon-bg-color' => 'true',
		'single-post-comments' => 'true',
		'post-style' => 'entry-date-left',
		'post-archives-enable-excerpt' => 'true',
		'post-archives-post-layout' => 'one-half-column',
		'post-archives-excerpt' => '50',
		'post-archives-readmore' => '[dt_sc_button title="Read More" style="filled" icon_type="fontawesome" iconalign="icon-right with-icon" iconclass="fa fa-long-arrow-right" class="type1"]'
	);

	$woo = array(
		'shop-product-per-page' => '9',
		'show-shop-standard-left-sidebar-for-product-layout' => 'true',
		'show-shop-standard-right-sidebar-for-product-layout' => 'true',
		'show-shop-standard-left-sidebar-for-product-category-layout' => 'true',
		'show-shop-standard-right-sidebar-for-product-category-layout' => 'true',
		'show-shop-standard-left-sidebar-for-product-tag-layout' => 'true',
		'show-shop-standard-right-sidebar-for-product-tag-layout' => 'true'
	);

	$colors = array(
		'theme-skin' => 'custom',
		'body-bgcolor' => '#000',
		'custom-default' => '#da0000',
		'custom-light' => '#ff2828',
		'custom-dark' => '#c50000',
		'content-text-color' => '#ffffff',
        'content-link-color' => '#da0000',
        'content-link-hcolor' => '#ffffff',
		'footer-bgcolor' => '#000000',
		'copyright-bgcolor' => '#000000'	
	);

	$fonts = array(
		'content-font' => 'Open Sans',
		'menu-font' => 'Raleway',
		'pagetitle-font' => 'Raleway',
		'h1-font' => 'Raleway',
		'h2-font' => 'Raleway',
		'h3-font' => 'Raleway',
		'h4-font' => 'Raleway',
		'h5-font' => 'Raleway',
		'h6-font' => 'Raleway',
		'font-style' => array( '100', '100italic', '200', '200italic','300', '300italic','400', '400italic','500', '500italic','600', '600italic','700', '700italic','800', '800italic','900', '900italic'),
		'content-font-size' => '13',
		'menu-font-size' => '13',
		'h1-font-size' => '30',
		'h2-font-size' => '24',
		'h3-font-size' => '18',
		'h4-font-size' => '16',
		'h5-font-size' => '14',
		'h6-font-size' => '13',
		'menu-letter-spacing' => '0.5px',
		'h1-letter-spacing' => '0.5px',
		'h2-letter-spacing' => '0.5px',
		'h3-letter-spacing' => '0.5px',
		'h4-letter-spacing' => '0.5px',
		'h5-letter-spacing' => '0.5px',
		'h6-letter-spacing' => '0.5px',
		'body-line-height' => '24'
	);
	
	$appointments = array(
		
			'dt_company_monday_start' 			=> '08:00',
			'dt_company_monday_end' 			=> '17:00',
	
			'dt_company_tuesday_start' 			=> '08:00',
			'dt_company_tuesday_end' 			=> '17:00',
	
			'dt_company_wednesday_start' 		=> '08:00',
			'dt_company_wednesday_end' 			=> '17:00',
	
			'dt_company_thursday_start' 		=> '08:00',
			'dt_company_thursday_end' 			=> '17:00',
	
			'dt_company_friday_start' 			=> '08:00',
			'dt_company_friday_end' 			=> '18:00',
	
			'notification_sender_name' 			=> get_option( 'blogname' ),
			'notification_sender_email' 		=> get_option( 'admin_email' ),
			
			'appointment_notification_to_staff_subject' 			=>  'Hi [STAFF_NAME] , New booking information ( Booking id: [APPOINTMENT_ID] )',
			'appointment_notification_to_staff_message' 			=> '<p> Hello [STAFF_NAME], </p>
																		<p> Your new Booking id : [APPOINTMENT_ID] </p>
																		<p> Store: [STORE_NAME]</p>
																		<p> Service: [SERVICE]</p>
																		<p> Date & Time: [APPOINTMENT_DATE] - [APPOINTMENT_TIME] </p>
																		<p>Client Name: [CLIENT_NAME]</p>
																		<p>Client Phone: [CLIENT_PHONE]</p>
																		<p>Client Email: [CLIENT_EMAIL]</p>
																		<p>[APPOINTMENT_BODY]</p>',
		
		
			'modified_appointment_notification_to_staff_subject' 	=> 'Hi [STAFF_NAME] , ( Booking id: [APPOINTMENT_ID] ) - Modified',
			'modified_appointment_notification_to_staff_message' 	=> '<p> Hello [STAFF_NAME], </p>
																		<p> Your Booking id : [APPOINTMENT_ID]  was modified </p>
																		<p> Store: [STORE_NAME]</p>
																		<p> Service: [SERVICE]</p>
																		<p> Date & Time: [APPOINTMENT_DATE] - [APPOINTMENT_TIME] </p>
																		<p>Client Name: [CLIENT_NAME]</p>
																		<p>Client Phone: [CLIENT_PHONE]</p>
																		<p>Client Email: [CLIENT_EMAIL]</p>
																		<p>[APPOINTMENT_BODY]</p>',
			
			'deleted_appointment_notification_to_staff_subject' 	=> 'Hi [STAFF_NAME] , ( Booking id: [APPOINTMENT_ID] ) - Deleted / Declined',
			'deleted_appointment_notification_to_staff_message'		=> '<p> Hello [STAFF_NAME], </p>
																		<p> Booking id : [APPOINTMENT_ID]  was Deleted / Declined </p>
																		<p> Store: [STORE_NAME]</p>
																		<p> Service: [SERVICE]</p>
																		<p> Date & Time: [APPOINTMENT_DATE] - [APPOINTMENT_TIME] </p>
																		<p>Client Name: [CLIENT_NAME]</p>
																		<p>Client Phone: [CLIENT_PHONE]</p>
																		<p>Client Email: [CLIENT_EMAIL]</p>
																		<p>[APPOINTMENT_BODY]</p>',
			
			'agenda_to_staff_subject' 								=> 'Hi [STAFF_NAME] , Your Agenda for [TOMORROW]',
			'agenda_to_staff_message' 								=> '<p> Hello [STAFF_NAME], </p><p>Your agenda for tomorrow is </p><p>[TOMORROW_AGENDA]</p>',
	
			'appointment_notification_to_client_subject' 			=> 'Hi [CLIENT_NAME] , New booking information ( Booking id: [APPOINTMENT_ID] )',
			'appointment_notification_to_client_message' 			=> '<p> Hello [CLIENT_NAME], </p>
																		<p> Your new Booking id : [APPOINTMENT_ID] </p>
																		<p> Store: [STORE_NAME]</p>
																		<p> Service: [SERVICE]</p>
																		<p> Date & Time: [APPOINTMENT_DATE] - [APPOINTMENT_TIME] </p>
																		<p> Amount to pay : [AMOUNT]</p>
																		<p>[APPOINTMENT_BODY]</p>
																		<p></p>
																		<p>Thank you for choosing our company.</p>',
	
			'modified_appointment_notification_to_client_subject' 	=> 'Hi [CLIENT_NAME] , ( Booking id: [APPOINTMENT_ID] ) - Modified',
			'modified_appointment_notification_to_client_message' 	=> '<p> Hello [CLIENT_NAME], </p>
																		<p> Your Booking id : [APPOINTMENT_ID]  was modified </p>
																		<p> Store: [STORE_NAME]</p>
																		<p> Service: [SERVICE]</p>
																		<p> Date & Time: [APPOINTMENT_DATE] - [APPOINTMENT_TIME] </p>
																		<p> Amount to pay : [AMOUNT]</p>
																		<p>[APPOINTMENT_BODY]</p>
																		<p></p>
																		<p>Thank you for choosing our company.</p>',
			
			'deleted_appointment_notification_to_client_subject' 	=> 'Hi [CLIENT_NAME] , ( Booking id: [APPOINTMENT_ID] ) - Deleted / Declined',
			'deleted_appointment_notification_to_client_message' 	=> '<p> Hello [CLIENT_NAME], </p>
																		<p> Your Booking id : [APPOINTMENT_ID]  was Deleted / Declined </p>
																		<p> Store: [STORE_NAME]</p>
																		<p> Service: [SERVICE]</p>
																		<p> Date & Time: [APPOINTMENT_DATE] - [APPOINTMENT_TIME] </p>
																		<p>[APPOINTMENT_BODY]</p>',
		
			'success_message' 										=>	'[dt_sc_notification_box type="dt-sc-success-box" class=""]Appointment created successfully. Our professionals will be waiting for your arrival on appontment date.[/dt_sc_notification_box]',
			'error_message' 										=>	'[dt_sc_notification_box type="dt-sc-error-box" class=""]Oops! Something went wrong![/dt_sc_notification_box]',
	
		);

	
	$data = array(
		'general' => $general,
		'layout'  => $layout,
		'social'  => $social,
		'pageoptions' => $pageoptions,
		'woo'	  => $woo,
		'colors'  => $colors,
		'fonts'   => $fonts,
		"appointments" => $appointments
	);
	return $data;
}

/* ---------------------------------------------------------------------------
 * Load default theme options
 * - To return default options to store in database.
 * --------------------------------------------------------------------------- */
function neocut_show_footer_widgetarea( $count ) {
	$classes = array (
		"1" => "dt-sc-full-width",
		"dt-sc-one-half",
		"dt-sc-one-third",
		"dt-sc-one-fourth",
		"1-2" => "dt-sc-one-half",
		"1-3" => "dt-sc-one-third",
		"1-4" => "dt-sc-one-fourth",
		"3-4" => "dt-sc-three-fourth",
		"2-3" => "dt-sc-two-third" );

	if ($count <= 4) :
		for($i = 1; $i <= $count; $i ++) :

			$class = $classes [$count];
			$class = esc_attr( $class );

			$first = ($i == 1) ? "first" : "";
			$first = esc_attr( $first );

			echo "<div class='column {$class} {$first}'>";
				if (function_exists ( 'dynamic_sidebar' ) && dynamic_sidebar ( "footer-sidebar-{$i}" )) : endif;
			echo "</div>";
		endfor;
	elseif ($count == 5 || $count == 6) :

		$a = array (
			"1-4",
			"1-4",
			"1-2" );

		$a = ($count == 5) ? $a : array_reverse ( $a );
		foreach ( $a as $k => $v ) :
			$class = $classes [$v];
			$class = esc_attr( $class );

			$first = ($k == 0 ) ? "first" : "";
			$first = esc_attr( $first );

			echo "<div class='column {$class} {$first}'>";
				if (function_exists ( 'dynamic_sidebar' ) && dynamic_sidebar ( "footer-sidebar-{$k}-{$v}" )) : endif;
			echo "</div>";
		endforeach;
	elseif ($count == 7 || $count == 8) :
		$a = array (
			"1-4",
			"3-4");

		$a = ($count == 7) ? $a : array_reverse ( $a );
		foreach ( $a as $k => $v ) :
			$class = $classes [$v];
			$class = esc_attr( $class );

			$first = ($k == 0 ) ? "first" : "";
			$first = esc_attr( $first );


			echo "<div class='column {$class} {$first}'>";
				if (function_exists ( 'dynamic_sidebar' ) && dynamic_sidebar ( "footer-sidebar-{$k}-{$v}" )) :endif;
			echo "</div>";
		endforeach;
	elseif ($count == 9 || $count == 10) :
		$a = array ( 
			"1-3",
			"2-3" );
		$a = ($count == 9) ? $a : array_reverse ( $a );

		foreach ( $a as $k => $v ) :
			$class = $classes [$v];
			$class = esc_attr( $class );

			$first = ($k == 0 ) ? "first" : "";
			$first = esc_attr( $first );

			echo "<div class='column {$class} {$first}'>";
				if (function_exists ( 'dynamic_sidebar' ) && dynamic_sidebar ( "footer-sidebar-{$k}-{$v}" )) :endif;
			echo "</div>";
		endforeach;
	elseif ($count == 11 ) :
		$a = array ( "1-4", "1-2", "1-4" );
		foreach ( $a as $k => $v ) :
			$class = $classes [$v];
			$class = esc_attr( $class );
			$first = ($k == 0 ) ? "first" : "";
			$first = esc_attr( $first );
			echo "<div class='column {$class} {$first}'>";
				if (function_exists ( 'dynamic_sidebar' ) && dynamic_sidebar ( "footer-sidebar-{$k}-{$v}" )) : endif;
			echo "</div>";
		endforeach;
	endif;
}

/* ---------------------------------------------------------------------------
 * Custom Function To Get Page Permalink By Its Template
 * --------------------------------------------------------------------------- */
function neocut_get_page_permalink_by_its_template( $temlplate ) {
	$permalink = '#';

	$pages = get_posts( array(
			'post_type' => 'page',
			'meta_key' => '_wp_page_template',
			'meta_value' => $temlplate,
			'suppress_filters' => false  ) );

	if ( is_array( $pages ) && count( $pages ) > 0 ) {
		$login_page = $pages[0];
		$permalink = get_permalink( $login_page->ID );
	}
	return $permalink;
}
?>