<!-- #colors -->
<div id="colors" class="bpanel-content">

    <!-- .bpanel-main-content -->
    <div class="bpanel-main-content">
        <ul class="sub-panel"> 
            <li><a href="#tab1"><?php esc_html_e('General', 'neocut');?></a></li>
            <li><a href="#tab2"><?php esc_html_e('Header', 'neocut');?></a></li>
			<li><a href="#tab3"><?php esc_html_e('Menu', 'neocut');?></a></li>
            <li><a href="#tab4"><?php esc_html_e('Content', 'neocut');?></a></li>
            <li><a href="#tab5"><?php esc_html_e('Footer', 'neocut');?></a></li>
            <li><a href="#tab6"><?php esc_html_e('Heading', 'neocut');?></a></li>
        </ul>
        
        <!-- #tab1-general -->
        <div id="tab1" class="tab-content">
            <!-- .bpanel-box -->
            <div class="bpanel-box">
                <div class="box-title">
                    <h3><?php esc_html_e('Skin', 'neocut');?></h3>
                </div>
                <div class="box-content">
                    <div class="column one-third"><label><?php esc_html_e('Theme Skin', 'neocut');?></label></div>
                    <div class="column two-third last">
                    	<?php 
						$skins = array('blue', 'brown', 'cadetblue', 'chillipepper', 'cyan', 'darkgolden', 'deeporange', 'deeppurple', 'green', 'lime', 'magenta', 'orange', 'pink', 'purple', 'red', 'skyblue', 'teal', 'turquoise', 'wisteria', 'yellow'); 
						?>
                        <select id="dttheme-skin-color" name="dttheme[colors][theme-skin]" class="medium dt-chosen-select skin-types">
                        	<optgroup label="Custom">
								<option value="custom"><?php esc_html_e('Custom Skin', 'neocut'); ?></option>
							</optgroup>
							<optgroup label="Skins"><?php
								foreach($skins as $skin):
									$s = selected(neocut_option('colors','theme-skin'),$skin,false);
									echo "<option $s >$skin</option>";
								endforeach;?>
                            </optgroup>    
                        </select>
                        <p class="note"><?php esc_html_e('Choose one of the predefined styles or set your own colors.', 'neocut');?></p>
                    </div>
                    <div class="hr"></div>

                    <div class="column one-third"><label><?php esc_html_e('Body Background Color', 'neocut');?></label></div>
                    <div class="column two-third last"><?php
						$name  =  "dttheme[colors][body-bgcolor]";
						$value =  (neocut_option('colors','body-bgcolor') != NULL) ? neocut_option('colors','body-bgcolor') :"";
                        neocut_admin_color_picker_two($name,$value);?>
                        <p class="note"><?php esc_html_e('Pick a custom background color of the body.(e.g. #a314a3)', 'neocut');?></p>
                    </div>
                    <div class="hr"></div>

                    <?php $panelvisible = ( neocut_option('colors','theme-skin') == 'custom' ) ? 'style="display:block"' : 'style="display:none"'; ?>

					<div class="custom-skin-panel" <?php echo neocut_wp_kses($panelvisible);?>>
                        <div class="column one-third"><label><?php esc_html_e('Default Color', 'neocut');?></label></div>
                        <div class="column two-third last"><?php
                            $name  =  "dttheme[colors][custom-default]";
                            $value =  (neocut_option('colors','custom-default') != NULL) ? neocut_option('colors','custom-default') :"";
                            neocut_admin_color_picker_two($name,$value);?>
                            <p class="note"><?php esc_html_e('Important: This option can be used only with the <b>"Custom Skin"</b>.', 'neocut');?></p>
                        </div>
                        <div class="hr"></div>
    
                        <div class="column one-third"><label><?php esc_html_e('Light Color', 'neocut');?></label></div>
                        <div class="column two-third last"><?php
                            $name  =  "dttheme[colors][custom-light]";
                            $value =  (neocut_option('colors','custom-light') != NULL) ? neocut_option('colors','custom-light') :"";
                            neocut_admin_color_picker_two($name,$value);?>
                            <p class="note"><?php esc_html_e('Important: This option can be used only with the <b>"Custom Skin"</b>.', 'neocut');?></p>
                        </div>
                        <div class="hr"></div>
    
                        <div class="column one-third"><label><?php esc_html_e('Dark Color', 'neocut');?></label></div>
                        <div class="column two-third last"><?php
                            $name  =  "dttheme[colors][custom-dark]";
                            $value =  (neocut_option('colors','custom-dark') != NULL) ? neocut_option('colors','custom-dark') :"";
                            neocut_admin_color_picker_two($name,$value);?>
                            <p class="note"><?php esc_html_e('Important: This option can be used only with the <b>"Custom Skin"</b>.', 'neocut');?></p>
                        </div>
                    </div>    

                </div><!-- .box-content -->
            </div><!-- .bpanel-box end -->
        </div><!-- #tab1-general end -->

        <!-- #tab2-header -->
        <div id="tab2" class="tab-content">
            <!-- .bpanel-box -->
            <div class="bpanel-box">
                <div class="box-title">
                    <h3><?php esc_html_e('Header', 'neocut');?></h3>
                </div>
                
                <div class="box-content">
                    <div class="column one-half">
                    	<label><?php esc_html_e('Header BG Color', 'neocut');?></label>
                        <div class="clear"></div><?php
						$name  =  "dttheme[colors][header-bgcolor]";
						$value =  (neocut_option('colors','header-bgcolor') != NULL) ? neocut_option('colors','header-bgcolor') :"";
                        neocut_admin_color_picker_two($name,$value);?>
                        <p class="note"><?php esc_html_e('Pick a custom background color of the header.(e.g. #a314a3)', 'neocut');?></p>
                    </div>

					<div class="column one-half last">
						<div class="bpanel-option-set">
	                        <?php echo neocut_admin_jqueryuislider( esc_html__("Background opacity", 'neocut'), "dttheme[colors][header-bgcolor-opacity]",
                                                                          neocut_option("colors","header-bgcolor-opacity"),"");?>
                        </div>
                        <p class="note"><?php esc_html_e('You can adjust opacity of the header BG color here.', 'neocut');?></p>
                    </div>
					<div class="hr"></div>
                </div><!-- .box-content -->
                
                <div class="box-title">
                    <h3><?php esc_html_e('Top Bar', 'neocut');?></h3>
                </div>
                
                <div class="box-content">
                    <div class="column one-third"><label><?php esc_html_e('Top Bar BG Color', 'neocut');?></label></div>
                    <div class="column two-third last"><?php
						$name  =  "dttheme[colors][topbar-bgcolor]";
						$value =  (neocut_option('colors','topbar-bgcolor') != NULL) ? neocut_option('colors','topbar-bgcolor') :"";
                        neocut_admin_color_picker_two($name,$value);?>
                        <p class="note"><?php esc_html_e('Pick a custom background color of the top bar.(e.g. #a314a3)', 'neocut');?></p>
                    </div>
                    <div class="hr"></div>
                    
                    <div class="column one-third"><label><?php esc_html_e('Top Bar Text Color', 'neocut');?></label></div>
                    <div class="column two-third last"><?php
						$name  =  "dttheme[colors][topbar-textcolor]";
						$value =  (neocut_option('colors','topbar-textcolor') != NULL) ? neocut_option('colors','topbar-textcolor') :"";
                        neocut_admin_color_picker_two($name,$value);?>
                        <p class="note"><?php esc_html_e('Pick a custom text color of the top bar.(e.g. #a314a3)', 'neocut');?></p>
                    </div>
                    <div class="hr"></div>
                    
                    <div class="column one-third"><label><?php esc_html_e('Top Bar Link Color', 'neocut');?></label></div>
                    <div class="column two-third last"><?php
						$name  =  "dttheme[colors][topbar-linkcolor]";
						$value =  (neocut_option('colors','topbar-linkcolor') != NULL) ? neocut_option('colors','topbar-linkcolor') :"";
                        neocut_admin_color_picker_two($name,$value);?>
                        <p class="note"><?php esc_html_e('Pick a custom link color of the top bar.(e.g. #a314a3)', 'neocut');?></p>
                    </div>
                    <div class="hr"></div>                    
                    
                    <div class="column one-third"><label><?php esc_html_e('Top Bar Link Hover Color', 'neocut');?></label></div>
                    <div class="column two-third last"><?php
						$name  =  "dttheme[colors][topbar-linkhovercolor]";
						$value =  (neocut_option('colors','topbar-linkhovercolor') != NULL) ? neocut_option('colors','topbar-linkhovercolor') :"";
                        neocut_admin_color_picker_two($name,$value);?>
                        <p class="note"><?php esc_html_e('Pick a custom link hover color of the top bar.(e.g. #a314a3)', 'neocut');?></p>
                    </div>
                </div><!-- .box-content -->
                
            </div><!-- .bpanel-box end -->            
        </div><!-- #tab2-header end -->

        <!-- #tab3-menu -->
        <div id="tab3" class="tab-content">
            <!-- .bpanel-box -->
            <div class="bpanel-box">
                <div class="box-title">
                    <h3><?php esc_html_e('Menu', 'neocut');?></h3>
                </div>

                <div class="box-content">
                    <div class="column one-half">
                    	<label><?php esc_html_e('Menu BG Color', 'neocut');?></label>
                        <div class="clear"></div><?php
						$name  =  "dttheme[colors][menu-bgcolor]";
						$value =  (neocut_option('colors','menu-bgcolor') != NULL) ? neocut_option('colors','menu-bgcolor') :"";
                        neocut_admin_color_picker_two($name,$value);?>
                        <p class="note"><?php esc_html_e('Pick a custom background color of the menu.(e.g. #a314a3)', 'neocut');?></p>
                    </div>

					<div class="column one-half last">
						<div class="bpanel-option-set">
	                        <?php echo neocut_admin_jqueryuislider( esc_html__("Background opacity", 'neocut'), "dttheme[colors][menu-bgcolor-opacity]",
                                                                          neocut_option("colors","menu-bgcolor-opacity"),"");?>
                        </div>
                        <p class="note"><?php esc_html_e('You can adjust opacity of the menu BG color here.', 'neocut');?></p>
                    </div>
					<div class="hr"></div>

                    <div class="column one-third"><label><?php esc_html_e('Menu Link Color', 'neocut');?></label></div>
                    <div class="column two-third last"><?php
						$name  =  "dttheme[colors][menu-linkcolor]";
						$value =  (neocut_option('colors','menu-linkcolor') != NULL) ? neocut_option('colors','menu-linkcolor') :"";
                        neocut_admin_color_picker_two($name,$value);?>
                        <p class="note"><?php esc_html_e('Pick a custom color of the menu links.(e.g. #a314a3)', 'neocut');?></p>
                    </div>
                    <div class="hr"></div>

                    <div class="column one-third"><label><?php esc_html_e('Menu Hover Color', 'neocut');?></label></div>
                    <div class="column two-third last"><?php
						$name  =  "dttheme[colors][menu-hovercolor]";
						$value =  (neocut_option('colors','menu-hovercolor') != NULL) ? neocut_option('colors','menu-hovercolor') :"";
                        neocut_admin_color_picker_two($name,$value);?>
                        <p class="note"><?php esc_html_e('Pick a custom color of the hover menu links.(e.g. #a314a3)', 'neocut');?></p>
                    </div>
                    <div class="hr"></div>

                    <div class="column one-third"><label><?php esc_html_e('Menu Link Active Color', 'neocut');?></label></div>
                    <div class="column two-third last"><?php
						$name  =  "dttheme[colors][menu-activecolor]";
						$value =  (neocut_option('colors','menu-activecolor') != NULL) ? neocut_option('colors','menu-activecolor') :"";
                        neocut_admin_color_picker_two($name,$value);?>
                        <p class="note"><?php esc_html_e('Pick a custom color of the active menu links.(e.g. #a314a3)', 'neocut');?></p>
                    </div>
                    <div class="hr"></div>

                    <div class="column one-third"><label><?php esc_html_e('Menu Link Active BG', 'neocut');?></label></div>
                    <div class="column two-third last"><?php
						$name  =  "dttheme[colors][menu-activebgcolor]";
						$value =  (neocut_option('colors','menu-activebgcolor') != NULL) ? neocut_option('colors','menu-activebgcolor') :"";
                        neocut_admin_color_picker_two($name,$value);?>
                        <p class="note"><?php esc_html_e('Pick a custom color of the active menu links background.(e.g. #a314a3)', 'neocut');?></p>
                    </div>
                </div><!-- .box-content -->
            </div><!-- .bpanel-box end -->            
        </div><!-- #tab3-menu end -->

        <!-- #tab4-content -->
        <div id="tab4" class="tab-content">
            <!-- .bpanel-box -->
            <div class="bpanel-box">
                <div class="box-title">
                    <h3><?php esc_html_e('Content', 'neocut');?></h3>
                </div>
                
                <div class="box-content">
                    <div class="column one-third"><label><?php esc_html_e('Text Color', 'neocut');?></label></div>
                    <div class="column two-third last"><?php
						$name  =  "dttheme[colors][content-text-color]";
						$value =  (neocut_option('colors','content-text-color') != NULL) ? neocut_option('colors','content-text-color') :"";
                        neocut_admin_color_picker_two($name,$value);?>
                        <p class="note"><?php esc_html_e('Pick a custom color of the body content text.(e.g. #a314a3)', 'neocut');?></p>
                    </div>
                    <div class="hr"></div>

                    <div class="column one-third"><label><?php esc_html_e('Link Color', 'neocut');?></label></div>
                    <div class="column two-third last"><?php
						$name  =  "dttheme[colors][content-link-color]";
						$value =  (neocut_option('colors','content-link-color') != NULL) ? neocut_option('colors','content-link-color') :"";
                        neocut_admin_color_picker_two($name,$value);?>
                        <p class="note"><?php esc_html_e('Pick a custom color of the body content link.(e.g. #a314a3)', 'neocut');?></p>
                    </div>
                    <div class="hr"></div>

                    <div class="column one-third"><label><?php esc_html_e('Link Hover Color', 'neocut');?></label></div>
                    <div class="column two-third last"><?php
						$name  =  "dttheme[colors][content-link-hcolor]";
						$value =  (neocut_option('colors','content-link-hcolor') != NULL) ? neocut_option('colors','content-link-hcolor') :"";
                        neocut_admin_color_picker_two($name,$value);?>
                        <p class="note"><?php esc_html_e('Pick a custom hover color of the body content link.(e.g. #a314a3)', 'neocut');?></p>
                    </div>
                </div><!-- .box-content -->
            </div><!-- .bpanel-box end -->            
        </div><!-- #tab4-content end -->

        <!-- #tab5-footer -->
        <div id="tab5" class="tab-content">
            <!-- .bpanel-box -->
            <div class="bpanel-box">
                <div class="box-title">
                    <h3><?php esc_html_e('Footer', 'neocut');?></h3>
                </div>
                
                <div class="box-content">
                    <div class="column one-half">
                    	<label><?php esc_html_e('Footer Background Color', 'neocut');?></label>
                        <div class="clear"></div><?php
						$name  =  "dttheme[colors][footer-bgcolor]";
						$value =  (neocut_option('colors','footer-bgcolor') != NULL) ? neocut_option('colors','footer-bgcolor') :"";
                        neocut_admin_color_picker_two($name,$value);?>
                        <p class="note"><?php esc_html_e('Pick a custom color of the footer background.(e.g. #a314a3)', 'neocut');?></p>
                    </div>

					<div class="column one-half last">
						<div class="bpanel-option-set">
	                        <?php echo neocut_admin_jqueryuislider( esc_html__("Background opacity", 'neocut'), "dttheme[colors][footer-bgcolor-opacity]",
                                                                          neocut_option("colors","footer-bgcolor-opacity"),"");?>
                        </div>
                        <p class="note"><?php esc_html_e('You can adjust opacity of the footer BG color here.', 'neocut');?></p>
                    </div>
					<div class="hr"></div>

                    <div class="column one-half">
                    	<label><?php esc_html_e('Copyright Section BG Color', 'neocut');?></label>
                        <div class="clear"></div><?php
						$name  =  "dttheme[colors][copyright-bgcolor]";
						$value =  (neocut_option('colors','copyright-bgcolor') != NULL) ? neocut_option('colors','copyright-bgcolor') :"";
                        neocut_admin_color_picker_two($name,$value);?>
                        <p class="note"><?php esc_html_e('Pick a custom color of the copyright section background.(e.g. #a314a3)', 'neocut');?></p>
                    </div>

					<div class="column one-half last">
						<div class="bpanel-option-set">
	                        <?php echo neocut_admin_jqueryuislider( esc_html__("Background opacity", 'neocut'), "dttheme[colors][copyright-bgcolor-opacity]",
                                                                          neocut_option("colors","copyright-bgcolor-opacity"),"");?>
                        </div>
                        <p class="note"><?php esc_html_e('You can adjust opacity of the copyright section BG color here.', 'neocut');?></p>
                    </div>
					<div class="hr"></div>

                    <div class="column one-third"><label><?php esc_html_e('Footer Text Color', 'neocut');?></label></div>
                    <div class="column two-third last"><?php
						$name  =  "dttheme[colors][footer-text-color]";
						$value =  (neocut_option('colors','footer-text-color') != NULL) ? neocut_option('colors','footer-text-color') :"";
                        neocut_admin_color_picker_two($name,$value);?>
                        <p class="note"><?php esc_html_e('Pick a custom color of the footer text elements.(e.g. #a314a3)', 'neocut');?></p>
                    </div>
                    <div class="hr"></div>

                    <div class="column one-third"><label><?php esc_html_e('Footer Link Color', 'neocut');?></label></div>
                    <div class="column two-third last"><?php
						$name  =  "dttheme[colors][footer-link-color]";
						$value =  (neocut_option('colors','footer-link-color') != NULL) ? neocut_option('colors','footer-link-color') :"";
                        neocut_admin_color_picker_two($name,$value);?>
                        <p class="note"><?php esc_html_e('Pick a custom color of the footer links.(e.g. #a314a3)', 'neocut');?></p>
                    </div>
                    <div class="hr"></div>

                    <div class="column one-third"><label><?php esc_html_e('Footer Hover Link Color', 'neocut');?></label></div>
                    <div class="column two-third last"><?php
						$name  =  "dttheme[colors][footer-link-hcolor]";
						$value =  (neocut_option('colors','footer-link-hcolor') != NULL) ? neocut_option('colors','footer-link-hcolor') :"";
                        neocut_admin_color_picker_two($name,$value);?>
                        <p class="note"><?php esc_html_e('Pick a custom hover color of the footer links.(e.g. #a314a3)', 'neocut');?></p>
                    </div>
                    <div class="hr"></div>

                    <div class="column one-third"><label><?php esc_html_e('Footer Heading Color', 'neocut');?></label></div>
                    <div class="column two-third last"><?php
						$name  =  "dttheme[colors][footer-heading-color]";
						$value =  (neocut_option('colors','footer-heading-color') != NULL) ? neocut_option('colors','footer-heading-color') :"";
                        neocut_admin_color_picker_two($name,$value);?>
                        <p class="note"><?php esc_html_e('Pick a custom color of the footer headings.(e.g. #a314a3)', 'neocut');?></p>
                    </div>
                </div><!-- .box-content -->
            </div><!-- .bpanel-box end -->            
        </div><!-- #tab5-footer end -->

        <!-- #tab6-heading -->
        <div id="tab6" class="tab-content">
            <!-- .bpanel-box -->
            <div class="bpanel-box">
                <div class="box-title">
                    <h3><?php esc_html_e('Heading', 'neocut');?></h3>
                </div>
                
                <div class="box-content">
                    <div class="column one-third"><label><?php esc_html_e('Heading H1 Color', 'neocut');?></label></div>
                    <div class="column two-third last"><?php
						$name  =  "dttheme[colors][heading-h1-color]";
						$value =  (neocut_option('colors','heading-h1-color') != NULL) ? neocut_option('colors','heading-h1-color') :"";
                        neocut_admin_color_picker_two($name,$value);?>
                        <p class="note"><?php esc_html_e('Pick a custom color of the heading tag h1.(e.g. #a314a3)', 'neocut');?></p>
                    </div>
                    <div class="hr"></div>
                    
                    <div class="column one-third"><label><?php esc_html_e('Heading H2 Color', 'neocut');?></label></div>
                    <div class="column two-third last"><?php
						$name  =  "dttheme[colors][heading-h2-color]";
						$value =  (neocut_option('colors','heading-h2-color') != NULL) ? neocut_option('colors','heading-h2-color') :"";
                        neocut_admin_color_picker_two($name,$value);?>
                        <p class="note"><?php esc_html_e('Pick a custom color of the heading tag h2.(e.g. #a314a3)', 'neocut');?></p>
                    </div>
                    <div class="hr"></div>

                    <div class="column one-third"><label><?php esc_html_e('Heading H3 Color', 'neocut');?></label></div>
                    <div class="column two-third last"><?php
						$name  =  "dttheme[colors][heading-h3-color]";
						$value =  (neocut_option('colors','heading-h3-color') != NULL) ? neocut_option('colors','heading-h3-color') :"";
                        neocut_admin_color_picker_two($name,$value);?>
                        <p class="note"><?php esc_html_e('Pick a custom color of the heading tag h3.(e.g. #a314a3)', 'neocut');?></p>
                    </div>
                    <div class="hr"></div>

                    <div class="column one-third"><label><?php esc_html_e('Heading H4 Color', 'neocut');?></label></div>
                    <div class="column two-third last"><?php
						$name  =  "dttheme[colors][heading-h4-color]";
						$value =  (neocut_option('colors','heading-h4-color') != NULL) ? neocut_option('colors','heading-h4-color') :"";
                        neocut_admin_color_picker_two($name,$value);?>
                        <p class="note"><?php esc_html_e('Pick a custom color of the heading tag h4.(e.g. #a314a3)', 'neocut');?></p>
                    </div>
                    <div class="hr"></div>

                    <div class="column one-third"><label><?php esc_html_e('Heading H5 Color', 'neocut');?></label></div>
                    <div class="column two-third last"><?php
						$name  =  "dttheme[colors][heading-h5-color]";
						$value =  (neocut_option('colors','heading-h5-color') != NULL) ? neocut_option('colors','heading-h5-color') :"";
                        neocut_admin_color_picker_two($name,$value);?>
                        <p class="note"><?php esc_html_e('Pick a custom color of the heading tag h5.(e.g. #a314a3)', 'neocut');?></p>
                    </div>
                    <div class="hr"></div>

                    <div class="column one-third"><label><?php esc_html_e('Heading H6 Color', 'neocut');?></label></div>
                    <div class="column two-third last"><?php
						$name  =  "dttheme[colors][heading-h6-color]";
						$value =  (neocut_option('colors','heading-h6-color') != NULL) ? neocut_option('colors','heading-h6-color') :"";
                        neocut_admin_color_picker_two($name,$value);?>
                        <p class="note"><?php esc_html_e('Pick a custom color of the heading tag h6.(e.g. #a314a3)', 'neocut');?></p>
                    </div>
                </div><!-- .box-content -->
            </div><!-- .bpanel-box end -->            
        </div><!-- #tab6-heading end -->

    </div><!-- .bpanel-main-content end -->
</div><!-- #colors end -->