<!-- #company -->
<div id="appointment" class="bpanel-content">
	<!-- .bpanel-main-content -->
	<div class="bpanel-main-content">
        <ul class="sub-panel">
            <li><a href="#tab1"><?php esc_html_e("Company",'neocut');?></a></li>
            <li><a href="#tab2"><?php esc_html_e("Payment",'neocut');?></a></li>
            <li><a href="#tab3"><?php esc_html_e("Notifications",'neocut');?></a></li>            
        </ul>
        
        <!-- #tab1 start -->
        <div id="tab1" class="tab-content">
        	<div class="bpanel-box">
            	<div class="box-title"><h3><?php esc_html_e('Settings','neocut');?></h3></div>
                <div class="box-content">
                    <h6><?php esc_html_e('Business Hours','neocut');?></h6>
					<?php
					echo '<table>'; 
					foreach ( array( 'monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday', 'sunday' ) as $day ):
						echo '<tr>';
						echo '<td>'.ucfirst( $day ).'</td>';
						echo '<td>';
						echo neocut_company_timer( "dttheme[appointments][dt_company_{$day}_start]",neocut_option('appointments', "dt_company_{$day}_start"));
						echo '<span> - '.esc_html__( 'To', 'neocut' ).' - </span>';
						echo neocut_company_timer( "dttheme[appointments][dt_company_{$day}_end]", neocut_option('appointments', "dt_company_{$day}_end") ,false);
						echo '</td>';
						echo '</tr>';
					endforeach;
					echo '</table>';
					?>
                </div>
            </div>
        </div><!-- #tab1 end -->
        
        <!-- #tab2 start -->
        <div id="tab2">
            <div class="bpanel-box">
                <div class="box-title"><h3><?php esc_html_e('Payments','neocut');?></h3></div>
                <div class="box-content">
                
                    <h6><?php esc_html_e('Enable Paypal','neocut');?></h6>
                    <div class="column one-fifth">
                        <?php neocut_switch("",'appointments','enable-paypal');?>
                    </div>
                    <div class="column four-fifth last">
                        <p class="note no-margin"><?php esc_html_e('You can enable express checkout paypal ','neocut');?></p>
                    </div>
                    <div class="hr"></div>
                    <div class="clear"> </div>

                    <h6><?php esc_html_e('Currency','neocut');?></h6>
                    <select name="dttheme[appointments][currency]">
						<?php
                        $selected = neocut_option('appointments', 'currency');
                        $currency_code_options = neocut_currencies();
                        foreach ( $currency_code_options as $code => $name ) {
                            $symbol = neocut_currency_symbol( $code );
                            $s = ( $code === $selected ) ? 'selected="selected"' : '';
                            echo '<option value="'.esc_attr($code).'" '.neocut_wp_kses($s).'>'.esc_html($name).' ( '.esc_html($symbol).' )</option>';
                        }
						?>
                    </select>
                    <div class="hr"></div>
                    
                    <h6><?php esc_html_e('Language','neocut');?></h6>
                    <select name="dttheme[appointments][language]">
						<?php
                        $selected = neocut_option('appointments', 'language');
                        $language_code_options = neocut_languages();
                        foreach ( $language_code_options as $code => $name ) {
                            $s = ( $code === $selected ) ? 'selected="selected"' : "";
                            echo '<option value="'.esc_attr($code).'" '.neocut_wp_kses($s).'>'.esc_html($name).'</option>';
                        }
						?>
                    </select>
                    <div class="hr"></div>
                    

                    <h6><?php esc_html_e('Payment Modes','neocut');?></h6>
                    <select name="dttheme[appointments][payment-modes]">
						<?php
                        $selected = neocut_option('appointments', 'payment-modes');
                        $payment_mode_options = neocut_payment_modes();
                        foreach ( $payment_mode_options as $code => $name ) {
                            $s = ( $code === $selected ) ? 'selected="selected"' : "";
                            echo '<option value="'.esc_attr($code).'" '.neocut_wp_kses($s).'>'.esc_html($name).'</option>';
                        }
						?>
                    </select>
                    <div class="hr"></div>

                    <h6><?php esc_html_e('Sandbox Account','neocut');?></h6>
                    <input name="dttheme[appointments][sandbox-account]" type="text" class="large" value="<?php echo neocut_option('appointments','sandbox-account');?>"/>
                    <div class="hr"></div>

                    <h6><?php esc_html_e('Live Account','neocut');?></h6>
                    <input name="dttheme[appointments][live-account]" type="text" class="large" value="<?php echo neocut_option('appointments','live-account');?>"/>
                                        
                </div>                
            </div>
        </div><!-- #tab2 end -->
        
        <!-- #tab3 start -->
        <div id="tab3" class="tab-content">
        	<div class="bpanel-box">
				<?php
                $sender_name = neocut_option('appointments', 'notification_sender_name'); 
                $sender_name = !empty($sender_name) ? $sender_name : get_option( 'blogname' );

                $sender_email = neocut_option('appointments', 'notification_sender_email'); 
                $sender_email = !empty( $sender_email ) ? $sender_email : get_option( 'admin_email' );?>
                <div class="box-title"><h3><?php esc_html_e('Settings','neocut');?></h3></div>
                <div class="box-content">
                    <h6><?php esc_html_e('Sender Name','neocut');?></h6>
                    <input type="text" name="dttheme[appointments][notification_sender_name]" value="<?php echo esc_attr( $sender_name );?>"/>
                    <h6><?php esc_html_e('Sender Emailid','neocut');?></h6>
                    <input type="text" name="dttheme[appointments][notification_sender_email]" value="<?php echo esc_attr( $sender_email );?>"/>
                    <div class="hr"></div>

                    <h6><?php esc_html_e('To send scheduled agenda please execute following script with your cron','neocut');?></h6>
                    <h5><?php echo WP_PLUGIN_DIR.'/designthemes-appointment-addon/cron/send_agenda_cron.sh';?></h5>
                </div>
            
            	<div class="box-title"><h3><?php esc_html_e('To Staff','neocut');?></h3></div>
                <div class="box-content">
                
                	<h6><b><?php esc_html_e('New Appoinment Notification','neocut');?></b></h6>
                    <h5><?php esc_html_e('Subject','neocut');?></h5>
                    <input type="text" name="dttheme[appointments][appointment_notification_to_staff_subject]" class="full-width" 
                    	value="<?php echo neocut_option('appointments', 'appointment_notification_to_staff_subject'); ?>"/>
                    <h5><?php esc_html_e('Mesage','neocut');?></h5><?php
						$value = neocut_option('appointments', 'appointment_notification_to_staff_message');?>
                        <textarea class="fullwidth-textarea" name="dttheme[appointments][appointment_notification_to_staff_message]" rows="" cols=""><?php echo esc_html($value);?></textarea>
                    <div class="hr"></div>
                    
                    
                    <h6><b><?php esc_html_e('Notification to the staff regarding modified Appointment', 'neocut');?></b></h6>
                    <h5><?php esc_html_e('Subject','neocut');?></h5>
                    <input type="text" name="dttheme[appointments][modified_appointment_notification_to_staff_subject]" class="full-width" 
                    	value="<?php echo neocut_option('appointments', 'modified_appointment_notification_to_staff_subject'); ?>"/>
                    <h5><?php esc_html_e('Mesage','neocut');?></h5><?php
						$value = neocut_option('appointments', 'modified_appointment_notification_to_staff_message');?>
                        <textarea class="fullwidth-textarea" name="dttheme[appointments][modified_appointment_notification_to_staff_message]" rows="" cols=""><?php echo esc_html($value);?></textarea>
                        
                    <div class="hr"></div>

                    <h6><b><?php esc_html_e('Notification to the staff regarding Deleted / Declined Appointment', 'neocut');?></b></h6>
                    <h5><?php esc_html_e('Subject','neocut');?></h5>
                    <input type="text" name="dttheme[appointments][deleted_appointment_notification_to_staff_subject]" class="full-width" 
                    	value="<?php echo neocut_option('appointments', 'deleted_appointment_notification_to_staff_subject'); ?>"/>
                    <h5><?php esc_html_e('Mesage','neocut');?></h5><?php
						$value = neocut_option('appointments', 'deleted_appointment_notification_to_staff_message');?>
                        <textarea class="fullwidth-textarea" name="dttheme[appointments][deleted_appointment_notification_to_staff_message]" rows="" cols=""><?php echo esc_html($value);?></textarea>
                        
                    <div class="hr"></div>

                    <h6><b><?php esc_html_e('Evening notification with the next day agenda to Staff Member', 'neocut');?></b></h6>
                    <h5><?php esc_html_e('Subject','neocut');?></h5>
                    <input type="text" name="dttheme[appointments][agenda_to_staff_subject]" class="full-width" 
                    	value="<?php echo neocut_option('appointments', 'agenda_to_staff_subject'); ?>"/>
                    <h5><?php esc_html_e('Mesage','neocut');?></h5><?php
						$value = neocut_option('appointments', 'agenda_to_staff_message');?>
                        <textarea class="fullwidth-textarea" name="dttheme[appointments][agenda_to_staff_message]" rows="" cols=""><?php echo esc_html($value);?></textarea>
                    <div class="hr"></div>
                </div>

            	<div class="box-title"><h3><?php esc_html_e('To Customer','neocut');?></h3></div>
                <div class="box-content">
                
                	 <h6><b><?php esc_html_e('Notification to the client about new Appointment', 'neocut');?></b></h6>
                     <h5><?php esc_html_e('Subject','neocut');?></h5>
                     <input type="text" name="dttheme[appointments][appointment_notification_to_client_subject]" class="full-width" 
                    	value="<?php echo neocut_option('appointments', 'appointment_notification_to_client_subject'); ?>"/>
                     <h5><?php esc_html_e('Mesage','neocut');?></h5><?php
						$value = neocut_option('appointments', 'appointment_notification_to_client_message');?>
                        <textarea class="fullwidth-textarea" name="dttheme[appointments][appointment_notification_to_client_message]" rows="" cols=""><?php echo esc_html($value);?></textarea>
                     <div class="hr"></div>

                	 <h6><b><?php esc_html_e('Notification to the client regarding modified Appointment', 'neocut');?></b></h6>
                     <h5><?php esc_html_e('Subject','neocut');?></h5>
                     <input type="text" name="dttheme[appointments][modified_appointment_notification_to_client_subject]" class="full-width" 
                    	value="<?php echo neocut_option('appointments', 'modified_appointment_notification_to_client_subject'); ?>"/>
                     <h5><?php esc_html_e('Mesage','neocut');?></h5><?php
						$value = neocut_option('appointments', 'modified_appointment_notification_to_client_message');?>
                        <textarea class="fullwidth-textarea" name="dttheme[appointments][modified_appointment_notification_to_client_message]" rows="" cols=""><?php echo esc_html($value);?></textarea>
                     <div class="hr"></div>

                	 <h6><b><?php esc_html_e('Notification to the client regarding Deleted / Declined Appointment', 'neocut');?></b></h6>
                     <h5><?php esc_html_e('Subject','neocut');?></h5>
                     <input type="text" name="dttheme[appointments][deleted_appointment_notification_to_client_subject]" class="full-width" 
                    	value="<?php echo neocut_option('appointments', 'deleted_appointment_notification_to_client_subject'); ?>"/>
                     <h5><?php esc_html_e('Mesage','neocut');?></h5><?php
						$value = neocut_option('appointments', 'deleted_appointment_notification_to_client_message');?>
                        <textarea class="fullwidth-textarea" name="dttheme[appointments][deleted_appointment_notification_to_client_message]" rows="" cols=""><?php echo esc_html($value);?></textarea>
                     <div class="hr"></div>
                     
                     <h6><b><?php esc_html_e('Notification to the Success Message', 'neocut');?></b></h6>
                     <h5><?php esc_html_e('Message','neocut');?></h5><?php
						$value = neocut_option('appointments', 'success_message');?>
                        <textarea class="fullwidth-textarea" name="dttheme[appointments][success_message]" rows="" cols=""><?php echo esc_html($value);?></textarea>
                     <div class="hr"></div>
                     
                     <h6><b><?php esc_html_e('Notification to the Failure Message', 'neocut');?></b></h6>
                     <h5><?php esc_html_e('Message','neocut');?></h5><?php
						$value = neocut_option('appointments', 'error_message');?>
                        <textarea class="fullwidth-textarea" name="dttheme[appointments][error_message]" rows="" cols=""><?php echo esc_html($value);?></textarea>
                     <div class="hr"></div>
                </div>
            </div>
        </div><!-- #tab3 end -->
        
    </div><!-- .bpanel-main-content -->
</div><!-- #company end -->
