<?php if ( post_password_required() ) : ?>
	<p class="nopassword"><?php esc_html_e( 'This post is password protected. Enter the password to view any comments.','neocut'); ?></p>
<?php  return;
	endif;?>
    
<?php if ( have_comments() ) : ?>

    <h3><?php comments_number(esc_html__('No Comments','neocut'), esc_html__('Comment ( 1 )','neocut'), esc_html__('Comments ( % )','neocut') );?></h3>

	<?php 
    if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : 
        ?>
        <div class="navigation">
            <div class="nav-previous"><?php previous_comments_link( esc_html__( 'Older Comments','neocut'  ) ); ?></div>
            <div class="nav-next"><?php next_comments_link( esc_html__( 'Newer Comments','neocut') ); ?></div>
        </div>
        <?php 
    endif;
    ?>
    
    <ul class="commentlist">
 		<?php wp_list_comments( array( 'callback' => 'neocut_comment_style' ) ); ?>
    </ul>

<?php endif; ?>

<?php if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) : ?>
    <p class="nocomments"><?php esc_html_e( 'Comments are closed.','neocut'); ?></p>
<?php endif;?> 
	
<?php

$comment = "<div class='column dt-sc-one-half first'><textarea id='comment' name='comment' cols='5' rows='3' placeholder='".esc_html__("Comment",'neocut')."' ></textarea></div>";
    
$fields = array(
    'author' => "<div class='column dt-sc-one-half'><p><input id='author' name='author' type='text' placeholder='".esc_html__("Name",'neocut')."' required /></p>",
    'email'  => "<p> <input id='email' name='email' type='text' placeholder='".esc_html__("Email",'neocut')."' required /> </p></div>",
);

$privacy_cmdfrm = neocut_option('privacy','enable-commentfrm-msg');
if( isset( $privacy_cmdfrm ) ) {

    $content = do_shortcode( neocut_option('privacy', 'commentfrm-msg') );

    $fields['comment-form-dt-privatepolicy'] = '<p class="comment-form-dt-privatepolicy">
        <input id="comment-form-dt-privatepolicy" name="comment-form-dt-privatepolicy" type="checkbox" value="yes">
        <label for="comment-form-dt-privatepolicy">'.$content.'</label> </p>';
}

$comments_args = array(
    'title_reply'       =>   esc_html__( 'Give a Reply','neocut' ),
    'fields'            =>   $fields,
    'comment_field'     =>   $comment,
    'comment_notes_before'=> '',
    'comment_notes_after'=>  '',
    'label_submit'      =>   esc_html__('Comment','neocut'));

comment_form($comments_args); ?>