<?php
$atts = shortcode_atts( array(
	'class'          => '',
	'css'            => '',
	'image'          => '',
	'image_size'     => 'full',
	'title'          => '',
	'subtitle'       => '',
	'link'           => '',
	'target'         => '',
	'show_button'    => 'no',
	'button_text'    => esc_html__( 'Continue', 'nanotext' ),
	'imagebox_style' => ''
), $atts );

// Preparing the shortcode attributes
$atts['show_button'] = $atts['show_button'] == 'yes';
$atts['button_text'] = empty( $atts['button_text'] ) ? esc_html__( 'Continue', 'nanotext' ) : $atts['button_text'];

// Build the element classes
$classes = array( 'imagebox' );
$classes[] = $atts['class'];
$classes[] = $atts['imagebox_style'];

if ( function_exists( 'vc_shortcode_custom_css_class' ) ) {
	$classes[] = vc_shortcode_custom_css_class( $atts['css'], ' ' );
}

// Preparing image for the box
if ( is_numeric( $atts['image'] ) && function_exists( 'wpb_getImageBySize' ) ) {
	$image = wpb_getImageBySize( array( 'attach_id' => $atts['image'], 'thumb_size' => $atts['image_size'] ) );
	$image = $image['thumbnail'];
}
elseif ( filter_var( $atts['image'], FILTER_VALIDATE_URL ) ) {
	$image = sprintf( '<img src="%s" />', esc_url( $atts['image'] ) );
}

$content = wpautop( $content );
$content = preg_replace( '/<([a-z]+)>\s*<\/\\1>/i', '', $content );
$content = nanotext_cleanup( $content );
?>

<!-- BEGIN .imagebox -->
<div class="<?php echo esc_attr( join( ' ', $classes ) ) ?>">
	<?php if ( ! empty( $image ) ): ?>
		<a class="box-image" href="<?php echo esc_url( $atts['link'] ) ?>" target="<?php echo empty($atts['target']) ? '_self' : esc_attr( $atts['target'] ) ?>">
			<?php print( nanotext_cleanup( $image ) ) ?>
			<div class="box-inner">
				<?php if ( ! empty( $atts['title'] ) ): ?>
					<div class="box-title">	
						<h3><?php echo nanotext_cleanup( $atts['title'] ) ?></h3>
						<?php if ( ! empty( $atts['subtitle'] ) ): ?>
							<span class="box-subtitle">
								<?php echo nanotext_cleanup( $atts['subtitle'] ) ?>
							</span>
						<?php endif ?>	
					</div>
				<?php endif ?>	

				
					<div class="box-content">
						<?php if ( ! empty( $content ) ): ?>
							<?php echo nanotext_cleanup( $content ) ?>
						<?php endif ?>

						<?php if ( $atts['show_button'] ): ?>
							<div class="box-btn"><?php echo esc_html( $atts['button_text'] ) ?></div>
						<?php endif ?>
					</div>
				

				
			</div>
		</a>	
	<?php endif ?>
</div>
<!-- End .imagebox -->
