<?php

/**
 * Prevent direct access to this file
 */
defined( 'ABSPATH' ) or die();

$options          = array( 'itemSelector' => '.project' );
$meta_information = (array)nanotext_option( 'projects__meta' );

/**
 * Ignore render related box when it's disabled
 */
if ( ! is_singular( 'nproject' ) ) {
	return;
}

// Query args
$args = array(
	'post_type'      => 'nproject',
	'posts_per_page' => nanotext_option( 'project__related__count', 4 ),
	'post__not_in'   => array( get_the_ID() )
);

$related_item_type = nanotext_option( 'project__related__type' );

// Filter by tags
if ( 'tag' == $related_item_type ) {
	if ( ! ( $terms = get_the_terms( get_the_ID(), nProjects::TYPE_TAG ) ) )
		return;

	$args['tax_query'] = array(
		'taxonomy' => nProjects::TYPE_TAG,
		'field'    => 'term_id',
		'terms'    => wp_list_pluck( $terms, 'term_id' )
	);
}
// Filter by categories
elseif ( 'category' == $related_item_type ) {
	if ( ! ( $terms = get_the_terms( get_the_ID(), nProjects::TYPE_CATEGORY ) ) )
		return;

	$args['tax_query'] = array(
		'taxonomy' => nProjects::TYPE_CATEGORY,
		'field'    => 'term_id',
		'terms'    => wp_list_pluck( $terms, 'term_id' )
	);
}
// Show random items
elseif ( 'random' == $related_item_type ) {
	$args['orderby'] = 'rand';
}
// Show latest items
elseif ( 'recent' == $related_item_type ) {
	$args['order'] = 'DESC';
	$args['orderby'] = 'date';
}

// Create the query instance
$query = new WP_Query( $args );
$widget_title = nanotext_option( 'project__related__title' );

if ( $query->have_posts() ): ?>

	<div class="projects-related projects">
		<?php if ( ! empty( $widget_title ) ): ?>
			<h3 class="projects-related-title">
				<?php echo esc_html( $widget_title ) ?>
			</h3>
		<?php endif ?>

		<div class="projects-related-wrap" data-grid="<?php echo esc_attr( json_encode( $options ) ) ?>" data-columns="<?php echo esc_attr( nanotext_option( 'projects__related__gridColumns' ) ) ?>">
			<?php while ( $query->have_posts() ): $query->the_post(); ?>

				<div <?php post_class( 'project' ) ?> itemscope="itemscope" itemtype="https://schema.org/CreativeWork">
					<a href="<?php the_permalink() ?>" class="project-inner" data-mh="project-grid">
						<h2 class="project-title"><?php the_title() ?></h2>

						<?php if ( nanotext_option( 'projects__excerpt' ) == 'on' ): ?>
							<?php the_excerpt() ?>
						<?php endif ?>

						<figure class="project-thumbnail">
							<?php
								$image = nanotext_get_image_resized( array(
									'post_id' => get_the_ID(),
									'size'    => nanotext_option( 'projects__imagesize' ),
									'crop'    => nanotext_option( 'projects__imagesizeCrop' ) == true
								) );

								echo nanotext_cleanup( $image['thumbnail'] );
							?>
						</figure>
						
						<?php if ( nanotext_option( 'projects__readmore' ) == 'on' ): ?>
							<p class="project-readmore">
								<span><?php esc_html_e( 'View Detail', 'nanotext' ) ?></span>
							</p>
						<?php endif ?>
					</a>
				</div>

			<?php endwhile ?>
		</div>
	</div>

<?php endif ?>
