<?php
defined( 'ABSPATH' ) or die();

$options          = array( 'itemSelector' => '.project' );
$meta_information = (array)nanotext_option( 'projects__meta' );
?>

	<?php if ( have_posts() ): ?>
		<div class="content" role="main" itemprop="mainContentOfPage">
			<?php get_template_part( 'tmpl/project/filter' ) ?>
			
			<div class="content-inner" data-grid="<?php echo esc_attr( json_encode( $options ) ) ?>" data-columns="<?php echo esc_attr( nanotext_option( 'projects__gridColumns' ) ) ?>">
				<?php while ( have_posts() ): the_post(); ?>

					<div <?php post_class( 'project' ) ?> itemscope="itemscope" itemtype="https://schema.org/CreativeWork">
						<a class="project-inner" data-mh="project-grid" href="<?php the_permalink() ?>">
							<figure class="project-thumbnail">
								<?php if ( $client_image_id = get_field( 'projectClientLogo', get_post() ) ): ?>
									<div class="project-client">
										<?php
											$image = nanotext_get_image_resized( array(
												'image_id' => $client_image_id,
												'size'     => 'full'
											) );

											echo wp_kses_post( $image['thumbnail'] );
										?>
									</div>		
								<?php endif ?>
							</figure>

							<div class="project-info">
								<div class="project-info-inner">
									<h2 class="project-title" itemprop="name headline">
										<?php the_title() ?>
									</h2>

									<?php if ( nanotext_option( 'projects__excerpt' ) == 'on' ): ?>
										<div class="project-summary">
											<?php the_excerpt() ?>
										</div>
									<?php endif ?>
									
									<?php if ( nanotext_option( 'projects__readmore' ) == 'on' ): ?>
										<p class="project-readmore"><span><?php esc_html_e( 'View Detail', 'nanotext' ) ?></span></p>
									<?php endif ?>
								</div>
							</div>
							<?php if ( $accent_color = get_field( 'projectAccentColor' ) ): ?>
								<span class="mask" style="background-color: <?php echo esc_attr( $accent_color ) ?>;">
									<?php echo esc_html( $accent_color ) ?>
								</span>
							<?php endif ?>
						</a>
					</div>

				<?php endwhile ?>
			</div>

			<?php nanotext_pagination() ?>
		</div>
	<?php else: ?>
		<!-- Show empty message -->
	<?php endif ?>
