<?php
defined( 'ABSPATH' ) or die();
?>
	
	<div class="content" role="main" itemprop="mainContentOfPage">
		<?php if ( have_posts() ): ?>
			<?php while ( have_posts() ): the_post(); ?>
				<div id="post-<?php the_ID() ?>" <?php post_class( 'post' ) ?>>	
					<div class="post-inner">
						<?php get_template_part( 'tmpl/post/content-featured', get_post_format() ) ?>
						<div class="post-header">
							<div class="post-categories">
								<?php the_category( _x( ' ', 'Used between list items, there is a space after the comma.', 'nanotext' ) ) ?>
							</div>
							<?php get_template_part( 'tmpl/post/content-title' ) ?>
							<div class="post-content">
								<?php
									nanotext_the_content( false );
									wp_link_pages( array(
										'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'nanotext' ) . '</span>',
										'after'       => '</div>',
										'link_before' => '<span>',
										'link_after'  => '</span>',
									) );
								?>
							</div>
						</div>

						<?php if ( nanotext_option( 'blog__archive__postMeta' ) == 'on' ): ?>
							<div class="post-meta">
								<div class="post-author">
									<span class="text"><?php esc_html_e( 'By', 'nanotext' ); ?></span>
									<?php the_author_posts_link() ?>
								</div>

								<div class="post-time">
									<span class="text"><?php esc_html_e( 'On', 'nanotext' ); ?></span>
									<?php echo esc_html( get_the_date( get_option( 'date_format' ) ) ) ?>
								</div>

								<div class="post-read">
									<span class="text"><?php esc_html_e( 'In', 'nanotext' ); ?></span>
									<?php echo nanotext_reading_time(); ?>
								</div>
							</div>
						<?php endif ?>
						
						<?php if ( nanotext_option( 'blog__archive__readmore' ) === 'on' ): ?>
							<?php get_template_part( 'tmpl/post/content-readmore' ) ?>
						<?php endif ?>
					</div>
				</div>
			<?php endwhile ?>
		<?php else: ?>
			<?php get_template_part( 'tmpl/post/content-none' ) ?>
		<?php endif ?>
	</div>
	<!-- /.content -->
	<?php nanotext_pagination() ?>
