<?php
defined( 'ABSPATH' ) or die();

$options = array( 'itemSelector' => '.post' );
?>
	
	<div class="content" role="main" itemprop="mainContentOfPage">
		<?php if ( have_posts() ): ?>
			<div class="content-inner" data-grid="<?php echo esc_attr( json_encode( $options ) ) ?>" data-columns="<?php echo esc_attr( nanotext_option( 'blog__archive__columns' ) ) ?>">
				<?php while ( have_posts() ): the_post(); ?>
					<div id="post-<?php the_ID() ?>" <?php post_class( 'post' ) ?>>
						<div class="post-inner">
							<?php get_template_part( 'tmpl/post/content-featured', get_post_format() ) ?>
							<div class="post-wrap">
								<div class="post-categories">
									<?php the_category( _x( ' ', 'Used between list items, there is a space after the comma.', 'nanotext' ) ) ?>
								</div>

								<div class="post-header">
									<?php get_template_part( 'tmpl/post/content-title' ) ?>
								</div>

								<div class="post-content">
									<?php
										nanotext_the_content( false );
										wp_link_pages( array(
											'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'nanotext' ) . '</span>',
											'after'       => '</div>',
											'link_before' => '<span>',
											'link_after'  => '</span>',
										) );
									?>
								</div>
								
								<?php if ( nanotext_option( 'blog__archive__postMeta' ) == 'on' ): ?>
									<div class="post-author-meta">
										<div class="post-avatar">
											<?php echo get_avatar( get_the_author_meta( 'ID' ), 45 ); ?>
										</div>
										<div class="post-author-content">
											<p class="post-name">
												<?php esc_html_e( 'By', 'nanotext' ) ?>
												<?php the_author(); ?>
											</p>
											<span class="post-date">
												<?php echo esc_html( get_the_date( get_option( 'date_format' ) ) ) ?>
											</span>
										</div>
									</div>
								<?php endif ?>	
							</div>
						</div>
					</div>
				<?php endwhile ?>
			</div>

			<?php nanotext_pagination() ?>
		<?php else: ?>
			<?php get_template_part( 'tmpl/post/content-none' ) ?>
		<?php endif ?>
	</div>
	<!-- /.content -->

