<?php
defined( 'ABSPATH' ) or die();
?>
	
	<div class="content" role="main" itemprop="mainContentOfPage">
		<?php if ( have_posts() ): ?>
			<?php while ( have_posts() ): the_post(); ?>
				<div id="post-<?php the_ID() ?>" <?php post_class( 'post' ) ?>>
					<div class="post-inner">
						<?php if ( nanotext_option( 'blog__archive__postMeta' ) == 'on' ): ?>
							<div class="post-meta">
								<div class="post-author">
									<?php echo get_avatar( get_the_author_meta( 'ID' ), 50 ); ?>
									<p class="post-name">
										<span><?php esc_html_e( 'By', 'nanotext' ) ?></span>
										<?php the_author_posts_link() ?>
									</p>

									<span class="post-day"><?php echo esc_html( get_the_date( 'd' ) ) ?></span>
									<span class="post-month"><?php echo esc_html( get_the_date( 'M' ) ) ?></span>
								    <span class="post-year"><?php echo esc_html( get_the_date( 'Y' ) ) ?></span>
								</div>

								<?php if ( ! post_password_required() && ( comments_open() || get_comments_number() ) ): ?>
									<p class="post-comments">
										<?php comments_popup_link( __( '0', 'nanotext' ), __( '1', 'nanotext' ), __( '%', 'nanotext' ) ); ?>
									</p>
								<?php endif ?>
							</div>
						<?php endif ?>

						<div class="post-wrap">
							
							<div class="post-categories">
								<?php the_category( _x( ' ', 'Used between list items, there is a space after the comma.', 'nanotext' ) ) ?>
							</div>
							<div class="post-header">
								<?php get_template_part( 'tmpl/post/content-title' ) ?>
							</div>
							<?php get_template_part( 'tmpl/post/content-featured', get_post_format() ) ?>
							<div class="post-content">
								<?php
									nanotext_the_content( false );
									wp_link_pages( array(
										'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'nanotext' ) . '</span>',
										'after'       => '</div>',
										'link_before' => '<span>',
										'link_after'  => '</span>',
									) );
								?>
							</div>
							<?php if ( nanotext_option( 'blog__archive__readmore' ) === 'on' ): ?>
								<?php get_template_part( 'tmpl/post/content-readmore' ) ?>
							<?php endif ?>
							<p class="post-date">
								<span><?php esc_html_e( 'On', 'nanotext' ) ?></span>
								<?php echo esc_html( get_the_date( get_option( 'date_format' ) ) ) ?>
							</p>
						</div>
					</div>
				</div>
			<?php endwhile ?>
		<?php else: ?>
			<?php get_template_part( 'tmpl/post/content-none' ) ?>
		<?php endif ?>
	</div>
	<!-- /.content -->
	<?php nanotext_pagination() ?>
			