<?php
defined( 'ABSPATH' ) or die();
?>

	<div id="post-<?php the_ID() ?>" <?php post_class( 'post' ) ?>>
		<div class="post-inner">
			<?php if ( nanotext_option( 'blog__archive__postMeta' ) == 'on' ): ?>
				<div class="post-meta">
					
					<div class="post-categories">
						<?php the_category( _x( ' ', 'Used between list items, there is a space after the comma.', 'nanotext' ) ) ?>
					</div>
					<span class="post-date">
						<?php echo esc_html( get_the_date( get_option( 'date_format' ) ) ) ?>
					</span>
				</div>
			<?php endif ?>
				
			<?php get_template_part( 'tmpl/post/content-featured', get_post_format() ) ?>
			
			<div class="post-header">
				<?php get_template_part( 'tmpl/post/content-title' ) ?>
			</div>

			<div class="post-author">
				<span class="post-name">
					<?php esc_html_e( 'By', 'nanotext' ) ?>
					<?php the_author_posts_link() ?>
				</span>
				<span class="post-read">
					<?php echo nanotext_reading_time(); ?>
				</span>
			</div>

			<div class="post-content">
				<?php
					nanotext_the_content( false );
					wp_link_pages( array(
						'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'nanotext' ) . '</span>',
						'after'       => '</div>',
						'link_before' => '<span>',
						'link_after'  => '</span>',
					) );
				?>
			</div>

			<?php if ( nanotext_option( 'blog__archive__readmore' ) === 'on' ): ?>
				<?php get_template_part( 'tmpl/post/content-readmore' ) ?>
			<?php endif ?>
		</div>
	</div>
