<?php
defined( 'ABSPATH' ) or die();

$featured_background_types = (array) nanotext_option( 'header__titlebar__backgroundFeatured' );
$current_post_type         = nanotext_current_post_type();
$show_featured_image       = ! in_array( $current_post_type, $featured_background_types ) && has_post_thumbnail();
?>

	<div id="post-<?php the_ID() ?>" <?php post_class( 'post' ) ?>>
		<div class="post-inner">
			<div class="post-content" itemprop="text">
				<span class="sticky"><?php if ( function_exists( 'ADDTOANY_SHARE_SAVE_KIT' ) ) { ADDTOANY_SHARE_SAVE_KIT(); } ?></span>
				<?php the_content() ?>

				<?php
					wp_link_pages( array(
						'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'nanotext' ) . '</span>',
						'after'       => '</div>',
						'link_before' => '<span>',
						'link_after'  => '</span>',
					) );
				?>	
			</div>

			<?php if ( nanotext_option( 'blog__single__postTags' ) == 'on' ): ?>
				<div class="post-tags"><p><?php the_tags( '', ' ' ); ?></p></div>
			<?php endif ?>

			<?php if ( nanotext_option( 'blog__single__postAuthor' ) == 'on' ): ?>
				<?php get_template_part( 'tmpl/post/content-author' ) ?>
			<?php endif ?>

			<?php if ( nanotext_option( 'blog__single__postNav' ) == 'on' ): ?>
				<?php get_template_part( 'tmpl/post/content-navigator' ) ?>
			<?php endif ?>
			<!-- /.post-content -->
		</div>
		<!-- /.post-inner -->
	</div>
	<!-- /#post-<?php echo get_the_ID() ?> -->
