<?php
defined( 'ABSPATH' ) or die();

// Query args
$args = array(
	'post_type'           => 'post',
	'posts_per_page'      => nanotext_option( 'blog__related__count', 5 ),
	'post__not_in'        => array( get_the_ID() ),
	'ignore_sticky_posts' => true
);

$related_item_type = nanotext_option( 'blog__related__type', 'category' );

// Filter by tags
if ( 'tag' == $related_item_type ) {
	if ( ! ( $terms = get_the_tags() ) )
		return;

	$args['tag__in'] = wp_list_pluck( $terms, 'term_id' );
}
// Filter by categories
elseif ( 'category' == $related_item_type ) {
	if ( ! ( $terms = get_the_category() ) )
		return;

	$args['category__in'] = wp_list_pluck( $terms, 'term_id' );
}
// Show random items
elseif ( 'random' == $related_item_type ) {
	$args['orderby'] = 'rand';
}
// Show latest items
elseif ( 'recent' == $related_item_type ) {
	$args['order'] = 'DESC';
	$args['orderby'] = 'date';
}

// Create the query instance
$query = new WP_Query( $args );
$widget_title   = nanotext_option( 'blog__related__title' );

if ( $query->have_posts() ):
?>

	<?php if ( nanotext_option( 'blog__single__relatedPosts' ) == 'on' ): ?>
		<div id="related-posts" class="related-posts blog-grid push-up">
			<div class="related-posts-inner">
				<?php if ( ! empty( $widget_title ) ): ?>
					<h3 class="related-posts-title">
						<?php echo esc_html( $widget_title ) ?>
					</h3>
				<?php endif ?>

					<div class="grid-posts content-inner" data-grid-normal data-columns="<?php echo esc_attr( nanotext_option( 'blog__related__gridColumns' ) ) ?>">
						<?php while ( $query->have_posts() ): $query->the_post(); ?>
							<div <?php post_class() ?> >
								<div class="post-inner">
									<?php get_template_part( 'tmpl/post/content-featured', get_post_format() ) ?>
									
									<div class="post-header">
										<?php get_template_part( 'tmpl/post/content-title' ) ?>
									</div>

									<div class="post-content">
										<?php
											nanotext_the_content( false );
											wp_link_pages( array(
												'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'nanotext' ) . '</span>',
												'after'       => '</div>',
												'link_before' => '<span>',
												'link_after'  => '</span>',
											) );
										?>
									</div>

									<div class="post-author-meta">
										<div class="post-avatar">
											<?php echo get_avatar( get_the_author_meta( 'ID' ), 32 ); ?>
										</div>
										<div class="post-author-content">
											<p class="post-name">
												<?php the_author(); ?>
											</p>
											<span class="post-date">
												<?php echo esc_html( get_the_date( get_option( 'date_format' ) ) ) ?>
											</span>
											<span class="post-read">
												<?php echo nanotext_reading_time(); ?>
											</span>
										</div>
									</div>

								</div>
							</div>					

						<?php endwhile ?>
				    </div>
				<?php wp_reset_postdata() ?>
			</div>
		</div>

	<?php endif ?>
<?php endif ?>
