<?php
defined( 'ABSPATH' ) or die();

if ( ! ( $author_id = get_the_author_meta( 'ID' ) ) ) {
	$author_id = get_query_var( 'author' );
}

$author_description = get_the_author_meta( 'description', $author_id );
?>

	<?php if ( ! empty( $author_description ) ): ?>
		<div class="post-author-box" itemprop="author" itemscope="itemscope" itemtype="https://schema.org/Person">
			<?php echo get_avatar( get_the_author_meta( 'ID' ), 45 ); ?>
			<div class="author-box-content">
				<div class="author-box-title">
					<span><?php esc_html_e( 'About the:', 'nanotext' ); ?></span>
					<span><?php the_author_posts_link() ?></span>
				</div>

				
					<div class="author-description">
						<?php echo nanotext_cleanup( $author_description ) ?>
					</div>
				
			</div>
		</div>
	<?php endif ?>