<?php
defined( 'ABSPATH' ) or die();

// The menu settings
$primary_menu_args = array(
	'theme_location'  => 'primary',
	'container'       => false,
	'menu_class'      => 'menu menu-primary',
	'fallback_cb'     => 'nanotext_page_menu',
	'items_wrap'      => '<ul id="%1$s" class="%2$s">%3$s</ul>',
	'depth'           => 0
);

$contact_info  = nanotext_option( 'header__info__text' );
$nav_info  = nanotext_option( 'header__nav__text' );
$header_nav_extras = nanotext_option( 'header__nav__extras' );

$header_classes = array( 'site-header site-header-classic' );
$header_classes[] = sprintf( 'header-brand-%s', nanotext_option( 'header__logoAlign' ) );

if ( nanotext_option( 'header__width' ) === 'on' ) {
	$header_classes[] = 'header-full';
}

if ( nanotext_option( 'header__shadow' ) === 'on' ) {
	$header_classes[] = 'header-shadow';
}

if ( nanotext_option( 'header__transparent' ) === 'on' ) {
	$header_classes[] = 'header-transparent';
}
?>

	<?php if ( nanotext_option( 'header__topbar' ) === 'on' ): ?>
		<?php get_template_part( 'tmpl/header-topbar' ); ?>
	<?php endif ?>

	<div id="site-header" class="<?php echo esc_attr( join( ' ', $header_classes ) ) ?>">
		<div class="site-header-inner wrap">
			<div class="header-content">
				<div class="header-brand">
					<a href="<?php echo esc_attr( site_url() ) ?>">
						<?php nanotext_logo( nanotext_option( 'header__logo' ) ) ?>
					</a>

					<?php if ( ! empty( $contact_info ) ): ?>
						<div class="header-info-text">
							<?php echo nanotext_cleanup( $contact_info ) ?>
						</div>
					<?php endif ?>

					<div class="extras">
						<?php if ( ! empty( $header_nav_extras ) ): ?>
							<ul class="navigator menu-extras">
								<?php foreach ( $header_nav_extras as $type ): ?>
									<?php get_template_part( 'tmpl/header-icon', $type ); ?>
								<?php endforeach ?>
							</ul>
						<?php endif ?>
					</div>
					<?php get_template_part( 'tmpl/header-sliding-toggle' ) ?>
				</div>

				<?php if ( has_nav_menu( 'primary' ) ): ?>
					<nav class="navigator" itemscope="itemscope" itemtype="https://schema.org/SiteNavigationElement">
						<?php wp_nav_menu( $primary_menu_args ) ?>

						<?php if ( ! empty( $nav_info ) ): ?>
							<div class="nav-info">
								<?php echo nanotext_cleanup( $nav_info ) ?>
							</div>
						<?php endif ?>

						<?php nanotext_social_icons( array( 'location' => 'nav' ) ) ?>
					</nav>
				<?php endif ?>			
			</div>			
		</div>
		<!-- /.site-header-inner -->
	</div>
	<!-- /.site-header -->

	<?php if ( nanotext_option( 'header__sticky' ) === 'on' ): ?>
		<?php get_template_part( 'tmpl/header-sticky' ); ?>
	<?php endif ?>