<?php
defined( 'ABSPATH' ) or die();


$layout    = nanotext_option( 'header__titlebar' );
$alignment = nanotext_option( 'header__titlebar__align' );

$current_post = get_queried_object();

if ($current_post instanceof WP_Post) {
	/**
	 * Override layout and alignment settings for the specific entry
	 */
	$_layout = get_field( 'titlebarLayout', $current_post->ID );
	$_alignment = get_field( 'titlebarAlign', $current_post->ID );
}

if ( isset( $_layout ) && $_layout != 'default' ) {
	$layout = $_layout;
}

if ( isset( $_alignment ) && $_alignment != 'default' ) {
	$alignment = $_alignment;
}

if ( ( is_front_page() && nanotext_option( 'header__titlebar__home' ) == 'off' ) || $layout == 'none' ) {
	return;
}

$classes = array(
	"content-header",
	"content-header-{$alignment}"
);

if ( nanotext_option( 'header__titlebar__full' ) === 'on' ) {
	$classes[] = 'content-header-full';
}

if ( nanotext_option( 'header__titlebar__shadow' ) === 'on' ) {
	$classes[] = 'content-header-shadow';
}

if ( is_singular() ) {
	$featured_background_types = (array) nanotext_option( 'header__titlebar__backgroundFeatured' );
	$current_post_type         = nanotext_current_post_type();


	if ( in_array( $current_post_type, $featured_background_types ) && has_post_thumbnail( $current_post->ID ) ) {
		$classes[] = 'content-header-featured';
	}
}

if ( ! ( $author_id = get_the_author_meta( 'ID' ) ) ) {
	$author_id = get_query_var( 'author' );
}
?>

	<div class="<?php echo esc_attr( join( ' ', $classes ) ) ?> vc_row">
		<?php if ( nanotext_option( 'header__titlebar__canvaseffect' ) == 'on' ): ?>
			<canvas></canvas>
		<?php endif ?>
		<?php if ( function_exists( 'bcn_display' ) && in_array( $layout, array( 'both', 'breadcrumbs' ) ) ): ?>
			<div class="breadcrumbs">
				<div class="breadcrumbs-inner wrap">
					<?php bcn_display() ?>
				</div>
			</div>
		<?php endif ?>

		<div class="content-header-inner wrap">
			<div class="page-title-wrap">
				
				<?php if ( in_array( $layout, array( 'both', 'title' ) ) ): ?>
					<div class="page-title">
						<?php if ( is_single( $post ) && $post->post_type == 'post' ): ?>
							<div class="post-categories">
								<?php the_category( _x( ' ', 'Used between list items, there is a space after the comma.', 'nanotext' ) ) ?>
							</div>
						<?php endif ?>

						<?php if ( $client_image_id = get_field( 'projectClientLogo', get_post() ) ): ?>
							<div class="project-client">
								<?php
									$image = nanotext_get_image_resized( array(
										'image_id' => $client_image_id,
										'size'     => 'full'
									) );

									echo wp_kses_post( $image['thumbnail'] );
								?>
							</div>
						<?php endif ?>

						<?php nanotext_header_page_title() ?>

						<?php if ( is_single( $post ) && $post->post_type == 'post' ): ?>
							<div class="post-author-meta">
								<div class="post-avatar">
									<?php echo get_avatar( get_the_author_meta( 'ID' ), 45 ); ?>
								</div>
								<div class="post-author-content">
									<p class="post-name">
										<?php esc_html_e( 'By', 'nanotext' ) ?>
										<?php the_author(); ?>
										<a href="<?php echo esc_url( get_author_posts_url( $author_id ) ) ?>" class="author-more-posts">
											<?php esc_html_e( 'More Posts', 'nanotext' ) ?>
										</a>
									</p>
									<span class="post-date">
										<?php echo esc_html( get_the_date( get_option( 'date_format' ) ) ) ?>
									</span>
									<span class="post-read">
										<?php echo nanotext_reading_time(); ?>
									</span>
								</div>
							</div>
							
							<?php wp_reset_postdata() ?>
						<?php endif ?>

						<?php if ( function_exists( 'have_rows' ) && have_rows('projectInfo') ): ?>
							<div class="project-info-list">
							<?php while( have_rows('projectInfo') ): the_row(); 
								// vars
								$projectTitleInfo = get_sub_field('titleInfo');
								$projectContentInfo = get_sub_field('contentInfo');
								?>
								<div class="item">
									<h6><?php echo nanotext_cleanup( $projectTitleInfo ); ?></h6>
									<p><?php echo nanotext_cleanup( $projectContentInfo ); ?> </p>
								</div>
							<?php endwhile; ?>
							</div>
						<?php endif; ?>

					</div>
				<?php endif ?>

				<?php if ( is_singular( $post ) && in_array( $post->post_type, ['post', 'page', 'nproject'] ) ): ?>
					<div class="post-thumbnail">
						<?php if (get_post(get_post_thumbnail_id())->post_excerpt): // search for if the image has caption added on it ?>
						    <span class="featured-image-caption">
						        <?php echo nanotext_cleanup(get_post(get_post_thumbnail_id())->post_excerpt); // displays the image caption ?>
						    </span>
						<?php endif ?>
						<div class="imgFeatured">
							<?php the_post_thumbnail( 'post-thumbnail' ) ?>
						</div>
					</div>
				<?php endif ?>
			</div>

			<?php if ( nanotext_option( 'header__titlebar__scrolldown' ) == 'on' ): ?>
				<div class="down-arrow">
					<a href="javascript:;">
						<span><?php esc_html_e( 'Find out more', 'nanotext' ) ?></span>
					</a>
				</div>
			<?php endif ?>
		</div>
	</div>
