<?php
defined( 'ABSPATH' ) or die();

// The menu settings
$primary_menu_args = array(
	'theme_location'  => 'primary',
	'container'       => false,
	'menu_class'      => 'menu menu-primary',
	'fallback_cb'     => 'nanotext_page_menu',
	'items_wrap'      => '<ul id="%1$s" class="%2$s">%3$s</ul>',
	'depth'           => 0
);

$contact_info  = nanotext_option( 'header__info__text' );
$nav_info  = nanotext_option( 'header__nav__text' );
$header_nav_extras = nanotext_option( 'header__nav__extras' );

$header_classes = array( 'site-header-sticky' );
$header_classes[] = sprintf( 'header-brand-%s', nanotext_option( 'header__sticky__logoAlign' ) );

if ( nanotext_option( 'header__sticky__width' ) === 'on' ) {
	$header_classes[] = 'header-full';
}

if ( nanotext_option( 'header__sticky__shadow' ) === 'on' ) {
	$header_classes[] = 'header-shadow';
}

if ( nanotext_option( 'header__sticky__transparent' ) === 'on' ) {
	$header_classes[] = 'header-transparent';
}
?>

	<div id="site-header-sticky" class=" <?php echo esc_attr( join( ' ', $header_classes ) ) ?>">
		<div class="header-brand">
			<a href="<?php echo esc_attr( site_url() ) ?>">
				<?php nanotext_logo( nanotext_option( 'header__sticky__logo' ) ) ?>
			</a>
		</div>

		<div class="site-header-inner wrap">
			<div class="header-content">
				<?php if ( has_nav_menu( 'primary' ) ): ?>
					<nav class="navigator" itemscope="itemscope" itemtype="https://schema.org/SiteNavigationElement">
						<?php wp_nav_menu( $primary_menu_args ) ?>

						<?php if ( ! empty( $nav_info ) ): ?>
							<div class="nav-info">
								<?php echo nanotext_cleanup( $nav_info ) ?>
							</div>
						<?php endif ?>

						<?php nanotext_social_icons( array( 'location' => 'sticky' ) ) ?>
					</nav>
				<?php endif ?>
				<?php get_template_part( 'tmpl/header-sliding-toggle' ) ?>
			</div>
		</div>
		<!-- /.site-header-inner -->
	</div>
	<!-- /.site-header -->