<?php
defined( 'ABSPATH' ) or die();

$classes = array( 'footer-copyright' );
$classes[] = sprintf( 'footer-copyright-%s', nanotext_option( 'footer__copyright__align' ) );

if ( nanotext_option( 'footer__copyright__full' ) == 'on' ) {
	$classes[] = 'footer-copyright-full';
}
?>

	<?php if ( nanotext_option( 'footer__copyright' ) == 'on' ): ?>
		<div class="<?php echo esc_attr( join( ' ', $classes ) ) ?>">
			<div class="wrap">
				<?php if ( nanotext_option( 'global__misc__gotop' ) == 'on' ): ?>
					<div class="go-to-top">
						<a href="javascript:;"><span><?php echo esc_html__( 'Go to Top', 'nanotext' ) ?></span></a>
					</div>
				<?php endif ?>
				<div class="footer-copyright-inner">
					<div class="copyright-content">
						<?php echo nanotext_cleanup( nanotext_option( 'footer__copyright__content' ) ) ?>
					</div>
					
					<?php nanotext_social_icons( array( 'location' => 'footer' ) ) ?>
				</div>
			</div>
		</div>
	<?php endif ?>