<?php
defined( 'ABSPATH' ) or die();

$featured_background_types = (array) nanotext_option( 'header__titlebar__backgroundFeatured' );
$current_post_type         = nanotext_current_post_type();
$show_featured_image       = ! in_array( $current_post_type, $featured_background_types ) && has_post_thumbnail();

$gallery_position = get_field( 'projectGalleryPosition' );
$gallery_style = get_field( 'projectGalleryStyle' );

if ( $gallery_position === 'default' ) {
	$gallery_position = nanotext_option( 'project__galleryPosition' );
}

if ( $gallery_style === 'default' ) {
	$gallery_style = nanotext_option( 'project__galerryMode' );
}

add_filter( 'nanotext_body_class', 'nanotext_single_project_body_classes' );
add_filter( 'nanotext_sidebar_id', 'nanotext_single_project_sidebar' );
add_filter( 'nanotext_sidebar_position', 'nanotext_single_project_sidebar_position' );
?>
	<?php get_header('blog') ?>
		<?php if ( have_posts() ): the_post(); ?>

			<main id="main-content" class="main-content" itemprop="mainContentOfPage">
				<div class="main-content-inner">
					<div class="content">
						<div <?php post_class( 'project' ) ?>>
							<div class="project-inner">
			
								<div class="project-content">
									<?php if ( in_array( $gallery_position, array( 'top' ) ) ): ?>
										<?php get_template_part( 'tmpl/project/gallery', $gallery_style ) ?>
									<?php endif ?>

									<?php if ( in_array( $gallery_position, array( 'left' ) ) ): ?>
										<?php get_template_part( 'tmpl/project/gallery', $gallery_style ) ?>
									<?php endif ?>

									<div class="project-detail">
										<?php the_content() ?>
									</div>

									<?php if ( nanotext_option( 'project__tags' ) == 'on' ): ?>
										<div class="project-tags"><?php echo get_the_term_list( get_the_ID(), 'nproject-tag' ) ?></div>
									<?php endif ?>

									<?php if ( in_array( $gallery_position, array( 'right' ) ) ): ?>
										<?php get_template_part( 'tmpl/project/gallery', $gallery_style ) ?>
									<?php endif ?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</main>

			<?php get_sidebar() ?>


			<?php if ( in_array( $gallery_position, array( 'bottom' ) ) ): ?>
				<?php get_template_part( 'tmpl/project/gallery', $gallery_style ) ?>
			<?php endif ?>

			<?php if ( nanotext_option( 'project__pagination' ) == 'on' ): ?>
				<?php get_template_part( 'tmpl/post/content-navigator' ) ?>
			<?php endif ?>

			<?php if ( nanotext_option( 'project__related' ) == 'on' ): ?>
				<?php get_template_part( 'tmpl/project/related' ) ?>
			<?php endif ?>
		<?php endif ?>
	<?php get_footer('blog') ?>
