<?php
if ( ! function_exists( 'vc_add_param' ) ) {
    return;
}

add_action( 'vc_before_init', function () {
	vc_add_param( 'vc_row', [
		'type' => 'dropdown',
		'heading' => esc_html__( 'Canvas Effect', 'nanotext' ),
		'param_name' => 'canvas_effect',
		'value' => [
			esc_html__( 'No', 'nanotext' ) => 'no',
			esc_html__( 'Yes', 'nanotext' ) => 'yes'
		]
	] );
	vc_add_param( 'vc_row', [
        'type' => 'dropdown',
        'heading' => esc_html__( 'Row Styles', 'nanotext' ),
        'param_name' => 'row_style',
        'value' => [
            esc_html__( 'Default', 'nanotext' ) => '',
            esc_html__( 'Shadow', 'nanotext' ) => 'shadow',
            esc_html__( 'Gradient', 'nanotext' ) => 'gradient',
            esc_html__( 'Gradient 2', 'nanotext' ) => 'gradient2',
            esc_html__( 'Gradient 3', 'nanotext' ) => 'gradient3'
        ]
    ] );
    vc_add_param( 'vc_row', [
        'type' => 'dropdown',
        'heading' => esc_html__( 'Background Position', 'nanotext' ),
        'param_name' => 'bg_position',
        'group' => esc_html__( 'Design Options', 'nanotext' ),
        'value' => [
            esc_html__( 'Default', 'nanotext' ) => '',
            esc_html__( 'Left Top', 'nanotext' ) => 'left top',
            esc_html__( 'Left Center', 'nanotext' ) => 'left center',
            esc_html__( 'Left Bottom', 'nanotext' ) => 'left bottom',
            esc_html__( 'Right Top', 'nanotext' ) => 'right top',
            esc_html__( 'Right Center', 'nanotext' ) => 'right center',
            esc_html__( 'Right Bottom', 'nanotext' ) => 'right bottom',
            esc_html__( 'Center Top', 'nanotext' ) => 'center top',
            esc_html__( 'Center Center', 'nanotext' ) => 'center center',
            esc_html__( 'Center Bottom', 'nanotext' ) => 'center bottom',
            esc_html__( 'Custom', 'nanotext' ) => 'custom'
        ]
    ] );
    vc_add_param( 'vc_row', [
        'type' => 'textfield',
        'heading' => esc_html__( 'Custom Background Position', 'nanotext' ),
        'param_name' => 'custom_position',
        'group' => esc_html__( 'Design Options', 'nanotext' ),
        'std' => '',
        'dependency' => array(
            'element' => 'bg_position',
            'value'   => 'custom',
        ),
    ] );
    
    vc_add_param( 'vc_row', [
        'type' => 'dropdown',
        'heading' => esc_html__( 'Advanced Background Size', 'nanotext' ),
        'param_name' => 'bg_size',
        'group' => esc_html__( 'Design Options', 'nanotext' ),
        'value' => [
            esc_html__( 'Default', 'nanotext' ) => '',
            esc_html__( '100% Width', 'nanotext' ) => '100% auto',
            esc_html__( '100% Height', 'nanotext' ) => 'auto 100%',
            esc_html__( 'Stretch', 'nanotext' ) => '100% 100%',
            esc_html__( 'Custom', 'nanotext' ) => 'custom'
        ]
    ] );
    vc_add_param( 'vc_row', [
        'type' => 'textfield',
        'heading' => esc_html__( 'Custom Background Size', 'nanotext' ),
        'param_name' => 'custom_size',
        'group' => esc_html__( 'Design Options', 'nanotext' ),
        'std' => '',
        'dependency' => array(
            'element' => 'bg_size',
            'value'   => 'custom',
        ),
    ] );

    vc_add_param( 'vc_section', [
        'type' => 'dropdown',
        'heading' => esc_html__( 'Section Styles', 'nanotext' ),
        'param_name' => 'section_style',
        'value' => [
            esc_html__( 'Default', 'nanotext' ) => '',
            esc_html__( 'Shadow', 'nanotext' ) => 'shadow',
            esc_html__( 'Gradient', 'nanotext' ) => 'gradient',
            esc_html__( 'Gradient 2', 'nanotext' ) => 'gradient2',
            esc_html__( 'Gradient 3', 'nanotext' ) => 'gradient3'
        ]
    ] );
    vc_add_param( 'vc_section', [
        'type' => 'dropdown',
        'heading' => esc_html__( 'Background Position', 'nanotext' ),
        'param_name' => 'bg_position',
        'group' => esc_html__( 'Design Options', 'nanotext' ),
        'value' => [
            esc_html__( 'Default', 'nanotext' ) => '',
            esc_html__( 'Left Top', 'nanotext' ) => 'left top',
            esc_html__( 'Left Center', 'nanotext' ) => 'left center',
            esc_html__( 'Left Bottom', 'nanotext' ) => 'left bottom',
            esc_html__( 'Right Top', 'nanotext' ) => 'right top',
            esc_html__( 'Right Center', 'nanotext' ) => 'right center',
            esc_html__( 'Right Bottom', 'nanotext' ) => 'right bottom',
            esc_html__( 'Center Top', 'nanotext' ) => 'center top',
            esc_html__( 'Center Center', 'nanotext' ) => 'center center',
            esc_html__( 'Center Bottom', 'nanotext' ) => 'center bottom',
            esc_html__( 'Custom', 'nanotext' ) => 'custom'
        ]
    ] );
    vc_add_param( 'vc_section', [
        'type' => 'textfield',
        'heading' => esc_html__( 'Custom Background Position', 'nanotext' ),
        'param_name' => 'custom_position',
        'group' => esc_html__( 'Design Options', 'nanotext' ),
        'std' => '',
        'dependency' => array(
            'element' => 'bg_position',
            'value'   => 'custom',
        ),
    ] );
    vc_add_param( 'vc_section', [
        'type' => 'dropdown',
        'heading' => esc_html__( 'Advanced Background Size', 'nanotext' ),
        'param_name' => 'bg_size',
        'group' => esc_html__( 'Design Options', 'nanotext' ),
        'value' => [
            esc_html__( 'Default', 'nanotext' ) => '',
            esc_html__( '100% Width', 'nanotext' ) => '100% auto',
            esc_html__( '100% Height', 'nanotext' ) => 'auto 100%',
            esc_html__( 'Stretch', 'nanotext' ) => '100% 100%',
            esc_html__( 'Custom', 'nanotext' ) => 'custom'
        ]
    ] );
    vc_add_param( 'vc_section', [
        'type' => 'textfield',
        'heading' => esc_html__( 'Custom Background Size', 'nanotext' ),
        'param_name' => 'custom_size',
        'group' => esc_html__( 'Design Options', 'nanotext' ),
        'std' => '',
        'dependency' => array(
            'element' => 'bg_size',
            'value'   => 'custom',
        ),
    ] );
} );

//Shortcode
add_action( 'admin_init', function () {
	vc_add_param( 'imagebox', [
        'type' => 'dropdown',
        'heading' => esc_html__( 'Select Styles', 'nanotext' ),
        'param_name' => 'imagebox_style',
        'value' => [
            esc_html__( 'Default', 'nanotext' ) => '',
            esc_html__( 'Style 1', 'nanotext' ) => 'style1',
            esc_html__( 'Style 2', 'nanotext' ) => 'style2'
        ]
    ] );
    vc_add_param( 'member', [
        'type' => 'dropdown',
        'heading' => esc_html__( 'Select Styles', 'nanotext' ),
        'param_name' => 'member_style',
        'value' => [
            esc_html__( 'Default', 'nanotext' ) => '',
            esc_html__( 'Style 1', 'nanotext' ) => 'style1',
            esc_html__( 'Style 2', 'nanotext' ) => 'style2'
        ]
    ] );
    vc_add_param( 'iconbox', [
        'type' => 'dropdown',
        'heading' => esc_html__( 'Select Styles', 'nanotext' ),
        'param_name' => 'iconbox_style',
        'value' => [
            esc_html__( 'Default', 'nanotext' ) => '',
            esc_html__( 'Style 1', 'nanotext' ) => 'style1',
            esc_html__( 'Style 2', 'nanotext' ) => 'style2',
            esc_html__( 'Box Color: Primary', 'nanotext' ) => 'primary',
            esc_html__( 'Box Color: Accent', 'nanotext' ) => 'accent'
        ]
    ] );
    vc_add_param( 'counter', [
        'type' => 'dropdown',
        'heading' => esc_html__( 'Select Styles', 'nanotext' ),
        'param_name' => 'counter_style',
        'value' => [
            esc_html__( 'Default', 'nanotext' ) => '',
            esc_html__( 'Style 1', 'nanotext' ) => 'style1'
        ]
    ] );
    vc_add_param( 'elements_carousel', [
        'type' => 'dropdown',
        'heading' => esc_html__( 'Select Styles', 'nanotext' ),
        'param_name' => 'elements-carousel_style',
        'value' => [
            esc_html__( 'Default', 'nanotext' ) => '',
            esc_html__( 'Style 1', 'nanotext' ) => 'timeline',
            esc_html__( 'Style 2', 'nanotext' ) => 'style2'
        ]
    ] );
    vc_add_param( 'elements_carousel', [
        'type' => 'dropdown',
        'heading' => esc_html__( 'Centered Slides', 'nanotext' ),
        'param_name' => 'centered',
        'value' => [
            esc_html__( 'No', 'nanotext' ) => 'no',
            esc_html__( 'Yes', 'nanotext' ) => 'yes'
        ]
    ] );
} );