<?php
defined( 'ABSPATH' ) or die();


// Setup the theme navigation
add_action( 'after_setup_theme', 'nanotext_navigation' );

// Setup theme supports
add_action( 'after_setup_theme', 'nanotext_supports' );

// Setup theme sidebars
add_action( 'widgets_init', 'nanotext_sidebars' );

// Add action to register the needed scripts and styles
// for the theme
add_action( 'init', 'nanotext_register_assets', 5 );

// We need enqueue the scripts and styles before showing
// the content
add_action( 'wp_enqueue_scripts', 'nanotext_enqueue_assets', 5 );

// Adding SVG support in the media library
add_filter( 'upload_mimes', 'nanotext_upload_mimes' );

// Adding filter to change the shortcodes path
add_filter( 'line-shortcode-path', 'nanotext_shortcodes_path' );

add_filter( 'vc_before_init', 'nanotext_shortcodes_init' );

add_filter( 'wp_kses_allowed_html', 'nanotext_allowed_html', 10, 2 );

add_filter( 'the_content', function ( $content ) {
	if ( is_singular() ) {
		return preg_replace( '/<p>\s*<span id="more-[0-9]+">\s*<\/span><\/p>/is', '', $content );
	}

	return $content;
}, 99 );


if ( ! isset( $content_width ) ) {
	$content_width = 900;
}

function nanotext_cleanup ( $content ) {
	return $content;
}

function nanotext_allowed_html ( $allowed_tags, $context ) {
	if ( $context === 'post' ) {
		$allowed_tags['div'] = array_merge( $allowed_tags['div'], [
			'data-vc-parallax-image' => true,
			'data-vc-video-bg' => true
		] );

		$common_atts = [
			'id' => true,
			'class' => true,
			'style' => true,
			'width' => true,
			'height' => true,
			'type' => true,
			'data-*' => true
		];

		$allowed_tags['rs-module-wrap'] = $common_atts;
		$allowed_tags['rs-module'] = $common_atts;
		$allowed_tags['rs-slides'] = $common_atts;
		$allowed_tags['rs-slide'] = $common_atts;
		$allowed_tags['rs-layer'] = $common_atts;
		$allowed_tags['rs-progress'] = $common_atts;
		$allowed_tags['script'] = $common_atts;
	}

	return $allowed_tags;
}

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
function nanotext_pingback_header() {
	if ( is_singular() && pings_open() ) {
		echo '<link rel="pingback" href="', esc_url( get_bloginfo( 'pingback_url' ) ), '">';
	}
}
add_action( 'wp_head', 'nanotext_pingback_header' );


/**
 * Register the theme menu locations
 *
 * @return  void
 * @since   1.0.0
 */
function nanotext_navigation() {
	register_nav_menus( array(
		'primary'   => esc_html__( 'Primary Menu', 'nanotext' ),
		'sliding'   => esc_html__( 'Sliding Menu', 'nanotext' ),
		'top'       => esc_html__( 'Top Menu', 'nanotext' )
	) );
}


/**
 * Register the theme features support
 *
 * @return  void
 */
function nanotext_supports() {
	add_theme_support( 'woocommerce' );
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'title-tag' );
	add_theme_support( 'post-formats', array( 'gallery', 'link', 'quote', 'status', 'video', 'audio' ) );
	add_theme_support( 'html5', array( 'comment-list', 'search-form', 'comment-form', 'gallery', 'caption' ) );
	add_theme_support( 'post-thumbnails' );
}


function nanotext_sidebars() {
	register_sidebar( array(
		'name'          => esc_html__( 'Primary Widgets Area', 'nanotext' ),
		'id'            => 'primary',
		'description'   => esc_html__( 'Add widgets here to appear in your sidebar', 'nanotext' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Sliding Content - Left', 'nanotext' ),
		'id'            => 'off-canvas-left',
		'description'   => esc_html__( 'Add widgets here to appear in your sidebar', 'nanotext' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
	register_sidebar( array(
		'name'          => esc_html__( 'Sliding Content - Right', 'nanotext' ),
		'id'            => 'off-canvas-right',
		'description'   => esc_html__( 'Add widgets here to appear in your sidebar', 'nanotext' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	/**
	 * Content bottom sidebars
	 */
	register_sidebar( array(
		'name'          => esc_html__( 'Content Bottom #1', 'nanotext' ),
		'id'            => 'content-bottom-1',
		'description'   => esc_html__( 'Add widgets here to appear in your Content Bottom #1 area', 'nanotext' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Content Bottom #2', 'nanotext' ),
		'id'            => 'content-bottom-2',
		'description'   => esc_html__( 'Add widgets here to appear in your Content Bottom #2 area', 'nanotext' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Content Bottom #3', 'nanotext' ),
		'id'            => 'content-bottom-3',
		'description'   => esc_html__( 'Add widgets here to appear in your Content Bottom #3 area', 'nanotext' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Content Bottom #4', 'nanotext' ),
		'id'            => 'content-bottom-4',
		'description'   => esc_html__( 'Add widgets here to appear in your Content Bottom #4 area', 'nanotext' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	/**
	 * Footer sidebars
	 */
	register_sidebar( array(
		'name'          => esc_html__( 'Footer #1', 'nanotext' ),
		'id'            => 'footer-1',
		'description'   => esc_html__( 'Add widgets here to appear in your Footer #1 area', 'nanotext' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer #2', 'nanotext' ),
		'id'            => 'footer-2',
		'description'   => esc_html__( 'Add widgets here to appear in your Footer #2 area', 'nanotext' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer #3', 'nanotext' ),
		'id'            => 'footer-3',
		'description'   => esc_html__( 'Add widgets here to appear in your Footer #3 area', 'nanotext' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer #4', 'nanotext' ),
		'id'            => 'footer-4',
		'description'   => esc_html__( 'Add widgets here to appear in your Footer #4 area', 'nanotext' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
}


function nanotext_register_assets() {
	// Theme's styles
	wp_register_style( 'nanotext-components', get_template_directory_uri() . '/assets/css/components.css', array(), NANOTEXT_VERSION, 'all' );

	if (is_child_theme()) {
		wp_register_style( 'nanotext-parent', get_template_directory_uri() . '/assets/css/style.css', array( 'nanotext-components' ), NANOTEXT_VERSION, 'all' );
		wp_register_style( 'nanotext', get_stylesheet_uri(), array( 'nanotext-parent' ), NANOTEXT_VERSION, 'all' );
	} else {
		wp_register_style( 'nanotext', get_template_directory_uri() . '/assets/css/style.css', ['nanotext-components'], NANOTEXT_VERSION, 'all' );
	}

	wp_register_script( 'imagesloaded', get_theme_file_uri( 'assets/js/libs/imagesloaded.js' ), ['jquery'], false, true );
	wp_register_script( 'packery', get_theme_file_uri( 'assets/js/libs/packery.js' ), ['jquery'], false, true );
	wp_register_script( 'isotope', get_theme_file_uri( 'assets/js/libs/isotope.js' ), ['jquery'], false, true );
	wp_register_script( 'isotope-packery', get_theme_file_uri( 'assets/js/libs/isotope.packery.js' ), ['isotope', 'packery'], false, true );
	wp_register_script( 'waypoints', get_theme_file_uri( 'assets/js/libs/waypoints.js' ), ['jquery'], false, true );
	wp_register_script( 'waypoints-inview', get_theme_file_uri( 'assets/js/libs/waypoints.inview.js' ), ['waypoints'], false, true );
	wp_register_script( 'swiper', get_theme_file_uri( 'assets/js/libs/swiper.js' ), ['jquery'], false, true );
	wp_register_script( 'prettyPhoto', get_theme_file_uri( 'assets/js/libs/prettyPhoto.js' ), ['jquery'], false, true );
	wp_register_script( 'countTo', get_theme_file_uri( 'assets/js/libs/countTo.js' ), ['jquery'], false, true );
	wp_register_script( 'matchHeight', get_theme_file_uri( 'assets/js/libs/matchHeight.js' ), ['jquery'], false, true );
	wp_register_script( 'tween-lite', get_theme_file_uri( 'assets/js/libs/tween-lite.js' ), ['jquery'], false, true );

	// Theme's scripts
	wp_register_script( 'nanotext', get_template_directory_uri() . '/assets/js/theme.js', [
		'imagesloaded',
		'isotope-packery',
		'waypoints-inview',
		'swiper',
		'prettyPhoto',
		'countTo',
		'matchHeight',
		'tween-lite'
	], NANOTEXT_VERSION, true );

	if ( $settings = get_option( 'line_settings' ) ) {
		wp_register_script( 'line-shortcode-maps-api', 'https://maps.google.com/maps/api/js?v=3&key=' . $settings['maps_api'], array(), false, true );
	}
}


function nanotext_enqueue_google_fonts() {
	global $_required_google_fonts;

	if ( ! empty( $_required_google_fonts ) && is_array( $_required_google_fonts ) ) {
		$fonts = array();
		$subsets = array();

		foreach ( $_required_google_fonts as $font ) {
			$fonts[] = sprintf( '%s:%s', urlencode( $font['family'] ), urlencode( $font['variants'] ) );
			$subsets = array_merge( $subsets, $font['subsets'] );
		}

		if ( ! empty( $fonts ) ) {
			$scheme = parse_url( get_site_url(), PHP_URL_SCHEME );
			$fonts_url = add_query_arg( array(
				'family' => implode( '|', array_unique( $fonts ) ),
				'subset' => implode( ',', array_unique( $subsets ) )
				), sprintf( '%s://fonts.googleapis.com/css', $scheme ) );

			wp_enqueue_style( 'nanotext-fonts', $fonts_url );
		}
	}
}


function nanotext_enqueue_assets() {
	// The dynamic styles
	if ( locate_template( 'dynamic-styles.php' ) ) {
		// Load the script that generate the dynamic
		// stylesheets
		get_template_part( 'dynamic-styles' );
	}

	nanotext_enqueue_google_fonts();

	// Enqueue the main styles
	wp_enqueue_style( 'nanotext' );

	// Enqueue the inline stylesheet
	wp_add_inline_style( 'nanotext', nanotext_styles() );
	wp_add_inline_style( 'nanotext', nanotext_scheme_styles() );

	// Enqueue the main script
	wp_enqueue_script( 'nanotext' );

	// Comment script
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}


/**
 * Register custom mime types for the theme
 *
 * @param   array  $mimes  List of mime types
 * @return  array
 */
function nanotext_upload_mimes( $mimes ) {
	$mimes['ico'] = 'image/x-icon';
	$mimes['dat'] = 'application/octet-stream';
	$mimes['txt'] = 'text/plain';

	return $mimes;
}


/**
 * Return the string that indicated the folder which contains
 * all shortcode templates
 *
 * @param   string  $path  The original path
 * @return  string
 */
function nanotext_shortcodes_path( $path ) {
	return 'tmpl/shortcodes/';
}


/**
 * Initial the additional shortcodes for the theme
 *
 * @return  void
 */
function nanotext_shortcodes_init() {
	require_once get_theme_file_path( 'inc/elements/locations.php' );
	
	vc_lean_map( 'video-lightbox', null, get_theme_file_path( 'inc/elements/video-lightbox.php' ) );
	vc_lean_map( 'project-carousel', null, get_theme_file_path( 'inc/elements/project-carousel.php' ) );
}


function nanotext_acf_fallback_init () {
	if ( ! function_exists( 'get_field' ) ) {
		function get_field () {}
	}

	if ( ! function_exists( 'the_field' ) ) {
		function the_field () {}
	}
}
add_action( 'wp', 'nanotext_acf_fallback_init' );

//Restoring the classic Widgets Editor 
function nanotext_theme_support() {
    remove_theme_support( 'widgets-block-editor' );
}
add_action( 'after_setup_theme', 'nanotext_theme_support' );