<?php
defined( 'ABSPATH' ) or die();


add_filter( 'nprojects/shortcode_template', 'nanotext_project_shortcode_template' );
add_filter( 'nprojects/shortcode_parameters', 'nanotext_project_shortcode_params' );
add_filter( 'line-shortcode-unsupported', 'nanotext_project_disable_justify_shortcode' );
add_filter( 'the_excerpt', 'nanotext_project_auto_excerpt', 99 );

add_action( 'after_setup_theme', function () {
	if ( class_exists( 'nProjects_Admin' ) ) {
		$admin = nProjects_Admin::instance();
		$meta_box_hook = 'add_meta' . '_boxes';
		
		remove_action( 'admin_enqueue_scripts', array( $admin, 'enqueue_styles' ) );
		remove_action( 'admin_enqueue_scripts', array( $admin, 'enqueue_scripts' ) );
		remove_action( 'save_post', array( $admin, 'update_media_items' ) );
		remove_action( $meta_box_hook, array( $admin, 'add_metabox' ) );
	}
} );

function nanotext_project_auto_excerpt( $excerpt ) {
	if ( nanotext_current_post_type() == 'nproject' && mb_strlen( $excerpt ) > nanotext_option( 'projects__autoExcerptLength' ) ) {
		$excerpt = mb_substr( $excerpt, 0, nanotext_option( 'projects__autoExcerptLength' ) );
	}

	return $excerpt;
}

function nanotext_project_disable_justify_shortcode( $unsupported ) {
	$unsupported[] = 'projects_justify';
	return $unsupported;
}


function nanotext_projects_body_class( $classes ) {
	$classes[] = sprintf( 'projects projects-%s', nanotext_option( 'projects__displayMode' ) );

	return $classes;
}

function nanotext_projects_sidebar() {
	return nanotext_option( 'projects__sidebar' );
}

function nanotext_projects_sidebar_position() {
	return nanotext_option( 'projects__sidebarPosition' );
}


function nanotext_single_project_body_classes( $classes ) {
	$gallery_position = get_field( 'projectGalleryPosition' );
	
	if ( $gallery_position === 'default' ) {
		$gallery_position = nanotext_option( 'project__galleryPosition' );
	}

	$classes[] = sprintf( 'project-gallery-%s', $gallery_position );
	
	return $classes;
}

function nanotext_single_project_sidebar() {
	return nanotext_option( 'project__sidebar' );
}

function nanotext_single_project_sidebar_position() {
	return nanotext_option( 'project__sidebarPosition' );
}


function nanotext_project_media_item( $item, $size = 'full', $crop = false, $lightbox = true ) {
	$attachment_image = nanotext_get_image_resized( [
		'image_id' => is_array( $item ) ? $item['id'] : $item,
		'size'     => $size,
		'crop'     => $crop
	] );

	$attachment_image_src = $attachment_image['thumbnail_raw'][0];
	$attachment_image_large = $attachment_image['large'];

	if ( $lightbox ) {
		printf( '<a href="%s" rel="prettyPhoto[gallery]"><img src="%s" /></a>',
			$attachment_image_src,
			$attachment_image_large[0]
		);
	}
	else {
		echo nanotext_cleanup( $attachment_image['thumbnail'] );
	}
}



function nanotext_project_shortcode_params( $params ) {
	// General tab
	$params[] = array(
		'type'        => 'textfield',
		'heading'     => esc_html__( 'Widget Title', 'nanotext' ),
		'description' => esc_html__( 'Enter text which will be used as widget title. Leave blank if no title is needed.', 'nanotext' ),
		'param_name'  => 'widget_title'
	);

	$params[] = array(
		'type'        => 'textfield',
		'heading'     => esc_html__( 'Categories', 'nanotext' ),
		'description' => esc_html__( 'If you want to narrow output, enter category names here. Note: Only listed categories will be included.', 'nanotext' ),
		'param_name'  => 'categories'
	);

	$params[] = array(
		'type'        => 'textfield',
		'heading'     => esc_html__( 'Tags', 'nanotext' ),
		'description' => esc_html__( 'If you want to narrow output, enter tag names here. Note: Only listed tags will be included.', 'nanotext' ),
		'param_name'  => 'tags'
	);

	$params[] = array(
		'type'       => 'dropdown',
		'heading'    => esc_html__( 'Display Mode', 'nanotext' ),
		'param_name' => 'mode',
		'std'        => 3,
		'value'      => array(
			esc_html__( 'Grid Classic', 'nanotext' )   => 'grid',
			esc_html__( 'Grid Masonry', 'nanotext' )   => 'masonry',
			esc_html__( 'Grid Alt', 'nanotext' ) => 'grid-alt'
		)
	);

	$params[] = array(
		'type'        => 'dropdown',
		'heading'     => esc_html__( 'Columns', 'nanotext' ),
		'description' => esc_html__( 'The number of columns will be shown', 'nanotext' ),
		'param_name'  => 'columns',
		'std'         => 3,
		'value'       => array(
			esc_html__( '1 Column', 'nanotext' )  => 1,
			esc_html__( '2 Columns', 'nanotext' ) => 2,
			esc_html__( '3 Columns', 'nanotext' ) => 3,
			esc_html__( '4 Columns', 'nanotext' ) => 4,
			esc_html__( '5 Columns', 'nanotext' ) => 5,
		)
	);

	$params[] = array(
		'type'       => 'dropdown',
		'heading'    => esc_html__( 'Show Items Filter', 'nanotext' ),
		'param_name' => 'filter',
		'std'        => 'yes',
		'value'      => array(
			esc_html__( 'Yes', 'nanotext' ) => 'yes',
			esc_html__( 'No', 'nanotext' )  => 'no'
		)
	);

	$params[] = array(
		'type'       => 'dropdown',
		'heading'    => esc_html__( 'Filter By', 'nanotext' ),
		'param_name' => 'filter_by',
		'std'        => 'category',
		'value'      => array(
			esc_html__( 'Categories', 'nanotext' ) => 'category',
			esc_html__( 'Tags', 'nanotext' )       => 'tag'
		)
	);

	$params[] = array(
		'type'        => 'textfield',
		'heading'     => esc_html__( 'Limit', 'nanotext' ),
		'description' => esc_html__( 'The number of posts will be shown', 'nanotext' ),
		'param_name'  => 'limit',
		'value'       => 9
	);

	$params[] = array(
		'type'        => 'textfield',
		'heading'     => esc_html__( 'Offset', 'nanotext' ),
		'description' => esc_html__( 'The number of posts to pass over', 'nanotext' ),
		'param_name'  => 'offset',
		'value'       => 0
	);

	$params[] = array(
		'type'        => 'textfield',
		'heading'     => esc_html__( 'Thumbnail Size', 'nanotext' ),
		'description' => esc_html__( 'Enter image size. Example: "thumbnail", "medium", "large", "full" or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use "thumbnail" size.', 'nanotext' ),
		'param_name'  => 'thumbnail_size'
	);

	$params[] = array(
		'type'       => 'dropdown',
		'heading'    => esc_html__( 'Show Read More', 'nanotext' ),
		'param_name' => 'readmore',
		'std'        => 'yes',
		'value'      => array(
			esc_html__( 'Yes', 'nanotext' ) => 'yes',
			esc_html__( 'No', 'nanotext' )  => 'no'
		)
	);
	$params[] = array(
		'type'        => 'textfield',
		'heading'     => esc_html__( 'Readmore Text', 'nanotext' ),
		'param_name'  => 'readmore_text'
	);

	$params[] = array(
		'type'        => 'dropdown',
		'heading'     => esc_html__( 'Order By', 'nanotext' ),
		'description' => esc_html__( 'Select how to sort retrieved posts.', 'nanotext' ),
		'param_name'  => 'order',
		'std'         => 'date',
		'value'       => array(
			esc_html__( 'Date', 'nanotext' )          => 'date',
			esc_html__( 'ID', 'nanotext' )            => 'ID',
			esc_html__( 'Author', 'nanotext' )        => 'author',
			esc_html__( 'Title', 'nanotext' )         => 'title',
			esc_html__( 'Modified', 'nanotext' )      => 'modified',
			esc_html__( 'Random', 'nanotext' )        => 'rand',
			esc_html__( 'Comment count', 'nanotext' ) => 'comment_count',
			esc_html__( 'Menu order', 'nanotext' )    => 'menu_order'
		)
	);

	$params[] = array(
		'type'        => 'dropdown',
		'heading'     => esc_html__( 'Order Direction', 'nanotext' ),
		'description' => esc_html__( 'Designates the ascending or descending order.', 'nanotext' ),
		'param_name'  => 'direction',
		'std'         => 'DESC',
		'value'       => array(
			esc_html__( 'Ascending', 'nanotext' )          => 'ASC',
			esc_html__( 'Descending', 'nanotext' )            => 'DESC'
		)
	);

	$params[] = array(
		'type'       => 'dropdown',
		'heading'    => esc_html__( 'Enable equals height?', 'nanotext' ),
		'param_name' => 'equals',
		'std'        => 'no',
		'value'      => array(
			esc_html__( 'Yes', 'nanotext' ) => 'yes',
			esc_html__( 'No', 'nanotext' )  => 'no'
		)
	);

	$params[] = array(
		'type'        => 'textfield',
		'heading'     => esc_html__( 'Extra Class', 'nanotext' ),
		'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'nanotext' ),
		'param_name'  => 'class'
	);

	$params[] = array(
		'type' => 'css_editor',
		'param_name' => 'css',
		'group' => esc_html__( 'Design Options', 'nanotext' )
	);

	return $params;
}



function nanotext_project_shortcode_template() {
	return 'tmpl/shortcodes/projects.php';
}
