<?php
defined( 'ABSPATH' ) or die();


// A filter for adding custom classes
// into the body element
add_filter( 'nanotext_body_class', 'nanotext_body_classes', 5 );


// A filter to generate the post excerpt
// automatically
add_filter( 'nanotext_the_content', 'nanotext_auto_excerpt', 5 );


add_filter( 'line-shortcodes/posts-params', 'nanotext_custom_posts_shortcode_params' );


/**
 * Return the classes name for the body tag
 * in array format
 * 
 * @param   array  $classes  An existing classes
 * @return  array
 * @since   1.0.0
 */
function nanotext_body_classes( $classes ) {
	$classes[] = sprintf( 'layout-%s', nanotext_option( 'global__layout__mode' ) );

	if ( nanotext_has_sidebar() && is_active_sidebar( nanotext_sidebar_id() ) ) {
		$classes[] = sprintf( 'sidebar-%s', nanotext_sidebar_position() );
	}

	return $classes;
}


function nanotext_auto_excerpt( $content ) {
	if ( nanotext_option( 'blog__archive__autoExcerpt' ) === 'on' ) {
		$length = (int) nanotext_option( 'blog__archive__excerptLength' );
		$post   = get_post();

		if ( ! preg_match( '/<!--more(.*?)?-->/', $post->post_content ) ) {
			$content = strip_tags( strip_shortcodes( $content ) );
			$content = trim( $content );

			if ( strlen( $content ) > $length ) {
				$content = mb_substr( $content, 0, $length );
				$content.= '...';
			}

			return sprintf( '<p>%s</p>', $content );
		}
	}

	return $content;
}


function nanotext_custom_posts_shortcode_params( $args ) {
	$args['params'] = array(
		array(
			'type'        => 'textfield',
			'heading'     => esc_html__( 'Widget Title', 'nanotext' ),
			'param_name'  => 'title',
			'description' => esc_html__( 'Enter text which will be used as widget title. Leave blank if no title is needed.', 'nanotext' )
		),
		array(
			'type'        => 'textfield',
			'heading'     => esc_html__( 'Category', 'nanotext' ),
			'param_name'  => 'category',
			'description' => esc_html__( 'Enter the category\'s slug that will be used to filter posts', 'nanotext' )
		),
		array(
			'type'        => 'textfield',
			'heading'     => esc_html__( 'Tag', 'nanotext' ),
			'param_name'  => 'tag',
			'description' => esc_html__( 'Enter the tag\'s slug that will be used to filter posts', 'nanotext' )
		),
		array(
			'type'       => 'dropdown',
			'heading'    => esc_html__( 'Layout', 'nanotext' ),
			'param_name' => 'layout',
			'value'      => array(
				esc_html__( 'Grid', 'nanotext' ) => 'grid',
				esc_html__( 'List', 'nanotext' ) => 'list'
			)
		),
		array(
			'type'        => 'dropdown',
			'heading'     => esc_html__( 'Grid Columns', 'nanotext' ),
			'param_name'  => 'grid_columns',
			'description' => esc_html__( 'The number of columns for grid and grid masonry layout', 'nanotext' ),
			'value'       => array(
				esc_html__( '2 Columns', 'nanotext' ) => 2,
				esc_html__( '3 Columns', 'nanotext' ) => 3,
				esc_html__( '4 Columns', 'nanotext' ) => 4,
				esc_html__( '5 Columns', 'nanotext' ) => 5
			)
		),
		array(
			'type'        => 'textfield',
			'heading'     => esc_html__( 'Thumbnail Size', 'nanotext' ),
			'description' => esc_html__( 'Enter image size. Example: "thumbnail", "medium", "large", "full" or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use "thumbnail" size.', 'nanotext' ),
			'param_name'  => 'thumbnail_size'
		),
		array(
			'type'        => 'textfield',
			'heading'     => esc_html__( 'Limit', 'nanotext' ),
			'param_name'  => 'limit',
			'description' => esc_html__( 'The number of posts will be shown', 'nanotext' ),
			'value'       => 9
		),
		array(
			'type'        => 'textfield',
			'heading'     => esc_html__( 'Offset', 'nanotext' ),
			'param_name'  => 'offset',
			'description' => esc_html__( 'The number of posts to pass over', 'nanotext' ),
			'value'       => 0
		),
		array(
			'type'       => 'dropdown',
			'heading'    => esc_html__( 'Icon For Posts', 'nanotext' ),
			'param_name' => 'icon',
			'value'      => array(
				esc_html__( 'Post Thumbnail', 'nanotext' ) => 'post-thumbnail',
				esc_html__( 'Post Date', 'nanotext' ) => 'post-date'
			)
		),
		array(
			'type'       => 'checkbox',
			'heading'    => esc_html__( 'Hide Post Content', 'nanotext' ),
			'param_name' => 'hide_content',
			'value'      => array(
				esc_html__( 'Yes, please', 'nanotext' ) => 'yes'
			)
		),
		array(
			'type'       => 'textfield',
			'heading'    => esc_html__( 'Post Content Length', 'nanotext' ),
			'param_name' => 'content_length',
			'value'      => 40
		),
		array(
			'type'       => 'checkbox',
			'heading'    => esc_html__( 'Hide Read More', 'nanotext' ),
			'param_name' => 'hide_readmore',
			'value'      => array(
				esc_html__( 'Yes, please', 'nanotext' ) => 'yes'
			)
		),
		array(
			'type'       => 'textfield',
			'heading'    => esc_html__( 'Read More Text', 'nanotext' ),
			'param_name' => 'readmore_text',
			'value'      => esc_html__( 'Continue &rarr;', 'nanotext' )
		),

		array(
			'type'        => 'textfield',
			'heading'     => esc_html__( 'Extra class name', 'nanotext' ),
			'param_name'  => 'class',
			'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'nanotext' )
		),

		array(
			'type'       => 'css_editor',
			'param_name' => 'css',
			'group'      => esc_html__( 'Design Options', 'nanotext' )
		)
	);

	return $args;
}