<?php
defined( 'ABSPATH' ) or die();

add_filter( 'line/iconpicker_params', function( $params ) {
	$params[] = array(
		'type'        => 'iconpicker',
		'heading'     => esc_html__( 'Icon', 'nanotext' ),
		'param_name'  => 'icon_nucleo',
		'value'       => '', // default value to backend editor admin_label
		'description' => esc_html__( 'Select icon from library.', 'nanotext' ),
		'settings'    => array(
			'emptyIcon'    => false,
			'type'         => 'nucleo',
			'iconsPerPage' => 4000
		),
		'dependency' => array(
			'element' => 'type',
			'value'   => 'nucleo',
		)
	);

	return $params;
} );

add_filter( 'line/iconpicker_types_dropdown', function( $types ) {
	$types[esc_html__( 'Nucleo Icons', 'nanotext' )] = 'nucleo';

	return $types;
} );

add_filter( 'vc_iconpicker-type-nucleo', function( $icons ) {
	return array_merge( $icons, array(
		array( 'nnt-browse-2' => 'nnt-browse-2' ),
		array( 'nnt-check' => 'nnt-check' ),
		array( 'nnt-web-hyperlink' => 'nnt-web-hyperlink' ),
		array( 'nnt-url' => 'nnt-url' ),
		array( 'nnt-launch-app' => 'nnt-launch-app' ),
		array( 'nnt-launch' => 'nnt-launch' ),
		array( 'nnt-3d-29' => 'nnt-3d-29' ),
		array( 'nnt-drag' => 'nnt-drag' ),
		array( 'nnt-measure-big' => 'nnt-measure-big' ),
		array( 'nnt-photo-editor' => 'nnt-photo-editor' ),
		array( 'nnt-responsive' => 'nnt-responsive' ),
		array( 'nnt-ruler-pencil' => 'nnt-ruler-pencil' ),
		array( 'nnt-shape-adjust' => 'nnt-shape-adjust' ),
		array( 'nnt-app-store' => 'nnt-app-store' ),
		array( 'nnt-geometry' => 'nnt-geometry' ),
		array( 'nnt-api' => 'nnt-api' ),
		array( 'nnt-plug-2' => 'nnt-plug-2' ),
		array( 'nnt-award-49' => 'nnt-award-49' ),
		array( 'nnt-bulb-62' => 'nnt-bulb-62' ),
		array( 'nnt-chart-bar-33' => 'nnt-chart-bar-33' ),
		array( 'nnt-chart' => 'nnt-chart' ),
		array( 'nnt-goal-65' => 'nnt-goal-65' ),
		array( 'nnt-archery-target' => 'nnt-archery-target' ),
		array( 'nnt-math' => 'nnt-math' ),
		array( 'nnt-percentage-38' => 'nnt-percentage-38' ),
		array( 'nnt-app-services' => 'nnt-app-services' ),
		array( 'nnt-interview' => 'nnt-interview' ),
		array( 'nnt-explore-user' => 'nnt-explore-user' ),
		array( 'nnt-explore' => 'nnt-explore' ),
		array( 'nnt-journey-04' => 'nnt-journey-04' ),
		array( 'nnt-pin-4' => 'nnt-pin-4' ),
		array( 'nnt-position-pin' => 'nnt-position-pin' ),
		array( 'nnt-radar' => 'nnt-radar' ),
		array( 'nnt-instant-camera-2' => 'nnt-instant-camera-2' ),
		array( 'nnt-selfie' => 'nnt-selfie' ),
		array( 'nnt-img-stack' => 'nnt-img-stack' ),
		array( 'nnt-media-player' => 'nnt-media-player' ),
		array( 'nnt-earbuds' => 'nnt-earbuds' ),
		array( 'nnt-video-playlist' => 'nnt-video-playlist' ),
		array( 'nnt-video-off' => 'nnt-video-off' ),
		array( 'nnt-offline' => 'nnt-offline' ),
		array( 'nnt-engine-start' => 'nnt-engine-start' ),
		array( 'nnt-hybrid-car' => 'nnt-hybrid-car' ),
		array( 'nnt-c-check' => 'nnt-c-check' ),
		array( 'nnt-move-layer-up' => 'nnt-move-layer-up' ),
		array( 'nnt-social-sharing' => 'nnt-social-sharing' ),
		array( 'nnt-thumb-down' => 'nnt-thumb-down' ),
		array( 'nnt-thumb-up' => 'nnt-thumb-up' ),
		array( 'nnt-battery-charging' => 'nnt-battery-charging' ),
		array( 'nnt-auto-flash-2' => 'nnt-auto-flash-2' ),
		array( 'nnt-radio' => 'nnt-radio' ),
		array( 'nnt-sound-wave' => 'nnt-sound-wave' ),
		array( 'nnt-selfie-2' => 'nnt-selfie-2' ),
		array( 'nnt-sport-mode' => 'nnt-sport-mode' ),
		array( 'nnt-audio-description' => 'nnt-audio-description' ),
		array( 'nnt-shuffle-35' => 'nnt-shuffle-35' ),
		array( 'nnt-antenna' => 'nnt-antenna' ),
		array( 'nnt-capitalize' => 'nnt-capitalize' ),
		array( 'nnt-code' => 'nnt-code' ),
	) );
} );

add_action( 'vc_backend_editor_enqueue_js_css', function() {
	wp_enqueue_style( 'nucleo-font', get_template_directory_uri() . '/assets/css/components.css' );
} );