<?php
$values     = [];
$taxonomies = [
    'nproject-category',
    'nproject-tag'
];

foreach ( $taxonomies as $taxonomy ) {
    $terms = get_terms( $taxonomy );
    $values[ $taxonomy ] = [];

    if ( is_array( $terms ) ) {
        foreach ( $terms as $term ) {
            $values[ $taxonomy ][] = [
                'label' => $term->name,
                'value' => $term->term_id
            ];
        }
    }
}

return array(
    'name'     => __( 'LineThemes: Project Carousel', 'nanotext' ),
    'base'     => 'project-carousel',
    'category' => 'LineThemes',
    'params'   => array(
        // General tab
        array(
            'type'        => 'textfield',
            'heading'     => __( 'Widget Title', 'nanotext' ),
            'description' => __( 'Enter text which will be used as widget title. Leave blank if no title is needed.', 'nanotext' ),
            'param_name'  => 'widget_title'
        ),

        array(
            'type'        => 'autocomplete',
            'heading'     => __( 'Categories', 'nanotext' ),
            'description' => __( 'If you want to narrow output, enter category names here. Note: Only listed categories will be included.', 'nanotext' ),
            'param_name'  => 'categories',
            'settings'    => array(
                'multiple'       => true,
                'sortable'       => true,
                'min_length'     => 1,
                'no_hide'        => true,
                'unique_values'  => true,
                'display_inline' => true,
                'values'         => $values['nproject-category']
            )
        ),

        array(
            'type'        => 'autocomplete',
            'heading'     => __( 'Tags', 'nanotext' ),
            'description' => __( 'If you want to narrow output, enter tag names here. Note: Only listed tags will be included.', 'nanotext' ),
            'param_name'  => 'tags',
            'settings'    => array(
                'multiple'       => true,
                'sortable'       => true,
                'min_length'     => 1,
                'no_hide'        => true,
                'unique_values'  => true,
                'display_inline' => true,
                'values'         => $values['nproject-tag']
            )
        ),

        array(
            'type'        => 'textfield',
            'heading'     => __( 'Limit', 'nanotext' ),
            'description' => __( 'The number of posts will be shown', 'nanotext' ),
            'param_name'  => 'limit',
            'value'       => 9
        ),

        array(
            'type'        => 'textfield',
            'heading'     => __( 'Offset', 'nanotext' ),
            'description' => __( 'The number of posts to pass over', 'nanotext' ),
            'param_name'  => 'offset',
            'value'       => 0
        ),

        array(
            'type'        => 'textfield',
            'heading'     => __( 'Thumbnail Size', 'nanotext' ),
            'description' => __( 'Enter image size. Example: "thumbnail", "medium", "large", "full" or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use "thumbnail" size.', 'nanotext' ),
            'param_name'  => 'thumbnail_size'
        ),

        array(
            'type'        => 'dropdown',
            'heading'     => __( 'Show Post Date?', 'nanotext' ),
            'description' => __( 'Select "Yes" to display post date in the carousel', 'nanotext' ),
            'param_name'  => 'show_date',
            'std'         => 'no',
            'value'       => array(
                __( 'Yes', 'nanotext' ) => 'yes',
                __( 'No', 'nanotext' ) => 'no'
            )
        ),

        array(
            'type'        => 'textfield',
            'heading'     => __( 'Date format', 'nanotext' ),
            'description' => __( 'Enter custom date format that will be shown', 'nanotext' ),
            'param_name'  => 'date_format',
            'dependency'  => array(
                'element' => 'show_date',
                'value'   => 'yes'
            ),
            'value'       => ''
        ),

        array(
            'type'        => 'dropdown',
            'heading'     => __( 'Show Post Excerpt?', 'nanotext' ),
            'description' => __( 'Select "Yes" to display post excerpt in the carousel', 'nanotext' ),
            'param_name'  => 'show_excerpt',
            'std'         => 'no',
            'value'       => array(
                __( 'Yes', 'nanotext' ) => 'yes',
                __( 'No', 'nanotext' ) => 'no'
            )
        ),

        array(
            'type'        => 'dropdown',
            'heading'     => __( 'Auto Post Excerpt?', 'nanotext' ),
            'description' => __( 'Select "Yes" to display automatic generate post excerpt', 'nanotext' ),
            'param_name'  => 'auto_excerpt',
            'dependency'  => array(
                'element' => 'show_excerpt',
                'value'   => 'yes'
            ),
            'std'         => 'no',
            'value'       => array(
                __( 'Yes', 'nanotext' ) => 'yes',
                __( 'No', 'nanotext' ) => 'no'
            )
        ),

        array(
            'type'        => 'textfield',
            'heading'     => __( 'Post excerpt length', 'nanotext' ),
            'description' => __( 'Enter the custom length of post excerpt that will be generated', 'nanotext' ),
            'param_name'  => 'excerpt_length',
            'dependency'  => array(
                'element' => 'auto_excerpt',
                'value'   => 'yes'
            ),
            'value'       => 200
        ),

        array(
            'type'       => 'dropdown',
            'heading'    => __( 'Read more', 'nanotext' ),
            'description' => __( 'Select "YES" to show the read more link', 'nanotext' ),
            'param_name' => 'readmore',
            'std'        => 'yes',
            'value'      => array(
                __( 'Yes', 'nanotext' ) => 'yes',
                __( 'No', 'nanotext' ) => 'no'
            )
        ),

        array(
            'type'        => 'textfield',
            'heading'     => __( 'Read more text', 'nanotext' ),
            'description' => __( 'Custom text for the read more link', 'nanotext' ),
            'param_name'  => 'readmore_text',
            'dependency'  => array(
                'element' => 'readmore',
                'value'   => 'yes'
            ),
            'value'       => __( 'Read More', 'nanotext' )
        ),

        array(
            'type'        => 'dropdown',
            'heading'     => __( 'Order By', 'nanotext' ),
            'description' => __( 'Select how to sort retrieved posts.', 'nanotext' ),
            'param_name'  => 'order',
            'std'         => 'date',
            'value'       => array(
                __( 'Date', 'nanotext' )          => 'date',
                __( 'ID', 'nanotext' )            => 'ID',
                __( 'Author', 'nanotext' )        => 'author',
                __( 'Title', 'nanotext' )         => 'title',
                __( 'Modified', 'nanotext' )      => 'modified',
                __( 'Random', 'nanotext' )        => 'rand',
                __( 'Comment count', 'nanotext' ) => 'comment_count',
                __( 'Menu order', 'nanotext' )    => 'menu_order'
            )
        ),

        array(
            'type'        => 'dropdown',
            'heading'     => __( 'Order Direction', 'nanotext' ),
            'description' => __( 'Designates the ascending or descending order.', 'nanotext' ),
            'param_name'  => 'direction',
            'std'         => 'DESC',
            'value'       => array(
                __( 'Ascending', 'nanotext' )          => 'ASC',
                __( 'Descending', 'nanotext' )            => 'DESC'
            )
        ),

        array(
            'type'        => 'textfield',
            'heading'     => __( 'Extra Class', 'nanotext' ),
            'description' => __( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'nanotext' ),
            'param_name'  => 'class'
        ),

        // Carousel Options
        array(
            'type'        => 'dropdown',
            'heading'     => __( 'Show Items', 'nanotext' ),
            'description' => __( 'The maximum amount of items displayed at a time', 'nanotext' ),
            'param_name'  => 'items',
            'group'       => __( 'Carousel Options', 'nanotext' ),
            'value'       => array_combine( range( 1, 6 ), range( 1, 6 ) ),
            'std'         => 4
        ),

        array(
            'type'       => 'dropdown',
            'heading'    => __( 'Autoplay?', 'nanotext' ),
            'param_name' => 'autoplay',
            'group'      => __( 'Carousel Options', 'nanotext' ),
            'std'        => 'yes',
            'value'      => array(
                __( 'Yes', 'nanotext' ) => 'yes',
                __( 'No', 'nanotext' ) => 'no'
            )
        ),

        array(
            'type'        => 'dropdown',
            'heading'     => __( 'Stop On Hover?', 'nanotext' ),
            'description' => __( 'Rewind speed in milliseconds', 'nanotext' ),
            'param_name'  => 'hover_stop',
            'group'       => __( 'Carousel Options', 'nanotext' ),
            'std'         => 'yes',
            'value'       => array(
                __( 'Yes', 'nanotext' ) => 'yes',
                __( 'No', 'nanotext' ) => 'no'
            )
        ),

        array(
            'type'        => 'checkbox',
            'heading'     => __( 'Slider Controls', 'nanotext' ),
            'param_name'  => 'controls',
            'group'       => __( 'Carousel Options', 'nanotext' ),
            'std'         => 'navigation,rewind-navigation,pagination,pagination-numbers',
            'value'       => array(
                __( 'Navigation', 'nanotext' )         => 'navigation',
                __( 'Rewind Navigation', 'nanotext' )  => 'rewind-navigation',
                __( 'Pagination', 'nanotext' )         => 'pagination',
                __( 'Pagination Numbers', 'nanotext' ) => 'pagination-numbers'
            )
        ),

        array(
            'type'       => 'dropdown',
            'heading'    => __( 'Scroll Per Page?', 'nanotext' ),
            'param_name' => 'scroll_page',
            'group'       => __( 'Carousel Options', 'nanotext' ),
            'std'        => 'yes',
            'value'      => array(
                __( 'Yes', 'nanotext' ) => 'yes',
                __( 'No', 'nanotext' ) => 'no'
            )
        ),

        array(
            'type'       => 'dropdown',
            'heading'    => __( 'Allow Mouse Drag?', 'nanotext' ),
            'param_name' => 'mouse_drag',
            'group'      => __( 'Carousel Options', 'nanotext' ),
            'std'        => 'yes',
            'value'      => array(
                __( 'Yes', 'nanotext' ) => 'yes',
                __( 'No', 'nanotext' ) => 'no'
            )
        ),

        array(
            'type'       => 'dropdown',
            'heading'    => __( 'Allow Touch Drag?', 'nanotext' ),
            'param_name' => 'touch_drag',
            'group'      => __( 'Carousel Options', 'nanotext' ),
            'std'        => 'yes',
            'value'      => array(
                __( 'Yes', 'nanotext' ) => 'yes',
                __( 'No', 'nanotext' ) => 'no'
            )
        ),

        array(
            'type'       => 'dropdown',
            'heading'    => __( 'Centered Slides?', 'nanotext' ),
            'param_name' => 'centered',
            'group'      => __( 'Carousel Options', 'nanotext' ),
            'std'        => 'no',
            'value'      => array(
                __( 'Yes', 'nanotext' ) => 'yes',
                __( 'No', 'nanotext' ) => 'no'
            )
        ),

        // Speed
        array(
            'type'        => 'textfield',
            'heading'     => __( 'Autoplay Speed', 'nanotext' ),
            'description' => __( 'Autoplay speed in milliseconds', 'nanotext' ),
            'param_name'  => 'autoplay_speed',
            'group'       => __( 'Speed', 'nanotext' ),
            'value'       => 5000
        ),

        array(
            'type'        => 'textfield',
            'heading'     => __( 'Slide Speed', 'nanotext' ),
            'description' => __( 'Slide speed in milliseconds', 'nanotext' ),
            'param_name'  => 'slide_speed',
            'group' => __( 'Speed', 'nanotext' ),
            'value'       => 200
        ),

        array(
            'type'        => 'textfield',
            'heading'     => __( 'Pagination Speed', 'nanotext' ),
            'description' => __( 'Pagination speed in milliseconds', 'nanotext' ),
            'param_name'  => 'pagination_speed',
            'group' => __( 'Speed', 'nanotext' ),
            'value'       => 200
        ),

        array(
            'type'        => 'textfield',
            'heading'     => __( 'Rewind Speed', 'nanotext' ),
            'description' => __( 'Rewind speed in milliseconds', 'nanotext' ),
            'param_name'  => 'rewind_speed',
            'group' => __( 'Speed', 'nanotext' ),
            'value'       => 200
        ),

        // Responsive
        array(
            'type'       => 'dropdown',
            'heading'    => __( 'Enable Responsive?', 'nanotext' ),
            'param_name' => 'responsive',
            'group'      => __( 'Responsive', 'nanotext' ),
            'std'        => 'yes',
            'value'      => array(
                __( 'Yes', 'nanotext' ) => 'yes',
                __( 'No', 'nanotext' ) => 'no'
            )
        ),

        array(
            'type'        => 'dropdown',
            'heading'     => __( 'Items On Tablet', 'nanotext' ),
            'description' => __( 'The maximum amount of items displayed at a time on tablet device', 'nanotext' ),
            'param_name'  => 'tablet_items',
            'group'       => __( 'Responsive', 'nanotext' ),
            'value'       => array_combine( range( 1, 6 ), range( 1, 6 ) ),
            'std'         => 2
        ),

        array(
            'type'        => 'dropdown',
            'heading'     => __( 'Items On Mobile', 'nanotext' ),
            'description' => __( 'The maximum amount of items displayed at a time on mobile device', 'nanotext' ),
            'param_name'  => 'mobile_items',
            'group'       => __( 'Responsive', 'nanotext' ),
            'value'       => array_combine( range( 1, 6 ), range( 1, 6 ) ),
            'std'         => 1
        ),

        array(
            'type' => 'css_editor',
            'param_name' => 'css',
            'group' => __( 'Design Options', 'nanotext' )
        )
    )
);
