<?php
defined( 'ABSPATH' ) or die();

add_filter( 'nanotext_customize_containers', 'nanotext_customize_projects_containers' );
add_filter( 'nanotext_customize_controls', 'nanotext_customize_projects_controls' );
add_filter( 'nanotext_customize_controls', 'nanotext_customize_single_project_controls' );
add_filter( 'nanotext_customize_controls', 'nanotext_customize_project_related' );
add_filter( 'nanotext_customize_settings', 'nanotext_customize_projects_settings' );


function nanotext_customize_projects_containers( $containers ) {
	$containers['projects'] = array(
		'type'        => 'panel',
		'title'       => esc_html__( 'Projects', 'nanotext' ),
		'description' => ''
	);

	$containers[ 'projectsList' ] = array(
		'type'  => 'section',
		'title'       => esc_html__( 'Project Archive', 'nanotext' ),
		'description' => '',
		'panel'       => 'projects'
	);

	$containers[ 'projectsSingle' ] = array(
		'type'  => 'section',
		'title'       => esc_html__( 'Project Single', 'nanotext' ),
		'description' => '',
		'panel'       => 'projects'
	);

	$containers[ 'projectsRelated' ] = array(
		'type'  => 'section',
		'title'       => esc_html__( 'Related Projects', 'nanotext' ),
		'description' => '',
		'panel'       => 'projects'
	);

	return $containers;
}


function nanotext_customize_projects_controls( $controls ) {
	$controls['projects__displayMode'] = array(
		'type'        => 'radio-buttons',
		'section'     => 'projectsList',
		'description' => esc_html__( 'Controls the layout for the projects pages.', 'nanotext' ),
		'choices'     => array(
			'grid-alt'  => esc_html__( 'Grid Titte', 'nanotext' ),
			'grid'      => esc_html__( 'Grid', 'nanotext' ),
			'masonry'   => esc_html__( 'Masonry', 'nanotext' )
		)
	);

	$controls['projects__gridColumns'] = array(
		'type'        => 'radio-buttons',
		'section'     => 'projectsList',
		'label'       => esc_html__( 'Grid Columns', 'nanotext' ),
		'choices'     => array( 2 => 2, 3 => 3, 4 => 4, 5 => 5 )
	);
	$controls['projects__gridGutter'] = array(
		'type'        => 'textfield',
		'section'     => 'projectsList',
		'label'       => esc_html__( 'Grid Column Spacing (px)', 'nanotext' ),
	);
	$controls['projects__imagesize'] = array(
		'type'        => 'textfield',
		'section'     => 'projectsList',
		'label' => esc_html__( 'Image Size', 'nanotext' ),
		'description' => esc_html__( 'Enter image size. Example: "thumbnail", "medium", "large", "full" or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use "thumbnail" size.', 'nanotext' )
	);
	$controls['projects__imagesizeCrop'] = array(
		'type'        => 'radio-buttons',
		'section'     => 'projectsList',
		'choices'     => array(
			'crop' => esc_html__('Hard Crop', 'nanotext'),
			'none' => esc_html__('None', 'nanotext')
		)
	);

	$controls['projects__filterable'] = array(
		'type'        => 'radio-onoff',
		'section'     => 'projectsList',
		'label'       => esc_html__( 'Enable Projects Filterable', 'nanotext' ),
	);
	$controls['projects__filterableType'] = array(
		'type'        => 'radio-buttons',
		'section'     => 'projectsList',
		'label'       => esc_html__( 'Filterable Type', 'nanotext' ),
		'choices'     => array(
			'nproject-tag'      => esc_html__( 'Tag', 'nanotext' ),
			'nproject-category' => esc_html__( 'Category', 'nanotext' )
		)
	);
	$controls['projects__filterableAlign'] = array(
		'type'        => 'radio-buttons',
		'section'     => 'projectsList',
		'label'       => _x( 'Filterable Alignment', 'customize', 'nanotext' ),
		'description' => _x( '', 'customize', 'nanotext' ),
		'choices'     => array(
			'left'    => _x( 'Left', 'customize', 'nanotext' ),
			'center'  => _x( 'Center', 'customize', 'nanotext' ),
			'right'   => _x( 'Right', 'customize', 'nanotext' )
		)
	);

	$controls['projects__excerpt'] = array(
		'type'        => 'radio-onoff',
		'section'     => 'projectsList',
		'label'       => esc_html__( 'Show Summary Text', 'nanotext' ),
	);
	$controls['projects__autoExcerptLength'] = array(
		'type'        => 'textfield',
		'section'     => 'projectsList',
		'label'       => esc_html__( 'Summary Text Length', 'nanotext' ),
	);

	$controls['projects__readmore'] = array(
		'type'        => 'radio-onoff',
		'section'     => 'projectsList',
		'label'       => esc_html__( 'Show Readmore Button', 'nanotext' ),
	);


	// Sidebar section
	$controls['projects__sidebarHeading'] = array(
		'type'        => 'heading',
		'section'     => 'projectsList',
		'label'       => esc_html__( 'Sidebar', 'nanotext' ),
	);
	$controls['projects__sidebar'] = array(
		'type'        => 'dropdown',
		'section'     => 'projectsList',
		'choices'     => 'nanotext_customize_dropdown_sidebars'
	);

	$controls['projects__sidebarPosition'] = array(
		'type'    => 'radio-buttons',
		'section' => 'projectsList',
		'label'   => esc_html__( 'Sidebar Position', 'nanotext' ),
		'choices' => array(
			'none'  => esc_html__( 'No Sidebar', 'nanotext' ),
			'left'  => esc_html__( 'Left', 'nanotext' ),
			'right' => esc_html__( 'Right', 'nanotext' )
		)
	);

	$controls['project__page__title'] = array(
		'type'    => 'textfield',
		'label'   => esc_html__( 'Archive Page Title', 'nanotext' ),
		'section' => 'projectsList',
		'default' => esc_html__( 'Project', 'nanotext' )
	);

	return $controls;
}


function nanotext_customize_single_project_controls( $controls ) {
	$controls['project__pagination'] = array(
		'type'        => 'radio-onoff',
		'section'     => 'projectsSingle',
		'label'       => esc_html__( 'Show Post Navigator', 'nanotext' ),
	);
	$controls['project__author'] = array(
		'type'        => 'radio-onoff',
		'section'     => 'projectsSingle',
		'label'       => esc_html__( 'Show Post Author', 'nanotext' ),
	);
	$controls['project__tags'] = array(
		'type'        => 'radio-onoff',
		'section'     => 'projectsSingle',
		'label'       => esc_html__( 'Show Project Tags', 'nanotext' ),
	);
	$controls['project__related'] = array(
		'type'        => 'radio-onoff',
		'section'     => 'projectsSingle',
		'label'       => esc_html__( 'Show Related Posts', 'nanotext' ),
	);
	$controls['project__galerryMode'] = array(
		'type'        => 'radio-buttons',
		'section'     => 'projectsSingle',
		'label'       => esc_html__( 'Gallery Styles', 'nanotext' ),
		'choices'     => array(
			'list'   => esc_html__( 'List', 'nanotext' ),
			'slider' => esc_html__( 'Slider', 'nanotext' ),
			'grid'   => esc_html__( 'Grid', 'nanotext' )
		)
	);

	$controls['project__galleryColumns'] = array(
		'type'        => 'radio-buttons',
		'section'     => 'projectsSingle',
		'label'       => esc_html__( 'Gallery Columns', 'nanotext' ),
		'choices'     => array(
			2 => 2,
			3 => 3,
			4 => 4,
			5 => 5,
		)
	);
	$controls['project__galleryPosition'] = array(
		'type'        => 'radio-buttons',
		'section'     => 'projectsSingle',
		'label'       => esc_html__( 'Gallery Position', 'nanotext' ),
		'choices'     => array(
			'top'    => esc_html__( 'Top', 'nanotext' ),
			'right'  => esc_html__( 'Right', 'nanotext' ),
			'bottom' => esc_html__( 'Bottom', 'nanotext' ),
			'left'   => esc_html__( 'Left', 'nanotext' )
		)
	);

	// Sidebar section
	$controls['project__sidebarHeading'] = array(
		'type'        => 'heading',
		'section'     => 'projectsSingle',
		'label'       => esc_html__( 'Sidebar', 'nanotext' ),
	);
	$controls['project__sidebar'] = array(
		'type'        => 'dropdown',
		'section'     => 'projectsSingle',
		'choices'     => 'nanotext_customize_dropdown_sidebars'
	);

	$controls['project__sidebarPosition'] = array(
		'type'    => 'radio-buttons',
		'section' => 'projectsSingle',
		'label'   => esc_html__( 'Sidebar Position', 'nanotext' ),
		'choices' => array(
			'none'  => esc_html__( 'No Sidebar', 'nanotext' ),
			'left'  => esc_html__( 'Left', 'nanotext' ),
			'right' => esc_html__( 'Right', 'nanotext' )
		)
	);

	return $controls;
}


function nanotext_customize_projects_settings( $settings ) {
	$settings['projects__displayMode']     = array( 'default' => 'grid' );
	$settings['projects__gridColumns']     = array( 'default' => 3 );
	$settings['projects__gridGutter']      = array( 'default' => 20 );
	$settings['projects__imagesize']       = array( 'default' => 'full' );
	$settings['projects__imagesizeCrop']   = array( 'default' => 'crop' );
	
	$settings['projects__filterable']        = array( 'default' => 'on' );
	$settings['projects__filterableAlign']   = array( 'default' => 'left' );
	$settings['projects__filterableType']    = array( 'default' => 'nproject-tag' );
	$settings['projects__excerpt']           = array( 'default' => 'on' );
	$settings['projects__autoExcerpt']       = array( 'default' => 'on' );
	$settings['projects__autoExcerptLength'] = array( 'default' => '12' );
	$settings['projects__readmore']          = array( 'default' => 'on' );
	$settings['projects__sidebar']           = array( 'default' => 'primary' );
	$settings['projects__sidebarPosition']   = array( 'default' => 'right' );

	$settings['project__pagination']      = array( 'default' => 'on' );
	$settings['project__author']          = array( 'default' => 'on' );
	$settings['project__related']         = array( 'default' => 'on' );
	$settings['project__galerryMode']     = array( 'default' => 'grid' );
	$settings['project__galleryColumns']  = array( 'default' => 3 );
	$settings['project__galleryPosition'] = array( 'default' => 'top' );
	$settings['project__sidebar']         = array( 'default' => 'primary' );
	$settings['project__sidebarPosition'] = array( 'default' => 'left' );
	$settings['project__tags']            = array( 'default' => 'on' );

	$settings['project__related__title']            = array( 'default' => 'Related Posts' );
	$settings['project__related__count']            = array( 'default' => '4' );
	$settings['projects__related__gridColumns']     = array( 'default' => 4 );
	$settings['project__related__type']             = array( 'default' => 'category' );

	return $settings;
}

function nanotext_customize_project_related( $controls ) {
	$controls['project__related__title'] = array(
		'type'    => 'textfield',
		'label'   => esc_html__( 'Widget Title', 'nanotext' ),
		'section' => 'projectsRelated',
		'default' => esc_html__( 'Related Projects', 'nanotext' )
	);

	$controls['project__related__count'] = array(
		'type'    => 'textfield',
		'label'   => esc_html__( 'Number of Related Projects', 'nanotext' ),
		'section' => 'projectsRelated',
		'default' => esc_html__( '4', 'nanotext' )
	);

	$controls['projects__related__gridColumns'] = array(
		'type'        => 'radio-buttons',
		'section'     => 'projectsRelated',
		'label'       => esc_html__( 'Grid Columns', 'nanotext' ),
		'choices'     => array( 2 => 2, 3 => 3, 4 => 4, 5 => 5 )
	);

	$controls['project__related__type'] = array(
		'type' => 'dropdown',
		'section' => 'projectsRelated',
		'label' => esc_html__( 'Show Related Projects Based On', 'nanotext' ),
		'default' => 'tag',
		'choices' => array(
			'tag'      => esc_html__( 'Tag', 'nanotext' ),
			'category' => esc_html__( 'Category', 'nanotext' ),
			'random'   => esc_html__( 'Random', 'nanotext' ),
			'recent'   => esc_html__( 'Recent', 'nanotext' )
		)
	);

	return $controls;
}
