<?php
defined( 'ABSPATH' ) or die();


/**
 * The helper function to generate controls definition
 * for the branding section
 * 
 * @param   array  $controls   The controls list
 * @param   array  $args       The arguments to generate the controls
 * 
 * @return  array
 * @since   1.0.0
 */
function nanotext_customize_generate_branding_controls( array &$controls, array $args ) {
	$args = array_replace_recursive( array(
			'prefix'  => '',
			'section' => false,
			'heading' => false
		), $args );

	if ( is_array( $args['heading'] ) ) {
		$controls[ $args['prefix'] . 'logoHeading' ] = array(
			'type'        => 'heading',
			'section'     => $args['section'],
			'label'       => $args['heading']['label'],
			'description' => $args['heading']['description']
		);
	}

	$controls[ $args['prefix'] . 'logo'] = array(
		'type'        => 'media-picker',
		'section'     => $args['section'],
		'label'       => esc_html__( 'Logo', 'nanotext' ),
	);
	$controls[ $args['prefix'] . 'logoRetina'] = array(
		'type'        => 'media-picker',
		'section'     => $args['section'],
		'label'       => esc_html__( 'Logo Retina', 'nanotext' ),
	);
	$controls[ $args['prefix'] . 'logoSize'] = array(
		'type'        => 'dimension',
		'section'     => $args['section'],
		'label'       => esc_html__( 'Logo Size', 'nanotext' ),
		'choices'     => array(
			'width'   => esc_html__( 'Width', 'nanotext' ),
			'height'  => esc_html__( 'Height', 'nanotext' )
		)
	);
	
	return $controls;
}


/**
 * The helper function to generate controls definition
 * for the background section
 * 
 * @param   array  $controls   The controls list
 * @param   array  $args       The arguments to generate the controls
 * 
 * @since   1.0.0
 */
function nanotext_customize_generate_background_controls( array &$controls, array $args ) {
	$args = array_replace_recursive( array(
			'prefix'  => '',
			'section' => false,
			'heading' => false
		), $args );

	if ( is_array( $args['heading'] ) ) {
		$controls[ $args['prefix'] . 'backgroundHeading' ] = array(
			'type'        => 'heading',
			'section'     => $args['section'],
			'label'       => $args['heading']['label'],
			'description' => $args['heading']['description']
		);
	}

	// Adding the controls
	$controls[ $args['prefix'] . 'backgroundImage'] = array(
		'type'        => 'media-picker',
		'section'     => $args['section'],
		'label'       => esc_html__( 'Image', 'nanotext' ),
		'description' => esc_html__( 'Select an image for the background. If left empty, the background color will be used.', 'nanotext' )
	);
	$controls[ $args['prefix'] . 'backgroundColor'] = array(
		'type'        => 'color-picker',
		'section'     => $args['section'],
		'label'       => esc_html__( 'Color', 'nanotext' ),
		'description' => esc_html__( 'Select the color you want to use for the background.', 'nanotext' )
	);
	$controls[ $args['prefix'] . 'backgroundRepeat'] = array(
		'type'    => 'dropdown',
		'section' => $args['section'],
		'label'   => esc_html__( 'Repeat', 'nanotext' ),
		'choices' => array(
			'no-repeat' => esc_html__( 'No Repeat', 'nanotext' ),
			'repeat-x'  => esc_html__( 'Repeat X', 'nanotext' ),
			'repeat-y'  => esc_html__( 'Repeat Y', 'nanotext' ),
			'repeat'    => esc_html__( 'Repeat Both', 'nanotext' )
		)
	);
	$controls[ $args['prefix'] . 'backgroundPosition'] = array(
		'type'    => 'dropdown',
		'section' => $args['section'],
		'label'   => esc_html__( 'Position', 'nanotext' ),
		'choices' => array(
			'top left'      => esc_html__( 'Top Left', 'nanotext' ),
			'top center'    => esc_html__( 'Top Center', 'nanotext' ),
			'top right'     => esc_html__( 'Top Right', 'nanotext' ),
			'center left'   => esc_html__( 'Center Left', 'nanotext' ),
			'center center' => esc_html__( 'Center Center', 'nanotext' ),
			'center right'  => esc_html__( 'Center Right', 'nanotext' ),
			'bottom left'   => esc_html__( 'Bottom Left', 'nanotext' ),
			'bottom center' => esc_html__( 'Bottom Center', 'nanotext' ),
			'bottom right'  => esc_html__( 'Bottom Right', 'nanotext' ),
			'custom'        => esc_html__( 'Custom Position', 'nanotext' )
		)
	);
	$controls[ $args['prefix'] . 'backgroundOffset'] = array(
		'type'    => 'dimension',
		'section' => $args['section'],
		'label'   => esc_html__( 'Custom Position', 'nanotext' ),
		'depends' => array(
			$args['prefix'] . 'backgroundPosition' => array( 'equals', 'custom' )
		),
		'fields'  => array(
			'x' => esc_html__( 'Position X', 'nanotext' ),
			'y' => esc_html__( 'Position Y', 'nanotext' )
		)
	);
	$controls[ $args['prefix'] . 'backgroundAttachment'] = array(
		'type'    => 'dropdown',
		'section' => $args['section'],
		'label'   => esc_html__( 'Attachment', 'nanotext' ),
		'choices' => array(
			'fixed'      => esc_html__( 'Fixed', 'nanotext' ),
			'scroll'     => esc_html__( 'Scroll', 'nanotext' )
		)
	);
	$controls[ $args['prefix'] . 'backgroundSize'] = array(
		'type'    => 'dropdown',
		'section' => $args['section'],
		'label'   => esc_html__( 'Size', 'nanotext' ),
		'choices' => array(
			'auto'       => esc_html__( 'Auto', 'nanotext' ),
			'cover'      => esc_html__( 'Cover', 'nanotext' ),
			'contain'    => esc_html__( 'Contain', 'nanotext' ),
			'fit-width'  => esc_html__( '100% Width', 'nanotext' ),
			'fit-height' => esc_html__( '100% Height', 'nanotext' ),
			'stretch'    => esc_html__( 'Stretch', 'nanotext' ),
			'custom'    => esc_html__( 'Custom', 'nanotext' )
		)
	);

	$controls[ $args['prefix'] . 'backgroundCustomSize'] = array(
		'type'    => 'dimension',
		'section' => $args['section'],
		'label'   => esc_html__( 'Size', 'nanotext' ),
		'depends' => array( $args['prefix'] . 'backgroundSize' => array( 'equals', 'custom' ) ),
		'fields'  => array(
			'width'  => esc_html__( 'Width', 'nanotext' ),
			'height' => esc_html__( 'Height', 'nanotext' )
		)
	);
}


/**
 * The helper function to generate controls definition
 * for the typography section
 * 
 * @param   array  $controls   The controls list
 * @param   array  $args       The arguments to generate the controls
 * 
 * @return  array
 * @since   1.0.0
 */
function nanotext_customize_generate_typography_controls( &$controls, $args ) {

}


/**
 * Retrieve the menu list for using as the menu dropdown
 * 
 * @return  array
 * @since   1.0.0
 */
function nanotext_customize_dropdown_menus() {
	$menus   = wp_get_nav_menus();
	$choices = array( 0 => esc_html__( '-- Select Menu --', 'nanotext' ) );
	$choices = array_merge( $choices, wp_list_pluck( $menus, 'name', 'term_id' ) );

	return $choices;
}


/**
 * Return an array of sidebars that will be use for
 * the dropdown in the theme options
 * 
 * @return  array
 */
function nanotext_customize_dropdown_sidebars() {
	global $wp_registered_sidebars;
	static $sidebars;

	if ( empty( $sidebars ) ) {
		$sidebars = array();

		foreach ( $wp_registered_sidebars as $sidebar ) {
			if ( $sidebar['id'] == 'wp_inactive_widgets' || strpos( $sidebar['id'], 'orphaned_widgets' ) !== false )
				continue;
			
			$sidebars[$sidebar['id']] = $sidebar['name'];
		}
	}
	
	return $sidebars;
}


function nanotext_customize_post_types_options() {
	$post_types = get_post_types( array( 'public' => true ), 'objects' );

	return wp_list_pluck(
		$post_types,
		'label',
		'name'
	);
}
