<?php
defined( 'ABSPATH' ) or die();

add_filter( 'nanotext_customize_containers', 'nanotext_customize_header_containers' );
add_filter( 'nanotext_customize_controls', 'nanotext_customize_header_controls' );
add_filter( 'nanotext_customize_settings', 'nanotext_customize_header_settings' );

function nanotext_customize_header_containers( $containers ) {
	$containers['headerAndFooter'] = array(
		'type'        => 'panel',
		'title'       => _x( 'Header & Footer Builder', 'customize', 'nanotext' ),
		'description' => _x( 'Controls the settings for customizing the header and footer styles', 'customize', 'nanotext' )
	);

	$containers['headerGeneral'] = array(
		'type'        => 'section',
		'panel'       => 'headerAndFooter',
		'title'       => _x( 'General', 'customize', 'nanotext' ),
		'parent'      => _x( 'Header Settings', 'customize', 'nanotext' ),
		'description' => _x( 'Controls the general settings for the header.', 'customize', 'nanotext' ),
		'heading'     => array(
			'title'       => esc_html__( 'Header Settings', 'nanotext' ),
		)
	);
	$containers['headerTopbar'] = array(
		'type'        => 'section',
		'panel'       => 'headerAndFooter',
		'title'       => _x( 'Topbar Settings', 'customize', 'nanotext' ),
		'parent'      => _x( 'Header Settings', 'customize', 'nanotext' ),
		'description' => _x( 'Configure the settings for the header topbar area.', 'customize', 'nanotext' )
	);
	$containers['headerNavigator'] = array(
		'type'        => 'section',
		'panel'       => 'headerAndFooter',
		'title'       => _x( 'Navigation Bar', 'customize', 'nanotext' ),
		'parent'      => _x( 'Header Settings', 'customize', 'nanotext' ),
		'description' => _x( 'Configure the settings for the header navigation bar area.', 'customize', 'nanotext' )
	);

	$containers['headerTitle'] = array(
		'type'        => 'section',
		'panel'       => 'headerAndFooter',
		'title'       => _x( 'Title Bar', 'customize', 'nanotext' ),
		'parent'      => _x( 'Header Settings', 'customize', 'nanotext' )
	);

	$containers['headerSticky'] = array(
		'type'        => 'section',
		'panel'       => 'headerAndFooter',
		'title'       => _x( 'General Settings', 'customize', 'nanotext' ),
		'description' => _x( 'Configure the settings for the sticky header.', 'customize', 'nanotext' ),
		'heading'     => array(
			'title'       => esc_html__( 'Header Sticky Setting', 'nanotext' ),
		)
	);
	$containers['headerStickyNav'] = array(
		'type'        => 'section',
		'panel'       => 'headerAndFooter',
		'title'       => _x( 'Navigation Bar', 'customize', 'nanotext' ),
		'description' => _x( '', 'customize', 'nanotext' )
	);

	return $containers;
}

function nanotext_customize_header_controls( $controls ) {
	$controls['header__position'] = array(
		'type'        => 'radio-buttons',
		'section'     => 'headerGeneral',
		'label'       => _x( 'Header Position', 'customize', 'nanotext' ),
		'description' => _x( '', 'customize', 'nanotext' ),
		'choices'     => array(
			'top'   => _x( 'Top', 'customize', 'nanotext' ),
			'right' => _x( 'Right', 'customize', 'nanotext' ),
			'bottom' => _x( 'Bottom', 'customize', 'nanotext' ),
			'left' => _x( 'Left', 'customize', 'nanotext' )
		)
	);

	/**
	 * The logo profile
	 */
	$controls['header__logo'] = array(
		'type'        => 'dropdown',
		'section'     => 'headerGeneral',
		'label'       => _x( 'logo that will be shown', 'customize', 'nanotext' ),
		'description' => _x( '', 'customize', 'nanotext' ),
		'choices'     => array(
			'logoDefault' => _x( 'Logo Default', 'customize', 'nanotext' ),
			'logoDark'    => _x( 'Logo Dark', 'customize', 'nanotext' ),
			'logoLight'   => _x( 'Logo Light', 'customize', 'nanotext' )
		)
	);
	$controls['header__logoAlign'] = array(
		'type'        => 'radio-buttons',
		'section'     => 'headerGeneral',
		'label'       => _x( 'Logo Alignment', 'customize', 'nanotext' ),
		'description' => _x( '', 'customize', 'nanotext' ),
		'choices'     => array(
			'left'   => _x( 'Left', 'customize', 'nanotext' ),
			'center' => _x( 'Center', 'customize', 'nanotext' ),
			'right'  => _x( 'Right', 'customize', 'nanotext' )
		)
	);
	$controls[ 'header__logoMargin'] = array(
		'type'        => 'dimension',
		'section'     => 'headerGeneral',
		'label'       => esc_html__( 'Logo Margin (px)', 'nanotext' ),
		'choices'     => array(
			'margin-top'    => esc_html__( 'Top', 'nanotext' ),
			'margin-right'  => esc_html__( 'Right', 'nanotext' ),
			'margin-bottom' => esc_html__( 'Bottom', 'nanotext' ),
			'margin-left'   => esc_html__( 'Left', 'nanotext' )
		)
	);

	/**
	 * Header Settings
	 */
	$controls['header__height'] = array(
		'type'        => 'textfield',
		'section'     => 'headerGeneral',
		'label'       => _x( 'Header Height', 'customize', 'nanotext' ),
		'description' => _x( '', 'customize', 'nanotext' )
	);
	$controls['header__width'] = array(
		'type'        => 'radio-onoff',
		'section'     => 'headerGeneral',
		'label'       => _x( '100% Header Full Width', 'customize', 'nanotext' ),
		'description' => _x( '', 'customize', 'nanotext' )
	);
	$controls['header__shadow'] = array(
		'type'        => 'radio-onoff',
		'section'     => 'headerGeneral',
		'label'       => esc_html__( 'Enable Shadow', 'nanotext' ),
	);
	$controls['header__transparent'] = array(
		'type'        => 'radio-onoff',
		'section'     => 'headerGeneral',
		'label'       => esc_html__( 'Enable Header Transparent', 'nanotext' ),
	);

	$controls['header__border'] = array(
		'type'        => 'radio-onoff',
		'section'     => 'headerGeneral',
		'label'       => esc_html__( 'Header Border', 'nanotext' ),
	);
	$controls[ 'header__border__options'] = array(
		'type'        => 'border',
		'section'     => 'headerGeneral',
		'choices'     => array(
			'top'    => esc_html__( 'Top', 'nanotext' ),
			'right'  => esc_html__( 'Right', 'nanotext' ),
			'bottom' => esc_html__( 'Bottom', 'nanotext' ),
			'left'   => esc_html__( 'Left', 'nanotext' )
		)
	);

	$controls['header__backgroundHeading'] = array(
		'type'        => 'heading',
		'section'     => 'headerGeneral',
		'label'       => _x( 'Header Background', 'customize', 'nanotext' ),
		'description' => _x( '', 'customize', 'nanotext' )
	);
	$controls['header__background'] = array(
		'type'        => 'background',
		'section'     => 'headerGeneral'
	);

	$controls['header__info__text'] = array(
		'type'        => 'textareafield',
		'section'     => 'headerGeneral',
		'label'       => _x( 'Contact Info', 'customize', 'nanotext' ),
		'description' => _x( '', 'customize', 'nanotext' )
	);


	/**
	 * Topbar Settings
	 */
	$controls['header__topbar'] = array(
		'type'        => 'radio-onoff',
		'section'     => 'headerTopbar',
		'label'       => _x( 'Enable Topbar', 'customize', 'nanotext' ),
		'description' => _x( '', 'customize', 'nanotext' )
	);
	$controls['header__topbar__height'] = array(
		'type'        => 'text',
		'section'     => 'headerTopbar',
		'label'       => _x( 'Topbar Height', 'customize', 'nanotext' ),
		'description' => _x( '', 'customize', 'nanotext' )
	);

	// Topbar content
	$controls['header__topbar__text'] = array(
		'type'        => 'textareafield',
		'section'     => 'headerTopbar',
		'label'       => _x( 'Topbar Content', 'customize', 'nanotext' ),
		'description' => _x( '', 'customize', 'nanotext' )
	);

	$controls['header__topbar__typoHeading'] = array(
		'type'        => 'heading',
		'section'     => 'headerTopbar',
		'label'       => esc_html__( 'Topbar Font', 'nanotext' ),
	);
	$controls['header__topbar__typography'] = array(
		'type'        => 'typography',
		'section'     => 'headerTopbar'
	);
	$controls['header__topbar__colors'] = array(
		'type'        => 'colors',
		'section'     => 'headerTopbar',
		'label'       => esc_html__( 'Topbar Link Colors', 'nanotext' ),
		'choices'     => array(
			'menu'        => esc_html__( 'Link Color', 'nanotext' ),
			'menu-hover'  => esc_html__( 'Hover Color', 'nanotext' ),
			'menu-active' => esc_html__( 'Active Color', 'nanotext' )
		)
	);

	$controls['header__topbar__backgroundHeading'] = array(
		'type'        => 'heading',
		'section'     => 'headerTopbar',
		'label'       => _x( 'Topbar Background', 'customize', 'nanotext' ),
		'description' => _x( '', 'customize', 'nanotext' )
	);
	$controls['header__topbar__background'] = array(
		'type'        => 'background',
		'section'     => 'headerTopbar'
	);


	/**
	 * Navigation Bar Settings
	 */
	$controls['header__nav__typography'] = array(
		'type'        => 'typography',
		'section'     => 'headerNavigator',
		'label'       => esc_html__( 'Menu Font', 'nanotext' ),
	);
	$controls['header__nav__colors'] = array(
		'type'        => 'colors',
		'section'     => 'headerNavigator',
		'label'       => esc_html__( 'Menu Colors', 'nanotext' ),
		'choices'     => array(
			'menu'        => esc_html__( 'Menu Color', 'nanotext' ),
			'menu-hover'  => esc_html__( 'Hover Color', 'nanotext' ),
			'menu-active' => esc_html__( 'Active Color', 'nanotext' )
		)
	);
	$controls[ 'header__nav__margin'] = array(
		'type'        => 'dimension',
		'section'     => 'headerNavigator',
		'label'       => esc_html__( 'Menu Margin', 'nanotext' ),
		'choices'     => array(
			'margin-top'    => esc_html__( 'Top', 'nanotext' ),
			'margin-right'  => esc_html__( 'Right', 'nanotext' ),
			'margin-bottom' => esc_html__( 'Bottom', 'nanotext' ),
			'margin-left'   => esc_html__( 'Left', 'nanotext' )
		)
	);
	$controls['header__nav__padding'] = array(
		'type'        => 'dimension',
		'section'     => 'headerNavigator',
		'label'       => esc_html__( 'Menu Padding', 'nanotext' ),
		'choices'     => array(
			'padding-top'    => esc_html__( 'Top', 'nanotext' ),
			'padding-right'  => esc_html__( 'Right', 'nanotext' ),
			'padding-bottom' => esc_html__( 'Bottom', 'nanotext' ),
			'padding-left'   => esc_html__( 'Left', 'nanotext' )
		)
	);
	$controls['header__nav__extras'] = array(
		'type'        => 'checkboxes',
		'section'     => 'headerNavigator',
		'label'       => esc_html__( 'Show Extra Items On The Header', 'nanotext' ),
		'choices'     => array(
			'cart'      => _x( 'Shopping Cart', 'customize', 'nanotext' ),
			'search'    => _x( 'Search Box', 'customize', 'nanotext' )
		)
	);

	$controls['header__nav__backgroundHeading'] = array(
		'type'        => 'heading',
		'section'     => 'headerNavigator',
		'label'       => _x( 'Navigator Background', 'customize', 'nanotext' ),
		'description' => _x( '', 'customize', 'nanotext' )
	);
	$controls['header__nav__background'] = array(
		'type'        => 'background',
		'section'     => 'headerNavigator'
	);

	$controls['header__nav__text'] = array(
		'type'        => 'textareafield',
		'section'     => 'headerNavigator',
		'label'       => _x( 'Navigator Info', 'customize', 'nanotext' ),
		'description' => _x( '', 'customize', 'nanotext' )
	);

	/**
	 * Sticky Header Settings
	 */
	$controls['header__sticky'] = array(
		'type'        => 'radio-onoff',
		'section'     => 'headerSticky',
		'label'       => _x( 'Enable Sticky Header', 'customize', 'nanotext' ),
		'description' => _x( '', 'customize', 'nanotext' ),
		'default'     => 'on'
	);
	$controls['header__sticky__logo'] = array(
		'type'        => 'dropdown',
		'section'     => 'headerSticky',
		'label'       => _x( 'logo that will be shown', 'customize', 'nanotext' ),
		'description' => _x( '', 'customize', 'nanotext' ),
		'choices'     => array(
			'logoDefault' => _x( 'Logo Default', 'customize', 'nanotext' ),
			'logoDark'    => _x( 'Logo Dark', 'customize', 'nanotext' ),
			'logoLight'   => _x( 'Logo Light', 'customize', 'nanotext' )
		)
	);
	$controls['header__sticky__logoAlign'] = array(
		'type'        => 'radio-buttons',
		'section'     => 'headerSticky',
		'label'       => _x( 'Logo Alignment', 'customize', 'nanotext' ),
		'description' => _x( '', 'customize', 'nanotext' ),
		'choices'     => array(
			'left'   => _x( 'Left', 'customize', 'nanotext' ),
			'center' => _x( 'Center', 'customize', 'nanotext' ),
			'right'  => _x( 'Right', 'customize', 'nanotext' )
		)
	);
	$controls[ 'header__sticky__logoMargin'] = array(
		'type'        => 'dimension',
		'section'     => 'headerSticky',
		'label'       => esc_html__( 'Logo Margin', 'nanotext' ),
		'choices'     => array(
			'margin-top'    => esc_html__( 'Top', 'nanotext' ),
			'margin-right'  => esc_html__( 'Right', 'nanotext' ),
			'margin-bottom' => esc_html__( 'Bottom', 'nanotext' ),
			'margin-left'   => esc_html__( 'Left', 'nanotext' )
		)
	);

	/**
	 * Header Settings
	 */
	$controls['header__sticky__height'] = array(
		'type'        => 'textfield',
		'section'     => 'headerSticky',
		'label'       => _x( 'Header Sticky Height', 'customize', 'nanotext' ),
		'description' => _x( '', 'customize', 'nanotext' )
	);
	$controls['header__sticky__width'] = array(
		'type'        => 'radio-onoff',
		'section'     => 'headerSticky',
		'label'       => _x( '100% Full Width', 'customize', 'nanotext' ),
		'description' => _x( '', 'customize', 'nanotext' )
	);
	
	$controls['header__sticky__shadow'] = array(
		'type'        => 'radio-onoff',
		'section'     => 'headerSticky',
		'label'       => esc_html__( 'Enable Shadow', 'nanotext' ),
	);

	$controls['header__sticky__border'] = array(
		'type'        => 'radio-onoff',
		'section'     => 'headerSticky',
		'label'       => esc_html__( 'Header Sticky Border', 'nanotext' ),
	);
	$controls[ 'header__sticky__border__options'] = array(
		'type'        => 'border',
		'section'     => 'headerSticky',
		'choices'     => array(
			'top'    => esc_html__( 'Top', 'nanotext' ),
			'right'  => esc_html__( 'Right', 'nanotext' ),
			'bottom' => esc_html__( 'Bottom', 'nanotext' ),
			'left'   => esc_html__( 'Left', 'nanotext' )
		)
	);

	$controls['header__sticky__backgroundHeading'] = array(
		'type'        => 'heading',
		'section'     => 'headerSticky',
		'label'       => _x( 'Header Sticky Background', 'customize', 'nanotext' ),
		'description' => _x( '', 'customize', 'nanotext' )
	);
	$controls['header__sticky__background'] = array(
		'type'        => 'background',
		'section'     => 'headerSticky'
	);

	$controls['header__sticky__nav__typography'] = array(
		'type'        => 'typography',
		'section'     => 'headerStickyNav',
		'label'       => esc_html__( 'Menu Sticky Font', 'nanotext' ),
	);
	$controls['header__sticky__nav__colors'] = array(
		'type'        => 'colors',
		'section'     => 'headerStickyNav',
		'label'       => esc_html__( 'Menu Sticky Colors', 'nanotext' ),
		'choices'     => array(
			'menu'        => esc_html__( 'Menu Color', 'nanotext' ),
			'menu-hover'  => esc_html__( 'Hover Color', 'nanotext' ),
			'menu-active' => esc_html__( 'Active Color', 'nanotext' )
		)
	);
	$controls[ 'header__sticky__nav__margin'] = array(
		'type'        => 'dimension',
		'section'     => 'headerStickyNav',
		'label'       => esc_html__( 'Menu Sticky Margin', 'nanotext' ),
		'choices'     => array(
			'margin-top'    => esc_html__( 'Top', 'nanotext' ),
			'margin-right'  => esc_html__( 'Right', 'nanotext' ),
			'margin-bottom' => esc_html__( 'Bottom', 'nanotext' ),
			'margin-left'   => esc_html__( 'Left', 'nanotext' )
		)
	);
	$controls['header__sticky__nav__padding'] = array(
		'type'        => 'dimension',
		'section'     => 'headerStickyNav',
		'label'       => esc_html__( 'Menu Sticky Padding', 'nanotext' ),
		'choices'     => array(
			'padding-top'    => esc_html__( 'Top', 'nanotext' ),
			'padding-right'  => esc_html__( 'Right', 'nanotext' ),
			'padding-bottom' => esc_html__( 'Bottom', 'nanotext' ),
			'padding-left'   => esc_html__( 'Left', 'nanotext' )
		)
	);


	/**
	 * Title bar
	 */
	$controls['header__titlebar'] = array(
		'type'        => 'dropdown',
		'section'     => 'headerTitle',
		'label'       => _x( 'Title Bar Displays', 'customize', 'nanotext' ),
		'description' => _x( '', 'customize', 'nanotext' ),
		'choices'     => array(
			'both'        => _x( 'Page Title and Breadcrumbs', 'customize', 'nanotext' ),
			'title'       => _x( 'Page Title Only', 'customize', 'nanotext' ),
			'breadcrumbs' => _x( 'Breadcrumbs Only', 'customize', 'nanotext' ),
			'none'        => _x( 'None', 'customize', 'nanotext' )
		)
	);
	$controls['header__titlebar__align'] = array(
		'type'        => 'radio-buttons',
		'section'     => 'headerTitle',
		'label'       => _x( 'Title Bar Alignment', 'customize', 'nanotext' ),
		'description' => _x( '', 'customize', 'nanotext' ),
		'choices'     => array(
			'left'   => _x( 'Left', 'customize', 'nanotext' ),
			'center' => _x( 'Center', 'customize', 'nanotext' ),
			'right'  => _x( 'Right', 'customize', 'nanotext' ),
			'inline' => _x( 'Inline', 'customize', 'nanotext' )
		)
	);
	$controls['header__titlebar__height'] = array(
		'type'        => 'textfield',
		'section'     => 'headerTitle',
		'label'       => _x( 'Title Bar Height', 'customize', 'nanotext' ),
		'description' => _x( '', 'customize', 'nanotext' )
	);
	$controls['header__titlebar__full'] = array(
		'type'        => 'radio-onoff',
		'section'     => 'headerTitle',
		'label'       => _x( 'Title Bar Full Width', 'customize', 'nanotext' ),
		'description' => _x( '', 'customize', 'nanotext' )
	);
	$controls['header__titlebar__home'] = array(
		'type'        => 'radio-onoff',
		'section'     => 'headerTitle',
		'label'       => _x( 'Display On The Homepage', 'customize', 'nanotext' ),
		'description' => _x( '', 'customize', 'nanotext' )
	);
	
	$controls['header__titlebar__shadow'] = array(
		'type'        => 'radio-onoff',
		'section'     => 'headerTitle',
		'label'       => esc_html__( 'Enable Shadow', 'nanotext' ),
	);

	$controls['header__titlebar__scrolldown'] = array(
		'type'        => 'radio-onoff',
		'section'     => 'headerTitle',
		'label'       => esc_html__( 'Enable Scroll Down Button', 'nanotext' ),
	);

	$controls['header__titlebar__canvaseffect'] = array(
		'type'        => 'radio-onoff',
		'section'     => 'headerTitle',
		'label'       => esc_html__( 'Enable Canvas Effect', 'nanotext' ),
	);

	$controls['header__titlebar__border'] = array(
		'type'        => 'radio-onoff',
		'section'     => 'headerTitle',
		'label'       => esc_html__( 'Title Bar Border', 'nanotext' ),
	);
	$controls[ 'header__titlebar__border__options'] = array(
		'type'        => 'border',
		'section'     => 'headerTitle',
		'choices'     => array(
			'top'    => esc_html__( 'Top', 'nanotext' ),
			'right'  => esc_html__( 'Right', 'nanotext' ),
			'bottom' => esc_html__( 'Bottom', 'nanotext' ),
			'left'   => esc_html__( 'Left', 'nanotext' )
		)
	);
	$controls['header__titlebar__background'] = array(
		'type'        => 'background',
		'section'     => 'headerTitle',
		'label'   => _x( 'Title Bar Background', 'customize', 'nanotext' ),
		'description' => _x( '', 'customize', 'nanotext' )
	);
	$controls[ 'header__titlebar__margin'] = array(
		'type'        => 'dimension',
		'section'     => 'headerTitle',
		'label'       => esc_html__( 'Title Bar Margin', 'nanotext' ),
		'choices'     => array(
			'margin-top'    => esc_html__( 'Top', 'nanotext' ),
			'margin-right'  => esc_html__( 'Right', 'nanotext' ),
			'margin-bottom' => esc_html__( 'Bottom', 'nanotext' ),
			'margin-left'   => esc_html__( 'Left', 'nanotext' )
		)
	);
	$controls['header__titlebar__padding'] = array(
		'type'        => 'dimension',
		'section'     => 'headerTitle',
		'label'       => esc_html__( 'Title Bar Padding', 'nanotext' ),
		'choices'     => array(
			'padding-top'    => esc_html__( 'Top', 'nanotext' ),
			'padding-right'  => esc_html__( 'Right', 'nanotext' ),
			'padding-bottom' => esc_html__( 'Bottom', 'nanotext' ),
			'padding-left'   => esc_html__( 'Left', 'nanotext' )
		)
	);
	$controls['header__titlebar__backgroundFeatured'] = array(
		'type'        => 'checkboxes',
		'section'     => 'headerTitle',
		'label'       => _x( 'Use Featured Image As Background in', 'customize', 'nanotext' ),
		'description' => _x( '', 'customize', 'nanotext' ),
		'choices'     => 'nanotext_customize_post_types_options'
	);

	$controls['header__titlebar__titleHeading'] = array(
		'type'        => 'heading',
		'section'     => 'headerTitle',
		'label'       => _x( 'Page Title Font', 'customize', 'nanotext' ),
		'description' => _x( '', 'customize', 'nanotext' )
	);
	$controls['header__titlebar__titleFont'] = array(
		'type'        => 'typography',
		'section'     => 'headerTitle'
	);

	$controls['header__titlebar__breadcrumbHeading'] = array(
		'type'        => 'heading',
		'section'     => 'headerTitle',
		'label'       => _x( 'Breadcrumbs Font', 'customize', 'nanotext' ),
		'description' => _x( '', 'customize', 'nanotext' )
	);
	$controls['header__titlebar__breadcrumbFont'] = array(
		'type'        => 'typography',
		'section'     => 'headerTitle'
	);
	$controls['header__titlebar__breadcrumbColors'] = array(
		'type'        => 'colors',
		'section'     => 'headerTitle',
		'label'       => _x( 'Breadcrumbs Link Color', 'customize', 'nanotext' ),
		'choices'     => array(
			'link' => _x( 'Link Color', 'customize', 'nanotext' ),
			'linkHover' => _x( 'Hover Color', 'customize', 'nanotext' )
		)
	);


	/**
	 * Sticky Header Settings
	 */
	$controls['header__widgets'] = array(
		'type'        => 'radio-onoff',
		'section'     => 'header__widgets',
		'label'       => _x( 'Enable Sticky Header', 'customize', 'nanotext' ),
		'description' => _x( 'Turn ON to enable the header widgets area', 'customize', 'nanotext' ),
		'default'     => 'on'
	);

	return $controls;
}



function nanotext_customize_header_settings( $settings ) {
	$border_default = array( 'size' => '0px', 'style' => 'none', 'color' => '#000000' );
	$settings = array_merge( $settings, array(
		'header__position'  => array( 'default' => 'top' ),
		'header__logo'       => array( 'default' => 'logoDefault' ),
		'header__logoAlign'  => array( 'default' => 'left' ),
		'header__logoMargin' => array( 'default' => array(
			'margin-top'    => '0px', 'margin-right'  => '0px',
			'margin-bottom' => '0px', 'margin-left'   => '0px'
		) ),

		'header__width'      => array( 'default' => 'on' ),
		'header__height'     => array( 'default' => '80px' ),
		'header__background' => array( 'default' => array() ),
		'header__shadow'     => array( 'default' => 'off' ),
		'header__border'     => array( 'default' => 'off' ),
		'header__border__options'     => array( 'default' => array(
			'all'  => $border_default, 'top'   => $border_default, 'bottom' => $border_default,
			'left' => $border_default, 'right' => $border_default
		) ),
		'header__transparent' => array( 'default' => 'off' ),

		'header__topbar'             => array( 'default' => 'on' ),
		'header__topbar__width'      => array( 'default' => 'on' ),
		'header__topbar__height'     => array( 'default' => '40px' ),
		'header__topbar__text'       => array( 'default' => '' ),
		'header__topbar__icons'      => array( 'default' => '' ),
		'header__topbar__background' => array( 'default' => array() ),
		'header__topbar__typography' => array( 'default' => array() ),
		'header__topbar__colors'     => array( 'default' => array() ),

		'header__nav__typography' => array( 'default' => array() ),
		'header__nav__colors'     => array( 'default' => array() ),
		'header__nav__margin'     => array( 'default' => array(
			'margin-top'    => '0px', 'margin-right' => '0px',
			'margin-bottom' => '0px', 'margin-left'  => '0px'
		) ),
		'header__nav__padding' => array( 'default' => array(
			'padding-top'    => '0px', 'padding-right' => '0px',
			'padding-bottom' => '0px', 'padding-left'  => '0px'
		) ),
		'header__nav__background' => array( 'default' => array() ),
		'header__nav__extras'     => array( 'default' => array() ),


		'header__sticky__logo'       => array( 'default' => 'logoDefault' ),
		'header__sticky__logoAlign'  => array( 'default' => 'left' ),
		'header__sticky__logoMargin' => array( 'default' => array(
			'margin-top'    => '0px', 'margin-right'  => '0px',
			'margin-bottom' => '0px', 'margin-left'   => '0px'
		) ),

		'header__sticky__width'      => array( 'default' => 'on' ),
		'header__sticky__height'     => array( 'default' => '80px' ),
		'header__sticky__background' => array( 'default' => array() ),
		'header__sticky__shadow'     => array( 'default' => 'off' ),
		'header__sticky__border'     => array( 'default' => 'off' ),
		'header__sticky__border__options'     => array( 'default' => array(
			'all'  => $border_default, 'top'   => $border_default, 'bottom' => $border_default,
			'left' => $border_default, 'right' => $border_default
		) ),
		'header__sticky__transparent' => array( 'default' => 'off' ),
		'header__sticky__nav__typography' => array( 'default' => array() ),
		'header__sticky__nav__colors'     => array( 'default' => array() ),
		'header__sticky__nav__margin'     => array( 'default' => array(
			'margin-top'    => '0px', 'margin-right' => '0px',
			'margin-bottom' => '0px', 'margin-left'  => '0px'
		) ),
		'header__sticky__nav__padding'    => array( 'default' => array(
			'padding-top'    => '0px', 'padding-right' => '0px',
			'padding-bottom' => '0px', 'padding-left'  => '0px'
		) ),

		'header__titlebar'         => array( 'default' => 'both' ),
		'header__titlebar__home'   => array( 'default' => 'on' ),
		'header__titlebar__align'  => array( 'default' => 'left' ),
		'header__titlebar__full'   => array( 'default' => 'off' ),
		'header__titlebar__height' => array( 'default' => '80px' ),
		'header__titlebar__margin' => array( 'default' => array(
			'margin-top'    => '0px', 'margin-right' => '0px',
			'margin-bottom' => '0px', 'margin-left'  => '0px'
		) ),
		'header__titlebar__padding' => array( 'default' => array(
			'padding-top'    => '0px', 'padding-right' => '0px',
			'padding-bottom' => '0px', 'padding-left'  => '0px'
		) ),
		'header__titlebar__shadow' => array( 'default' => 'off' ),
		'header__titlebar__scrolldown' => array( 'default' => 'on' ),
		'header__titlebar__border' => array( 'default' => 'off' ),
		'header__titlebar__border__options' => array( 'default' => array(
			'all'  => $border_default, 'top'   => $border_default, 'bottom' => $border_default,
			'left' => $border_default, 'right' => $border_default
		) ),
		'header__titlebar__background'         => array( 'default' => array() ),
		'header__titlebar__backgroundFeatured' => array( 'default' => array() ),
		'header__titlebar__titleFont'          => array( 'default' => array() ),
		'header__titlebar__breadcrumbFont'     => array( 'default' => array() ),
		'header__titlebar__breadcrumbColors'   => array( 'default' => array() ),
	) );

	return $settings;
}
