<?php
defined( 'ABSPATH' ) or die();

add_filter( 'nanotext_customize_containers', 'nanotext_customize_blog_containers' );
add_filter( 'nanotext_customize_settings', 'nanotext_customize_blog_settings' );

add_filter( 'nanotext_customize_controls', 'nanotext_customize_blog_archive' );
add_filter( 'nanotext_customize_controls', 'nanotext_customize_blog_single' );
add_filter( 'nanotext_customize_controls', 'nanotext_customize_blog_related' );


function nanotext_customize_blog_containers( $containers ) {
	$containers['blog'] = array(
		'type'            => 'panel',
		'title'           => esc_html__( 'Blog & Post', 'nanotext' )
	);
	$containers['blogArchive'] = array(
		'type'        => 'section',
		'panel'       => 'blog',
		'title'       => esc_html__( 'Blog Settings', 'nanotext' ),
		'description' => esc_html__( 'Select the style of blog posts that will appearing on the archive page', 'nanotext' )
	);
	$containers['blogSingle'] = array(
		'type'        => 'section',
		'panel'       => 'blog',
		'title'       => esc_html__( 'Post Settings', 'nanotext' )
	);
	$containers['blogAuthor'] = array(
		'type'        => 'section',
		'panel'       => 'blog',
		'title'       => esc_html__( 'Author Box', 'nanotext' ),
	);
	$containers['blogRelated'] = array(
		'type'        => 'section',
		'panel'       => 'blog',
		'title'       => esc_html__( 'Related Posts', 'nanotext' ),
	);

	return $containers;
}


function nanotext_customize_blog_settings( $settings ) {
	$settings['blog__archive__style']           = array( 'default' => 'large' );
	$settings['blog__archive__columns']         = array( 'default' => 3 );
	$settings['blog__archive__gridGutter']      = array( 'default' => 60 );
	$settings['blog__archive__imagesize']       = array( 'default' => 'full' );
	$settings['blog__archive__imagesizeCrop']   = array( 'default' => 'crop' );
	$settings['blog__archive__autoExcerpt']     = array( 'default' => 'off' );
	$settings['blog__archive__excerptLength']   = array( 'default' => '40' );
	$settings['blog__archive__postMeta']        = array( 'default' => 'on' );
	$settings['blog__archive__readmore']        = array( 'default' => 'on' );
	$settings['blog__archive__sidebar']         = array( 'default' => 'primary' );
	$settings['blog__archive__sidebarPosition'] = array( 'default' => 'left' );
	
	$settings['blog__single__postMeta']        = array( 'default' => 'on' );
	$settings['blog__single__postTags']        = array( 'default' => 'on' );
	$settings['blog__single__postNav']         = array( 'default' => 'on' );
	$settings['blog__single__postAuthor']      = array( 'default' => 'on' );
	$settings['blog__single__relatedPosts']    = array( 'default' => 'on' );
	$settings['blog__single__sidebar']         = array( 'default' => 'primary' );
	$settings['blog__single__sidebarPosition'] = array( 'default' => 'left' );
	
	$settings['blog__related__title']     = array( 'default' => 'Related Posts' );
	$settings['blog__related__type']      = array( 'default' => 'category' );
	$settings['blog__related__count']     = array( 'default' => '3' );

	return $settings;
}


function nanotext_customize_blog_archive( $controls ) {
	$controls['blog__archive__style'] = array(
		'type' => 'radio-buttons',
		'section' => 'blogArchive',
		'default' => 'grid',
		'choices' => array(
			'grid'   => esc_html__( 'Grid', 'nanotext' ),
			'masonry'   => esc_html__( 'Masonry', 'nanotext' ),
			'medium' => esc_html__( 'Medium', 'nanotext' ),
			'large'  => esc_html__( 'Large', 'nanotext' )
		)
	);
	$controls['blog__archive__columns'] = array(
		'type' => 'radio-buttons',
		'label'   => esc_html__( 'Grid Columns', 'nanotext' ),
		'section' => 'blogArchive',
		'choices' => array(
			2 => 2,
			3 => 3,
			4 => 4,
			5 => 5
		)
	);
	$controls['blog__archive__gridGutter'] = array(
		'type'        => 'textfield',
		'section'     => 'blogArchive',
		'label'       => esc_html__( 'Grid Column Spacing (px)', 'nanotext' ),
	);
	$controls['blog__archive__imagesize'] = array(
		'type'        => 'textfield',
		'section'     => 'blogArchive',
		'label' => esc_html__( 'Image Size', 'nanotext' ),
		'description' => esc_html__( 'Enter image size. Example: "thumbnail", "medium", "large", "full" or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use "thumbnail" size.', 'nanotext' )
	);
	$controls['blog__archive__imagesizeCrop'] = array(
		'type'        => 'radio-buttons',
		'section'     => 'blogArchive',
		'choices'     => array(
			'crop' => esc_html__('Hard Crop', 'nanotext'),
			'none' => esc_html__('None', 'nanotext')
		)
	);
	$controls['blog__archive__postMeta'] = array(
		'type'    => 'radio-onoff',
		'label'   => esc_html__( 'Show Post Meta', 'nanotext' ),
		'section' => 'blogArchive',
		'default' => 'on'
	);
	$controls['blog__archive__readmore'] = array(
		'type'    => 'radio-onoff',
		'label'   => esc_html__( 'Show Read More', 'nanotext' ),
		'section' => 'blogArchive',
		'default' => 'on'
	);
	$controls['blog__archive__autoExcerpt'] = array(
		'type'    => 'radio-onoff',
		'label'   => esc_html__( 'Auto Post Excerpt', 'nanotext' ),
		'section' => 'blogArchive',
		'default' => 'off'
	);

	$controls['blog__archive__excerptLength'] = array(
		'type'    => 'textfield',
		'label'   => esc_html__( 'Post Excerpt Length', 'nanotext' ),
		'section' => 'blogArchive',
		'default' => 40
	);

	/**
	 * Sidebar settings
	 */
	$controls['blog__archive__sidebar'] = array(
		'type'    => 'dropdown',
		'section' => 'blogArchive',
		'label'   => esc_html__( 'Sidebar', 'nanotext' ),
		'choices' => 'nanotext_customize_dropdown_sidebars'
	);
	$controls['blog__archive__sidebarPosition'] = array(
		'type'    => 'radio-buttons',
		'section' => 'blogArchive',
		'label'   => esc_html__( 'Sidebar Position', 'nanotext' ),
		'choices' => array(
			'none' => esc_html__( 'No Sidebar', 'nanotext' ),
			'left'       => esc_html__( 'Left', 'nanotext' ),
			'right'      => esc_html__( 'Right', 'nanotext' )
		)
	);
	
	
	return $controls;
}


function nanotext_customize_blog_single( $controls ) {
	$controls['blog__single__postMeta'] = array(
		'type'    => 'radio-onoff',
		'label'   => esc_html__( 'Show Post Meta', 'nanotext' ),
		'section' => 'blogSingle',
		'default' => 'on'
	);
	$controls['blog__single__postTags'] = array(
		'type'    => 'radio-onoff',
		'label'   => esc_html__( 'Show Post Tags', 'nanotext' ),
		'section' => 'blogSingle',
		'default' => 'on'
	);
	$controls['blog__single__postNav'] = array(
		'type'    => 'radio-onoff',
		'label'   => esc_html__( 'Show Post Navigator', 'nanotext' ),
		'section' => 'blogSingle',
		'default' => 'on'
	);
	$controls['blog__single__postAuthor'] = array(
		'type'    => 'radio-onoff',
		'label'   => esc_html__( 'Show Post Author', 'nanotext' ),
		'section' => 'blogSingle',
		'default' => 'on'
	);
	$controls['blog__single__relatedPosts'] = array(
		'type'    => 'radio-onoff',
		'label'   => esc_html__( 'Show Related Posts', 'nanotext' ),
		'section' => 'blogSingle',
		'default' => 'on'
	);

	/**
	 * Sidebar settings
	 */
	$controls['blog__single__sidebar'] = array(
		'type'    => 'dropdown',
		'section' => 'blogSingle',
		'label'   => esc_html__( 'Sidebar', 'nanotext' ),
		'choices' => 'nanotext_customize_dropdown_sidebars'
	);
	$controls['blog__single__sidebarPosition'] = array(
		'type'    => 'radio-buttons',
		'section' => 'blogSingle',
		'label'   => esc_html__( 'Sidebar Position', 'nanotext' ),
		'choices' => array(
			'none'    => esc_html__( 'No Sidebar', 'nanotext' ),
			'left'  => esc_html__( 'Left', 'nanotext' ),
			'right' => esc_html__( 'Right', 'nanotext' )
		)
	);
	
	
	return $controls;
}


function nanotext_customize_blog_related( $controls ) {
	$controls['blog__related__title'] = array(
		'type'    => 'textfield',
		'label'   => esc_html__( 'Widget Title', 'nanotext' ),
		'section' => 'blogRelated',
		'default' => esc_html__( 'Related Posts', 'nanotext' )
	);

	$controls['blog__related__count'] = array(
		'type'    => 'textfield',
		'label'   => esc_html__( 'Number of Related Posts', 'nanotext' ),
		'section' => 'blogRelated',
		'default' => esc_html__( '4', 'nanotext' )
	);

	$controls['blog__related__gridColumns'] = array(
		'type'        => 'radio-buttons',
		'section'     => 'blogRelated',
		'label'       => esc_html__( 'Grid Columns', 'nanotext' ),
		'choices'     => array( 2 => 2, 3 => 3, 4 => 4, 5 => 5 )
	);

	$controls['blog__related__type'] = array(
		'type' => 'dropdown',
		'section' => 'blogRelated',
		'label' => esc_html__( 'Show Related Posts Based On', 'nanotext' ),
		'default' => 'tag',
		'choices' => array(
			'tag'      => esc_html__( 'Tag', 'nanotext' ),
			'category' => esc_html__( 'Category', 'nanotext' ),
			'random'   => esc_html__( 'Random', 'nanotext' ),
			'recent'   => esc_html__( 'Recent', 'nanotext' )
		)
	);

	return $controls;
}
