<?php
defined( 'ABSPATH' ) or die();

// The third-party libraries
require_once NANOTEXT_PATH . 'vendor/class-tgm-plugin-activation.php';

// Classes
require_once NANOTEXT_PATH . 'admin/inc/class-plugins-activation.php';
require_once NANOTEXT_PATH . 'admin/inc/class-sample-data-worker.php';
require_once NANOTEXT_PATH . 'admin/inc/class-sample-data.php';

// Register theme's assets
add_action( 'init', 'nanotext_setup_admin_assets' );

// Initialize sample data installer
add_action( 'init', 'nanotext_setup_sample_data_installer' );


if ( ! function_exists( 'nanotext_setup_admin_assets' ) ):
/**
 * Register scripts and styles for the theme
 * 
 * @return  void
 */
function nanotext_setup_admin_assets() {
	// Font Awesome
	wp_register_style( 'font-awesome', get_theme_file_uri( 'assets/css/components.css' ), array(), '4.7.0' );
	
	// Chosen
	wp_register_style( 'nanotext-chosen', get_theme_file_uri( 'admin/js/vendor/chosen/chosen.min.css' ), array(), NANOTEXT_VERSION );
	wp_register_script( 'nanotext-chosen', get_theme_file_uri( 'admin/js/vendor/chosen/chosen.jquery.min.js' ), array( 'jquery' ), NANOTEXT_VERSION, true );
	
	// Spectrum
	wp_register_style( 'nanotext-spectrum', get_theme_file_uri( 'admin/js/vendor/spectrum/spectrum.css' ), array(), NANOTEXT_VERSION );
	wp_register_script( 'nanotext-spectrum', get_theme_file_uri( 'admin/js/vendor/spectrum/spectrum.js' ), array( 'jquery' ), NANOTEXT_VERSION, true );

	// Spectrum
	wp_register_style( 'nanotext-iconpicker', get_theme_file_uri( 'admin/js/vendor/iconpicker/css/jquery.fonticonpicker.css' ), array(), NANOTEXT_VERSION );
	wp_register_script( 'nanotext-iconpicker', get_theme_file_uri( 'admin/js/vendor/iconpicker/fonticonpicker.js' ), array( 'jquery' ), NANOTEXT_VERSION, true );

	// VueJS library
	wp_register_script( 'vuejs', get_theme_file_uri( 'admin/js/vendor/vue.js' ), array(), NANOTEXT_VERSION, true );

	// Sample data installer
	wp_register_style( 'nanotext-sample-data', get_theme_file_uri( 'admin/css/sample-data.css' ) );
	wp_register_script( 'nanotext-sample-data', get_theme_file_uri( 'admin/js/sample-data.js' ), array( 'vuejs', 'jquery' ) );

	/**
	 * Core scripts
	 */
	wp_register_script( 'nanotext-options', get_theme_file_uri( 'admin/js/options.js' ), array(
		'vuejs',
		'nanotext-spectrum',
		'nanotext-chosen',
		'wp-plupload',
		'jquery-ui-resizable',
		'jquery-ui-sortable',
		'nanotext-iconpicker'
	), NANOTEXT_VERSION, true );

	wp_register_style( 'nanotext-options', get_theme_file_uri( 'admin/css/options.css' ), array(
		'font-awesome',
		'nanotext-chosen',
		'nanotext-spectrum',
		'nanotext-iconpicker'
	), NANOTEXT_VERSION );
	
	wp_register_style( 'nanotext-customize', get_theme_file_uri( 'admin/css/customize.css' ), array( 'nanotext-options' ), NANOTEXT_VERSION );
}
endif;



if ( ! function_exists( 'nanotext_setup_sample_data_installer' ) ):
function nanotext_setup_sample_data_installer() {
	new NanoText_Sample_Data();
}
endif;

function nanotext_sample_data_files() {
	return array(
		array(
			'title'   => 'Sample Data #1',
			'file'    => 'demo-01.zip',
			'preview' => get_theme_file_uri( 'demo/screenshot-01.png' )
		)
	);
}
add_filter( 'nanotext/sample-datas', 'nanotext_sample_data_files' );


add_filter('acf/settings/save_json', function() {
	return get_theme_file_path( 'admin/json/' );
} );

add_filter('acf/settings/load_json', function( $paths ) {
    return array( get_theme_file_path( 'admin/json/' ) );
} );
