<?php

defined('ABSPATH') or die;

/*
 * 
 * Require the framework class before doing anything else, so we can use the defined urls and dirs
 *
 */
require_once( dirname( __FILE__ ) . '/options/options.php' );

/*
 * 
 * Add support tab
 *
 */
if ( ! defined('MTS_THEME_WHITE_LABEL') || ! MTS_THEME_WHITE_LABEL ) {
	require_once( dirname( __FILE__ ) . '/options/support.php' );
	$mts_options_tab_support = MTS_Options_Tab_Support::get_instance();
}

/*
 * 
 * Custom function for filtering the sections array given by theme, good for child themes to override or add to the sections.
 * Simply include this function in the child themes functions.php file.
 *
 * NOTE: the defined constants for urls, and dir will NOT be available at this point in a child theme, so you must use
 * get_template_directory_uri() if you want to use any of the built in icons
 *
 */
function add_another_section($sections){
	
	//$sections = array();
	$sections[] = array(
		'title' => __('A Section added by hook', 'writer' ),
		'desc' => '<p class="description">' . __('This is a section created by adding a filter to the sections array, great to allow child themes, to add/remove sections from the options.', 'writer' ) . '</p>',
		//all the glyphicons are included in the options folder, so you can hook into them, or link to your own custom ones.
		//You dont have to though, leave it blank for default.
		'icon' => trailingslashit(get_template_directory_uri()).'options/img/glyphicons/glyphicons_062_attach.png',
		//Lets leave this as a blank section, no options just some intro text set above.
		'fields' => array()
	);
	
	return $sections;
	
}//function
//add_filter('nhp-opts-sections-twenty_eleven', 'add_another_section');


/*
 * 
 * Custom function for filtering the args array given by theme, good for child themes to override or add to the args array.
 *
 */
function change_framework_args($args){
	
	//$args['dev_mode'] = false;
	
	return $args;
	
}//function
//add_filter('nhp-opts-args-twenty_eleven', 'change_framework_args');

/*
 * This is the meat of creating the options page
 *
 * Override some of the default values, uncomment the args and change the values
 * - no $args are required, but there there to be overridden if needed.
 *
 *
 */

function setup_framework_options(){
	$args = array();

	//Set it to dev mode to view the class settings/info in the form - default is false
	$args['dev_mode'] = false;
	//Remove the default stylesheet? make sure you enqueue another one all the page will look whack!
	//$args['stylesheet_override'] = true;

	//Add HTML before the form
	//$args['intro_text'] = __('<p>This is the HTML which can be displayed before the form, it isnt required, but more info is always better. Anything goes in terms of markup here, any HTML.</p>', 'writer' );

	if ( ! MTS_THEME_WHITE_LABEL ) {
		//Setup custom links in the footer for share icons
		$args['share_icons']['twitter'] = array(
			'link' => 'http://twitter.com/mythemeshopteam',
			'title' => __( 'Follow Us on Twitter', 'writer' ),
			'img' => 'fa fa-twitter-square'
		);
		$args['share_icons']['facebook'] = array(
			'link' => 'http://www.facebook.com/mythemeshop',
			'title' => __( 'Like us on Facebook', 'writer' ),
			'img' => 'fa fa-facebook-square'
		);
	}

	//Choose to disable the import/export feature
	//$args['show_import_export'] = false;

	//Choose a custom option name for your theme options, the default is the theme name in lowercase with spaces replaced by underscores
	$args['opt_name'] = MTS_THEME_NAME;

	//Custom menu icon
	//$args['menu_icon'] = '';

	//Custom menu title for options page - default is "Options"
	$args['menu_title'] = __('Theme Options', 'writer' );

	//Custom Page Title for options page - default is "Options"
	$args['page_title'] = __('Theme Options', 'writer' );

	//Custom page slug for options page (wp-admin/themes.php?page=***) - default is "nhp_theme_options"
	$args['page_slug'] = 'theme_options';

	//Custom page capability - default is set to "manage_options"
	//$args['page_cap'] = 'manage_options';

	//page type - "menu" (adds a top menu section) or "submenu" (adds a submenu) - default is set to "menu"
	//$args['page_type'] = 'submenu';

	//parent menu - default is set to "themes.php" (Appearance)
	//the list of available parent menus is available here: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
	//$args['page_parent'] = 'themes.php';

	//custom page location - default 100 - must be unique or will override other items
	$args['page_position'] = 62;

	//Custom page icon class (used to override the page icon next to heading)
	//$args['page_icon'] = 'icon-themes';

	if ( ! MTS_THEME_WHITE_LABEL ) {
		//Set ANY custom page help tabs - displayed using the new help tab API, show in order of definition
		$args['help_tabs'][] = array(
			'id' => 'nhp-opts-1',
			'title' => __('Support', 'writer' ),
			'content' => '<p>' . sprintf( __('If you are facing any problem with our theme or theme option panel, head over to our %s.', 'writer' ), '<a href="http://community.mythemeshop.com/">'. __( 'Support Forums', 'writer' ) . '</a>' ) . '</p>'
		);
		$args['help_tabs'][] = array(
			'id' => 'nhp-opts-2',
			'title' => __('Earn Money', 'writer' ),
			'content' => '<p>' . sprintf( __('Earn 70%% commision on every sale by refering your friends and readers. Join our %s.', 'writer' ), '<a href="http://mythemeshop.com/affiliate-program/">' . __( 'Affiliate Program', 'writer' ) . '</a>' ) . '</p>'
		);
	}

	//Set the Help Sidebar for the options page - no sidebar by default										
	//$args['help_sidebar'] = __('<p>This is the sidebar content, HTML is allowed.</p>', 'writer' );

	$mts_patterns = array(
		'nobg' => array('img' => NHP_OPTIONS_URL.'img/patterns/nobg.png'),
		'pattern0' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern0.png'),
		'pattern1' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern1.png'),
		'pattern2' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern2.png'),
		'pattern3' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern3.png'),
		'pattern4' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern4.png'),
		'pattern5' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern5.png'),
		'pattern6' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern6.png'),
		'pattern7' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern7.png'),
		'pattern8' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern8.png'),
		'pattern9' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern9.png'),
		'pattern10' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern10.png'),
		'pattern11' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern11.png'),
		'pattern12' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern12.png'),
		'pattern13' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern13.png'),
		'pattern14' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern14.png'),
		'pattern15' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern15.png'),
		'pattern16' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern16.png'),
		'pattern17' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern17.png'),
		'pattern18' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern18.png'),
		'pattern19' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern19.png'),
		'pattern20' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern20.png'),
		'pattern21' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern21.png'),
		'pattern22' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern22.png'),
		'pattern23' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern23.png'),
		'pattern24' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern24.png'),
		'pattern25' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern25.png'),
		'pattern26' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern26.png'),
		'pattern27' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern27.png'),
		'pattern28' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern28.png'),
		'pattern29' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern29.png'),
		'pattern30' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern30.png'),
		'pattern31' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern31.png'),
		'pattern32' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern32.png'),
		'pattern33' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern33.png'),
		'pattern34' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern34.png'),
		'pattern35' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern35.png'),
		'pattern36' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern36.png'),
		'pattern37' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern37.png'),
		'hbg' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg.png'),
		'hbg2' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg2.png'),
		'hbg3' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg3.png'),
		'hbg4' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg4.png'),
		'hbg5' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg5.png'),
		'hbg6' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg6.png'),
		'hbg7' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg7.png'),
		'hbg8' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg8.png'),
		'hbg9' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg9.png'),
		'hbg10' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg10.png'),
		'hbg11' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg11.png'),
		'hbg12' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg12.png'),
		'hbg13' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg13.png'),
		'hbg14' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg14.png'),
		'hbg15' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg15.png'),
		'hbg16' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg16.png'),
		'hbg17' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg17.png'),
		'hbg18' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg18.png'),
		'hbg19' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg19.png'),
		'hbg20' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg20.png'),
		'hbg21' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg21.png'),
		'hbg22' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg22.png'),
		'hbg23' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg23.png'),
		'hbg24' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg24.png'),
		'hbg25' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg25.png')
	);

	$sections = array();

	$sections[] = array(
		'icon' => 'fa fa-cogs',
		'title' => __('General Settings', 'writer' ),
		'desc' => '<p class="description">' . __('This tab contains common setting options which will be applied to the whole theme.', 'writer' ) . '</p>',
		'fields' => array(
			array(
				'id' => 'mts_logo',
				'type' => 'upload',
				'title' => __('Logo Image', 'writer' ),
				'sub_desc' => __('Upload your logo using the Upload Button or insert image URL. Recommended height 60px', 'writer' ),
				'return' => 'id'
			),
			array(
				'id' => 'mts_favicon',
				'type' => 'upload',
				'title' => __('Favicon', 'writer' ),
				'sub_desc' => sprintf( __('Upload a %s image that will represent your website\'s favicon.', 'writer' ), '<strong>32 x 32 px</strong>' ),
				'return' => 'id'
			),
			array(
				'id' => 'mts_touch_icon',
				'type' => 'upload',
				'title' => __('Touch icon', 'writer' ),
				'sub_desc' => sprintf( __('Upload a %s image that will represent your website\'s touch icon for iOS 2.0+ and Android 2.1+ devices.', 'writer' ), '<strong>152 x 152 px</strong>' ),
				'return' => 'id'
			),
			array(
				'id' => 'mts_metro_icon',
				'type' => 'upload',
				'title' => __('Metro icon', 'writer' ),
				'sub_desc' => sprintf( __('Upload a %s image that will represent your website\'s IE 10 Metro tile icon.', 'writer' ), '<strong>144 x 144 px</strong>' ),
				'return' => 'id'
			),
			array(
				'id' => 'mts_twitter_username',
				'type' => 'text',
				'title' => __('Twitter Username', 'writer' ),
				'sub_desc' => __('Enter your Username here.', 'writer' ),
			),
			array(
				'id' => 'mts_feedburner',
				'type' => 'text',
				'title' => __('FeedBurner URL', 'writer' ),
				'sub_desc' => sprintf( __('Enter your FeedBurner\'s URL here, ex: %s and your main feed (http://example.com/feed) will get redirected to the FeedBurner ID entered here.)', 'writer' ), '<strong>http://feeds.feedburner.com/mythemeshop</strong>' ),
				'validate' => 'url'
			),
			array(
				'id' => 'mts_header_code',
				'type' => 'textarea',
				'title' => __('Header Code', 'writer' ),
				'sub_desc' => wp_kses( __('Enter the code which you need to place <strong>before closing &lt;/head&gt; tag</strong>. (ex: Google Webmaster Tools verification, Bing Webmaster Center, BuySellAds Script, Alexa verification etc.)', 'writer' ), array( 'strong' => array() ) )
			),
			array(
				'id' => 'mts_analytics_code',
				'type' => 'textarea',
				'title' => __('Footer Code', 'writer' ),
				'sub_desc' => wp_kses( __('Enter the codes which you need to place in your footer. <strong>(ex: Google Analytics, Clicky, STATCOUNTER, Woopra, Histats, etc.)</strong>.', 'writer' ), array( 'strong' => array() ) )
			),
			array(
				'id' => 'mts_pagenavigation_type',
				'type' => 'radio',
				'title' => __('Pagination Type', 'writer' ),
				'sub_desc' => __('Select pagination type.', 'writer' ),
				'options' => array(
					'0'=> __('Next / Previous', 'writer' ),
					'1' => __('Default (Numbered 1 2 3 4...)', 'writer' ),
					'2' => __( 'AJAX (Load More Button)', 'writer' ),
					'3' => __( 'AJAX (Auto Infinite Scroll)', 'writer' ) 
				),
				'std' => '1'
			),
			array(
				'id' => 'mts_ajax_search',
				'type' => 'button_set',
				'title' => __('AJAX Quick search', 'writer' ),
				'options' => array( '0' => __( 'Off', 'writer' ), '1' => __( 'On', 'writer' ) ),
				'sub_desc' => __('Enable or disable search results appearing instantly below the search form', 'writer' ),
				'std' => '0'
			),
			array(
				'id' => 'mts_responsive',
				'type' => 'button_set',
				'title' => __('Responsiveness', 'writer' ),
				'options' => array( '0' => __( 'Off', 'writer' ), '1' => __( 'On', 'writer' ) ),
				'sub_desc' => __('MyThemeShop themes are responsive, which means they adapt to tablet and mobile devices, ensuring that your content is always displayed beautifully no matter what device visitors are using. Enable or disable responsiveness using this option.', 'writer' ),
				'std' => '1'
			),
			array(
				'id' => 'mts_rtl',
				'type' => 'button_set',
				'title' => __('Right To Left Language Support', 'writer' ),
				'options' => array( '0' => __( 'Off', 'writer' ), '1' => __( 'On', 'writer' ) ),
				'sub_desc' => __('Enable this option for right-to-left sites.', 'writer' ),
				'std' => '0'
			),
			array(
				'id' => 'mts_shop_products',
				'type' => 'text',
				'title' => __('No. of Products', 'writer' ),
				'sub_desc' => __('Enter the total number of products which you want to show on shop page (WooCommerce plugin must be enabled).', 'writer' ),
				'validate' => 'numeric',
				'std' => '9',
				'class' => 'small-text'
			),
		)
	);
	$sections[] = array(
		'icon' => 'fa fa-bolt',
		'title' => __('Performance', 'writer' ),
		'desc' => '<p class="description">' . __('This tab contains performance-related options which can help speed up your website.', 'writer' ) . '</p>',
		'fields' => array(
			array(
				'id' => 'mts_prefetching',
				'type' => 'button_set',
				'title' => __('Prefetching', 'writer' ),
				'options' => array( '0' => __( 'Off', 'writer' ), '1' => __( 'On', 'writer' ) ),
				'sub_desc' => __('Enable or disable prefetching. If user is on homepage, then single page will load faster and if user is on single page, homepage will load faster in modern browsers.', 'writer' ),
				'std' => '0'
			),
			array(
				'id' => 'mts_lazy_load',
				'type' => 'button_set_hide_below',
				'title' => __('Lazy Load', 'writer' ),
				'options' => array( '0' => __( 'Off', 'writer' ), '1' => __( 'On', 'writer' ) ),
				'sub_desc' => __('Delay loading of images outside of viewport, until user scrolls to them.', 'writer' ),
				'std' => '0',
				'args' => array('hide' => 2)
				),
				array(
					'id' => 'mts_lazy_load_thumbs',
					'type' => 'button_set',
					'title' => __('Lazy load featured images', 'writer' ),
					'options' => array( '0' => __( 'Off', 'writer' ), '1' => __( 'On', 'writer' ) ),
					'sub_desc' => __('Enable or disable Lazy load of featured images across site.', 'writer' ),
					'std' => '0'
				),
				array(
					'id' => 'mts_lazy_load_content',
					'type' => 'button_set',
					'title' => __('Lazy load post content images', 'writer' ),
					'options' => array( '0' => __( 'Off', 'writer' ), '1' => __( 'On', 'writer' ) ),
					'sub_desc' => __('Enable or disable Lazy load of images inside post/page content.', 'writer' ),
					'std' => '0'
			),
			array(
				'id' => 'mts_async_js',
				'type' => 'button_set',
				'title' => __('Async JavaScript', 'writer' ),
				'options' => array( '0' => __( 'Off', 'writer' ), '1' => __( 'On', 'writer' ) ),
				'sub_desc' => sprintf( __('Add %s attribute to script tags to improve page download speed.', 'writer' ), '<code>async</code>' ),
				'std' => '1',
			),
			array(
				'id' => 'mts_remove_ver_params',
				'type' => 'button_set',
				'title' => __('Remove ver parameters', 'writer' ),
				'options' => array( '0' => __( 'Off', 'writer' ), '1' => __( 'On', 'writer' ) ),
				'sub_desc' => sprintf( __('Remove %s parameter from CSS and JS file calls. It may improve speed in some browsers which do not cache files having the parameter.', 'writer' ), '<code>ver</code>' ),
				'std' => '1',
			),
			array(
				'id' => 'mts_optimize_wc',
				'type' => 'button_set',
				'title' => __('Optimize WooCommerce scripts', 'writer' ),
				'options' => array( '0' => __( 'Off', 'writer' ), '1' => __( 'On', 'writer' ) ),
				'sub_desc' => __('Load WooCommerce scripts and styles only on WooCommerce pages (WooCommerce plugin must be enabled).', 'writer' ),
				'std' => '1'
			),
			'cache_message' => array(
				'id' => 'mts_cache_message',
				'type' => 'info',
				'title' => __('Use Cache', 'writer' ),
				// Translators: %1$s = popup link to W3 Total Cache, %2$s = popup link to WP Super Cache
				'desc' => sprintf(
					__('A cache plugin can increase page download speed dramatically. We recommend using %1$s or %2$s.', 'writer' ),
					'<a href="https://community.mythemeshop.com/tutorials/article/8-make-your-website-load-faster-using-w3-total-cache-plugin/" target="_blank" title="W3 Total Cache">W3 Total Cache</a>',
					'<a href="'.admin_url( 'plugin-install.php?tab=plugin-information&plugin=wp-super-cache&TB_iframe=true&width=772&height=574' ).'" class="thickbox" title="WP Super Cache">WP Super Cache</a>'
				),
			),
		)
	);

	// Hide cache message on multisite or if a cache plugin is active already
	if ( is_multisite() || strstr( join( ';', get_option( 'active_plugins' ) ), 'cache' ) ) {
		unset( $sections[1]['fields']['cache_message'] );
	}

	$sections[] = array(
		'icon' => 'fa fa-adjust',
		'title' => __('Styling Options', 'writer' ),
		'desc' => '<p class="description">' . __('Control the visual appearance of your theme, such as colors, layout and patterns, from here.', 'writer' ) . '</p>',
		'fields' => array(
			array(
				'id' => 'mts_color_scheme',
				'type' => 'color',
				'title' => __('Color Scheme', 'writer' ),
				'sub_desc' => __('The theme comes with unlimited color schemes for your theme\'s styling.', 'writer' ),
				'std' => '#26a8ed'
			),
			array(
				'id' => 'mts_layout',
				'type' => 'radio_img',
				'title' => __('Sidebar Position', 'writer' ),
				'sub_desc' => wp_kses( __('Choose the <strong>default sidebar position</strong> for your site. The position of the sidebar for individual posts can be set in the post editor.', 'writer' ), array( 'strong' => array() ) ),
				'options' => array(
					'cslayout' => array('img' => NHP_OPTIONS_URL.'img/layouts/cs.png'),
					'sclayout' => array('img' => NHP_OPTIONS_URL.'img/layouts/sc.png')
				),
				'std' => 'cslayout'
			),
			array(
				'id' => 'mts_background',
				'type' => 'background',
				'title' => __('Site Background', 'writer' ),
				'sub_desc' => __('Set background color, pattern and image from here.', 'writer' ),
				'options' => array(
					'color'		 => '',
					'image_pattern' => $mts_patterns,
					'image_upload'  => '',
					'repeat'		=> array(),
					'attachment'	=> array(),
					'position'	=> array(),
					'size'		=> array(),
					'gradient'	=> '',
					'parallax'	=> array(),
				),
				'std' => array(
					'color'		 => '#ffffff',
					'use'		 => 'pattern',
					'image_pattern' => 'nobg',
					'image_upload'  => '',
					'repeat'		=> 'repeat',
					'attachment'	=> 'scroll',
					'position'	=> 'left top',
					'size'		=> 'cover',
					'gradient'	=> array('from' => '#ffffff', 'to' => '#000000', 'direction' => 'horizontal' ),
					'parallax'	=> '0',
				)
			),
			array(
				'id' => 'mts_custom_css',
				'type' => 'textarea',
				'title' => __('Custom CSS', 'writer' ),
				'sub_desc' => __('You can enter custom CSS code here to further customize your theme. This will override the default CSS used on your site.', 'writer' )
			),
			array(
				'id' => 'mts_lightbox',
				'type' => 'button_set',
				'title' => __('Lightbox', 'writer' ),
				'options' => array( '0' => __( 'Off', 'writer' ), '1' => __( 'On', 'writer' ) ),
				'sub_desc' => __('A lightbox is a stylized pop-up that allows your visitors to view larger versions of images without leaving the current page. You can enable or disable the lightbox here.', 'writer' ),
				'std' => '0'
			),
		)
	);
	$sections[] = array(
		'icon' => 'fa fa-credit-card',
		'title' => __('Header', 'writer' ),
		'desc' => '<p class="description">' . __('From here, you can control the elements of header section.', 'writer' ) . '</p>',
		'fields' => array(
			array(
				'id' => 'mts_nav_bar_location',
				'type' => 'button_set',
				'class' => 'green',
				'title' => __('Navigation Bar Location', 'writer' ),
				'sub_desc' => wp_kses( __('Choose the location of navigation bar form here.', 'writer' ), array( 'strong' => array() ) ),
				'options' => array(
					'above' => __( 'Above Logo', 'writer' ),
					'below' => __( 'Below Logo', 'writer' ),
				),
				'std' => 'below'
			),
			array(
				'id' => 'mts_sticky_nav',
				'type' => 'button_set',
				'title' => __('Floating Navigation Menu', 'writer' ),
				'options' => array( '0' => __( 'Off', 'writer' ), '1' => __( 'On', 'writer' ) ),
				'sub_desc' => sprintf( __('Use this button to enable %s.', 'writer' ), '<strong>' . __('Floating Navigation Menu', 'writer' ) . '</strong>' ),
				'std' => '0'
			),
			array(
				'id' => 'mts_show_primary_nav',
				'type' => 'button_set',
				'title' => __('Show Primary Menu', 'writer' ),
				'options' => array( '0' => __( 'Off', 'writer' ), '1' => __( 'On', 'writer' ) ),
				'sub_desc' => sprintf( __('Use this button to enable %s.', 'writer' ), '<strong>' . __( 'Primary Navigation Menu', 'writer' ) . '</strong>' ),
				'std' => '1'
			),
			array(
				'id' => 'mts_header_search',
				'type' => 'button_set',
				'title' => __('Show Header Search Form', 'writer'), 
				'options' => array( '0' => __( 'Off', 'writer' ), '1' => __( 'On', 'writer' ) ),
				'sub_desc' => __('Use this button to Show or Hide <strong>Header Search Form</strong>.', 'writer'),
				'std' => '1'
			),
			array(
				'id' => 'mts_header_background',
				'type' => 'background',
				'title' => __('Header Background', 'writer' ),
				'sub_desc' => __('Set Header Background color, pattern and image from here.', 'writer' ),
				'options' => array(
					'color'		 => '',
					'image_pattern' => $mts_patterns,
					'image_upload'  => '',
					'repeat'		=> array(),
					'attachment'	=> array(),
					'position'	=> array(),
					'size'		=> array(),
					'gradient'	=> '',
					'parallax'	=> array(),
				),
				'std' => array(
					'color'		 => '#242629',
					'use'		 => 'pattern',
					'image_pattern' => 'nobg',
					'image_upload'  => '',
					'repeat'		=> 'repeat',
					'attachment'	=> 'scroll',
					'position'	=> 'left top',
					'size'		=> 'cover',
					'gradient'	=> array('from' => '#ffffff', 'to' => '#000000', 'direction' => 'horizontal' ),
					'parallax'	=> '0',
				)
			),
			array(
				'id' => 'mts_navigation_background',
				'type' => 'background',
				'title' => __('Navigation Background', 'writer' ),
				'sub_desc' => __('Set navigation background color, pattern and image from here.', 'writer' ),
				'options' => array(
					'color'		 => '',
					'image_pattern' => $mts_patterns,
					'image_upload'  => '',
					'repeat'		=> array(),
					'attachment'	=> array(),
					'position'	=> array(),
					'size'		=> array(),
					'gradient'	=> '',
					'parallax'	=> array(),
				),
				'std' => array(
					'color'		 => '#ffffff',
					'use'		 => 'pattern',
					'image_pattern' => 'nobg',
					'image_upload'  => '',
					'repeat'		=> 'repeat',
					'attachment'	=> 'scroll',
					'position'	=> 'left top',
					'size'		=> 'cover',
					'gradient'	=> array('from' => '#ffffff', 'to' => '#000000', 'direction' => 'horizontal' ),
					'parallax'	=> '0',
				)
			),
			array(
				'id' => 'mts_header_section2',
				'type' => 'button_set',
				'title' => __('Show Logo', 'writer' ),
				'options' => array( '0' => __( 'Off', 'writer' ), '1' => __( 'On', 'writer' ) ),
				'sub_desc' => wp_kses( __('Use this button to Show or Hide the <strong>Logo</strong> completely.', 'writer' ), array( 'strong' => array() ) ),
				'std' => '1'
			),
			array(
				'id' => 'mts_header_text',
				'type' => 'textarea',
				'title' => __('Header Text', 'writer' ),
				'sub_desc' => __('Paste your header text here, this text will appear along with the Logo.', 'writer' ),
				'std' => wp_kses( __('<strong>Powerfully Effective Writing Strategy</strong><br/> Join over 10000+ Subscribers today!', 'writer' ), array( 'strong' => array() ) ),
			),
		)
	);
	$sections[] = array(
		'icon' => 'fa fa-table',
		'title' => __('Footer', 'writer' ),
		'desc' => '<p class="description">' . __('From here, you can control the elements of Footer section.', 'writer' ) . '</p>',
		'fields' => array(
			array(
				'id' => 'mts_first_footer',
				'type' => 'button_set_hide_below',
				'title' => __('Footer Widgets', 'writer' ),
				'sub_desc' => __('Enable or disable footer widget with this option.', 'writer' ),
				'options' => array( '0' => __( 'Off', 'writer' ), '1' => __( 'On', 'writer' ) ),
				'std' => '0'
				),
				array(
					'id' => 'mts_first_footer_num',
					'type' => 'button_set',
					'class' => 'green',
					'title' => __('Footer Widget Layout', 'writer' ),
					'sub_desc' => wp_kses( __('Choose the number of widget areas in the <strong>footer</strong>', 'writer' ), array( 'strong' => array() ) ),
					'options' => array(
						'3' => __( '3 Widgets', 'writer' ),
						'4' => __( '4 Widgets', 'writer' ),
					),
					'std' => '4'
			),
			array(
				'id' => 'mts_footer_background',
				'type' => 'background',
				'title' => __('Footer Widget Background', 'writer' ),
				'sub_desc' => __('Set background color, pattern and image from here.', 'writer' ),
				'options' => array(
					'color'		 => '',
					'image_pattern' => $mts_patterns,
					'image_upload'  => '',
					'repeat'		=> array(),
					'attachment'	=> array(),
					'position'	=> array(),
					'size'		=> array(),
					'gradient'	=> '',
					'parallax'	=> array(),
				),
				'std' => array(
					'color'		 => '#f4f4f4',
					'use'		 => 'pattern',
					'image_pattern' => 'nobg',
					'image_upload'  => '',
					'repeat'		=> 'repeat',
					'attachment'	=> 'scroll',
					'position'	=> 'left top',
					'size'		=> 'cover',
					'gradient'	=> array('from' => '#ffffff', 'to' => '#000000', 'direction' => 'horizontal' ),
					'parallax'	=> '0',
				)
			),
			array(
				'id' => 'mts_copyright_background',
				'type' => 'background',
				'title' => __('Copyright Background', 'writer' ),
				'sub_desc' => __('Set background color, pattern and image from here.', 'writer' ),
				'options' => array(
					'color'		 => '',
					'image_pattern' => $mts_patterns,
					'image_upload'  => '',
					'repeat'		=> array(),
					'attachment'	=> array(),
					'position'	=> array(),
					'size'		=> array(),
					'gradient'	=> '',
					'parallax'	=> array(),
				),
				'std' => array(
					'color'		 => '#242629',
					'use'		 => 'pattern',
					'image_pattern' => 'nobg',
					'image_upload'  => '',
					'repeat'		=> 'repeat',
					'attachment'	=> 'scroll',
					'position'	=> 'left top',
					'size'		=> 'cover',
					'gradient'	=> array('from' => '#ffffff', 'to' => '#000000', 'direction' => 'horizontal' ),
					'parallax'	=> '0',
				)
			),
			array(
				'id' => 'mts_copyrights',
				'type' => 'textarea',
				'title' => __('Copyrights Text', 'writer' ),
				'sub_desc' => __( 'You can change or remove our link from footer and use your own custom text.', 'writer' ) . ( MTS_THEME_WHITE_LABEL ? '' : wp_kses( __('(You can also use your affiliate link to <strong>earn 70% of sales</strong>. Ex: <a href="https://mythemeshop.com/go/aff/aff" target="_blank">https://mythemeshop.com/?ref=username</a>)', 'writer' ), array( 'strong' => array(), 'a' => array( 'href' => array(), 'target' => array() ) ) ) ),
				'std' => MTS_THEME_WHITE_LABEL ? null : sprintf( __( 'Theme Designed by %s', 'writer' ), '<a href="http://mythemeshop.com/" rel="nofollow">MyThemeShop.com</a>' )
			),
		)
	);

	$sections[] = array(
		'icon' => '',
		'title' => __('Home Layout', 'writer' ),
		'desc' => '<p class="description">' . __('From here, you can control the Homepage Layout.', 'writer' ) . '</p>',
		'fields' => array(
			array(
				'id'	=> 'mts_homepage_layout',
				'type'	=> 'layout',
				'title'   => __('Homepage Layout Manager','writer'),
				'sub_desc'	=> __('Organize how you want the layout to appear on the homepage.','writer'),
				'options' => array(
					'enabled'  => array(
						'intro' => __('Intro Section','writer'),
						'featured-on' => __('Featured On','writer'),
						'about' => __('About Section','writer'),
						'newsletter' => __('Subscription Box','writer'),
						'about-2' => __('About 2 Section','writer'),
						'newsletter-2' => __('Subscription Box 2','writer'),
						'blog' => __('Blog Section','writer')
					),
					'disabled' => array( )
				),
				'std'  => array(
					'enabled'  => array(
						'intro' => __('Intro Section','writer'),
						'featured-on' => __('Featured On','writer'),
						'about' => __('About Section','writer'),
						'newsletter' => __('Subscription Box','writer'),
						'about-2' => __('About 2 Section','writer'),
						'newsletter-2' => __('Subscription Box 2','writer'),
						'blog' => __('Blog Section','writer')
					),
					'disabled' => array()
				)
			)
		)
	);

	$sections[] = array(
		'icon' => '',
		'title' => __('Intro Section', 'writer'),
		'desc' => '<p class="description">' . __('Control settings related to Intro section on homepage.', 'writer' ) . '</p>',
		'fields' => array(
			array(
				'id' => 'mts_intro_background',
				'type' => 'background',
				'title' => __('Intro Section Background', 'writer' ), 
				'options' => array(
					'color'			=> '',
					'image_pattern' => $mts_patterns,
					'image_upload'  => '',
					'repeat'		=> array(),
					'attachment'	=> array(),
					'position'		=> array(),
					'size'			=> array(),
					'gradient'		=> '',
					'parallax'		=> array(),
				),
				'std' => array(
					'color'			=> '#eeeeee',
					'use'			=> 'pattern',
					'image_pattern' => 'nobg',
					'image_upload'  => '',
					'repeat'		=> 'repeat',
					'attachment'	=> 'scroll',
					'position'		=> 'left top',
					'size'			=> 'cover',
					'gradient'		=> array('from' => '#ffffff', 'to' => '#000000', 'direction' => 'horizontal' ),
					'parallax'		=> '0',
				)
			),
			array(
				'id' => 'mts_intro_heading',
				'type' => 'text',
				'title' => __('Intro Section Heading', 'writer' ),
				'sub_desc' => __('Add heading text for Intro section here.', 'writer' ),
				'std'=> __('Best theme for Writers, Bloggers, Authors, & Journalists.', 'writer' ),
			),
			array(
				'id' => 'mts_intro_heading_color',
				'type' => 'color',
				'title' => __('Intro Heading Color', 'writer' ),
				'sub_desc' => __('Choose color for Intro headline.', 'writer' ),
				'std' => '#242628'
			),
			array(
				'id' => 'mts_intro_sub_heading',
				'type' => 'text',
				'title' => __('Intro Section Sub Heading', 'writer' ),
				'sub_desc' => __('Add sub heading text for Intro section here.', 'writer' ),
				'std'=> __('Clean design & free of clutter.', 'writer' ),
			),
			array(
				'id' => 'mts_intro_sub_heading_color',
				'type' => 'color',
				'title' => __('Intro Sub Heading Color', 'writer' ),
				'sub_desc' => __('Choose color for Intro sub headline.', 'writer' ),
				'std' => '#52636b'
			),
			array(
				'id' => 'mts_intro_image',
				'type' => 'upload',
				'title' => __('Intro Banner Image', 'writer'), 
				'sub_desc' => __('Upload or select an image for intro section.', 'writer'),
				'std' => get_template_directory_uri().'/images/intro.png',
			),
		),
	);

	$sections[] = array(
		'icon' => '',
		'title' => __('Featured On', 'writer'),
		'desc' => '<p class="description">' . __('Control settings related to Featured On section from here.', 'writer' ) . '</p>',
		'fields' => array(
			array(
				'id' => 'mts_featured_on_background',
				'type' => 'color',
				'title' => __('Featured On Section Background', 'writer' ),
				'sub_desc' => __('Set background color for Featured On section from here.','writer'),
				'std' => '#242628'
			),
			array(
				'id' => 'mts_featured_on_heading',
				'type' => 'text',
				'title' => __('Featured On Section Heading', 'writer'),
				'std'=> __('Featured On', 'writer')
			),
			array(
				'id' => 'mts_featured_on_headline_color',
				'type' => 'color',
				'title' => __('Featured On Section Heading Color', 'writer' ),
				'sub_desc' => __('Set color for section heading.', 'writer' ),
				'std' => '#ffffff'
			),
			array(
				'id' => 'mts_featured_on_items',
				'type' => 'group',
				'title' => __('Featured On Items', 'writer'), 
				'groupname' => __('Featured On Item', 'writer'), // Group name
				'subfields' =>  array(
					array(
						'id' => 'mts_featured_on_item_title',
						'type' => 'text',
						'title' => __('Title', 'writer' ),
						'sub_desc' => __('This title will not appear anywhere.', 'writer' ),
						'class' => 'medium-text'
					),
					array(
						'id' => 'mts_featured_on_item_logo',
						'type' => 'upload',
						'title' => __('Logo Image', 'writer'), 
						'sub_desc' => __('Upload or select an image for this item.', 'writer')
					),
					array(
						'id' => 'mts_featured_on_item_text',
						'type' => 'textarea',
						'title' => __('Quote Text', 'writer' ),
						'std' => '#',
						'class' => 'medium-text'
					),
					array(
						'id' => 'mts_featured_on_item_text_color',
						'type' => 'color',
						'title' => __('Quote Text Color', 'writer' ),
						'sub_desc' => __('Set color for quote text from here.', 'writer' ),
						'std' => '#76787b'
					),
				),
				'std' => array(
					'inc' => array(
						'group_title' => 'Inc',
						'group_sort' => '1',
						'mts_featured_on_item_title' => 'Inc',
						'mts_featured_on_item_logo' => get_template_directory_uri().'/images/inc.svg',
						'mts_featured_on_item_text' => '"Lorem ipsum dolor sit amet, pulvinar consectetur adipiscing elit."',
						'mts_featured_on_item_text_color' => '#76787b'
					),
					'forbes' => array(
						'group_title' => 'Forbes',
						'group_sort' => '2',
						'mts_featured_on_item_title' => 'Forbes',
						'mts_featured_on_item_logo' => get_template_directory_uri().'/images/forbes.svg',
						'mts_featured_on_item_text' => '"Lorem ipsum dolor sit amet, pulvinar consectetur adipiscing elit."',
						'mts_featured_on_item_text_color' => '#76787b'
					),
					'tnw' => array(
						'group_title' => 'TNW',
						'group_sort' => '3',
						'mts_featured_on_item_title' => 'TNW',
						'mts_featured_on_item_logo' => get_template_directory_uri().'/images/tnw.svg',
						'mts_featured_on_item_text' => '"Lorem ipsum dolor sit amet, pulvinar consectetur adipiscing elit."',
						'mts_featured_on_item_text_color' => '#76787b'
					),
					'social-media-today' => array(
						'group_title' => 'Social Media Today',
						'group_sort' => '4',
						'mts_featured_on_item_title' => 'Social Media Today',
						'mts_featured_on_item_logo' => get_template_directory_uri().'/images/social-media-today.svg',
						'mts_featured_on_item_text' => '"Lorem ipsum dolor sit amet, pulvinar consectetur adipiscing elit."',
						'mts_featured_on_item_text_color' => '#76787b'
					),
					'business-com' => array(
						'group_title' => 'Business.com',
						'group_sort' => '5',
						'mts_featured_on_item_title' => 'Business.com',
						'mts_featured_on_item_logo' => get_template_directory_uri().'/images/business-com.svg',
						'mts_featured_on_item_text' => '"Lorem ipsum dolor sit amet, pulvinar consectetur adipiscing elit."',
						'mts_featured_on_item_text_color' => '#76787b'
					),
					'huffington-post' => array(
						'group_title' => 'Huffington Post',
						'group_sort' => '6',
						'mts_featured_on_item_title' => 'Huffington Post',
						'mts_featured_on_item_logo' => get_template_directory_uri().'/images/the-huffington-post.svg',
						'mts_featured_on_item_text' => '"Lorem ipsum dolor sit amet, pulvinar consectetur adipiscing elit."',
						'mts_featured_on_item_text_color' => '#76787b'
					),
				)
			)	
		),
	);

	$sections[] = array(
		'icon' => '',
		'title' => __('About Section', 'writer'),
		'desc' => '<p class="description">' . __('Control settings related to About section from here.', 'writer' ) . '</p>',
		'fields' => array(
			array(
				'id' => 'mts_about_background',
				'type' => 'background',
				'title' => __('About Section Background', 'writer' ), 
				'options' => array(
					'color'		 => '',
					'image_pattern' => $mts_patterns,
					'image_upload'  => '',
					'repeat'		=> array(),
					'attachment'	=> array(),
					'position'	  => array(),
					'size'		  => array(),
					'gradient'	  => '',
					'parallax'	  => array(),
				),
				'std' => array(
					'color'		 => '#ffffff',
					'use'		   => 'pattern',
					'image_pattern' => 'nobg',
					'image_upload'  => '',
					'repeat'		=> 'repeat',
					'attachment'	=> 'scroll',
					'position'	  => 'left top',
					'size'		  => 'cover',
					'gradient'	  => array('from' => '#ffffff', 'to' => '#000000', 'direction' => 'horizontal' ),
					'parallax'	  => '0',
				)
			),
			array(
				'id' => 'mts_about_heading',
				'type' => 'text',
				'title' => __('About Section Heading', 'writer'),
				'std'=> __('What Writer Theme is all about', 'writer')
			),
			array(
				'id' => 'mts_about_headline_color',
				'type' => 'color',
				'title' => __('About Section Heading Color', 'writer' ),
				'sub_desc' => __('Set color for section heading.', 'writer' ),
				'std' => '#242628'
			),
			array(
				'id' => 'mts_about_img',
				'type' => 'upload',
				'title' => __('About Section Left Image', 'writer' ),
				'sub_desc' => __('Set left image for About Section.', 'writer' ),
				'std' => get_template_directory_uri().'/images/about.jpg',
			),
			array(
				'id' => 'mts_about_text',
				'type' => 'textarea',
				'title' => __('About Section Text', 'writer' ),
				'std' => '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus sollicitudin, nunc in fermentum tristique, sem odio porta purus, a porttitor velit nisl quis erat. Suspendisse a odio id risus fringilla molestie at vitae sapien.</p>
<p>Suspendisse dui risus, pharetra sed justo quis, tempus dapibus neque. Vestibulum auctor est vitae leo bibendum laoreet.</p>
<p>Aliquam mollis tellus a elit sagittis pretium. Etiam scelerisque sit amet lectus ac imperdiet. Quisque laoreet sagittis odio quis porttitor. Morbi vel erat non est porta aliquet et vel orci.</p>
<p>Nullam eget magna non ligula tincidunt lobortis in laoreet augue. Vestibulum quis ligula non nisl porta ultrices et lacinia elit.</p>'
			),
			array(
				'id' => 'mts_about_text_color',
				'type' => 'color',
				'title' => __('About Section Text Color', 'writer' ),
				'sub_desc' => __('Set color for section text.', 'writer' ),
				'std' => '#52636b'
			),
		),
	);

	$sections[] = array(
		'icon' => '',
		'title' => __('Subscription Box', 'writer'),
		'desc' => '<p class="description">' . __('Control settings related to Subscription Box Section from here.', 'writer' ) . '</p>',
		'fields' => array(
			array(
				'id' => 'mts_subscription_box_note',
				'type' => 'info',
				'desc' => '<div style="font-size: 18px; line-height: 1.4">'.wp_kses( __('For this section please install our <strong>"WP Subscribe"</strong> plugin, head over to Widgets page and drag WP Subscribe Widget in the "Home Subscribe Widget" sidebar.', 'writer'), array( 'strong' => array() ) ).'</div>'
			),
			array(
				'id' => 'mts_subscription_box_background',
				'type' => 'background',
				'title' => __('Subscription Box Background', 'writer' ), 
				'options' => array(
					'color'		 => '',
					'image_pattern' => $mts_patterns,
					'image_upload'  => '',
					'repeat'		=> array(),
					'attachment'	=> array(),
					'position'	  => array(),
					'size'		  => array(),
					'gradient'	  => '',
					'parallax'	  => array(),
				),
				'std' => array(
					'color'		 => '#242629',
					'use'		   => 'pattern',
					'image_pattern' => 'nobg',
					'image_upload'  => '',
					'repeat'		=> 'repeat',
					'attachment'	=> 'scroll',
					'position'	  => 'left top',
					'size'		  => 'cover',
					'gradient'	  => array('from' => '#ffffff', 'to' => '#000000', 'direction' => 'horizontal' ),
					'parallax'	  => '0',
				)
			),
			array(
				'id' => 'mts_subscription_box_text_color',
				'type' => 'color',
				'title' => __('Subscription Box Text Color', 'writer'),
				'std'=> __('Set text color for Subscription box from here.', 'writer'),
				'std' => '#ffffff'
			),
		),
	);

	$sections[] = array(
		'icon' => '',
		'title' => __('About 2 Section', 'writer'),
		'desc' => '<p class="description">' . __('Control settings related to About 2 section from here.', 'writer' ) . '</p>',
		'fields' => array(
			array(
				'id' => 'mts_about_2_background',
				'type' => 'background',
				'title' => __('About 2 Section Background', 'writer' ), 
				'options' => array(
					'color'		 => '',
					'image_pattern' => $mts_patterns,
					'image_upload'  => '',
					'repeat'		=> array(),
					'attachment'	=> array(),
					'position'	  => array(),
					'size'		  => array(),
					'gradient'	  => '',
					'parallax'	  => array(),
				),
				'std' => array(
					'color'		 => '#ffffff',
					'use'		   => 'pattern',
					'image_pattern' => 'nobg',
					'image_upload'  => '',
					'repeat'		=> 'repeat',
					'attachment'	=> 'scroll',
					'position'	  => 'left top',
					'size'		  => 'cover',
					'gradient'	  => array('from' => '#ffffff', 'to' => '#000000', 'direction' => 'horizontal' ),
					'parallax'	  => '0',
				)
			),
			array(
				'id' => 'mts_about_2_heading',
				'type' => 'text',
				'title' => __('About 2 Section Heading', 'writer'),
				'std'=> __('How Writer Theme Helps You Get More Traffic', 'writer')
			),
			array(
				'id' => 'mts_about_2_headline_color',
				'type' => 'color',
				'title' => __('About 2 Section Heading Color', 'writer' ),
				'sub_desc' => __('Set color for section heading.', 'writer' ),
				'std' => '#242628'
			),
			array(
				'id' => 'mts_about_2_img',
				'type' => 'upload',
				'title' => __('About 2 Section Left Image', 'writer' ),
				'sub_desc' => __('Set left image for About Section.', 'writer' ),
				'std' => get_template_directory_uri().'/images/about.jpg',
			),
			array(
				'id' => 'mts_about_2_text',
				'type' => 'textarea',
				'title' => __('About 2 Section Text', 'writer' ),
				'std' => '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus sollicitudin, nunc in fermentum tristique, sem odio porta purus, a porttitor velit nisl quis erat. Suspendisse a odio id risus fringilla molestie at vitae sapien.</p>
<p>Suspendisse dui risus, pharetra sed justo quis, tempus dapibus neque. Vestibulum auctor est vitae leo bibendum laoreet.</p>
<p>Aliquam mollis tellus a elit sagittis pretium. Etiam scelerisque sit amet lectus ac imperdiet. Quisque laoreet sagittis odio quis porttitor. Morbi vel erat non est porta aliquet et vel orci.</p>
<p>Nullam eget magna non ligula tincidunt lobortis in laoreet augue. Vestibulum quis ligula non nisl porta ultrices et lacinia elit.</p>'
			),
			array(
				'id' => 'mts_about_2_text_color',
				'type' => 'color',
				'title' => __('About 2 Section Text Color', 'writer' ),
				'sub_desc' => __('Set color for section text.', 'writer' ),
				'std' => '#52636b'
			),
		),
	);

	$sections[] = array(
		'icon' => '',
		'title' => __('Subscription Box 2', 'writer'),
		'desc' => '<p class="description">' . __('Control settings related to Subscription Box 2 Section from here.', 'writer' ) . '</p>',
		'fields' => array(
			array(
				'id' => 'mts_subscription_box_2_note',
				'type' => 'info',
				'desc' => '<div style="font-size: 18px; line-height: 1.4">'.wp_kses( __('For this section please install our <strong>"WP Subscribe"</strong> plugin, head over to Widgets page and drag WP Subscribe Widget in the "Home Subscribe Widget" sidebar.', 'writer'), array( 'strong' => array() ) ).'</div>'
			),
			array(
				'id' => 'mts_subscription_box_2_background',
				'type' => 'background',
				'title' => __('Subscription Box 2 Background', 'writer' ), 
				'options' => array(
					'color'		 => '',
					'image_pattern' => $mts_patterns,
					'image_upload'  => '',
					'repeat'		=> array(),
					'attachment'	=> array(),
					'position'	  => array(),
					'size'		  => array(),
					'gradient'	  => '',
					'parallax'	  => array(),
				),
				'std' => array(
					'color'		 => '#eeeeee',
					'use'		   => 'pattern',
					'image_pattern' => 'nobg',
					'image_upload'  => '',
					'repeat'		=> 'repeat',
					'attachment'	=> 'scroll',
					'position'	  => 'left top',
					'size'		  => 'cover',
					'gradient'	  => array('from' => '#ffffff', 'to' => '#000000', 'direction' => 'horizontal' ),
					'parallax'	  => '0',
				)
			),
			array(
				'id' => 'mts_subscription_box_2_text_color',
				'type' => 'color',
				'title' => __('Subscription Box 2 Text Color', 'writer'),
				'std'=> __('Set text color for Subscription box from here.', 'writer'),
				'std' => '#52636b'
			),
		),
	);

	$sections[] = array(
		'icon' => '',
		'title' => __('Blog Section', 'writer'),
		'desc' => '<p class="description">' . __('Control settings related to Blog Section from here.', 'writer' ) . '</p>',
		'fields' => array(
			array(
				'id' => 'mts_blog_section_background',
				'type' => 'background',
				'title' => __('Blog Section Background', 'writer' ), 
				'options' => array(
					'color'		 => '',
					'image_pattern' => $mts_patterns,
					'image_upload'  => '',
					'repeat'		=> array(),
					'attachment'	=> array(),
					'position'	  => array(),
					'size'		  => array(),
					'gradient'	  => '',
					'parallax'	  => array(),
				),
				'std' => array(
					'color'		 => '#ffffff',
					'use'		   => 'pattern',
					'image_pattern' => 'nobg',
					'image_upload'  => '',
					'repeat'		=> 'repeat',
					'attachment'	=> 'scroll',
					'position'	  => 'left top',
					'size'		  => 'cover',
					'gradient'	  => array('from' => '#ffffff', 'to' => '#000000', 'direction' => 'horizontal' ),
					'parallax'	  => '0',
				)
			),
			array(
				'id' => 'mts_blog_section_heading',
				'type' => 'text',
				'title' => __('Blog Section Heading', 'writer'),
				'std'=> __('From the Blog', 'writer' )
			),
			array(
				'id' => 'mts_blog_section_heading_url',
				'type' => 'text',
				'title' => __('Blog Section Heading URL', 'writer'),
				'std'=> get_permalink(get_option( 'page_for_posts' )),
			),
			array(
				'id' => 'mts_blog_section_headline_color',
				'type' => 'color',
				'title' => __('Blog Section Heading Color', 'writer' ),
				'sub_desc' => __('Set color for section heading.', 'writer' ),
				'std' => '#242628'
			)
		),
	);

	$sections[] = array(
		'icon' => '',
		'title' => __('Blog Page', 'writer' ),
		'desc' => '<p class="description">' . __('From here, you can control the elements of the blog page.', 'writer' ) . '</p>',
		'fields' => array(
			array(
				'id' => 'mts_featured_slider',
				'type' => 'button_set_hide_below',
				'title' => __('Blog Slider', 'writer' ),
				'options' => array( '0' => __( 'Off', 'writer' ), '1' => __( 'On', 'writer' ) ),
				'sub_desc' => wp_kses( __('<strong>Enable or Disable</strong> blog page slider with this button. The slider will show recent articles from the selected categories.', 'writer' ), array( 'strong' => array() ) ),
				'std' => '0',
				'args' => array('hide' => 4)
				),
				array(
					'id' => 'mts_featured_slider_cat',
					'type' => 'cats_multi_select',
					'title' => __('Slider Category(s)', 'writer' ),
					'sub_desc' => wp_kses( __('Select a category from the drop-down menu, latest articles from this category will be shown <strong>in the slider</strong>.', 'writer' ), array( 'strong' => array() ) ),
				),
				array(
					'id' => 'mts_featured_slider_num',
					'type' => 'text',
					'class' => 'small-text',
					'title' => __('Number of posts', 'writer' ),
					'sub_desc' => __('Enter the number of posts to show in the slider', 'writer' ),
					'std' => '3',
					'args' => array('type' => 'number')
				),
				array(
					'id'	 => 'mts_slider_headline_meta_info',
					'type'	 => 'layout',
					'title'	=> __('Slider Post Meta Info', 'writer' ),
					'sub_desc' => __('Organize how you want the post meta info to appear in the Slider', 'writer' ),
					'options'  => array(
						'enabled'  => array(
							'author-image'   => __('Author Image', 'writer' ),
							'author'   => __('Author Name', 'writer' ),
							'date'	 => __('Date', 'writer' )
						),
						'disabled' => array()
					),
					'std'  => array(
						'enabled'  => array(
							'author-image'   => __('Author Image', 'writer' ),
							'author'   => __('Author Name', 'writer' ),
							'date'	 => __('Date', 'writer' )
						),
						'disabled' => array()
					)
				),
				array(
					'id' => 'mts_custom_slider',
					'type' => 'group',
					'title' => __('Custom Slider', 'writer' ),
					'sub_desc' => __('With this option you can set up a slider with custom image and text instead of the default slider automatically generated from your posts.', 'writer' ),
					'groupname' => __('Slider', 'writer' ), // Group name
					'subfields' => array(
						array(
							'id' => 'mts_custom_slider_title',
							'type' => 'text',
							'title' => __('Title', 'writer' ),
							'sub_desc' => __('Title of the slide', 'writer' ),
						),
						array(
							'id' => 'mts_custom_slider_image',
							'type' => 'upload',
							'title' => __('Image', 'writer' ),
							'sub_desc' => __('Upload or select an image for this slide', 'writer' ),
							'return' => 'id'
						),
						array('id' => 'mts_custom_slider_link',
							'type' => 'text',
							'title' => __('Link', 'writer' ),
							'sub_desc' => __('Insert a link URL for the slide', 'writer' ),
							'std' => '#'
						),
					),
			),
			array(
				'id' => 'mts_featured_categories',
				'type' => 'group',
				'title'	 => __('Featured Categories', 'writer' ),
				'sub_desc'  => __('Select categories appearing on the blog page.', 'writer' ),
				'groupname' => __('Section', 'writer' ), // Group name
				'subfields' => array(
					array(
						'id' => 'mts_featured_category',
						'type' => 'cats_select',
						'title' => __('Category', 'writer' ),
						'sub_desc' => __('Select a category or the latest posts for this section', 'writer' ),
						'std' => 'latest',
						'args' => array('include_latest' => 1, 'hide_empty' => 0),
					),
					array(
						'id' => 'mts_featured_category_postsnum',
						'type' => 'text',
						'class' => 'small-text',
						'title' => __('Number of posts', 'writer' ),
						'sub_desc' => __('Enter the number of posts to show in this section.', 'writer' ),
						'std' => '3',
						'args' => array('type' => 'number')
					),
					array(
						'id' => 'mts_featured_category_layout',
						'type' => 'select',
						'title' => __('Posts Layout', 'writer'),
						'sub_desc' => __('Select the posts layout for this section.', 'writer') ,
						'options' => array(
							'small-thumb'=> __('Small Thumb','writer'),
							'large-thumb'=> __('Large Thumb','writer'),
							'small-oddeven'=> __('Small Thumb(Odd-even)','writer'),
						),
						'std' => 'small-thumb'
					),
				),
				'std' => array(
					'1' => array(
						'group_title' => '',
						'group_sort' => '1',
						'mts_featured_category' => 'latest',
						'mts_featured_category_postsnum' => get_option('posts_per_page'),
						'mts_featured_category_layout' => 'small-thumb'
					)
				)
			),
			array(
				'id'	 => 'mts_home_headline_meta_info',
				'type'	 => 'layout',
				'title'	=> __('HomePage Post Meta Info', 'writer' ),
				'sub_desc' => __('Organize how you want the post meta info to appear on the blog page', 'writer' ),
				'options'  => array(
					'enabled'  => array(
						'author-image'   => __('Author Image', 'writer' ),
						'author'   => __('Author Name', 'writer' ),
						'date'	 => __('Date', 'writer' )
					),
					'disabled' => array(
						'category' => __('Categories', 'writer' ),
					)
				),
				'std'  => array(
					'enabled'  => array(
						'author-image'   => __('Author Image', 'writer' ),
						'author'   => __('Author Name', 'writer' ),
						'date'	 => __('Date', 'writer' )
					),
					'disabled' => array(
						'category' => __('Categories', 'writer' )
					)
				)
			),
		)
	);

	$sections[] = array(
		'icon' => '',
		'title' => __('Single Posts', 'writer' ),
		'desc' => '<p class="description">' . __('From here, you can control the appearance and functionality of your single posts page.', 'writer' ) . '</p>',
		'fields' => array(
			array(
				'id'	 => 'mts_single_post_layout',
				'type'	 => 'layout2',
				'title'	=> __('Single Post Layout', 'writer' ),
				'sub_desc' => __('Customize the look of single posts', 'writer' ),
				'options'  => array(
					'enabled'  => array(
						'content'   => array(
							'label' 	=> __('Post Content', 'writer' ),
							'subfields'	=> array(
								
							)
						),
						'author'   => array(
							'label' 	=> __('Author Box', 'writer' ),
							'subfields'	=> array()
						),
						'related'   => array(
							'label' 	=> __('Related Articles', 'writer' ),
							'subfields'	=> array(
								array(
									'id' => 'mts_related_posts_taxonomy',
									'type' => 'button_set',
									'title' => __('Related Articles Taxonomy', 'writer' ) ,
									'options' => array(
										'tags' => __( 'Tags', 'writer' ),
										'categories' => __( 'Categories', 'writer' )
									) ,
									'class' => 'green',
									'sub_desc' => __('Related Articles based on tags or categories.', 'writer' ) ,
									'std' => 'categories'
								),
								array(
									'id' => 'mts_related_postsnum',
									'type' => 'text',
									'class' => 'small-text',
									'title' => __('Number of related articles', 'writer' ) ,
									'sub_desc' => __('Enter the number of posts to show in the related articles section.', 'writer' ) ,
									'std' => '3',
									'args' => array(
										'type' => 'number'
									)
								),
								array(
									'id' => 'mts_related_time',
									'type' => 'button_set',
									'title' => __('Date', 'writer' ),
									'options' => array( '0' => __( 'Off', 'writer' ), '1' => __( 'On', 'writer' ) ),
									'sub_desc' => __('Show published date in related articles.', 'writer' ),
									'std' => '1'
								),
							)
						),
					),
					'disabled' => array(
						'tags'   => array(
							'label' 	=> __('Tags', 'writer' ),
							'subfields'	=> array(
							)
						)
					)
				)
			),
			array(
				'id'	 => 'mts_single_headline_meta_info',
				'type'	 => 'layout',
				'title'	=> __('Meta Info to Show', 'writer' ),
				'sub_desc' => __('Organize how you want the post meta info to appear', 'writer' ),
				'options'  => array(
					'enabled'  => array(
						'author-image'   => __('Author Image', 'writer' ),
						'author'   => __('Author Name', 'writer' ),
						'date'	 => __('Date', 'writer' )
					),
					'disabled' => array(
						'category' => __('Categories', 'writer' ),
					)
				),
				'std'  => array(
					'enabled'  => array(
						'author-image'   => __('Author Image', 'writer' ),
						'author'   => __('Author Name', 'writer' ),
						'date'	 => __('Date', 'writer' )
					),
					'disabled' => array(
						'category' => __('Categories', 'writer' )
					)
				)
			),
			array(
				'id' => 'mts_breadcrumb',
				'type' => 'button_set',
				'title' => __('Breadcrumbs', 'writer' ),
				'options' => array( '0' => __( 'Off', 'writer' ), '1' => __( 'On', 'writer' ) ),
				'sub_desc' => __('Breadcrumbs are a great way to make your site more user-friendly. You can enable them by checking this box.', 'writer' ),
				'std' => '0'
			),
			array(
				'id' => 'mts_author_comment',
				'type' => 'button_set',
				'title' => __('Highlight Author Comment', 'writer' ),
				'options' => array( '0' => __( 'Off', 'writer' ), '1' => __( 'On', 'writer' ) ),
				'sub_desc' => __('Use this button to highlight author comments.', 'writer' ),
				'std' => '1'
			),
			array(
				'id' => 'mts_comment_date',
				'type' => 'button_set',
				'title' => __('Date in Comments', 'writer' ),
				'options' => array( '0' => __( 'Off', 'writer' ), '1' => __( 'On', 'writer' ) ),
				'sub_desc' => __('Use this button to show the date for comments.', 'writer' ),
				'std' => '1'
			),
		)
	);
	$sections[] = array(
		'icon' => 'fa fa-group',
		'title' => __('Social Buttons', 'writer' ),
		'desc' => '<p class="description">' . __('Enable or disable social sharing buttons on single posts using these buttons.', 'writer' ) . '</p>',
		'fields' => array(
			array(
				'id' => 'mts_social_button_layout',
				'type' => 'radio_img',
				'title' => __('Social Sharing Buttons Layout', 'writer' ),
				'sub_desc' => wp_kses( __('Choose default <strong>social sharing buttons</strong> layout or modern <strong>social sharing buttons</strong> layout for your site. ', 'writer' ), array( 'strong' => array() ) ),
				'options' => array(
					'default' => array('img' => NHP_OPTIONS_URL.'img/layouts/default-social.jpg'),
					'modern' => array('img' => NHP_OPTIONS_URL.'img/layouts/modern-social.jpg')
				),
				'std' => 'default',
				'reset_at_version' => '1.1.3'
			),
			array(
				'id' => 'mts_social_button_position',
				'type' => 'button_set',
				'title' => __('Social Sharing Buttons Position', 'writer' ),
				'options' => array('top' => __('Above Content', 'writer' ), 'bottom' => __('Below Content', 'writer' ), 'floating' => __('Floating', 'writer' )),
				'sub_desc' => __('Choose position for Social Sharing Buttons. Note: Floating buttons will only appear on screens larger than 1350px.', 'writer' ),
				'std' => 'floating',
				'class' => 'green'
			),
			array(
				'id' => 'mts_social_buttons_on_pages',
				'type' => 'button_set',
				'title' => __('Social Sharing Buttons on Pages', 'writer' ),
				'options' => array('0' => __('Off', 'writer' ), '1' => __('On', 'writer' )),
				'sub_desc' => __('Enable the sharing buttons for pages too, not just posts.', 'writer' ),
				'std' => '0',
			),
			array(
				'id'   => 'mts_social_buttons',
				'type' => 'layout',
				'title'	=> __('Social Media Buttons', 'writer' ),
				'sub_desc' => __('Organize how you want the social sharing buttons to appear on single posts', 'writer' ),
				'options'  => array(
					'enabled'  => array(
						'facebookshare'   => __('Facebook Share', 'writer' ),
						'facebook'  => __('Facebook Like', 'writer' ),
						'twitter'   => __('Twitter', 'writer' ),
						'gplus' => __('Google Plus', 'writer' ),
						'pinterest' => __('Pinterest', 'writer' ),
					),
					'disabled' => array(
						'linkedin'  => __('LinkedIn', 'writer' ),
						'stumble'   => __('StumbleUpon', 'writer' ),
						'reddit'   => __('Reddit', 'writer' ),
					)
				),
				'std'  => array(
					'enabled'  => array(
						'facebookshare'   => __('Facebook Share', 'writer' ),
						'facebook'  => __('Facebook Like', 'writer' ),
						'twitter'   => __('Twitter', 'writer' ),
						'gplus' => __('Google Plus', 'writer' ),
						'pinterest' => __('Pinterest', 'writer' ),
					),
					'disabled' => array(
						'linkedin'  => __('LinkedIn', 'writer' ),
						'stumble'   => __('StumbleUpon', 'writer' ),
						'reddit'   => __('Reddit', 'writer' ),
					)
				),
				'reset_at_version' => '1.1.3'
			),
		)
	);
	$sections[] = array(
		'icon' => 'fa fa-bar-chart-o',
		'title' => __('Ad Management', 'writer' ),
		'desc' => '<p class="description">' . __('Now, ad management is easy with our options panel. You can control everything from here, without using separate plugins.', 'writer' ) . '</p>',
		'fields' => array(
			array(
				'id' => 'mts_posttop_adcode',
				'type' => 'textarea',
				'title' => __('Below Post Title', 'writer' ),
				'sub_desc' => __('Paste your Adsense, BSA or other ad code here to show ads below your article title on single posts.', 'writer' )
			),
			array(
				'id' => 'mts_posttop_adcode_time',
				'type' => 'text',
				'title' => __('Show After X Days', 'writer' ),
				'sub_desc' => __('Enter the number of days after which you want to show the Below Post Title Ad. Enter 0 to disable this feature.', 'writer' ),
				'validate' => 'numeric',
				'std' => '0',
				'class' => 'small-text',
				'args' => array('type' => 'number')
			),
			array(
				'id' => 'mts_postend_adcode',
				'type' => 'textarea',
				'title' => __('Below Post Content', 'writer' ),
				'sub_desc' => __('Paste your Adsense, BSA or other ad code here to show ads below the post content on single posts.', 'writer' )
			),
			array(
				'id' => 'mts_postend_adcode_time',
				'type' => 'text',
				'title' => __('Show After X Days', 'writer' ),
				'sub_desc' => __('Enter the number of days after which you want to show the Below Post Title Ad. Enter 0 to disable this feature.', 'writer' ),
				'validate' => 'numeric',
				'std' => '0',
				'class' => 'small-text',
				'args' => array('type' => 'number')
			),
		)
	);
	$sections[] = array(
		'icon' => 'fa fa-columns',
		'title' => __('Sidebars', 'writer' ),
		'desc' => '<p class="description">' . __('Now you have full control over the sidebars. Here you can manage sidebars and select one for each section of your site, or select a custom sidebar on a per-post basis in the post editor.', 'writer' ) . '<br></p>',
		'fields' => array(
			array(
				'id' => 'mts_custom_sidebars',
				'type'  => 'group', //doesn't need to be called for callback fields
				'title' => __('Custom Sidebars', 'writer' ),
				'sub_desc'  => wp_kses( __('Add custom sidebars. <strong style="font-weight: 800;">You need to save the changes to use the sidebars in the dropdowns below.</strong><br />You can add content to the sidebars in Appearance &gt; Widgets.', 'writer' ), array( 'strong' => array(), 'br' => array() ) ),
				'groupname' => __('Sidebar', 'writer' ), // Group name
				'subfields' => 
					array(
						array(
							'id' => 'mts_custom_sidebar_name',
							'type' => 'text',
							'title' => __('Name', 'writer' ),
							'sub_desc' => __('Example: Homepage Sidebar', 'writer' )
						),	
						array(
							'id' => 'mts_custom_sidebar_id',
							'type' => 'text',
							'title' => __('ID', 'writer' ),
							'sub_desc' => __('Enter a unique ID for the sidebar. Use only alphanumeric characters, underscores (_) and dashes (-), eg. "sidebar-home"', 'writer' ),
							'std' => 'sidebar-'
						),
					),
			),
			array(
				'id' => 'mts_sidebar_for_home',
				'type' => 'sidebars_select',
				'title' => __('Homepage', 'writer' ),
				'sub_desc' => __('Select a sidebar for the homepage.', 'writer' ),
				'args' => array('allow_nosidebar' => false, 'exclude' => array('sidebar', 'footer-first', 'footer-first-2', 'footer-first-3', 'footer-first-4', 'footer-second', 'footer-second-2', 'footer-second-3', 'footer-second-4', 'widget-header','shop-sidebar', 'product-sidebar','homepage')),
				'std' => ''
			),
			array(
				'id' => 'mts_sidebar_for_post',
				'type' => 'sidebars_select',
				'title' => __('Single Post', 'writer' ),
				'sub_desc' => __('Select a sidebar for the single posts. If a post has a custom sidebar set, it will override this.', 'writer' ),
				'args' => array('exclude' => array('sidebar', 'footer-first', 'footer-first-2', 'footer-first-3', 'footer-first-4', 'footer-second', 'footer-second-2', 'footer-second-3', 'footer-second-4', 'widget-header','shop-sidebar', 'product-sidebar','homepage')),
				'std' => ''
			),
			array(
				'id' => 'mts_sidebar_for_page',
				'type' => 'sidebars_select',
				'title' => __('Single Page', 'writer' ),
				'sub_desc' => __('Select a sidebar for the single pages. If a page has a custom sidebar set, it will override this.', 'writer' ),
				'args' => array('exclude' => array('sidebar', 'footer-first', 'footer-first-2', 'footer-first-3', 'footer-first-4', 'footer-second', 'footer-second-2', 'footer-second-3', 'footer-second-4', 'widget-header','shop-sidebar', 'product-sidebar','homepage')),
				'std' => ''
			),
			array(
				'id' => 'mts_sidebar_for_archive',
				'type' => 'sidebars_select',
				'title' => __('Archive', 'writer' ),
				'sub_desc' => __('Select a sidebar for the archives. Specific archive sidebars will override this setting (see below).', 'writer' ),
				'args' => array('allow_nosidebar' => false, 'exclude' => array('sidebar', 'footer-first', 'footer-first-2', 'footer-first-3', 'footer-first-4', 'footer-second', 'footer-second-2', 'footer-second-3', 'footer-second-4', 'widget-header','shop-sidebar', 'product-sidebar','homepage')),
				'std' => ''
			),
			array(
				'id' => 'mts_sidebar_for_category',
				'type' => 'sidebars_select',
				'title' => __('Category Archive', 'writer' ),
				'sub_desc' => __('Select a sidebar for the category archives.', 'writer' ),
				'args' => array('allow_nosidebar' => false, 'exclude' => array('sidebar', 'footer-first', 'footer-first-2', 'footer-first-3', 'footer-first-4', 'footer-second', 'footer-second-2', 'footer-second-3', 'footer-second-4', 'widget-header','shop-sidebar', 'product-sidebar','homepage')),
				'std' => ''
			),
			array(
				'id' => 'mts_sidebar_for_tag',
				'type' => 'sidebars_select',
				'title' => __('Tag Archive', 'writer' ),
				'sub_desc' => __('Select a sidebar for the tag archives.', 'writer' ),
				'args' => array('allow_nosidebar' => false, 'exclude' => array('sidebar', 'footer-first', 'footer-first-2', 'footer-first-3', 'footer-first-4', 'footer-second', 'footer-second-2', 'footer-second-3', 'footer-second-4', 'widget-header','shop-sidebar', 'product-sidebar','homepage')),
				'std' => ''
			),
			array(
				'id' => 'mts_sidebar_for_date',
				'type' => 'sidebars_select',
				'title' => __('Date Archive', 'writer' ),
				'sub_desc' => __('Select a sidebar for the date archives.', 'writer' ),
				'args' => array('allow_nosidebar' => false, 'exclude' => array('sidebar', 'footer-first', 'footer-first-2', 'footer-first-3', 'footer-first-4', 'footer-second', 'footer-second-2', 'footer-second-3', 'footer-second-4', 'widget-header','shop-sidebar', 'product-sidebar','homepage')),
				'std' => ''
			),
			array(
				'id' => 'mts_sidebar_for_author',
				'type' => 'sidebars_select',
				'title' => __('Author Archive', 'writer' ),
				'sub_desc' => __('Select a sidebar for the author archives.', 'writer' ),
				'args' => array('allow_nosidebar' => false, 'exclude' => array('sidebar', 'footer-first', 'footer-first-2', 'footer-first-3', 'footer-first-4', 'footer-second', 'footer-second-2', 'footer-second-3', 'footer-second-4', 'widget-header','shop-sidebar', 'product-sidebar','homepage')),
				'std' => ''
			),
			array(
				'id' => 'mts_sidebar_for_search',
				'type' => 'sidebars_select',
				'title' => __('Search', 'writer' ),
				'sub_desc' => __('Select a sidebar for the search results.', 'writer' ),
				'args' => array('allow_nosidebar' => false, 'exclude' => array('sidebar', 'footer-first', 'footer-first-2', 'footer-first-3', 'footer-first-4', 'footer-second', 'footer-second-2', 'footer-second-3', 'footer-second-4', 'widget-header','shop-sidebar', 'product-sidebar','homepage')),
				'std' => ''
			),
			array(
				'id' => 'mts_sidebar_for_notfound',
				'type' => 'sidebars_select',
				'title' => __('404 Error', 'writer' ),
				'sub_desc' => __('Select a sidebar for the 404 Not found pages.', 'writer' ),
				'args' => array('exclude' => array('sidebar', 'footer-first', 'footer-first-2', 'footer-first-3', 'footer-first-4', 'footer-second', 'footer-second-2', 'footer-second-3', 'footer-second-4', 'widget-header','shop-sidebar', 'product-sidebar','homepage')),
				'std' => ''
			),
			array(
				'id' => 'mts_sidebar_for_shop',
				'type' => 'sidebars_select',
				'title' => __('Shop Pages', 'writer' ),
				'sub_desc' => wp_kses( __('Select a sidebar for Shop main page and product archive pages (WooCommerce plugin must be enabled). Default is <strong>Shop Page Sidebar</strong>.', 'writer' ), array( 'strong' => array() ) ),
				'args' => array('allow_nosidebar' => false, 'exclude' => array('sidebar', 'footer-first', 'footer-first-2', 'footer-first-3', 'footer-first-4', 'footer-second', 'footer-second-2', 'footer-second-3', 'footer-second-4', 'widget-header','shop-sidebar', 'product-sidebar','homepage')),
				'std' => 'shop-sidebar'
			),
			array(
				'id' => 'mts_sidebar_for_product',
				'type' => 'sidebars_select',
				'title' => __('Single Product', 'writer' ),
				'sub_desc' => wp_kses( __('Select a sidebar for single products (WooCommerce plugin must be enabled). Default is <strong>Single Product Sidebar</strong>.', 'writer' ), array( 'strong' => array() ) ),
				'args' => array('allow_nosidebar' => false, 'exclude' => array('sidebar', 'footer-first', 'footer-first-2', 'footer-first-3', 'footer-first-4', 'footer-second', 'footer-second-2', 'footer-second-3', 'footer-second-4', 'widget-header','shop-sidebar', 'product-sidebar','homepage')),
				'std' => 'product-sidebar'
			),
		),
	);

	$sections[] = array(
		'icon' => 'fa fa-list-alt',
		'title' => __('Navigation', 'writer' ),
		'desc' => '<p class="description"><div class="controls">' . sprintf( __('Navigation settings can now be modified from the %s.', 'writer' ), '<a href="nav-menus.php"><b>' . __( 'Menus Section', 'writer' ) . '</b></a>' ) . '<br></div></p>'
	);

					
	$tabs = array();

	$args['presets'] = array();
	$args['show_translate'] = false;
	include('theme-presets.php');

	global $NHP_Options;
	$NHP_Options = new NHP_Options($sections, $args, $tabs);

} //function

add_action('init', 'setup_framework_options', 0);

/*
 * 
 * Custom function for the callback referenced above
 *
 */
function my_custom_field($field, $value){
	print_r($field);
	print_r($value);

}//function

/*
 * 
 * Custom function for the callback validation referenced above
 *
 */
function validate_callback_function($field, $value, $existing_value){
	
	$error = false;
	$value =  'just testing';
	$return['value'] = $value;
	if($error == true){
		$return['error'] = $field;
	}
	return $return;
	
}//function

/*--------------------------------------------------------------------
 * 
 * Default Font Settings
 *
 --------------------------------------------------------------------*/
if(function_exists('mts_register_typography')) { 
	mts_register_typography( array(
		'logo_font' => array(
			'preview_text' => __( 'Logo Font', 'writer' ),
			'preview_color' => 'dark',
			'font_family' => 'Domine',
			'font_variant' => 'normal',
			'font_size' => '50px',
			'font_color' => '#ffffff',
			'css_selectors' => '#header h1 a, #header h2 a'
		),
		'navigation_font' => array(
			'preview_text' => __( 'Navigation Font', 'writer' ),
			'preview_color' => 'dark',
			'font_family' => 'Lato',
			'font_variant' => 'normal',
			'font_size' => '16px',
			'font_color' => '#52636b',
			'css_selectors' => '#secondary-navigation, #searchform.searchbox'
		),
		'home_title_font' => array(
			'preview_text' => __( 'Home Article Title', 'writer' ),
			'preview_color' => 'light',
			'font_family' => 'Domine',
			'font_size' => '24px',
			'font_variant' => '700',
			'font_color' => '#242628',
			'css_selectors' => '.latestPost .title'
		),
		'single_title_font' => array(
			'preview_text' => __( 'Single Article Title', 'writer' ),
			'preview_color' => 'light',
			'font_family' => 'Domine',
			'font_size' => '36px',
			'font_variant' => '700',
			'font_color' => '#242628',
			'css_selectors' => '.single-title, .postsby, .featured-category-title a'
		),
		'content_font' => array(
			'preview_text' => __( 'Content Font', 'writer' ),
			'preview_color' => 'light',
			'font_family' => 'Lato',
			'font_size' => '18px',
			'font_variant' => 'normal',
			'font_color' => '#52636b',
			'css_selectors' => 'body'
		),
		'post_info_font' => array(
			'preview_text' => __( 'Post Info', 'writer' ),
			'preview_color' => 'light',
			'font_family' => 'Lato',
			'font_size' => '16px',
			'font_variant' => 'normal',
			'font_color' => '#52636b',
			'css_selectors' => '.post-info, .widget .wpt-postmeta, .breadcrumb, .ago, .tagtext, #load-posts, .woocommerce .woocommerce-breadcrumb, .reply, .readMore a'
		),
		'sidebar_widget_title_font' => array(
			'preview_text' => __( 'Sidebar Widget Title', 'writer' ),
			'preview_color' => 'light',
			'font_family' => 'Domine',
			'font_variant' => '700',
			'font_size' => '20px',
			'font_color' => '#242628',
			'css_selectors' => '.widget .widget-title'
		),
		'sidebar_widget_font' => array(
			'preview_text' => __( 'Sidebar Widget Font', 'writer' ),
			'preview_color' => 'light',
			'font_family' => 'Lato',
			'font_variant' => 'normal',
			'font_size' => '16px',
			'font_color' => '#242628',
			'css_selectors' => '.widget, .widget li a'
		),
		'sidebar_widget_post_font' => array(
			'preview_text' => __( 'Sidebar Widget Post Title', 'writer' ),
			'preview_color' => 'light',
			'font_family' => 'Domine',
			'font_variant' => '700',
			'font_size' => '16px',
			'font_color' => '#242628',
			'css_selectors' => '.widget .post-title a, .widget .entry-title a, .ajax-search-results .post-title'
		),
		'footer_widget_heading' => array(
			'preview_text' => __( 'Footer Widget Title', 'writer' ),
			'preview_color' => 'light',
			'font_family' => 'Domine',
			'font_variant' => '700',
			'font_size' => '20px',
			'font_color' => '#242628',
			'css_selectors' => '#site-footer .widget h3'
		),
		'footer_font' => array(
			'preview_text' => __( 'Footer Font', 'writer' ),
			'preview_color' => 'light',
			'font_family' => 'Lato',
			'font_variant' => 'normal',
			'font_size' => '15px',
			'font_color' => '#242628',
			'css_selectors' => '#site-footer, #site-footer .widget, #site-footer .widget li a'
		),
		'footer_post_font' => array(
			'preview_text' => __( 'Footer Widget Post Title', 'writer' ),
			'preview_color' => 'light',
			'font_family' => 'Domine',
			'font_variant' => '700',
			'font_size' => '16px',
			'font_color' => '#242628',
			'css_selectors' => '#site-footer .widget .post-title a, #site-footer .widget .entry-title a'
		),
		'copyrights_font' => array(
			'preview_text' => __( 'Copyrights Font', 'writer' ),
			'preview_color' => 'light',
			'font_family' => 'Lato',
			'font_variant' => 'normal',
			'font_size' => '15px',
			'font_color' => '#8a8a8a',
			'css_selectors' => '.copyrights'
		),
		'h1_headline' => array(
			'preview_text' => __( 'Content H1', 'writer' ),
			'preview_color' => 'light',
			'font_family' => 'Domine',
			'font_variant' => '700',
			'font_size' => '36px',
			'font_color' => '#242628',
			'css_selectors' => 'h1'
		),
		'h2_headline' => array(
			'preview_text' => __( 'Content H2', 'writer' ),
			'preview_color' => 'light',
			'font_family' => 'Domine',
			'font_variant' => '700',
			'font_size' => '32px',
			'font_color' => '#242628',
			'css_selectors' => 'h2'
		),
		'h3_headline' => array(
			'preview_text' => __( 'Content H3', 'writer' ),
			'preview_color' => 'light',
			'font_family' => 'Domine',
			'font_variant' => '700',
			'font_size' => '28px',
			'font_color' => '#242628',
			'css_selectors' => 'h3'
		),
		'h4_headline' => array(
			'preview_text' => __( 'Content H4', 'writer' ),
			'preview_color' => 'light',
			'font_family' => 'Domine',
			'font_variant' => '700',
			'font_size' => '24px',
			'font_color' => '#242628',
			'css_selectors' => 'h4, .project-title'
		),
		'h5_headline' => array(
			'preview_text' => __( 'Content H5', 'writer' ),
			'preview_color' => 'light',
			'font_family' => 'Domine',
			'font_variant' => '700',
			'font_size' => '20px',
			'font_color' => '#242628',
			'css_selectors' => 'h5'
		),
		'h6_headline' => array(
			'preview_text' => __( 'Content H6', 'writer' ),
			'preview_color' => 'light',
			'font_family' => 'Domine',
			'font_variant' => '700',
			'font_size' => '16px',
			'font_color' => '#242628',
			'css_selectors' => 'h6'
		)
	));
}
