<?php
/**
 * The template for displaying search results pages.
 */
$mts_options = get_option(MTS_THEME_NAME);

get_header(); ?>

<div id="page">
	<div class="article <?php mts_article_class(); ?>">
		<div id="content_box">
			<h1 class="postsby">
				<span><?php _e("Search Results for:", 'writer' ); ?></span> <?php the_search_query(); ?>
			</h1>
			<?php 
			$featured_categories = array();
			$post_layout = 'small-thumb';
			if ( !empty( $mts_options['mts_featured_categories'] ) ) {
				foreach ( $mts_options['mts_featured_categories'] as $section ) {
					$category_id = $section['mts_featured_category'];
					$featured_categories[] = $category_id;
					if('latest' == $category_id) {
						$post_layout = $section['mts_featured_category_layout'];
					}
				}
			} ?>
			<div class="<?php echo $post_layout; ?>">
				<?php $j = 0; if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
					<article class="latestPost excerpt <?php echo (++$j % 3 == 0) ? 'last' : ''; ?>">
						<?php mts_archive_post($layout = $post_layout); ?>
					</article>
				<?php endwhile; endif; ?>

				<?php if ( $j !== 0 ) { // No pagination if there is no posts ?>
					<?php mts_pagination(); ?>
				<?php } ?>
			</div>
		</div>
	</div>
	<?php get_sidebar(); ?>
<?php get_footer(); ?>